/**
 * <h1>CloudWatch Alarm Actions library</h1>
 * <p>
 * This library contains a set of classes which can be used as CloudWatch Alarm actions.
 * <p>
 * The currently implemented actions are: EC2 Actions, SNS Actions, SSM OpsCenter Actions, Autoscaling Actions and Application Autoscaling Actions
 * <p>
 * <h2>EC2 Action Example</h2>
 * <p>
 * <blockquote><pre>
 * // Alarm must be configured with an EC2 per-instance metric
 * Alarm alarm;
 * 
 * // Attach a reboot when alarm triggers
 * alarm.addAlarmAction(
 * new Ec2Action(Ec2InstanceAction.REBOOT));
 * </pre></blockquote>
 * <p>
 * <h2>SSM OpsCenter Action Example</h2>
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * 
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 * <p>
 * <h2>SSM Incident Manager Action Example</h2>
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * 
 * // Create an Incident Manager incident based on a specific response plan
 * alarm.addAlarmAction(
 * new SsmIncidentAction("ResponsePlanName"));
 * </pre></blockquote>
 * <p>
 * See <code>&#64;aws-cdk/aws-cloudwatch</code> for more information.
 */
package software.amazon.awscdk.services.cloudwatch.actions;
