package software.amazon.awscdk.services.backup;

/**
 * A backup plan.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Daily, weekly and monthly with 5 year retention
 * BackupPlan plan = BackupPlan.dailyWeeklyMonthly5YearRetention(this, "Plan");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:05.366Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupPlan")
public class BackupPlan extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.backup.IBackupPlan {

    protected BackupPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.BackupPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Daily with 35 day retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan daily35DayRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "daily35DayRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), backupVault });
    }

    /**
     * Daily with 35 day retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan daily35DayRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "daily35DayRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Daily and monthly with 1 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyMonthly1YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyMonthly1YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), backupVault });
    }

    /**
     * Daily and monthly with 1 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyMonthly1YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyMonthly1YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Daily, weekly and monthly with 5 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyWeeklyMonthly5YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyWeeklyMonthly5YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), backupVault });
    }

    /**
     * Daily, weekly and monthly with 5 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyWeeklyMonthly5YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyWeeklyMonthly5YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Daily, weekly and monthly with 7 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param backupVault
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyWeeklyMonthly7YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.IBackupVault backupVault) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyWeeklyMonthly7YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), backupVault });
    }

    /**
     * Daily, weekly and monthly with 7 year retention.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlan dailyWeeklyMonthly7YearRetention(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "dailyWeeklyMonthly7YearRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing backup plan.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param backupPlanId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.IBackupPlan fromBackupPlanId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String backupPlanId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupPlan.class, "fromBackupPlanId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupPlan.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(backupPlanId, "backupPlanId is required") });
    }

    /**
     * Adds a rule to a plan.
     * <p>
     * @param rule the rule to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupPlanRule rule) {
        software.amazon.jsii.Kernel.call(this, "addRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Adds a selection to this plan.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupSelection addSelection(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupSelectionOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupSelection.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The ARN of the backup plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanArn() {
        return software.amazon.jsii.Kernel.get(this, "backupPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the backup plan.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBackupPlanId() {
        return software.amazon.jsii.Kernel.get(this, "backupPlanId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The backup vault where backups are stored if not defined at the rule level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.IBackupVault getBackupVault() {
        return software.amazon.jsii.Kernel.get(this, "backupVault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupVault.class));
    }

    /**
     * Version Id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersionId() {
        return software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.BackupPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.BackupPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.backup.BackupPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The display name of the backup plan.
         * <p>
         * Default: - A CDK generated name
         * <p>
         * @return {@code this}
         * @param backupPlanName The display name of the backup plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanName(final java.lang.String backupPlanName) {
            this.props().backupPlanName(backupPlanName);
            return this;
        }

        /**
         * Rules for the backup plan.
         * <p>
         * Use <code>addRule()</code> to add rules after
         * instantiation.
         * <p>
         * Default: - use `addRule()` to add rules
         * <p>
         * @return {@code this}
         * @param backupPlanRules Rules for the backup plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanRules(final java.util.List<? extends software.amazon.awscdk.services.backup.BackupPlanRule> backupPlanRules) {
            this.props().backupPlanRules(backupPlanRules);
            return this;
        }

        /**
         * The backup vault where backups are stored.
         * <p>
         * Default: - use the vault defined at the rule level. If not defined a new
         * common vault for the plan will be created
         * <p>
         * @return {@code this}
         * @param backupVault The backup vault where backups are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVault(final software.amazon.awscdk.services.backup.IBackupVault backupVault) {
            this.props().backupVault(backupVault);
            return this;
        }

        /**
         * Enable Windows VSS backup.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html">https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html</a>
         * @param windowsVss Enable Windows VSS backup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowsVss(final java.lang.Boolean windowsVss) {
            this.props().windowsVss(windowsVss);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.backup.BackupPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.BackupPlan build() {
            return new software.amazon.awscdk.services.backup.BackupPlan(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.backup.BackupPlanProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.backup.BackupPlanProps.Builder();
            }
            return this.props;
        }
    }
}
