package software.amazon.awscdk.services.appmesh;

/**
 * Properties for defining a `CfnVirtualGateway`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnVirtualGatewayProps cfnVirtualGatewayProps = CfnVirtualGatewayProps.builder()
 *         .meshName("meshName")
 *         .spec(VirtualGatewaySpecProperty.builder()
 *                 .listeners(List.of(VirtualGatewayListenerProperty.builder()
 *                         .portMapping(VirtualGatewayPortMappingProperty.builder()
 *                                 .port(123)
 *                                 .protocol("protocol")
 *                                 .build())
 *                         // the properties below are optional
 *                         .connectionPool(VirtualGatewayConnectionPoolProperty.builder()
 *                                 .grpc(VirtualGatewayGrpcConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .http(VirtualGatewayHttpConnectionPoolProperty.builder()
 *                                         .maxConnections(123)
 *                                         // the properties below are optional
 *                                         .maxPendingRequests(123)
 *                                         .build())
 *                                 .http2(VirtualGatewayHttp2ConnectionPoolProperty.builder()
 *                                         .maxRequests(123)
 *                                         .build())
 *                                 .build())
 *                         .healthCheck(VirtualGatewayHealthCheckPolicyProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalMillis(123)
 *                                 .protocol("protocol")
 *                                 .timeoutMillis(123)
 *                                 .unhealthyThreshold(123)
 *                                 // the properties below are optional
 *                                 .path("path")
 *                                 .port(123)
 *                                 .build())
 *                         .tls(VirtualGatewayListenerTlsProperty.builder()
 *                                 .certificate(VirtualGatewayListenerTlsCertificateProperty.builder()
 *                                         .acm(VirtualGatewayListenerTlsAcmCertificateProperty.builder()
 *                                                 .certificateArn("certificateArn")
 *                                                 .build())
 *                                         .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
 *                                                 .certificateChain("certificateChain")
 *                                                 .privateKey("privateKey")
 *                                                 .build())
 *                                         .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
 *                                                 .secretName("secretName")
 *                                                 .build())
 *                                         .build())
 *                                 .mode("mode")
 *                                 // the properties below are optional
 *                                 .validation(VirtualGatewayListenerTlsValidationContextProperty.builder()
 *                                         .trust(VirtualGatewayListenerTlsValidationContextTrustProperty.builder()
 *                                                 .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .build())
 *                                                 .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                 .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                         .exact(List.of("exact"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .backendDefaults(VirtualGatewayBackendDefaultsProperty.builder()
 *                         .clientPolicy(VirtualGatewayClientPolicyProperty.builder()
 *                                 .tls(VirtualGatewayClientPolicyTlsProperty.builder()
 *                                         .validation(VirtualGatewayTlsValidationContextProperty.builder()
 *                                                 .trust(VirtualGatewayTlsValidationContextTrustProperty.builder()
 *                                                         .acm(VirtualGatewayTlsValidationContextAcmTrustProperty.builder()
 *                                                                 .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 *                                                                 .build())
 *                                                         .file(VirtualGatewayTlsValidationContextFileTrustProperty.builder()
 *                                                                 .certificateChain("certificateChain")
 *                                                                 .build())
 *                                                         .sds(VirtualGatewayTlsValidationContextSdsTrustProperty.builder()
 *                                                                 .secretName("secretName")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 *                                                         .match(SubjectAlternativeNameMatchersProperty.builder()
 *                                                                 .exact(List.of("exact"))
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .certificate(VirtualGatewayClientTlsCertificateProperty.builder()
 *                                                 .file(VirtualGatewayListenerTlsFileCertificateProperty.builder()
 *                                                         .certificateChain("certificateChain")
 *                                                         .privateKey("privateKey")
 *                                                         .build())
 *                                                 .sds(VirtualGatewayListenerTlsSdsCertificateProperty.builder()
 *                                                         .secretName("secretName")
 *                                                         .build())
 *                                                 .build())
 *                                         .enforce(false)
 *                                         .ports(List.of(123))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .logging(VirtualGatewayLoggingProperty.builder()
 *                         .accessLog(VirtualGatewayAccessLogProperty.builder()
 *                                 .file(VirtualGatewayFileAccessLogProperty.builder()
 *                                         .path("path")
 *                                         // the properties below are optional
 *                                         .format(LoggingFormatProperty.builder()
 *                                                 .json(List.of(JsonFormatRefProperty.builder()
 *                                                         .key("key")
 *                                                         .value("value")
 *                                                         .build()))
 *                                                 .text("text")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualGatewayName("virtualGatewayName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:05.014Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnVirtualGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnVirtualGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVirtualGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the service mesh that the virtual gateway resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshName();

    /**
     * The specifications of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpec();

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return null;
    }

    /**
     * Optional metadata that you can apply to the virtual gateway to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the virtual gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualGatewayName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVirtualGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVirtualGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVirtualGatewayProps> {
        java.lang.String meshName;
        java.lang.Object spec;
        java.lang.String meshOwner;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String virtualGatewayName;

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getMeshName}
         * @param meshName The name of the service mesh that the virtual gateway resides in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(java.lang.String meshName) {
            this.meshName = meshName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getSpec}
         * @param spec The specifications of the virtual gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.services.appmesh.CfnVirtualGateway.VirtualGatewaySpecProperty spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getSpec}
         * @param spec The specifications of the virtual gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.IResolvable spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getMeshOwner}
         * @param meshOwner The AWS IAM account ID of the service mesh owner.
         *                  If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(java.lang.String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getTags}
         * @param tags Optional metadata that you can apply to the virtual gateway to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualGatewayProps#getVirtualGatewayName}
         * @param virtualGatewayName The name of the virtual gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(java.lang.String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVirtualGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVirtualGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVirtualGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVirtualGatewayProps {
        private final java.lang.String meshName;
        private final java.lang.Object spec;
        private final java.lang.String meshOwner;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String virtualGatewayName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meshName = software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.meshOwner = software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.virtualGatewayName = software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meshName = java.util.Objects.requireNonNull(builder.meshName, "meshName is required");
            this.spec = java.util.Objects.requireNonNull(builder.spec, "spec is required");
            this.meshOwner = builder.meshOwner;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.virtualGatewayName = builder.virtualGatewayName;
        }

        @Override
        public final java.lang.String getMeshName() {
            return this.meshName;
        }

        @Override
        public final java.lang.Object getSpec() {
            return this.spec;
        }

        @Override
        public final java.lang.String getMeshOwner() {
            return this.meshOwner;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meshName", om.valueToTree(this.getMeshName()));
            data.set("spec", om.valueToTree(this.getSpec()));
            if (this.getMeshOwner() != null) {
                data.set("meshOwner", om.valueToTree(this.getMeshOwner()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVirtualGatewayName() != null) {
                data.set("virtualGatewayName", om.valueToTree(this.getVirtualGatewayName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnVirtualGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVirtualGatewayProps.Jsii$Proxy that = (CfnVirtualGatewayProps.Jsii$Proxy) o;

            if (!meshName.equals(that.meshName)) return false;
            if (!spec.equals(that.spec)) return false;
            if (this.meshOwner != null ? !this.meshOwner.equals(that.meshOwner) : that.meshOwner != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.virtualGatewayName != null ? this.virtualGatewayName.equals(that.virtualGatewayName) : that.virtualGatewayName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.meshName.hashCode();
            result = 31 * result + (this.spec.hashCode());
            result = 31 * result + (this.meshOwner != null ? this.meshOwner.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.virtualGatewayName != null ? this.virtualGatewayName.hashCode() : 0);
            return result;
        }
    }
}
