package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Properties for a scalable target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Code code;
 * Function handler = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.PYTHON_3_7)
 *         .handler("index.handler")
 *         .code(code)
 *         .reservedConcurrentExecutions(2)
 *         .build();
 * Version fnVer = handler.getCurrentVersion();
 * ScalableTarget target = ScalableTarget.Builder.create(this, "ScalableTarget")
 *         .serviceNamespace(ServiceNamespace.LAMBDA)
 *         .maxCapacity(100)
 *         .minCapacity(10)
 *         .resourceId(String.format("function:%s:%s", handler.getFunctionName(), fnVer.getVersion()))
 *         .scalableDimension("lambda:function:ProvisionedConcurrency")
 *         .build();
 * target.scaleToTrackMetric("PceTracking", BasicTargetTrackingScalingPolicyProps.builder()
 *         .targetValue(0.9)
 *         .predefinedMetric(PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.ScalableTargetProps")
@software.amazon.jsii.Jsii.Proxy(ScalableTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScalableTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

    /**
     * The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

    /**
     * The resource identifier to associate with this scalable target.
     * <p>
     * This string consists of the resource type and unique identifier.
     * <p>
     * Example value: <code>service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH</code>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The scalable dimension that's associated with the scalable target.
     * <p>
     * Specify the service namespace, resource type, and scaling property.
     * <p>
     * Example value: <code>ecs:service:DesiredCount</code>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ScalingPolicy.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ScalingPolicy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScalableDimension();

    /**
     * The namespace of the AWS service that provides the resource or custom-resource for a resource provided by your own application or service.
     * <p>
     * For valid AWS service namespace values, see the RegisterScalableTarget
     * action in the Application Auto Scaling API Reference.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace getServiceNamespace();

    /**
     * Role that allows Application Auto Scaling to modify your scalable target.
     * <p>
     * Default: A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScalableTargetProps> {
        java.lang.Number maxCapacity;
        java.lang.Number minCapacity;
        java.lang.String resourceId;
        java.lang.String scalableDimension;
        software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link ScalableTargetProps#getMaxCapacity}
         * @param maxCapacity The maximum value that Application Auto Scaling can use to scale a target during a scaling activity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetProps#getMinCapacity}
         * @param minCapacity The minimum value that Application Auto Scaling can use to scale a target during a scaling activity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetProps#getResourceId}
         * @param resourceId The resource identifier to associate with this scalable target. This parameter is required.
         *                   This string consists of the resource type and unique identifier.
         *                   <p>
         *                   Example value: <code>service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetProps#getScalableDimension}
         * @param scalableDimension The scalable dimension that's associated with the scalable target. This parameter is required.
         *                          Specify the service namespace, resource type, and scaling property.
         *                          <p>
         *                          Example value: <code>ecs:service:DesiredCount</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalableDimension(java.lang.String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetProps#getServiceNamespace}
         * @param serviceNamespace The namespace of the AWS service that provides the resource or custom-resource for a resource provided by your own application or service. This parameter is required.
         *                         For valid AWS service namespace values, see the RegisterScalableTarget
         *                         action in the Application Auto Scaling API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNamespace(software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ScalableTargetProps#getRole}
         * @param role Role that allows Application Auto Scaling to modify your scalable target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalableTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScalableTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScalableTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalableTargetProps {
        private final java.lang.Number maxCapacity;
        private final java.lang.Number minCapacity;
        private final java.lang.String resourceId;
        private final java.lang.String scalableDimension;
        private final software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace serviceNamespace;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalableDimension = software.amazon.jsii.Kernel.get(this, "scalableDimension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNamespace = software.amazon.jsii.Kernel.get(this, "serviceNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
            this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.scalableDimension = java.util.Objects.requireNonNull(builder.scalableDimension, "scalableDimension is required");
            this.serviceNamespace = java.util.Objects.requireNonNull(builder.serviceNamespace, "serviceNamespace is required");
            this.role = builder.role;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getScalableDimension() {
            return this.scalableDimension;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace getServiceNamespace() {
            return this.serviceNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
            data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.ScalableTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalableTargetProps.Jsii$Proxy that = (ScalableTargetProps.Jsii$Proxy) o;

            if (!maxCapacity.equals(that.maxCapacity)) return false;
            if (!minCapacity.equals(that.minCapacity)) return false;
            if (!resourceId.equals(that.resourceId)) return false;
            if (!scalableDimension.equals(that.scalableDimension)) return false;
            if (!serviceNamespace.equals(that.serviceNamespace)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxCapacity.hashCode();
            result = 31 * result + (this.minCapacity.hashCode());
            result = 31 * result + (this.resourceId.hashCode());
            result = 31 * result + (this.scalableDimension.hashCode());
            result = 31 * result + (this.serviceNamespace.hashCode());
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
