package software.amazon.awscdk.services.appflow;

/**
 * Properties for defining a `CfnFlow`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * Object customProperties;
 * CfnFlowProps cfnFlowProps = CfnFlowProps.builder()
 *         .destinationFlowConfigList(List.of(DestinationFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
 *                         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(customProperties)
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .redshift(RedshiftDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .s3(S3DestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         .preserveSourceDataTyping(false)
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .sapoData(SAPODataDestinationPropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .upsolver(UpsolverDestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .build())
 *                         .zendesk(ZendeskDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .build()))
 *         .flowName("flowName")
 *         .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                         .amplitude(AmplitudeSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(customProperties)
 *                                 .build())
 *                         .datadog(DatadogSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .dynatrace(DynatraceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .inforNexus(InforNexusSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .s3(S3SourcePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 // the properties below are optional
 *                                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
 *                                         .s3InputFileType("s3InputFileType")
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .enableDynamicFieldUpdate(false)
 *                                 .includeDeletedRecords(false)
 *                                 .build())
 *                         .sapoData(SAPODataSourcePropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 .build())
 *                         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .singular(SingularSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .slack(SlackSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .veeva(VeevaSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .documentType("documentType")
 *                                 .includeAllVersions(false)
 *                                 .includeRenditions(false)
 *                                 .includeSourceFiles(false)
 *                                 .build())
 *                         .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                         .datetimeTypeFieldName("datetimeTypeFieldName")
 *                         .build())
 *                 .build())
 *         .tasks(List.of(TaskProperty.builder()
 *                 .sourceFields(List.of("sourceFields"))
 *                 .taskType("taskType")
 *                 // the properties below are optional
 *                 .connectorOperator(ConnectorOperatorProperty.builder()
 *                         .amplitude("amplitude")
 *                         .customConnector("customConnector")
 *                         .datadog("datadog")
 *                         .dynatrace("dynatrace")
 *                         .googleAnalytics("googleAnalytics")
 *                         .inforNexus("inforNexus")
 *                         .marketo("marketo")
 *                         .s3("s3")
 *                         .salesforce("salesforce")
 *                         .sapoData("sapoData")
 *                         .serviceNow("serviceNow")
 *                         .singular("singular")
 *                         .slack("slack")
 *                         .trendmicro("trendmicro")
 *                         .veeva("veeva")
 *                         .zendesk("zendesk")
 *                         .build())
 *                 .destinationField("destinationField")
 *                 .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .triggerConfig(TriggerConfigProperty.builder()
 *                 .triggerType("triggerType")
 *                 // the properties below are optional
 *                 .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataPullMode("dataPullMode")
 *                         .firstExecutionFrom(123)
 *                         .flowErrorDeactivationThreshold(123)
 *                         .scheduleEndTime(123)
 *                         .scheduleOffset(123)
 *                         .scheduleStartTime(123)
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .kmsArn("kmsArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlowProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestinationFlowConfigList();

    /**
     * The specified name of the flow.
     * <p>
     * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowName();

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceFlowConfig();

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTasks();

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTriggerConfig();

    /**
     * A user-entered description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for your flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowProps> {
        java.lang.Object destinationFlowConfigList;
        java.lang.String flowName;
        java.lang.Object sourceFlowConfig;
        java.lang.Object tasks;
        java.lang.Object triggerConfig;
        java.lang.String description;
        java.lang.String kmsArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFlowProps#getDestinationFlowConfigList}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(software.amazon.awscdk.IResolvable destinationFlowConfigList) {
            this.destinationFlowConfigList = destinationFlowConfigList;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDestinationFlowConfigList}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(java.util.List<? extends java.lang.Object> destinationFlowConfigList) {
            this.destinationFlowConfigList = destinationFlowConfigList;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getFlowName}
         * @param flowName The specified name of the flow. This parameter is required.
         *                 Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowName(java.lang.String flowName) {
            this.flowName = flowName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFlowConfig}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFlowConfig}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(software.amazon.awscdk.IResolvable sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTasks}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(software.amazon.awscdk.IResolvable tasks) {
            this.tasks = tasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTasks}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(java.util.List<? extends java.lang.Object> tasks) {
            this.tasks = tasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTriggerConfig}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTriggerConfig}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(software.amazon.awscdk.IResolvable triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDescription}
         * @param description A user-entered description of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getKmsArn}
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *               This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(java.lang.String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTags}
         * @param tags The tags used to organize, track, or control access for your flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowProps {
        private final java.lang.Object destinationFlowConfigList;
        private final java.lang.String flowName;
        private final java.lang.Object sourceFlowConfig;
        private final java.lang.Object tasks;
        private final java.lang.Object triggerConfig;
        private final java.lang.String description;
        private final java.lang.String kmsArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationFlowConfigList = software.amazon.jsii.Kernel.get(this, "destinationFlowConfigList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.flowName = software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceFlowConfig = software.amazon.jsii.Kernel.get(this, "sourceFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tasks = software.amazon.jsii.Kernel.get(this, "tasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.triggerConfig = software.amazon.jsii.Kernel.get(this, "triggerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationFlowConfigList = java.util.Objects.requireNonNull(builder.destinationFlowConfigList, "destinationFlowConfigList is required");
            this.flowName = java.util.Objects.requireNonNull(builder.flowName, "flowName is required");
            this.sourceFlowConfig = java.util.Objects.requireNonNull(builder.sourceFlowConfig, "sourceFlowConfig is required");
            this.tasks = java.util.Objects.requireNonNull(builder.tasks, "tasks is required");
            this.triggerConfig = java.util.Objects.requireNonNull(builder.triggerConfig, "triggerConfig is required");
            this.description = builder.description;
            this.kmsArn = builder.kmsArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDestinationFlowConfigList() {
            return this.destinationFlowConfigList;
        }

        @Override
        public final java.lang.String getFlowName() {
            return this.flowName;
        }

        @Override
        public final java.lang.Object getSourceFlowConfig() {
            return this.sourceFlowConfig;
        }

        @Override
        public final java.lang.Object getTasks() {
            return this.tasks;
        }

        @Override
        public final java.lang.Object getTriggerConfig() {
            return this.triggerConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationFlowConfigList", om.valueToTree(this.getDestinationFlowConfigList()));
            data.set("flowName", om.valueToTree(this.getFlowName()));
            data.set("sourceFlowConfig", om.valueToTree(this.getSourceFlowConfig()));
            data.set("tasks", om.valueToTree(this.getTasks()));
            data.set("triggerConfig", om.valueToTree(this.getTriggerConfig()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getKmsArn() != null) {
                data.set("kmsArn", om.valueToTree(this.getKmsArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowProps.Jsii$Proxy that = (CfnFlowProps.Jsii$Proxy) o;

            if (!destinationFlowConfigList.equals(that.destinationFlowConfigList)) return false;
            if (!flowName.equals(that.flowName)) return false;
            if (!sourceFlowConfig.equals(that.sourceFlowConfig)) return false;
            if (!tasks.equals(that.tasks)) return false;
            if (!triggerConfig.equals(that.triggerConfig)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.kmsArn != null ? !this.kmsArn.equals(that.kmsArn) : that.kmsArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationFlowConfigList.hashCode();
            result = 31 * result + (this.flowName.hashCode());
            result = 31 * result + (this.sourceFlowConfig.hashCode());
            result = 31 * result + (this.tasks.hashCode());
            result = 31 * result + (this.triggerConfig.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.kmsArn != null ? this.kmsArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
