package software.amazon.awscdk.pipelines;

/**
 * Properties for a `PermissionsBroadeningCheck`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage stage = new MyApplicationStage(this, "MyApplication");
 * pipeline.addStage(stage, AddStageOpts.builder()
 *         .pre(List.of(
 *             ConfirmPermissionsBroadening.Builder.create("Check").stage(stage).build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:11.428Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.PermissionsBroadeningCheckProps")
@software.amazon.jsii.Jsii.Proxy(PermissionsBroadeningCheckProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PermissionsBroadeningCheckProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CDK Stage object to check the stacks of.
     * <p>
     * This should be the same Stage object you are passing to <code>addStage()</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage getStage();

    /**
     * Topic to send notifications when a human needs to give manual confirmation.
     * <p>
     * Default: - no notification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PermissionsBroadeningCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PermissionsBroadeningCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PermissionsBroadeningCheckProps> {
        software.amazon.awscdk.Stage stage;
        software.amazon.awscdk.services.sns.ITopic notificationTopic;

        /**
         * Sets the value of {@link PermissionsBroadeningCheckProps#getStage}
         * @param stage The CDK Stage object to check the stacks of. This parameter is required.
         *              This should be the same Stage object you are passing to <code>addStage()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(software.amazon.awscdk.Stage stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Sets the value of {@link PermissionsBroadeningCheckProps#getNotificationTopic}
         * @param notificationTopic Topic to send notifications when a human needs to give manual confirmation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopic(software.amazon.awscdk.services.sns.ITopic notificationTopic) {
            this.notificationTopic = notificationTopic;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PermissionsBroadeningCheckProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PermissionsBroadeningCheckProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PermissionsBroadeningCheckProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PermissionsBroadeningCheckProps {
        private final software.amazon.awscdk.Stage stage;
        private final software.amazon.awscdk.services.sns.ITopic notificationTopic;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stage.class));
            this.notificationTopic = software.amazon.jsii.Kernel.get(this, "notificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stage = java.util.Objects.requireNonNull(builder.stage, "stage is required");
            this.notificationTopic = builder.notificationTopic;
        }

        @Override
        public final software.amazon.awscdk.Stage getStage() {
            return this.stage;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
            return this.notificationTopic;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stage", om.valueToTree(this.getStage()));
            if (this.getNotificationTopic() != null) {
                data.set("notificationTopic", om.valueToTree(this.getNotificationTopic()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.PermissionsBroadeningCheckProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PermissionsBroadeningCheckProps.Jsii$Proxy that = (PermissionsBroadeningCheckProps.Jsii$Proxy) o;

            if (!stage.equals(that.stage)) return false;
            return this.notificationTopic != null ? this.notificationTopic.equals(that.notificationTopic) : that.notificationTopic == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stage.hashCode();
            result = 31 * result + (this.notificationTopic != null ? this.notificationTopic.hashCode() : 0);
            return result;
        }
    }
}
