package software.amazon.awscdk;

/**
 * Properties for defining a `CfnHookVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnHookVersionProps cfnHookVersionProps = CfnHookVersionProps.builder()
 *         .schemaHandlerPackage("schemaHandlerPackage")
 *         .typeName("typeName")
 *         // the properties below are optional
 *         .executionRoleArn("executionRoleArn")
 *         .loggingConfig(LoggingConfigProperty.builder()
 *                 .logGroupName("logGroupName")
 *                 .logRoleArn("logRoleArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:04.328Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnHookVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnHookVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnHookVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A URL to the Amazon S3 bucket containing the hook project package that contains the necessary files for the hook you want to register.
     * <p>
     * For information on generating a schema handler package for the resource you want to register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a> in the <em>CloudFormation CLI User Guide for Extension Development</em> .
     * <p>
     * <blockquote>
     * <p>
     * The user registering the resource must be able to access the package in the S3 bucket. That's, the user must have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaHandlerPackage();

    /**
     * The unique name for your hook.
     * <p>
     * Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
     * <p>
     * <blockquote>
     * <p>
     * The following organization namespaces are reserved and can't be used in your hook type names:
     * <p>
     * <ul>
     * <li><code>Alexa</code></li>
     * <li><code>AMZN</code></li>
     * <li><code>Amazon</code></li>
     * <li><code>ASK</code></li>
     * <li><code>AWS</code></li>
     * <li><code>Custom</code></li>
     * <li><code>Dev</code></li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the hook permission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * Contains logging configuration information for an extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnHookVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnHookVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnHookVersionProps> {
        java.lang.String schemaHandlerPackage;
        java.lang.String typeName;
        java.lang.String executionRoleArn;
        java.lang.Object loggingConfig;

        /**
         * Sets the value of {@link CfnHookVersionProps#getSchemaHandlerPackage}
         * @param schemaHandlerPackage A URL to the Amazon S3 bucket containing the hook project package that contains the necessary files for the hook you want to register. This parameter is required.
         *                             For information on generating a schema handler package for the resource you want to register, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html">submit</a> in the <em>CloudFormation CLI User Guide for Extension Development</em> .
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             The user registering the resource must be able to access the package in the S3 bucket. That's, the user must have <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html">GetObject</a> permissions for the schema handler package. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaHandlerPackage(java.lang.String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookVersionProps#getTypeName}
         * @param typeName The unique name for your hook. This parameter is required.
         *                 Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 The following organization namespaces are reserved and can't be used in your hook type names:
         *                 <p>
         *                 <ul>
         *                 <li><code>Alexa</code></li>
         *                 <li><code>AMZN</code></li>
         *                 <li><code>Amazon</code></li>
         *                 <li><code>ASK</code></li>
         *                 <li><code>AWS</code></li>
         *                 <li><code>Custom</code></li>
         *                 <li><code>Dev</code></li>
         *                 </ul>
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookVersionProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants the hook permission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookVersionProps#getLoggingConfig}
         * @param loggingConfig Contains logging configuration information for an extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.IResolvable loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnHookVersionProps#getLoggingConfig}
         * @param loggingConfig Contains logging configuration information for an extension.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.CfnHookVersion.LoggingConfigProperty loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnHookVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnHookVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnHookVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnHookVersionProps {
        private final java.lang.String schemaHandlerPackage;
        private final java.lang.String typeName;
        private final java.lang.String executionRoleArn;
        private final java.lang.Object loggingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schemaHandlerPackage = software.amazon.jsii.Kernel.get(this, "schemaHandlerPackage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfig = software.amazon.jsii.Kernel.get(this, "loggingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schemaHandlerPackage = java.util.Objects.requireNonNull(builder.schemaHandlerPackage, "schemaHandlerPackage is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
            this.executionRoleArn = builder.executionRoleArn;
            this.loggingConfig = builder.loggingConfig;
        }

        @Override
        public final java.lang.String getSchemaHandlerPackage() {
            return this.schemaHandlerPackage;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.Object getLoggingConfig() {
            return this.loggingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schemaHandlerPackage", om.valueToTree(this.getSchemaHandlerPackage()));
            data.set("typeName", om.valueToTree(this.getTypeName()));
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getLoggingConfig() != null) {
                data.set("loggingConfig", om.valueToTree(this.getLoggingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnHookVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnHookVersionProps.Jsii$Proxy that = (CfnHookVersionProps.Jsii$Proxy) o;

            if (!schemaHandlerPackage.equals(that.schemaHandlerPackage)) return false;
            if (!typeName.equals(that.typeName)) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            return this.loggingConfig != null ? this.loggingConfig.equals(that.loggingConfig) : that.loggingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schemaHandlerPackage.hashCode();
            result = 31 * result + (this.typeName.hashCode());
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.loggingConfig != null ? this.loggingConfig.hashCode() : 0);
            return result;
        }
    }
}
