package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for creating an Amazon SageMaker transform job task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTransformJob.Builder.create(this, "Batch Inference")
 *         .transformJobName("MyTransformJob")
 *         .modelName("MyModelName")
 *         .modelClientOptions(ModelClientOptions.builder()
 *                 .invocationsMaxRetries(3) // default is 0
 *                 .invocationsTimeout(Duration.minutes(5))
 *                 .build())
 *         .transformInput(TransformInput.builder()
 *                 .transformDataSource(TransformDataSource.builder()
 *                         .s3DataSource(TransformS3DataSource.builder()
 *                                 .s3Uri("s3://inputbucket/train")
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .transformOutput(TransformOutput.builder()
 *                 .s3OutputPath("s3://outputbucket/TransformJobOutputPath")
 *                 .build())
 *         .transformResources(TransformResources.builder()
 *                 .instanceCount(1)
 *                 .instanceType(InstanceType.of(InstanceClass.M4, InstanceSize.XLARGE))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:42.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTransformJobProps")
@software.amazon.jsii.Jsii.Proxy(SageMakerCreateTransformJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SageMakerCreateTransformJobProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * Name of the model that you want to use for the transform job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelName();

    /**
     * Dataset to be transformed and the Amazon S3 location where it is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformInput getTransformInput();

    /**
     * Transform Job Name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransformJobName();

    /**
     * S3 location where you want Amazon SageMaker to save the results from the transform job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput getTransformOutput();

    /**
     * Number of records to include in a mini-batch for an HTTP inference request.
     * <p>
     * Default: - No batch strategy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy getBatchStrategy() {
        return null;
    }

    /**
     * Environment variables to set in the Docker container.
     * <p>
     * Default: - No environment variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * Maximum number of parallel requests that can be sent to each instance in a transform job.
     * <p>
     * Default: - Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm.
     * If the execution-parameters endpoint is not enabled, the default value is 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentTransforms() {
        return null;
    }

    /**
     * Maximum allowed size of the payload, in MB.
     * <p>
     * Default: 6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMaxPayload() {
        return null;
    }

    /**
     * Configures the timeout and maximum number of retries for processing a transform job invocation.
     * <p>
     * Default: - 0 retries and 60 seconds of timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions getModelClientOptions() {
        return null;
    }

    /**
     * Role for the Transform Job.
     * <p>
     * Default: - A role is created with `AmazonSageMakerFullAccess` managed policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Tags to be applied to the train job.
     * <p>
     * Default: - No tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * ML compute instances for the transform job.
     * <p>
     * Default: - 1 instance of type M4.XLarge
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.TransformResources getTransformResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SageMakerCreateTransformJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SageMakerCreateTransformJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SageMakerCreateTransformJobProps> {
        java.lang.String modelName;
        software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput;
        java.lang.String transformJobName;
        software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput;
        software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.Number maxConcurrentTransforms;
        software.amazon.awscdk.Size maxPayload;
        software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions modelClientOptions;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.Map<java.lang.String, java.lang.String> tags;
        software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources;
        java.lang.String comment;
        software.amazon.awscdk.Duration heartbeat;
        java.lang.String inputPath;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        java.lang.String outputPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getModelName}
         * @param modelName Name of the model that you want to use for the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTransformInput}
         * @param transformInput Dataset to be transformed and the Amazon S3 location where it is stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformInput(software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTransformJobName}
         * @param transformJobName Transform Job Name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformJobName(java.lang.String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTransformOutput}
         * @param transformOutput S3 location where you want Amazon SageMaker to save the results from the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformOutput(software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getBatchStrategy}
         * @param batchStrategy Number of records to include in a mini-batch for an HTTP inference request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchStrategy(software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getEnvironment}
         * @param environment Environment variables to set in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getMaxConcurrentTransforms}
         * @param maxConcurrentTransforms Maximum number of parallel requests that can be sent to each instance in a transform job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrentTransforms(java.lang.Number maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getMaxPayload}
         * @param maxPayload Maximum allowed size of the payload, in MB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxPayload(software.amazon.awscdk.Size maxPayload) {
            this.maxPayload = maxPayload;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getModelClientOptions}
         * @param modelClientOptions Configures the timeout and maximum number of retries for processing a transform job invocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelClientOptions(software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions modelClientOptions) {
            this.modelClientOptions = modelClientOptions;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getRole}
         * @param role Role for the Transform Job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTags}
         * @param tags Tags to be applied to the train job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTransformResources}
         * @param transformResources ML compute instances for the transform job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformResources(software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link SageMakerCreateTransformJobProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SageMakerCreateTransformJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SageMakerCreateTransformJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SageMakerCreateTransformJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerCreateTransformJobProps {
        private final java.lang.String modelName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput;
        private final java.lang.String transformJobName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput;
        private final software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Number maxConcurrentTransforms;
        private final software.amazon.awscdk.Size maxPayload;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions modelClientOptions;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources;
        private final java.lang.String comment;
        private final software.amazon.awscdk.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transformInput = software.amazon.jsii.Kernel.get(this, "transformInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformInput.class));
            this.transformJobName = software.amazon.jsii.Kernel.get(this, "transformJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transformOutput = software.amazon.jsii.Kernel.get(this, "transformOutput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput.class));
            this.batchStrategy = software.amazon.jsii.Kernel.get(this, "batchStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxConcurrentTransforms = software.amazon.jsii.Kernel.get(this, "maxConcurrentTransforms", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxPayload = software.amazon.jsii.Kernel.get(this, "maxPayload", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.modelClientOptions = software.amazon.jsii.Kernel.get(this, "modelClientOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.transformResources = software.amazon.jsii.Kernel.get(this, "transformResources", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TransformResources.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.modelName = java.util.Objects.requireNonNull(builder.modelName, "modelName is required");
            this.transformInput = java.util.Objects.requireNonNull(builder.transformInput, "transformInput is required");
            this.transformJobName = java.util.Objects.requireNonNull(builder.transformJobName, "transformJobName is required");
            this.transformOutput = java.util.Objects.requireNonNull(builder.transformOutput, "transformOutput is required");
            this.batchStrategy = builder.batchStrategy;
            this.environment = builder.environment;
            this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
            this.maxPayload = builder.maxPayload;
            this.modelClientOptions = builder.modelClientOptions;
            this.role = builder.role;
            this.tags = builder.tags;
            this.transformResources = builder.transformResources;
            this.comment = builder.comment;
            this.heartbeat = builder.heartbeat;
            this.inputPath = builder.inputPath;
            this.integrationPattern = builder.integrationPattern;
            this.outputPath = builder.outputPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformInput getTransformInput() {
            return this.transformInput;
        }

        @Override
        public final java.lang.String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput getTransformOutput() {
            return this.transformOutput;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy getBatchStrategy() {
            return this.batchStrategy;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Number getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        @Override
        public final software.amazon.awscdk.Size getMaxPayload() {
            return this.maxPayload;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ModelClientOptions getModelClientOptions() {
            return this.modelClientOptions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TransformResources getTransformResources() {
            return this.transformResources;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("modelName", om.valueToTree(this.getModelName()));
            data.set("transformInput", om.valueToTree(this.getTransformInput()));
            data.set("transformJobName", om.valueToTree(this.getTransformJobName()));
            data.set("transformOutput", om.valueToTree(this.getTransformOutput()));
            if (this.getBatchStrategy() != null) {
                data.set("batchStrategy", om.valueToTree(this.getBatchStrategy()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getMaxConcurrentTransforms() != null) {
                data.set("maxConcurrentTransforms", om.valueToTree(this.getMaxConcurrentTransforms()));
            }
            if (this.getMaxPayload() != null) {
                data.set("maxPayload", om.valueToTree(this.getMaxPayload()));
            }
            if (this.getModelClientOptions() != null) {
                data.set("modelClientOptions", om.valueToTree(this.getModelClientOptions()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransformResources() != null) {
                data.set("transformResources", om.valueToTree(this.getTransformResources()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTransformJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SageMakerCreateTransformJobProps.Jsii$Proxy that = (SageMakerCreateTransformJobProps.Jsii$Proxy) o;

            if (!modelName.equals(that.modelName)) return false;
            if (!transformInput.equals(that.transformInput)) return false;
            if (!transformJobName.equals(that.transformJobName)) return false;
            if (!transformOutput.equals(that.transformOutput)) return false;
            if (this.batchStrategy != null ? !this.batchStrategy.equals(that.batchStrategy) : that.batchStrategy != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.maxConcurrentTransforms != null ? !this.maxConcurrentTransforms.equals(that.maxConcurrentTransforms) : that.maxConcurrentTransforms != null) return false;
            if (this.maxPayload != null ? !this.maxPayload.equals(that.maxPayload) : that.maxPayload != null) return false;
            if (this.modelClientOptions != null ? !this.modelClientOptions.equals(that.modelClientOptions) : that.modelClientOptions != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transformResources != null ? !this.transformResources.equals(that.transformResources) : that.transformResources != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.modelName.hashCode();
            result = 31 * result + (this.transformInput.hashCode());
            result = 31 * result + (this.transformJobName.hashCode());
            result = 31 * result + (this.transformOutput.hashCode());
            result = 31 * result + (this.batchStrategy != null ? this.batchStrategy.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.maxConcurrentTransforms != null ? this.maxConcurrentTransforms.hashCode() : 0);
            result = 31 * result + (this.maxPayload != null ? this.maxPayload.hashCode() : 0);
            result = 31 * result + (this.modelClientOptions != null ? this.modelClientOptions.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transformResources != null ? this.transformResources.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
