package software.amazon.awscdk.services.stepfunctions;

/**
 * Type union for task classes that accept multiple types of payload.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * LambdaInvoke.Builder.create(this, "Invoke with callback")
 *         .lambdaFunction(fn)
 *         .integrationPattern(IntegrationPattern.WAIT_FOR_TASK_TOKEN)
 *         .payload(TaskInput.fromObject(Map.of(
 *                 "token", JsonPath.getTaskToken(),
 *                 "input", JsonPath.stringAt("$.someField"))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:42.408Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.TaskInput")
public class TaskInput extends software.amazon.jsii.JsiiObject {

    protected TaskInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TaskInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use a part of the execution data or task context as task input.
     * <p>
     * Use this when you want to use a subobject or string from
     * the current state machine execution or the current task context
     * as complete payload to a task.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput fromJsonPathAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.TaskInput.class, "fromJsonPathAt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Use an object as task input.
     * <p>
     * This object may contain JSON path fields as object values, if desired.
     * <p>
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput fromObject(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.TaskInput.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class), new Object[] { java.util.Objects.requireNonNull(obj, "obj is required") });
    }

    /**
     * Use a literal string as task input.
     * <p>
     * This might be a JSON-encoded object, or just a text.
     * <p>
     * @param text This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput fromText(final @org.jetbrains.annotations.NotNull java.lang.String text) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.TaskInput.class, "fromText", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class), new Object[] { java.util.Objects.requireNonNull(text, "text is required") });
    }

    /**
     * type of task input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.InputType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.InputType.class));
    }

    /**
     * payload for the corresponding input type.
     * <p>
     * It can be a JSON-encoded object, context, data, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
