package software.amazon.awscdk.services.s3;

/**
 * Inventory version support.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Bucket inventoryBucket = new Bucket(this, "InventoryBucket");
 * Bucket dataBucket = Bucket.Builder.create(this, "DataBucket")
 *         .inventories(List.of(Inventory.builder()
 *                 .frequency(InventoryFrequency.DAILY)
 *                 .includeObjectVersions(InventoryObjectVersion.CURRENT)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .build())
 *                 .build(), Inventory.builder()
 *                 .frequency(InventoryFrequency.WEEKLY)
 *                 .includeObjectVersions(InventoryObjectVersion.ALL)
 *                 .destination(InventoryDestination.builder()
 *                         .bucket(inventoryBucket)
 *                         .prefix("with-all-versions")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.813Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.InventoryObjectVersion")
public enum InventoryObjectVersion {
    /**
     * Includes all versions of each object in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Includes only the current version of each object in the report.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CURRENT,
}
