package software.amazon.awscdk.services.redshift;

/**
 * A CloudFormation `AWS::Redshift::ScheduledAction`.
 * <p>
 * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * Object targetAction;
 * CfnScheduledAction cfnScheduledAction = CfnScheduledAction.Builder.create(this, "MyCfnScheduledAction")
 *         .scheduledActionName("scheduledActionName")
 *         // the properties below are optional
 *         .enable(false)
 *         .endTime("endTime")
 *         .iamRole("iamRole")
 *         .schedule("schedule")
 *         .scheduledActionDescription("scheduledActionDescription")
 *         .startTime("startTime")
 *         .targetAction(targetAction)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.549Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction")
public class CfnScheduledAction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnScheduledAction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Redshift::ScheduledAction`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScheduledAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.CfnScheduledActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * List of times when the scheduled action will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrNextInvocations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrNextInvocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The state of the scheduled action.
     * <p>
     * For example, <code>DISABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduledActionName() {
        return software.amazon.jsii.Kernel.get(this, "scheduledActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledActionName", java.util.Objects.requireNonNull(value, "scheduledActionName is required"));
    }

    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     * <p>
     * " <code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code> ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTargetAction() {
        return software.amazon.jsii.Kernel.get(this, "targetAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     * <p>
     * " <code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code> ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetAction(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "targetAction", java.util.Objects.requireNonNull(value, "targetAction is required"));
    }

    /**
     * If true, the schedule is enabled.
     * <p>
     * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
        return software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If true, the schedule is enabled.
     * <p>
     * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enable", value);
    }

    /**
     * If true, the schedule is enabled.
     * <p>
     * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enable", value);
    }

    /**
     * The end time in UTC when the schedule is no longer active.
     * <p>
     * After this time, the scheduled action does not trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndTime() {
        return software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The end time in UTC when the schedule is no longer active.
     * <p>
     * After this time, the scheduled action does not trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endTime", value);
    }

    /**
     * The IAM role to assume to run the scheduled action.
     * <p>
     * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamRole() {
        return software.amazon.jsii.Kernel.get(this, "iamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role to assume to run the scheduled action.
     * <p>
     * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamRole", value);
    }

    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
     * <p>
     * Schedule invocations must be separated by at least one hour.
     * <p>
     * Format of at expressions is " <code>at(yyyy-mm-ddThh:mm:ss)</code> ". For example, " <code>at(2016-03-04T17:27:00)</code> ".
     * <p>
     * Format of cron expressions is " <code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code> ". For example, " <code>cron(0 10 ? * MON *)</code> ". For more information, see <a href="https://docs.aws.amazon.com//AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <em>Amazon CloudWatch Events User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
     * <p>
     * Schedule invocations must be separated by at least one hour.
     * <p>
     * Format of at expressions is " <code>at(yyyy-mm-ddThh:mm:ss)</code> ". For example, " <code>at(2016-03-04T17:27:00)</code> ".
     * <p>
     * Format of cron expressions is " <code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code> ". For example, " <code>cron(0 10 ? * MON *)</code> ". For more information, see <a href="https://docs.aws.amazon.com//AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <em>Amazon CloudWatch Events User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The description of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduledActionDescription() {
        return software.amazon.jsii.Kernel.get(this, "scheduledActionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledActionDescription", value);
    }

    /**
     * The start time in UTC when the schedule is active.
     * <p>
     * Before this time, the scheduled action does not trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start time in UTC when the schedule is active.
     * <p>
     * Before this time, the scheduled action does not trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshift.CfnScheduledAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshift.CfnScheduledAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshift.CfnScheduledActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshift.CfnScheduledActionProps.Builder();
        }

        /**
         * The name of the scheduled action.
         * <p>
         * @return {@code this}
         * @param scheduledActionName The name of the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActionName(final java.lang.String scheduledActionName) {
            this.props.scheduledActionName(scheduledActionName);
            return this;
        }

        /**
         * If true, the schedule is enabled.
         * <p>
         * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
         * <p>
         * @return {@code this}
         * @param enable If true, the schedule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final java.lang.Boolean enable) {
            this.props.enable(enable);
            return this;
        }
        /**
         * If true, the schedule is enabled.
         * <p>
         * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
         * <p>
         * @return {@code this}
         * @param enable If true, the schedule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final software.amazon.awscdk.IResolvable enable) {
            this.props.enable(enable);
            return this;
        }

        /**
         * The end time in UTC when the schedule is no longer active.
         * <p>
         * After this time, the scheduled action does not trigger.
         * <p>
         * @return {@code this}
         * @param endTime The end time in UTC when the schedule is no longer active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(final java.lang.String endTime) {
            this.props.endTime(endTime);
            return this;
        }

        /**
         * The IAM role to assume to run the scheduled action.
         * <p>
         * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * <p>
         * @return {@code this}
         * @param iamRole The IAM role to assume to run the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRole(final java.lang.String iamRole) {
            this.props.iamRole(iamRole);
            return this;
        }

        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
         * <p>
         * Schedule invocations must be separated by at least one hour.
         * <p>
         * Format of at expressions is " <code>at(yyyy-mm-ddThh:mm:ss)</code> ". For example, " <code>at(2016-03-04T17:27:00)</code> ".
         * <p>
         * Format of cron expressions is " <code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code> ". For example, " <code>cron(0 10 ? * MON *)</code> ". For more information, see <a href="https://docs.aws.amazon.com//AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <em>Amazon CloudWatch Events User Guide</em> .
         * <p>
         * @return {@code this}
         * @param schedule The schedule for a one-time (at format) or recurring (cron format) scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final java.lang.String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The description of the scheduled action.
         * <p>
         * @return {@code this}
         * @param scheduledActionDescription The description of the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActionDescription(final java.lang.String scheduledActionDescription) {
            this.props.scheduledActionDescription(scheduledActionDescription);
            return this;
        }

        /**
         * The start time in UTC when the schedule is active.
         * <p>
         * Before this time, the scheduled action does not trigger.
         * <p>
         * @return {@code this}
         * @param startTime The start time in UTC when the schedule is active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         * <p>
         * " <code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code> ".
         * <p>
         * @return {@code this}
         * @param targetAction A JSON format string of the Amazon Redshift API operation with input parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAction(final java.lang.Object targetAction) {
            this.props.targetAction(targetAction);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.redshift.CfnScheduledAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshift.CfnScheduledAction build() {
            return new software.amazon.awscdk.services.redshift.CfnScheduledAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
