package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 * <p>
 * The <code>AWS::RDS::DBInstance</code> resource creates an Amazon RDS DB instance.
 * <p>
 * If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
 * <p>
 * <blockquote>
 * <p>
 * If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html">Prevent Updates to Stack Resources</a> .
 * <p>
 * </blockquote>
 * <p>
 * This topic covers the resource for Amazon RDS DB instances. For the documentation on the resource for Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
 * <p>
 * <em>Updating DB instances</em>
 * <p>
 * When properties labeled " <em>Update requires:</em> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> " are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
 * <p>
 * <blockquote>
 * <p>
 * We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
 * <p>
 * <ul>
 * <li>Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.</li>
 * <li>Create a snapshot of the DB instance. For more information about creating DB snapshots, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html">Creating a DB Snapshot</a> .</li>
 * <li>If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the <code>DBSnapshotIdentifier</code> property with the ID of the DB snapshot that you want to use.</li>
 * </ul>
 * <p>
 * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
 * <p>
 * <ul>
 * <li>Update the stack.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * For more information about updating other properties of this resource, see <code>[ModifyDBInstance](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBInstance.html)</code> . For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * <em>Deleting DB instances</em>
 * <p>
 * For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to <em>retain</em> the DB instance, to <em>delete</em> the DB instance, or to <em>create a snapshot</em> of the DB instance. The default AWS CloudFormation behavior depends on the <code>DBClusterIdentifier</code> property:
 * <p>
 * <ul>
 * <li>For <code>AWS::RDS::DBInstance</code> resources that don't specify the <code>DBClusterIdentifier</code> property, AWS CloudFormation saves a snapshot of the DB instance.</li>
 * <li>For <code>AWS::RDS::DBInstance</code> resources that do specify the <code>DBClusterIdentifier</code> property, AWS CloudFormation deletes the DB instance.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBInstance cfnDBInstance = CfnDBInstance.Builder.create(this, "MyCfnDBInstance")
 *         .allocatedStorage("allocatedStorage")
 *         .allowMajorVersionUpgrade(false)
 *         .associatedRoles(List.of(DBInstanceRoleProperty.builder()
 *                 .featureName("featureName")
 *                 .roleArn("roleArn")
 *                 .build()))
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .backupRetentionPeriod(123)
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .characterSetName("characterSetName")
 *         .copyTagsToSnapshot(false)
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbInstanceClass("dbInstanceClass")
 *         .dbInstanceIdentifier("dbInstanceIdentifier")
 *         .dbName("dbName")
 *         .dbParameterGroupName("dbParameterGroupName")
 *         .dbSecurityGroups(List.of("dbSecurityGroups"))
 *         .dbSnapshotIdentifier("dbSnapshotIdentifier")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .deleteAutomatedBackups(false)
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainIamRoleName("domainIamRoleName")
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableIamDatabaseAuthentication(false)
 *         .enablePerformanceInsights(false)
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .licenseModel("licenseModel")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .maxAllocatedStorage(123)
 *         .monitoringInterval(123)
 *         .monitoringRoleArn("monitoringRoleArn")
 *         .multiAz(false)
 *         .optionGroupName("optionGroupName")
 *         .performanceInsightsKmsKeyId("performanceInsightsKmsKeyId")
 *         .performanceInsightsRetentionPeriod(123)
 *         .port("port")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .processorFeatures(List.of(ProcessorFeatureProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .promotionTier(123)
 *         .publiclyAccessible(false)
 *         .sourceDbInstanceIdentifier("sourceDbInstanceIdentifier")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timezone("timezone")
 *         .useDefaultProcessorFeatures(false)
 *         .vpcSecurityGroups(List.of("vpcSecurityGroups"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.376Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance")
public class CfnDBInstance extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBInstance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::RDS::DBInstance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The connection endpoint for the database.
     * <p>
     * For example: <code>mystack-mydb-1apw1j4phylrk.cg034hpkmmjt.us-east-2.rds.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the database accepts connections.
     * <p>
     * For example: <code>3306</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags to assign to the DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The amount of storage (in gigabytes) to be initially allocated for the database instance.
     * <p>
     * <blockquote>
     * <p>
     * If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Provisioned IOPS storage (io1):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Magnetic storage (standard):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllocatedStorage() {
        return software.amazon.jsii.Kernel.get(this, "allocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The amount of storage (in gigabytes) to be initially allocated for the database instance.
     * <p>
     * <blockquote>
     * <p>
     * If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
     * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
     * <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Constraints to the amount of storage for each storage type are the following:
     * <p>
     * <ul>
     * <li>General Purpose (SSD) storage (gp2):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Provisioned IOPS storage (io1):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
     * <li>Magnetic storage (standard):</li>
     * <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
     * <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllocatedStorage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allocatedStorage", value);
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     * <p>
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * <p>
     * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowMajorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "allowMajorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     * <p>
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * <p>
     * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowMajorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowMajorVersionUpgrade", value);
    }

    /**
     * A value that indicates whether major version upgrades are allowed.
     * <p>
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     * <p>
     * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowMajorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowMajorVersionUpgrade", value);
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated roles are managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated roles are managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated roles are managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceRoleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnDBInstance.DBInstanceRoleProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * The Availability Zone (AZ) where the database will be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
     * <p>
     * Example: <code>us-east-1d</code>
     * <p>
     * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone (AZ) where the database will be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
     * <p>
     * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
     * <p>
     * Example: <code>us-east-1d</code>
     * <p>
     * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 0 to 35</li>
     * <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The retention period for automated backups is managed by the DB cluster.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 0 to 35</li>
     * <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * <blockquote>
     * <p>
     * Specifying or updating this property triggers a reboot.
     * <p>
     * </blockquote>
     * <p>
     * For more information about CA certificate identifiers for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For more information about CA certificate identifiers for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * <blockquote>
     * <p>
     * Specifying or updating this property triggers a reboot.
     * <p>
     * </blockquote>
     * <p>
     * For more information about CA certificate identifiers for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For more information about CA certificate identifiers for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaCertificateIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "caCertificateIdentifier", value);
    }

    /**
     * For supported engines, indicates that the DB instance should be associated with the specified character set.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCharacterSetName() {
        return software.amazon.jsii.Kernel.get(this, "characterSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For supported engines, indicates that the DB instance should be associated with the specified character set.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCharacterSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "characterSetName", value);
    }

    /**
     * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance.
     * <p>
     * By default, tags are not copied.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance.
     * <p>
     * By default, tags are not copied.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance.
     * <p>
     * By default, tags are not copied.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * The identifier of the DB cluster that the instance will belong to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the DB cluster that the instance will belong to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * The compute and memory capacity of the DB instance, for example, `db.m4.large` . Not all DB instance classes are available in all AWS Regions, or for all database engines.
     * <p>
     * For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <em>Amazon RDS User Guide.</em> For more information about DB instance class pricing and AWS Region support for DB instance classes, see <a href="https://docs.aws.amazon.com/rds/pricing/">Amazon RDS Pricing</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceClass() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute and memory capacity of the DB instance, for example, `db.m4.large` . Not all DB instance classes are available in all AWS Regions, or for all database engines.
     * <p>
     * For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <em>Amazon RDS User Guide.</em> For more information about DB instance class pricing and AWS Region support for DB instance classes, see <a href="https://docs.aws.amazon.com/rds/pricing/">Amazon RDS Pricing</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceClass", value);
    }

    /**
     * A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbInstanceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbInstanceIdentifier", value);
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The database name is managed by the DB cluster.
     * <p>
     * <em>MySQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 63 letters, numbers, or underscores.</li>
     * <li>Must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0-9).</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
     * <p>
     * Default: <code>ORCL</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be longer than 8 characters</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Not applicable. Must be null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbName() {
        return software.amazon.jsii.Kernel.get(this, "dbName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The database name is managed by the DB cluster.
     * <p>
     * <em>MySQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>MariaDB</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 64 letters or numbers.</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain 1 to 63 letters, numbers, or underscores.</li>
     * <li>Must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0-9).</li>
     * <li>Can't be a word reserved by the specified database engine</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
     * <p>
     * Default: <code>ORCL</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't be longer than 8 characters</li>
     * </ul>
     * <p>
     * <em>SQL Server</em>
     * <p>
     * Not applicable. Must be null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbName", value);
    }

    /**
     * The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
     * <p>
     * To list all of the available DB parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
     * <p>
     * <blockquote>
     * <p>
     * If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
     * <p>
     * </blockquote>
     * <p>
     * If you don't specify a value for the <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
     * <p>
     * To list all of the available DB parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
     * <p>
     * <blockquote>
     * <p>
     * If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
     * <p>
     * </blockquote>
     * <p>
     * If you don't specify a value for the <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbParameterGroupName", value);
    }

    /**
     * A list of the DB security groups to assign to the DB instance.
     * <p>
     * The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
     * <p>
     * If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
     * <p>
     * <blockquote>
     * <p>
     * If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
     * <p>
     * <ul>
     * <li><code>AllocatedStorage</code></li>
     * <li><code>AutoMinorVersionUpgrade</code></li>
     * <li><code>AvailabilityZone</code></li>
     * <li><code>BackupRetentionPeriod</code></li>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBInstanceClass</code></li>
     * <li><code>DBName</code></li>
     * <li><code>DBParameterGroupName</code></li>
     * <li><code>DBSecurityGroups</code></li>
     * <li><code>DBSubnetGroupName</code></li>
     * <li><code>Engine</code></li>
     * <li><code>EngineVersion</code></li>
     * <li><code>Iops</code></li>
     * <li><code>LicenseModel</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>MultiAZ</code></li>
     * <li><code>OptionGroupName</code></li>
     * <li><code>PreferredBackupWindow</code></li>
     * <li><code>PreferredMaintenanceWindow</code></li>
     * </ul>
     * <p>
     * All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dbSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the DB security groups to assign to the DB instance.
     * <p>
     * The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
     * <p>
     * If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
     * <p>
     * <blockquote>
     * <p>
     * If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
     * <p>
     * <ul>
     * <li><code>AllocatedStorage</code></li>
     * <li><code>AutoMinorVersionUpgrade</code></li>
     * <li><code>AvailabilityZone</code></li>
     * <li><code>BackupRetentionPeriod</code></li>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBInstanceClass</code></li>
     * <li><code>DBName</code></li>
     * <li><code>DBParameterGroupName</code></li>
     * <li><code>DBSecurityGroups</code></li>
     * <li><code>DBSubnetGroupName</code></li>
     * <li><code>Engine</code></li>
     * <li><code>EngineVersion</code></li>
     * <li><code>Iops</code></li>
     * <li><code>LicenseModel</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>MultiAZ</code></li>
     * <li><code>OptionGroupName</code></li>
     * <li><code>PreferredBackupWindow</code></li>
     * <li><code>PreferredMaintenanceWindow</code></li>
     * </ul>
     * <p>
     * All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dbSecurityGroups", value);
    }

    /**
     * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     * <p>
     * If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
     * <p>
     * By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
     * <p>
     * Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties. For information about the properties that you can specify, see the <code>RestoreDBInstanceFromDBSnapshot</code> action in the <em>Amazon RDS API Reference</em> .
     * <p>
     * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
     * <p>
     * If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBClusterIdentifier</code></li>
     * <li><code>DBName</code></li>
     * <li><code>DeleteAutomatedBackups</code></li>
     * <li><code>EnablePerformanceInsights</code></li>
     * <li><code>KmsKeyId</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>PerformanceInsightsKMSKeyId</code></li>
     * <li><code>PerformanceInsightsRetentionPeriod</code></li>
     * <li><code>PromotionTier</code></li>
     * <li><code>SourceDBInstanceIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>Timezone</code></li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Snapshot restore is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbSnapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
     * <p>
     * If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
     * <p>
     * By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
     * <p>
     * Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties. For information about the properties that you can specify, see the <code>RestoreDBInstanceFromDBSnapshot</code> action in the <em>Amazon RDS API Reference</em> .
     * <p>
     * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
     * <p>
     * If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>CharacterSetName</code></li>
     * <li><code>DBClusterIdentifier</code></li>
     * <li><code>DBName</code></li>
     * <li><code>DeleteAutomatedBackups</code></li>
     * <li><code>EnablePerformanceInsights</code></li>
     * <li><code>KmsKeyId</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>PerformanceInsightsKMSKeyId</code></li>
     * <li><code>PerformanceInsightsRetentionPeriod</code></li>
     * <li><code>PromotionTier</code></li>
     * <li><code>SourceDBInstanceIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>Timezone</code></li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Snapshot restore is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSnapshotIdentifier", value);
    }

    /**
     * A DB subnet group to associate with the DB instance.
     * <p>
     * If you update this value, the new subnet group must be a subnet group in a new VPC.
     * <p>
     * If there's no DB subnet group, then the DB instance isn't a VPC DB instance.
     * <p>
     * For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon Virtual Private Cloud (VPC)</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A DB subnet group to associate with the DB instance.
     * <p>
     * If you update this value, the new subnet group must be a subnet group in a new VPC.
     * <p>
     * If there's no DB subnet group, then the DB instance isn't a VPC DB instance.
     * <p>
     * For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon Virtual Private Cloud (VPC)</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     * <p>
     * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAutomatedBackups() {
        return software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     * <p>
     * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAutomatedBackups(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteAutomatedBackups", value);
    }

    /**
     * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
     * <p>
     * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAutomatedBackups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteAutomatedBackups", value);
    }

    /**
     * A value that indicates whether the DB instance has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB instance has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * A value that indicates whether the DB instance has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     * <p>
     * Currently, only Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Active Directory directory ID to create the DB instance in.
     * <p>
     * Currently, only Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domain", value);
    }

    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainIamRoleName() {
        return software.amazon.jsii.Kernel.get(this, "domainIamRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainIamRoleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainIamRoleName", value);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Valid values: <code>agent</code> , <code>error</code>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code> , <code>upgrade</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Valid values: <code>agent</code> , <code>error</code>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code> , <code>upgrade</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MySQL and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MySQL and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MySQL and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceInsights() {
        return software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePerformanceInsights(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enablePerformanceInsights", value);
    }

    /**
     * A value that indicates whether to enable Performance Insights for the DB instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnablePerformanceInsights(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enablePerformanceInsights", value);
    }

    /**
     * The name of the database engine that you want to use for this DB instance.
     * <p>
     * <blockquote>
     * <p>
     * When you are creating a DB instance, the <code>Engine</code> property is required.
     * <p>
     * </blockquote>
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
     * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se1</code></li>
     * <li><code>oracle-se</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database engine that you want to use for this DB instance.
     * <p>
     * <blockquote>
     * <p>
     * When you are creating a DB instance, the <code>Engine</code> property is required.
     * <p>
     * </blockquote>
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
     * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>mariadb</code></li>
     * <li><code>mysql</code></li>
     * <li><code>oracle-ee</code></li>
     * <li><code>oracle-se2</code></li>
     * <li><code>oracle-se1</code></li>
     * <li><code>oracle-se</code></li>
     * <li><code>postgres</code></li>
     * <li><code>sqlserver-ee</code></li>
     * <li><code>sqlserver-se</code></li>
     * <li><code>sqlserver-ex</code></li>
     * <li><code>sqlserver-web</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
     * <p>
     * The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>MySQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Oracle</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
     * <p>
     * The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>MySQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>Oracle</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     * <p>
     * The value must be equal to or greater than 1000.
     * <p>
     * If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of I/O operations per second (IOPS) that the database provisions.
     * <p>
     * The value must be equal to or greater than 1000.
     * <p>
     * If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIops(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "iops", value);
    }

    /**
     * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> property, the value is inherited from the source DB instance if the read replica is created in the same region.
     * <p>
     * If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The KMS key identifier is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> property, the value is inherited from the source DB instance if the read replica is created in the same region.
     * <p>
     * If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The KMS key identifier is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * License model information for this DB instance.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li>Aurora MySQL - <code>general-public-license</code></li>
     * <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
     * <li>MariaDB - <code>general-public-license</code></li>
     * <li>Microsoft SQL Server - <code>license-included</code></li>
     * <li>MySQL - <code>general-public-license</code></li>
     * <li>Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
     * <li>PostgreSQL - <code>postgresql-license</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * License model information for this DB instance.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li>Aurora MySQL - <code>general-public-license</code></li>
     * <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
     * <li>MariaDB - <code>general-public-license</code></li>
     * <li>Microsoft SQL Server - <code>license-included</code></li>
     * <li>MySQL - <code>general-public-license</code></li>
     * <li>Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
     * <li>PostgreSQL - <code>postgresql-license</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLicenseModel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "licenseModel", value);
    }

    /**
     * The master user name for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The name for the master user is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for MariaDB.</li>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for SQL Server.</li>
     * <li>Must be 1 to 128 letters or numbers.</li>
     * <li>The first character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for MySQL.</li>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for Oracle.</li>
     * <li>Must be 1 to 30 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for PostgreSQL.</li>
     * <li>Must be 1 to 63 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The master user name for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
     * <p>
     * </blockquote>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The name for the master user is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for MariaDB.</li>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for SQL Server.</li>
     * <li>Must be 1 to 128 letters or numbers.</li>
     * <li>The first character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for MySQL.</li>
     * <li>Must be 1 to 16 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for Oracle.</li>
     * <li>Must be 1 to 30 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Required for PostgreSQL.</li>
     * <li>Must be 1 to 63 letters or numbers.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't be a reserved word for the chosen database engine.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The password for the master user is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints: Must contain from 8 to 30 characters.
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The password for the master user is managed by the DB cluster.
     * <p>
     * <em>MariaDB</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>Microsoft SQL Server</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     * <p>
     * <em>MySQL</em>
     * <p>
     * Constraints: Must contain from 8 to 41 characters.
     * <p>
     * <em>Oracle</em>
     * <p>
     * Constraints: Must contain from 8 to 30 characters.
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * Constraints: Must contain from 8 to 128 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxAllocatedStorage() {
        return software.amazon.jsii.Kernel.get(this, "maxAllocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     * <p>
     * For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxAllocatedStorage(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxAllocatedStorage", value);
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     * <p>
     * To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.
     * <p>
     * This setting doesn't apply to RDS Custom.
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMonitoringInterval() {
        return software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
     * <p>
     * To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.
     * <p>
     * This setting doesn't apply to RDS Custom.
     * <p>
     * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringInterval(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "monitoringInterval", value);
    }

    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "monitoringRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringRoleArn", value);
    }

    /**
     * Specifies whether the database instance is a Multi-AZ DB instance deployment.
     * <p>
     * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to true.
     * <p>
     * Currently, you can't use AWS CloudFormation to create a Multi-AZ DB cluster deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.MultiAZ.html">Multi-AZ deployments for high availability</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Amazon Aurora storage is replicated across all of the Availability Zones and doesn't require the <code>MultiAZ</code> option to be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiAz() {
        return software.amazon.jsii.Kernel.get(this, "multiAz", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the database instance is a Multi-AZ DB instance deployment.
     * <p>
     * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to true.
     * <p>
     * Currently, you can't use AWS CloudFormation to create a Multi-AZ DB cluster deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.MultiAZ.html">Multi-AZ deployments for high availability</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Amazon Aurora storage is replicated across all of the Availability Zones and doesn't require the <code>MultiAZ</code> option to be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAz(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiAz", value);
    }

    /**
     * Specifies whether the database instance is a Multi-AZ DB instance deployment.
     * <p>
     * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to true.
     * <p>
     * Currently, you can't use AWS CloudFormation to create a Multi-AZ DB cluster deployment.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.MultiAZ.html">Multi-AZ deployments for high availability</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Amazon Aurora storage is replicated across all of the Availability Zones and doesn't require the <code>MultiAZ</code> option to be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiAz(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiAz", value);
    }

    /**
     * Indicates that the DB instance should be associated with the specified option group.
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOptionGroupName() {
        return software.amazon.jsii.Kernel.get(this, "optionGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates that the DB instance should be associated with the specified option group.
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "optionGroupName", value);
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
     * <p>
     * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerformanceInsightsKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
     * <p>
     * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsKmsKeyId", value);
    }

    /**
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * <p>
     * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceInsightsRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "performanceInsightsRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * <p>
     * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceInsightsRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "performanceInsightsRetentionPeriod", value);
    }

    /**
     * The port number on which the database accepts connections.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The port number is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number on which the database accepts connections.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The port number is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Adjusting the Preferred DB Instance Maintenance Window</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <blockquote>
     * <p>
     * This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
     * <p>
     * </blockquote>
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Adjusting the Preferred DB Instance Maintenance Window</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * <blockquote>
     * <p>
     * This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
     * <p>
     * </blockquote>
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProcessorFeatures() {
        return software.amazon.jsii.Kernel.get(this, "processorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessorFeatures(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "processorFeatures", value);
    }

    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessorFeatures(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBInstance.ProcessorFeatureProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnDBInstance.ProcessorFeatureProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "processorFeatures", value);
    }

    /**
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     * <p>
     * Default: 1
     * <p>
     * Valid Values: 0 - 15
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPromotionTier() {
        return software.amazon.jsii.Kernel.get(this, "promotionTier", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * This setting doesn't apply to RDS Custom.
     * <p>
     * Default: 1
     * <p>
     * Valid Values: 0 - 15
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPromotionTier(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "promotionTier", value);
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     * <p>
     * If you specify <code>true</code> , AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
     * <p>
     * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html"><code>CreateDBInstance</code></a> in the <em>Amazon RDS API Reference</em> .
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <em>DependsOn</em> attribute to declare a dependency on the VPC-gateway attachment. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify DBSecurityGroups, AWS CloudFormation ignores this property. To specify a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     * <p>
     * If you specify <code>true</code> , AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
     * <p>
     * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html"><code>CreateDBInstance</code></a> in the <em>Amazon RDS API Reference</em> .
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <em>DependsOn</em> attribute to declare a dependency on the VPC-gateway attachment. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify DBSecurityGroups, AWS CloudFormation ignores this property. To specify a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * Indicates whether the DB instance is an internet-facing instance.
     * <p>
     * If you specify <code>true</code> , AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
     * <p>
     * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html"><code>CreateDBInstance</code></a> in the <em>Amazon RDS API Reference</em> .
     * <p>
     * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <em>DependsOn</em> attribute to declare a dependency on the VPC-gateway attachment. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify DBSecurityGroups, AWS CloudFormation ignores this property. To specify a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * If you want to create a read replica DB instance, specify the ID of the source DB instance.
     * <p>
     * Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation deletes the Read Replica and creates a new DB instance (not a read replica).
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
     * <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
     * <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
     * <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
     * <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
     * <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbInstanceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you want to create a read replica DB instance, specify the ID of the source DB instance.
     * <p>
     * Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation deletes the Read Replica and creates a new DB instance (not a read replica).
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
     * <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
     * <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
     * <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
     * <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
     * <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbInstanceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbInstanceIdentifier", value);
    }

    /**
     * The ID of the region that contains the source DB instance for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the region that contains the source DB instance for the read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceRegion", value);
    }

    /**
     * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB instance is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB instance to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The encryption for DB instances is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB instance is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB instance to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The encryption for DB instances is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBInstanceIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB instance is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB instance to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The encryption for DB instances is managed by the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Specifies the storage type to be associated with the DB instance.
     * <p>
     * Valid values: <code>standard | gp2 | io1</code>
     * <p>
     * The <code>standard</code> value is also known as magnetic.
     * <p>
     * If you specify <code>io1</code> , you must also include a value for the <code>Iops</code> parameter.
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>standard</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB Instance Storage</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Aurora data is stored in the cluster volume, which is a single, virtual volume that uses solid state drives (SSDs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the storage type to be associated with the DB instance.
     * <p>
     * Valid values: <code>standard | gp2 | io1</code>
     * <p>
     * The <code>standard</code> value is also known as magnetic.
     * <p>
     * If you specify <code>io1</code> , you must also include a value for the <code>Iops</code> parameter.
     * <p>
     * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>standard</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB Instance Storage</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. Aurora data is stored in the cluster volume, which is a single, virtual volume that uses solid state drives (SSDs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * The time zone of the DB instance.
     * <p>
     * The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
        return software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time zone of the DB instance.
     * <p>
     * The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimezone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timezone", value);
    }

    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseDefaultProcessorFeatures() {
        return software.amazon.jsii.Kernel.get(this, "useDefaultProcessorFeatures", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseDefaultProcessorFeatures(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useDefaultProcessorFeatures", value);
    }

    /**
     * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
     * <p>
     * This setting doesn't apply to RDS Custom.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseDefaultProcessorFeatures(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useDefaultProcessorFeatures", value);
    }

    /**
     * A list of the VPC security group IDs to assign to the DB instance.
     * <p>
     * The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
     * <p>
     * <blockquote>
     * <p>
     * You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
     * <p>
     * <ul>
     * <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
     * <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
     * <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the VPC security group IDs to assign to the DB instance.
     * <p>
     * The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
     * <p>
     * <blockquote>
     * <p>
     * You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
     * <p>
     * <ul>
     * <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
     * <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
     * <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
     * <p>
     * <em>Amazon Aurora</em>
     * <p>
     * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroups", value);
    }
    /**
     * Describes an AWS Identity and Access Management (IAM) role that is associated with a DB instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * DBInstanceRoleProperty dBInstanceRoleProperty = DBInstanceRoleProperty.builder()
     *         .featureName("featureName")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceRoleProperty")
    @software.amazon.jsii.Jsii.Proxy(DBInstanceRoleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBInstanceRoleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the feature associated with the AWS Identity and Access Management (IAM) role.
         * <p>
         * IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBInstanceRoleProperty> {
            java.lang.String featureName;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link DBInstanceRoleProperty#getFeatureName}
             * @param featureName The name of the feature associated with the AWS Identity and Access Management (IAM) role. This parameter is required.
             *                    IAM roles that are associated with a DB instance grant permission for the DB instance to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Sets the value of {@link DBInstanceRoleProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBInstanceRoleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBInstanceRoleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DBInstanceRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBInstanceRoleProperty {
            private final java.lang.String featureName;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.featureName = java.util.Objects.requireNonNull(builder.featureName, "featureName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("featureName", om.valueToTree(this.getFeatureName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.DBInstanceRoleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBInstanceRoleProperty.Jsii$Proxy that = (DBInstanceRoleProperty.Jsii$Proxy) o;

                if (!featureName.equals(that.featureName)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.featureName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .hostedZoneId("hostedZoneId")
     *         .port("port")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDBInstance.EndpointProperty.Address`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * `CfnDBInstance.EndpointProperty.HostedZoneId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
            return null;
        }

        /**
         * `CfnDBInstance.EndpointProperty.Port`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.String hostedZoneId;
            java.lang.String port;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address `CfnDBInstance.EndpointProperty.Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getHostedZoneId}
             * @param hostedZoneId `CfnDBInstance.EndpointProperty.HostedZoneId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port `CfnDBInstance.EndpointProperty.Port`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.String hostedZoneId;
            private final java.lang.String port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.hostedZoneId = builder.hostedZoneId;
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getHostedZoneId() != null) {
                    data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.hostedZoneId != null ? !this.hostedZoneId.equals(that.hostedZoneId) : that.hostedZoneId != null) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.hostedZoneId != null ? this.hostedZoneId.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ProcessorFeature` property type specifies the processor features of a DB instance class status.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ProcessorFeatureProperty processorFeatureProperty = ProcessorFeatureProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBInstance.ProcessorFeatureProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorFeatureProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorFeatureProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the processor feature.
         * <p>
         * Valid names are <code>coreCount</code> and <code>threadsPerCore</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of a processor feature name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorFeatureProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ProcessorFeatureProperty#getName}
             * @param name The name of the processor feature.
             *             Valid names are <code>coreCount</code> and <code>threadsPerCore</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorFeatureProperty#getValue}
             * @param value The value of a processor feature name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorFeatureProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorFeatureProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorFeatureProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorFeatureProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBInstance.ProcessorFeatureProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorFeatureProperty.Jsii$Proxy that = (ProcessorFeatureProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The amount of storage (in gigabytes) to be initially allocated for the database instance.
         * <p>
         * <blockquote>
         * <p>
         * If any value is set in the <code>Iops</code> parameter, <code>AllocatedStorage</code> must be at least 100 GiB, which corresponds to the minimum Iops value of 1,000. If you increase the <code>Iops</code> value (in 1,000 IOPS increments), then you must also increase the <code>AllocatedStorage</code> value (in 100-GiB increments).
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.
         * <p>
         * <em>MySQL</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 5 to 3072.</li>
         * </ul>
         * <p>
         * <em>Oracle</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</li>
         * <li>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</li>
         * <li>Magnetic storage (standard): Must be an integer from 10 to 3072.</li>
         * </ul>
         * <p>
         * <em>SQL Server</em>
         * <p>
         * Constraints to the amount of storage for each storage type are the following:
         * <p>
         * <ul>
         * <li>General Purpose (SSD) storage (gp2):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         * <li>Provisioned IOPS storage (io1):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 16384.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 16384.</li>
         * <li>Magnetic storage (standard):</li>
         * <li>Enterprise and Standard editions: Must be an integer from 20 to 1024.</li>
         * <li>Web and Express editions: Must be an integer from 20 to 1024.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param allocatedStorage The amount of storage (in gigabytes) to be initially allocated for the database instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(final java.lang.String allocatedStorage) {
            this.props().allocatedStorage(allocatedStorage);
            return this;
        }

        /**
         * A value that indicates whether major version upgrades are allowed.
         * <p>
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * <p>
         * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * <p>
         * @return {@code this}
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(final java.lang.Boolean allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }
        /**
         * A value that indicates whether major version upgrades are allowed.
         * <p>
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         * <p>
         * Constraints: Major version upgrades must be allowed when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB instance's current version.
         * <p>
         * @return {@code this}
         * @param allowMajorVersionUpgrade A value that indicates whether major version upgrades are allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMajorVersionUpgrade(final software.amazon.awscdk.IResolvable allowMajorVersionUpgrade) {
            this.props().allowMajorVersionUpgrade(allowMajorVersionUpgrade);
            return this;
        }

        /**
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated roles are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final software.amazon.awscdk.IResolvable associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }
        /**
         * The AWS Identity and Access Management (IAM) roles associated with the DB instance.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated roles are managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param associatedRoles The AWS Identity and Access Management (IAM) roles associated with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final java.util.List<? extends java.lang.Object> associatedRoles) {
            this.props().associatedRoles(associatedRoles);
            return this;
        }

        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * <p>
         * By default, minor engine upgrades are applied automatically.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.props().autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * The Availability Zone (AZ) where the database will be created.
         * <p>
         * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.
         * <p>
         * Default: A random, system-chosen Availability Zone in the endpoint's AWS Region .
         * <p>
         * Example: <code>us-east-1d</code>
         * <p>
         * Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same AWS Region as the current endpoint.
         * <p>
         * @return {@code this}
         * @param availabilityZone The Availability Zone (AZ) where the database will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        /**
         * The number of days for which automated backups are retained.
         * <p>
         * Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The retention period for automated backups is managed by the DB cluster.
         * <p>
         * Default: 1
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a value from 0 to 35</li>
         * <li>Can't be set to 0 if the DB instance is a source to read replicas</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param backupRetentionPeriod The number of days for which automated backups are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props().backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * The identifier of the CA certificate for this DB instance.
         * <p>
         * <blockquote>
         * <p>
         * Specifying or updating this property triggers a reboot.
         * <p>
         * </blockquote>
         * <p>
         * For more information about CA certificate identifiers for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * For more information about CA certificate identifiers for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">Rotating Your SSL/TLS Certificate</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param caCertificateIdentifier The identifier of the CA certificate for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(final java.lang.String caCertificateIdentifier) {
            this.props().caCertificateIdentifier(caCertificateIdentifier);
            return this;
        }

        /**
         * For supported engines, indicates that the DB instance should be associated with the specified character set.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The character set is managed by the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">AWS::RDS::DBCluster</a> .
         * <p>
         * @return {@code this}
         * @param characterSetName For supported engines, indicates that the DB instance should be associated with the specified character set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder characterSetName(final java.lang.String characterSetName) {
            this.props().characterSetName(characterSetName);
            return this;
        }

        /**
         * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance.
         * <p>
         * By default, tags are not copied.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance.
         * <p>
         * By default, tags are not copied.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.props().copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * The identifier of the DB cluster that the instance will belong to.
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifier The identifier of the DB cluster that the instance will belong to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props().dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The compute and memory capacity of the DB instance, for example, `db.m4.large` . Not all DB instance classes are available in all AWS Regions, or for all database engines.
         * <p>
         * For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <em>Amazon RDS User Guide.</em> For more information about DB instance class pricing and AWS Region support for DB instance classes, see <a href="https://docs.aws.amazon.com/rds/pricing/">Amazon RDS Pricing</a> .
         * <p>
         * @return {@code this}
         * @param dbInstanceClass The compute and memory capacity of the DB instance, for example, `db.m4.large` . Not all DB instance classes are available in all AWS Regions, or for all database engines. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceClass(final java.lang.String dbInstanceClass) {
            this.props().dbInstanceClass(dbInstanceClass);
            return this;
        }

        /**
         * A name for the DB instance.
         * <p>
         * If you specify a name, AWS CloudFormation converts it to lowercase. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param dbInstanceIdentifier A name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceIdentifier(final java.lang.String dbInstanceIdentifier) {
            this.props().dbInstanceIdentifier(dbInstanceIdentifier);
            return this;
        }

        /**
         * The meaning of this parameter differs according to the database engine you use.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>[DBSnapshotIdentifier](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier)</code> property, this property only applies to RDS for Oracle.
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The database name is managed by the DB cluster.
         * <p>
         * <em>MySQL</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 letters or numbers.</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>MariaDB</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, no database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 64 letters or numbers.</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * The name of the database to create when the DB instance is created. If this parameter is not specified, the default <code>postgres</code> database is created in the DB instance.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1 to 63 letters, numbers, or underscores.</li>
         * <li>Must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0-9).</li>
         * <li>Can't be a word reserved by the specified database engine</li>
         * </ul>
         * <p>
         * <em>Oracle</em>
         * <p>
         * The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code> , the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code> .
         * <p>
         * Default: <code>ORCL</code>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Can't be longer than 8 characters</li>
         * </ul>
         * <p>
         * <em>SQL Server</em>
         * <p>
         * Not applicable. Must be null.
         * <p>
         * @return {@code this}
         * @param dbName The meaning of this parameter differs according to the database engine you use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbName(final java.lang.String dbName) {
            this.props().dbName(dbName);
            return this;
        }

        /**
         * The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template.
         * <p>
         * To list all of the available DB parameter group names, use the following command:
         * <p>
         * <code>aws rds describe-db-parameter-groups --query "DBParameterGroups[].DBParameterGroupName" --output text</code>
         * <p>
         * <blockquote>
         * <p>
         * If any of the data members of the referenced parameter group are changed during an update, the DB instance might need to be restarted, which causes some interruption. If the parameter group contains static parameters, whether they were changed or not, an update triggers a reboot.
         * <p>
         * </blockquote>
         * <p>
         * If you don't specify a value for the <code>DBParameterGroupName</code> property, the default DB parameter group for the specified engine and engine version is used.
         * <p>
         * @return {@code this}
         * @param dbParameterGroupName The name of an existing DB parameter group or a reference to an [AWS::RDS::DBParameterGroup](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html) resource created in the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbParameterGroupName(final java.lang.String dbParameterGroupName) {
            this.props().dbParameterGroupName(dbParameterGroupName);
            return this;
        }

        /**
         * A list of the DB security groups to assign to the DB instance.
         * <p>
         * The list can include both the name of existing DB security groups or references to AWS::RDS::DBSecurityGroup resources created in the template.
         * <p>
         * If you set DBSecurityGroups, you must not set VPCSecurityGroups, and vice versa. Also, note that the DBSecurityGroups property exists only for backwards compatibility with older regions and is no longer recommended for providing security information to an RDS DB instance. Instead, use VPCSecurityGroups.
         * <p>
         * <blockquote>
         * <p>
         * If you specify this property, AWS CloudFormation sends only the following properties (if specified) to Amazon RDS during create operations:
         * <p>
         * <ul>
         * <li><code>AllocatedStorage</code></li>
         * <li><code>AutoMinorVersionUpgrade</code></li>
         * <li><code>AvailabilityZone</code></li>
         * <li><code>BackupRetentionPeriod</code></li>
         * <li><code>CharacterSetName</code></li>
         * <li><code>DBInstanceClass</code></li>
         * <li><code>DBName</code></li>
         * <li><code>DBParameterGroupName</code></li>
         * <li><code>DBSecurityGroups</code></li>
         * <li><code>DBSubnetGroupName</code></li>
         * <li><code>Engine</code></li>
         * <li><code>EngineVersion</code></li>
         * <li><code>Iops</code></li>
         * <li><code>LicenseModel</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>MultiAZ</code></li>
         * <li><code>OptionGroupName</code></li>
         * <li><code>PreferredBackupWindow</code></li>
         * <li><code>PreferredMaintenanceWindow</code></li>
         * </ul>
         * <p>
         * All other properties are ignored. Specify a virtual private cloud (VPC) security group if you want to submit other properties, such as <code>StorageType</code> , <code>StorageEncrypted</code> , or <code>KmsKeyId</code> . If you're already using the <code>DBSecurityGroups</code> property, you can't use these other properties by updating your DB instance to use a VPC security group. You must recreate the DB instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param dbSecurityGroups A list of the DB security groups to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroups(final java.util.List<java.lang.String> dbSecurityGroups) {
            this.props().dbSecurityGroups(dbSecurityGroups);
            return this;
        }

        /**
         * The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance.
         * <p>
         * If you're restoring from a shared manual DB snapshot, you must specify the ARN of the snapshot.
         * <p>
         * By specifying this property, you can create a DB instance from the specified DB snapshot. If the <code>DBSnapshotIdentifier</code> property is an empty string or the <code>AWS::RDS::DBInstance</code> declaration has no <code>DBSnapshotIdentifier</code> property, AWS CloudFormation creates a new database. If the property contains a value (other than an empty string), AWS CloudFormation creates a database from the specified snapshot. If a snapshot with the specified name doesn't exist, AWS CloudFormation can't create the database and it rolls back the stack.
         * <p>
         * Some DB instance properties aren't valid when you restore from a snapshot, such as the <code>MasterUsername</code> and <code>MasterUserPassword</code> properties. For information about the properties that you can specify, see the <code>RestoreDBInstanceFromDBSnapshot</code> action in the <em>Amazon RDS API Reference</em> .
         * <p>
         * After you restore a DB instance with a <code>DBSnapshotIdentifier</code> property, you must specify the same <code>DBSnapshotIdentifier</code> property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the <code>DBSnapshotIdentifier</code> property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified <code>DBSnapshotIdentifier</code> property, and the original DB instance is deleted.
         * <p>
         * If you specify the <code>DBSnapshotIdentifier</code> property to restore a DB instance (as opposed to specifying it for DB instance updates), then don't specify the following properties:
         * <p>
         * <ul>
         * <li><code>CharacterSetName</code></li>
         * <li><code>DBClusterIdentifier</code></li>
         * <li><code>DBName</code></li>
         * <li><code>DeleteAutomatedBackups</code></li>
         * <li><code>EnablePerformanceInsights</code></li>
         * <li><code>KmsKeyId</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>PerformanceInsightsKMSKeyId</code></li>
         * <li><code>PerformanceInsightsRetentionPeriod</code></li>
         * <li><code>PromotionTier</code></li>
         * <li><code>SourceDBInstanceIdentifier</code></li>
         * <li><code>SourceRegion</code></li>
         * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
         * <li><code>Timezone</code></li>
         * </ul>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Snapshot restore is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param dbSnapshotIdentifier The name or Amazon Resource Name (ARN) of the DB snapshot that's used to restore the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSnapshotIdentifier(final java.lang.String dbSnapshotIdentifier) {
            this.props().dbSnapshotIdentifier(dbSnapshotIdentifier);
            return this;
        }

        /**
         * A DB subnet group to associate with the DB instance.
         * <p>
         * If you update this value, the new subnet group must be a subnet group in a new VPC.
         * <p>
         * If there's no DB subnet group, then the DB instance isn't a VPC DB instance.
         * <p>
         * For more information about using Amazon RDS in a VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon Virtual Private Cloud (VPC)</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The DB subnet group is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * <p>
         * @return {@code this}
         * @param dbSubnetGroupName A DB subnet group to associate with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props().dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * @return {@code this}
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final java.lang.Boolean deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }
        /**
         * A value that indicates whether to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.
         * <p>
         * @return {@code this}
         * @param deleteAutomatedBackups A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(final software.amazon.awscdk.IResolvable deleteAutomatedBackups) {
            this.props().deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        /**
         * A value that indicates whether the DB instance has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB instance has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }
        /**
         * A value that indicates whether the DB instance has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html">Deleting a DB Instance</a> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code> . DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB instance has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The Active Directory directory ID to create the DB instance in.
         * <p>
         * Currently, only Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * @return {@code this}
         * @param domain The Active Directory directory ID to create the DB instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(final java.lang.String domain) {
            this.props().domain(domain);
            return this;
        }

        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param domainIamRoleName Specify the name of the IAM role to be used when making API calls to the Directory Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIamRoleName(final java.lang.String domainIamRoleName) {
            this.props().domainIamRoleName(domainIamRoleName);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Relational Database Service User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. CloudWatch Logs exports are managed by the DB cluster.
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * Valid values: <code>agent</code> , <code>error</code>
         * <p>
         * <em>MySQL</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Oracle</em>
         * <p>
         * Valid values: <code>alert</code> , <code>audit</code> , <code>listener</code> , <code>trace</code>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Valid values: <code>postgresql</code> , <code>upgrade</code>
         * <p>
         * @return {@code this}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props().enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MySQL and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final java.lang.Boolean enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }
        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication for MySQL and PostgreSQL</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Mapping AWS IAM accounts to database accounts is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.props().enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        /**
         * A value that indicates whether to enable Performance Insights for the DB instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final java.lang.Boolean enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }
        /**
         * A value that indicates whether to enable Performance Insights for the DB instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(final software.amazon.awscdk.IResolvable enablePerformanceInsights) {
            this.props().enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        /**
         * The name of the database engine that you want to use for this DB instance.
         * <p>
         * <blockquote>
         * <p>
         * When you are creating a DB instance, the <code>Engine</code> property is required.
         * <p>
         * </blockquote>
         * <p>
         * Valid Values:
         * <p>
         * <ul>
         * <li><code>aurora</code> (for MySQL 5.6-compatible Aurora)</li>
         * <li><code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)</li>
         * <li><code>aurora-postgresql</code></li>
         * <li><code>mariadb</code></li>
         * <li><code>mysql</code></li>
         * <li><code>oracle-ee</code></li>
         * <li><code>oracle-se2</code></li>
         * <li><code>oracle-se1</code></li>
         * <li><code>oracle-se</code></li>
         * <li><code>postgres</code></li>
         * <li><code>sqlserver-ee</code></li>
         * <li><code>sqlserver-se</code></li>
         * <li><code>sqlserver-ex</code></li>
         * <li><code>sqlserver-web</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param engine The name of the database engine that you want to use for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props().engine(engine);
            return this;
        }

        /**
         * The version number of the database engine to use.
         * <p>
         * For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.
         * <p>
         * The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every AWS Region.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.
         * <p>
         * <em>MariaDB</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>MySQL</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>Oracle</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions">Supported PostgreSQL Database Versions</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the database engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * The number of I/O operations per second (IOPS) that the database provisions.
         * <p>
         * The value must be equal to or greater than 1000.
         * <p>
         * If you specify this property, you must follow the range of allowed ratios of your requested IOPS rate to the amount of storage that you allocate (IOPS to allocated storage). For example, you can provision an Oracle database instance with 1000 IOPS and 200 GiB of storage (a ratio of 5:1), or specify 2000 IOPS with 200 GiB of storage (a ratio of 10:1). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify <code>io1</code> for the <code>StorageType</code> property, then you must also specify the <code>Iops</code> property.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param iops The number of I/O operations per second (IOPS) that the database provisions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(final java.lang.Number iops) {
            this.props().iops(iops);
            return this;
        }

        /**
         * The ARN of the AWS KMS key that's used to encrypt the DB instance, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
         * <p>
         * If you enable the StorageEncrypted property but don't specify this property, AWS CloudFormation uses the default KMS key. If you specify this property, you must set the StorageEncrypted property to true.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> property, the value is inherited from the source DB instance if the read replica is created in the same region.
         * <p>
         * If you create an encrypted read replica in a different AWS Region, then you must specify a KMS key for the destination AWS Region. KMS encryption keys are specific to the region that they're created in, and you can't use encryption keys from one region in another region.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify <code>DBSecurityGroups</code> , AWS CloudFormation ignores this property. To specify both a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The KMS key identifier is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The ARN of the AWS KMS key that's used to encrypt the DB instance, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * License model information for this DB instance.
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li>Aurora MySQL - <code>general-public-license</code></li>
         * <li>Aurora PostgreSQL - <code>postgresql-license</code></li>
         * <li>MariaDB - <code>general-public-license</code></li>
         * <li>Microsoft SQL Server - <code>license-included</code></li>
         * <li>MySQL - <code>general-public-license</code></li>
         * <li>Oracle - <code>bring-your-own-license</code> or <code>license-included</code></li>
         * <li>PostgreSQL - <code>postgresql-license</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you've specified <code>DBSecurityGroups</code> and then you update the license model, AWS CloudFormation replaces the underlying DB instance. This will incur some interruptions to database availability.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param licenseModel License model information for this DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(final java.lang.String licenseModel) {
            this.props().licenseModel(licenseModel);
            return this;
        }

        /**
         * The master user name for the DB instance.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> or <code>DBSnapshotIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance or snapshot.
         * <p>
         * </blockquote>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The name for the master user is managed by the DB cluster.
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for MariaDB.</li>
         * <li>Must be 1 to 16 letters or numbers.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for SQL Server.</li>
         * <li>Must be 1 to 128 letters or numbers.</li>
         * <li>The first character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>MySQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for MySQL.</li>
         * <li>Must be 1 to 16 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>Oracle</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for Oracle.</li>
         * <li>Must be 1 to 30 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for PostgreSQL.</li>
         * <li>Must be 1 to 63 letters or numbers.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param masterUsername The master user name for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props().masterUsername(masterUsername);
            return this;
        }

        /**
         * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The password for the master user is managed by the DB cluster.
         * <p>
         * <em>MariaDB</em>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * <p>
         * <em>Microsoft SQL Server</em>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * <p>
         * <em>MySQL</em>
         * <p>
         * Constraints: Must contain from 8 to 41 characters.
         * <p>
         * <em>Oracle</em>
         * <p>
         * Constraints: Must contain from 8 to 30 characters.
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Constraints: Must contain from 8 to 128 characters.
         * <p>
         * @return {@code this}
         * @param masterUserPassword The password for the master user. The password can include any printable ASCII character except "/", """, or "@". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props().masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         * <p>
         * For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling">Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param maxAllocatedStorage The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAllocatedStorage(final java.lang.Number maxAllocatedStorage) {
            this.props().maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.
         * <p>
         * To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.
         * <p>
         * If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code>
         * <p>
         * @return {@code this}
         * @param monitoringInterval The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final java.lang.Number monitoringInterval) {
            this.props().monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs.
         * <p>
         * For example, <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param monitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRoleArn(final java.lang.String monitoringRoleArn) {
            this.props().monitoringRoleArn(monitoringRoleArn);
            return this;
        }

        /**
         * Specifies whether the database instance is a Multi-AZ DB instance deployment.
         * <p>
         * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to true.
         * <p>
         * Currently, you can't use AWS CloudFormation to create a Multi-AZ DB cluster deployment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.MultiAZ.html">Multi-AZ deployments for high availability</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Amazon Aurora storage is replicated across all of the Availability Zones and doesn't require the <code>MultiAZ</code> option to be set.
         * <p>
         * @return {@code this}
         * @param multiAz Specifies whether the database instance is a Multi-AZ DB instance deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(final java.lang.Boolean multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }
        /**
         * Specifies whether the database instance is a Multi-AZ DB instance deployment.
         * <p>
         * You can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to true.
         * <p>
         * Currently, you can't use AWS CloudFormation to create a Multi-AZ DB cluster deployment.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.MultiAZ.html">Multi-AZ deployments for high availability</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Amazon Aurora storage is replicated across all of the Availability Zones and doesn't require the <code>MultiAZ</code> option to be set.
         * <p>
         * @return {@code this}
         * @param multiAz Specifies whether the database instance is a Multi-AZ DB instance deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAz(final software.amazon.awscdk.IResolvable multiAz) {
            this.props().multiAz(multiAz);
            return this;
        }

        /**
         * Indicates that the DB instance should be associated with the specified option group.
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance once it is associated with a DB instance.
         * <p>
         * @return {@code this}
         * @param optionGroupName Indicates that the DB instance should be associated with the specified option group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionGroupName(final java.lang.String optionGroupName) {
            this.props().optionGroupName(optionGroupName);
            return this;
        }

        /**
         * The AWS KMS key identifier for encryption of Performance Insights data.
         * <p>
         * The KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * <p>
         * If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account. Your AWS account has a different default KMS key for each AWS Region.
         * <p>
         * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
         * <p>
         * @return {@code this}
         * @param performanceInsightsKmsKeyId The AWS KMS key identifier for encryption of Performance Insights data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsKmsKeyId(final java.lang.String performanceInsightsKmsKeyId) {
            this.props().performanceInsightsKmsKeyId(performanceInsightsKmsKeyId);
            return this;
        }

        /**
         * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * <p>
         * For information about enabling Performance Insights, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights">EnablePerformanceInsights</a> .
         * <p>
         * @return {@code this}
         * @param performanceInsightsRetentionPeriod The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsRetentionPeriod(final java.lang.Number performanceInsightsRetentionPeriod) {
            this.props().performanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
            return this;
        }

        /**
         * The port number on which the database accepts connections.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The port number is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param port The port number on which the database accepts connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.String port) {
            this.props().port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup Window</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The daily time range for creating automated backups is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props().preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow">Adjusting the Preferred DB Instance Maintenance Window</a> in the <em>Amazon RDS User Guide.</em>
         * <p>
         * <blockquote>
         * <p>
         * This property applies when AWS CloudFormation initially creates the DB instance. If you use AWS CloudFormation to update the DB instance, those updates are applied immediately.
         * <p>
         * </blockquote>
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props().preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(final software.amazon.awscdk.IResolvable processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param processorFeatures The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processorFeatures(final java.util.List<? extends java.lang.Object> processorFeatures) {
            this.props().processorFeatures(processorFeatures);
            return this;
        }

        /**
         * A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance">Fault Tolerance for an Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * Default: 1
         * <p>
         * Valid Values: 0 - 15
         * <p>
         * @return {@code this}
         * @param promotionTier A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promotionTier(final java.lang.Number promotionTier) {
            this.props().promotionTier(promotionTier);
            return this;
        }

        /**
         * Indicates whether the DB instance is an internet-facing instance.
         * <p>
         * If you specify <code>true</code> , AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         * <p>
         * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html"><code>CreateDBInstance</code></a> in the <em>Amazon RDS API Reference</em> .
         * <p>
         * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <em>DependsOn</em> attribute to declare a dependency on the VPC-gateway attachment. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify DBSecurityGroups, AWS CloudFormation ignores this property. To specify a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * Indicates whether the DB instance is an internet-facing instance.
         * <p>
         * If you specify <code>true</code> , AWS CloudFormation creates an instance with a publicly resolvable DNS name, which resolves to a public IP address. If you specify false, AWS CloudFormation creates an internal instance with a DNS name that resolves to a private IP address.
         * <p>
         * The default behavior value depends on your VPC setup and the database subnet group. For more information, see the <code>PubliclyAccessible</code> parameter in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html"><code>CreateDBInstance</code></a> in the <em>Amazon RDS API Reference</em> .
         * <p>
         * If this resource has a public IP address and is also in a VPC that is defined in the same template, you must use the <em>DependsOn</em> attribute to declare a dependency on the VPC-gateway attachment. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify DBSecurityGroups, AWS CloudFormation ignores this property. To specify a security group and this property, you must use a VPC security group. For more information about Amazon RDS and VPC, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.html">Using Amazon RDS with Amazon VPC</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param publiclyAccessible Indicates whether the DB instance is an internet-facing instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props().publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * If you want to create a read replica DB instance, specify the ID of the source DB instance.
         * <p>
         * Each DB instance can have a limited number of read replicas. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/DeveloperGuide/USER_ReadRepl.html">Working with Read Replicas</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * For information about constraints that apply to DB instance identifiers, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming constraints in Amazon RDS</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * The <code>SourceDBInstanceIdentifier</code> property determines whether a DB instance is a read replica. If you remove the <code>SourceDBInstanceIdentifier</code> property from your template and then update your stack, AWS CloudFormation deletes the Read Replica and creates a new DB instance (not a read replica).
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>If you specify a source DB instance that uses VPC security groups, we recommend that you specify the <code>VPCSecurityGroups</code> property. If you don't specify the property, the read replica inherits the value of the <code>VPCSecurityGroups</code> property from the source DB when you create the replica. However, if you update the stack, AWS CloudFormation reverts the replica's <code>VPCSecurityGroups</code> property to the default value because it's not defined in the stack's template. This change might cause unexpected issues.</li>
         * <li>Read replicas don't support deletion policies. AWS CloudFormation ignores any deletion policy that's associated with a read replica.</li>
         * <li>If you specify <code>SourceDBInstanceIdentifier</code> , don't specify the <code>DBSnapshotIdentifier</code> property. You can't create a read replica from a snapshot.</li>
         * <li>Don't set the <code>BackupRetentionPeriod</code> , <code>DBName</code> , <code>MasterUsername</code> , <code>MasterUserPassword</code> , and <code>PreferredBackupWindow</code> properties. The database attributes are inherited from the source DB instance, and backups are disabled for read replicas.</li>
         * <li>If the source DB instance is in a different region than the read replica, specify the source region in <code>SourceRegion</code> , and specify an ARN for a valid DB instance in <code>SourceDBInstanceIdentifier</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.ARN">Constructing a Amazon RDS Amazon Resource Name (ARN)</a> in the <em>Amazon RDS User Guide</em> .</li>
         * <li>For DB instances in Amazon Aurora clusters, don't specify this property. Amazon RDS automatically assigns writer and reader DB instances.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param sourceDbInstanceIdentifier If you want to create a read replica DB instance, specify the ID of the source DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbInstanceIdentifier(final java.lang.String sourceDbInstanceIdentifier) {
            this.props().sourceDbInstanceIdentifier(sourceDbInstanceIdentifier);
            return this;
        }

        /**
         * The ID of the region that contains the source DB instance for the read replica.
         * <p>
         * @return {@code this}
         * @param sourceRegion The ID of the region that contains the source DB instance for the read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(final java.lang.String sourceRegion) {
            this.props().sourceRegion(sourceRegion);
            return this;
        }

        /**
         * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB instance is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB instance to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The encryption for DB instances is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBInstanceIdentifier</code> property, don't specify this property. The value is inherited from the source DB instance, and if the DB instance is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB instance is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB instance to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The encryption for DB instances is managed by the DB cluster.
         * <p>
         * @return {@code this}
         * @param storageEncrypted A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * Specifies the storage type to be associated with the DB instance.
         * <p>
         * Valid values: <code>standard | gp2 | io1</code>
         * <p>
         * The <code>standard</code> value is also known as magnetic.
         * <p>
         * If you specify <code>io1</code> , you must also include a value for the <code>Iops</code> parameter.
         * <p>
         * Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>standard</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html">Amazon RDS DB Instance Storage</a> in the <em>Amazon RDS User Guide</em> .
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. Aurora data is stored in the cluster volume, which is a single, virtual volume that uses solid state drives (SSDs).
         * <p>
         * @return {@code this}
         * @param storageType Specifies the storage type to be associated with the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props().storageType(storageType);
            return this;
        }

        /**
         * Tags to assign to the DB instance.
         * <p>
         * @return {@code this}
         * @param tags Tags to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The time zone of the DB instance.
         * <p>
         * The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a> .
         * <p>
         * @return {@code this}
         * @param timezone The time zone of the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(final java.lang.String timezone) {
            this.props().timezone(timezone);
            return this;
        }

        /**
         * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param useDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance uses its default processor features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(final java.lang.Boolean useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }
        /**
         * A value that indicates whether the DB instance class of the DB instance uses its default processor features.
         * <p>
         * This setting doesn't apply to RDS Custom.
         * <p>
         * @return {@code this}
         * @param useDefaultProcessorFeatures A value that indicates whether the DB instance class of the DB instance uses its default processor features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useDefaultProcessorFeatures(final software.amazon.awscdk.IResolvable useDefaultProcessorFeatures) {
            this.props().useDefaultProcessorFeatures(useDefaultProcessorFeatures);
            return this;
        }

        /**
         * A list of the VPC security group IDs to assign to the DB instance.
         * <p>
         * The list can include both the physical IDs of existing VPC security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">AWS::EC2::SecurityGroup</a> resources created in the template.
         * <p>
         * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * <p>
         * If you set <code>VPCSecurityGroups</code> , you must not set <a href="https://docs.aws.amazon.com//AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> , and vice versa.
         * <p>
         * <blockquote>
         * <p>
         * You can migrate a DB instance in your stack from an RDS DB security group to a VPC security group, but keep the following in mind:
         * <p>
         * <ul>
         * <li>You can't revert to using an RDS security group after you establish a VPC security group membership.</li>
         * <li>When you migrate your DB instance to VPC security groups, if your stack update rolls back because the DB instance update fails or because an update fails in another AWS CloudFormation resource, the rollback fails because it can't revert to an RDS security group.</li>
         * <li>To use the properties that are available when you use a VPC security group, you must recreate the DB instance. If you don't, AWS CloudFormation submits only the property values that are listed in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups"><code>DBSecurityGroups</code></a> property.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * To avoid this situation, migrate your DB instance to using VPC security groups only when that is the only change in your stack template.
         * <p>
         * <em>Amazon Aurora</em>
         * <p>
         * Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. If specified, the setting must match the DB cluster setting.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroups A list of the VPC security group IDs to assign to the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroups(final java.util.List<java.lang.String> vpcSecurityGroups) {
            this.props().vpcSecurityGroups(vpcSecurityGroups);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBInstance build() {
            return new software.amazon.awscdk.services.rds.CfnDBInstance(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.rds.CfnDBInstanceProps.Builder();
            }
            return this.props;
        }
    }
}
