package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 * <p>
 * The <code>AWS::RDS::DBCluster</code> resource creates an Amazon Aurora DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Aurora.html">Managing an Amazon Aurora DB Cluster</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * You can only create this resource in AWS Regions where Amazon Aurora is supported.
 * <p>
 * </blockquote>
 * <p>
 * This topic covers the resource for Amazon Aurora DB clusters. For the documentation on the resource for Amazon RDS DB instances, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html">AWS::RDS::DBInstance</a> .
 * <p>
 * <em>Updating DB clusters</em>
 * <p>
 * When properties labeled " <em>Update requires:</em> <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">Replacement</a> " are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
 * <p>
 * <blockquote>
 * <p>
 * We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
 * <p>
 * <ul>
 * <li>Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.</li>
 * <li>Create a snapshot of the DB cluster. For more information about creating DB snapshots, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html">Creating a DB Cluster Snapshot</a> .</li>
 * <li>If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the <code>SnapshotIdentifier</code> property with the ID of the DB cluster snapshot that you want to use.</li>
 * </ul>
 * <p>
 * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
 * <p>
 * <ul>
 * <li>Update the stack.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: <code>PreferredBackupWindow</code> , <code>PreferredMaintenanceWindow</code> , and <code>Port</code> . This limitation doesn't apply to provisioned DB clusters.
 * <p>
 * For more information about updating other properties of this resource, see <code>[ModifyDBCluster](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBCluster.html)</code> . For more information about updating stacks, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html">AWS CloudFormation Stacks Updates</a> .
 * <p>
 * <em>Deleting DB clusters</em>
 * <p>
 * The default <code>DeletionPolicy</code> for <code>AWS::RDS::DBCluster</code> resources is <code>Snapshot</code> . For more information about how AWS CloudFormation deletes resources, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy Attribute</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBCluster cfnDBCluster = CfnDBCluster.Builder.create(this, "MyCfnDBCluster")
 *         .engine("engine")
 *         // the properties below are optional
 *         .associatedRoles(List.of(DBClusterRoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .featureName("featureName")
 *                 .build()))
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backtrackWindow(123)
 *         .backupRetentionPeriod(123)
 *         .copyTagsToSnapshot(false)
 *         .databaseName("databaseName")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .deletionProtection(false)
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableHttpEndpoint(false)
 *         .enableIamDatabaseAuthentication(false)
 *         .engineMode("engineMode")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .kmsKeyId("kmsKeyId")
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .replicationSourceIdentifier("replicationSourceIdentifier")
 *         .restoreType("restoreType")
 *         .scalingConfiguration(ScalingConfigurationProperty.builder()
 *                 .autoPause(false)
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .secondsUntilAutoPause(123)
 *                 .build())
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.353Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster")
public class CfnDBCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The connection endpoint for the DB cluster.
     * <p>
     * For example: <code>mystack-mydbcluster-123456789012.us-east-2.rds.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number that will accept connections on this DB cluster.
     * <p>
     * For example: <code>3306</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The reader endpoint for the DB cluster.
     * <p>
     * For example: <code>mystack-mydbcluster-ro-123456789012.us-east-2.rds.amazonaws.com</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrReadEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrReadEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags to assign to the DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", java.util.Objects.requireNonNull(value, "engine is required"));
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedRoles(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.rds.CfnDBCluster.DBClusterRoleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.rds.CfnDBCluster.DBClusterRoleProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "associatedRoles", value);
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZones", value);
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * <p>
     * <blockquote>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * <p>
     * </blockquote>
     * <p>
     * Default: 0
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBacktrackWindow() {
        return software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     * <p>
     * <blockquote>
     * <p>
     * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
     * <p>
     * </blockquote>
     * <p>
     * Default: 0
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBacktrackWindow(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backtrackWindow", value);
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "backupRetentionPeriod", value);
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCopyTagsToSnapshot(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "copyTagsToSnapshot", value);
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", value);
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterIdentifier", value);
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbClusterParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbClusterParameterGroupName", value);
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dbSubnetGroupName", value);
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableCloudwatchLogsExports(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "enableCloudwatchLogsExports", value);
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableHttpEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "enableHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
     * <p>
     * By default, the HTTP endpoint is disabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableHttpEndpoint(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableHttpEndpoint", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableIamDatabaseAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableIamDatabaseAuthentication", value);
    }

    /**
     * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
     * <p>
     * The <code>serverless</code> engine mode only supports Aurora Serverless v1. Currently, AWS CloudFormation doesn't support Aurora Serverless v2.
     * <p>
     * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
     * <p>
     * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
     * <p>
     * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * <p>
     * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
     * <p>
     * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineMode() {
        return software.amazon.jsii.Kernel.get(this, "engineMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
     * <p>
     * The <code>serverless</code> engine mode only supports Aurora Serverless v1. Currently, AWS CloudFormation doesn't support Aurora Serverless v2.
     * <p>
     * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
     * <p>
     * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
     * <p>
     * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * <p>
     * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
     * <p>
     * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineMode", value);
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalClusterIdentifier", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", value);
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getReplicationSourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "replicationSourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReplicationSourceIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "replicationSourceIdentifier", value);
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestoreType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restoreType", value);
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingConfiguration", value);
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotIdentifier", value);
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbClusterIdentifier", value);
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster.
     * <p>
     * For example, <code>us-east-1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster.
     * <p>
     * For example, <code>us-east-1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceRegion", value);
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseLatestRestorableTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useLatestRestorableTime", value);
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     * Describes an AWS Identity and Access Management (IAM) role that is associated with a DB cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * DBClusterRoleProperty dBClusterRoleProperty = DBClusterRoleProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .featureName("featureName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty")
    @software.amazon.jsii.Jsii.Proxy(DBClusterRoleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DBClusterRoleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the feature associated with the AWS Identity and Access Management (IAM) role.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFeatureName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DBClusterRoleProperty> {
            java.lang.String roleArn;
            java.lang.String featureName;

            /**
             * Sets the value of {@link DBClusterRoleProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DBClusterRoleProperty#getFeatureName}
             * @param featureName The name of the feature associated with the AWS Identity and Access Management (IAM) role.
             *                    IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other AWS services on your behalf. For the list of supported feature names, see the <code>SupportedFeatureNames</code> description in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DBEngineVersion.html">DBEngineVersion</a> in the <em>Amazon RDS API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DBClusterRoleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DBClusterRoleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DBClusterRoleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DBClusterRoleProperty {
            private final java.lang.String roleArn;
            private final java.lang.String featureName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.featureName = builder.featureName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getFeatureName() != null) {
                    data.set("featureName", om.valueToTree(this.getFeatureName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBCluster.DBClusterRoleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DBClusterRoleProperty.Jsii$Proxy that = (DBClusterRoleProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.featureName != null ? this.featureName.equals(that.featureName) : that.featureName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.featureName != null ? this.featureName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * ScalingConfigurationProperty scalingConfigurationProperty = ScalingConfigurationProperty.builder()
     *         .autoPause(false)
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .secondsUntilAutoPause(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * A DB cluster can be paused only when it's idle (it has no connections).
         * <p>
         * <blockquote>
         * <p>
         * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoPause() {
            return null;
        }

        /**
         * The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
         * <p>
         * The maximum capacity must be greater than or equal to the minimum capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
         * <p>
         * The minimum capacity must be less than or equal to the maximum capacity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinCapacity() {
            return null;
        }

        /**
         * The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
         * <p>
         * Specify a value between 300 and 86,400 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSecondsUntilAutoPause() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConfigurationProperty> {
            java.lang.Object autoPause;
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;
            java.lang.Number secondsUntilAutoPause;

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
             *                  A DB cluster can be paused only when it's idle (it has no connections).
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(java.lang.Boolean autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getAutoPause}
             * @param autoPause A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode.
             *                  A DB cluster can be paused only when it's idle (it has no connections).
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoPause(software.amazon.awscdk.IResolvable autoPause) {
                this.autoPause = autoPause;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMaxCapacity}
             * @param maxCapacity The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
             *                    For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
             *                    <p>
             *                    For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
             *                    <p>
             *                    The maximum capacity must be greater than or equal to the minimum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getMinCapacity}
             * @param minCapacity The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
             *                    For Aurora MySQL, valid capacity values are <code>1</code> , <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>128</code> , and <code>256</code> .
             *                    <p>
             *                    For Aurora PostgreSQL, valid capacity values are <code>2</code> , <code>4</code> , <code>8</code> , <code>16</code> , <code>32</code> , <code>64</code> , <code>192</code> , and <code>384</code> .
             *                    <p>
             *                    The minimum capacity must be less than or equal to the maximum capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConfigurationProperty#getSecondsUntilAutoPause}
             * @param secondsUntilAutoPause The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
             *                              Specify a value between 300 and 86,400 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondsUntilAutoPause(java.lang.Number secondsUntilAutoPause) {
                this.secondsUntilAutoPause = secondsUntilAutoPause;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConfigurationProperty {
            private final java.lang.Object autoPause;
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.Number secondsUntilAutoPause;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoPause = software.amazon.jsii.Kernel.get(this, "autoPause", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secondsUntilAutoPause = software.amazon.jsii.Kernel.get(this, "secondsUntilAutoPause", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoPause = builder.autoPause;
                this.maxCapacity = builder.maxCapacity;
                this.minCapacity = builder.minCapacity;
                this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
            }

            @Override
            public final java.lang.Object getAutoPause() {
                return this.autoPause;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public final java.lang.Number getSecondsUntilAutoPause() {
                return this.secondsUntilAutoPause;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoPause() != null) {
                    data.set("autoPause", om.valueToTree(this.getAutoPause()));
                }
                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getMinCapacity() != null) {
                    data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                }
                if (this.getSecondsUntilAutoPause() != null) {
                    data.set("secondsUntilAutoPause", om.valueToTree(this.getSecondsUntilAutoPause()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBCluster.ScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConfigurationProperty.Jsii$Proxy that = (ScalingConfigurationProperty.Jsii$Proxy) o;

                if (this.autoPause != null ? !this.autoPause.equals(that.autoPause) : that.autoPause != null) return false;
                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
                return this.secondsUntilAutoPause != null ? this.secondsUntilAutoPause.equals(that.secondsUntilAutoPause) : that.secondsUntilAutoPause == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoPause != null ? this.autoPause.hashCode() : 0;
                result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
                result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
                result = 31 * result + (this.secondsUntilAutoPause != null ? this.secondsUntilAutoPause.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBClusterProps.Builder();
        }

        /**
         * The name of the database engine to be used for this DB cluster.
         * <p>
         * Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), and <code>aurora-postgresql</code>
         * <p>
         * @return {@code this}
         * @param engine The name of the database engine to be used for this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * <p>
         * @return {@code this}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final software.amazon.awscdk.IResolvable associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }
        /**
         * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         * <p>
         * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         * <p>
         * @return {@code this}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(final java.util.List<? extends java.lang.Object> associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        /**
         * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         * <p>
         * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param availabilityZones A list of Availability Zones (AZs) where instances in the DB cluster can be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         * <p>
         * <blockquote>
         * <p>
         * Currently, Backtrack is only supported for Aurora MySQL DB clusters.
         * <p>
         * </blockquote>
         * <p>
         * Default: 0
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param backtrackWindow The target backtrack window, in seconds. To disable backtracking, set this value to 0. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(final java.lang.Number backtrackWindow) {
            this.props.backtrackWindow(backtrackWindow);
            return this;
        }

        /**
         * The number of days for which automated backups are retained.
         * <p>
         * Default: 1
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be a value from 1 to 35</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param backupRetentionPeriod The number of days for which automated backups are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(final java.lang.Number backupRetentionPeriod) {
            this.props.backupRetentionPeriod(backupRetentionPeriod);
            return this;
        }

        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         * <p>
         * The default is not to copy them.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }
        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         * <p>
         * The default is not to copy them.
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * The name of your database.
         * <p>
         * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param databaseName The name of your database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * The DB cluster identifier. This parameter is stored as a lowercase string.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
         * </ul>
         * <p>
         * Example: <code>my-cluster1</code>
         * <p>
         * @return {@code this}
         * @param dbClusterIdentifier The DB cluster identifier. This parameter is stored as a lowercase string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(final java.lang.String dbClusterIdentifier) {
            this.props.dbClusterIdentifier(dbClusterIdentifier);
            return this;
        }

        /**
         * The name of the DB cluster parameter group to associate with this DB cluster.
         * <p>
         * <blockquote>
         * <p>
         * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         * <p>
         * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
         * <p>
         * </blockquote>
         * <p>
         * To list all of the available DB cluster parameter group names, use the following command:
         * <p>
         * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
         * <p>
         * @return {@code this}
         * @param dbClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(final java.lang.String dbClusterParameterGroupName) {
            this.props.dbClusterParameterGroupName(dbClusterParameterGroupName);
            return this;
        }

        /**
         * A DB subnet group that you want to associate with this DB cluster.
         * <p>
         * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         * <p>
         * @return {@code this}
         * @param dbSubnetGroupName A DB subnet group that you want to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(final java.lang.String dbSubnetGroupName) {
            this.props.dbSubnetGroupName(dbSubnetGroupName);
            return this;
        }

        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * <p>
         * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * <em>Aurora MySQL</em>
         * <p>
         * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         * <p>
         * <em>Aurora PostgreSQL</em>
         * <p>
         * Valid values: <code>postgresql</code>
         * <p>
         * @return {@code this}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(final java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.props.enableCloudwatchLogsExports(enableCloudwatchLogsExports);
            return this;
        }

        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         * <p>
         * By default, the HTTP endpoint is disabled.
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final java.lang.Boolean enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }
        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster.
         * <p>
         * By default, the HTTP endpoint is disabled.
         * <p>
         * When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableHttpEndpoint A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(final software.amazon.awscdk.IResolvable enableHttpEndpoint) {
            this.props.enableHttpEndpoint(enableHttpEndpoint);
            return this;
        }

        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final java.lang.Boolean enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }
        /**
         * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * By default, mapping is disabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * @return {@code this}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(final software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.props.enableIamDatabaseAuthentication(enableIamDatabaseAuthentication);
            return this;
        }

        /**
         * The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` .
         * <p>
         * The <code>serverless</code> engine mode only supports Aurora Serverless v1. Currently, AWS CloudFormation doesn't support Aurora Serverless v2.
         * <p>
         * The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.
         * <p>
         * The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.
         * <p>
         * The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
         * <p>
         * For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.
         * <p>
         * Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <em>Amazon Aurora User Guide</em> :
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">Limitations of Parallel Query</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">Limitations of Aurora Global Databases</a></li>
         * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">Limitations of Multi-Master Clusters</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param engineMode The DB engine mode of the DB cluster, either `provisioned` , `serverless` , `parallelquery` , `global` , or `multimaster` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineMode(final java.lang.String engineMode) {
            this.props.engineMode(engineMode);
            return this;
        }

        /**
         * The version number of the database engine to use.
         * <p>
         * To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora), use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * To list all of the available engine versions for <code>aurora-postgresql</code> , use the following command:
         * <p>
         * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the database engine to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
         * <p>
         * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
         * <p>
         * If you aren't configuring a global database cluster, don't specify this property.
         * <p>
         * <blockquote>
         * <p>
         * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
         * <p>
         * </blockquote>
         * <p>
         * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
         * <p>
         * @return {@code this}
         * @param globalClusterIdentifier If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(final java.lang.String globalClusterIdentifier) {
            this.props.globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` .
         * <p>
         * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as `arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * The name of the master user for the DB cluster.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param masterUsername The name of the master user for the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        /**
         * The master password for the DB instance.
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param masterUserPassword The master password for the DB instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The port number on which the DB instances in the DB cluster accept connections.
         * <p>
         * Default:
         * <p>
         * <ul>
         * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
         * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
         * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
         * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param port The port number on which the DB instances in the DB cluster accept connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The daily time range during which automated backups are created.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         * <li>Must be in Universal Coordinated Time (UTC).</li>
         * <li>Must not conflict with the preferred maintenance window.</li>
         * <li>Must be at least 30 minutes.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param preferredBackupWindow The daily time range during which automated backups are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Adjusting the Preferred DB Cluster Maintenance Window</a> in the <em>Amazon Aurora User Guide.</em>
         * <p>
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * <p>
         * Constraints: Minimum 30-minute window.
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         * <p>
         * @return {@code this}
         * @param replicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(final java.lang.String replicationSourceIdentifier) {
            this.props.replicationSourceIdentifier(replicationSourceIdentifier);
            return this;
        }

        /**
         * The type of restore to be performed. You can specify one of the following values:.
         * <p>
         * <ul>
         * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
         * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
         * </ul>
         * <p>
         * Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.
         * <p>
         * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
         * <p>
         * @return {@code this}
         * @param restoreType The type of restore to be performed. You can specify one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(final java.lang.String restoreType) {
            this.props.restoreType(restoreType);
            return this;
        }

        /**
         * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         * <p>
         * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
         * <p>
         * @return {@code this}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }
        /**
         * The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster.
         * <p>
         * Currently, AWS CloudFormation only supports Aurora Serverless v1. AWS CloudFormation doesn't support Aurora Serverless v2.
         * <p>
         * @return {@code this}
         * @param scalingConfiguration The `ScalingConfiguration` property type specifies the scaling configuration of an Aurora Serverless DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(final software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.props.scalingConfiguration(scalingConfiguration);
            return this;
        }

        /**
         * The identifier for the DB snapshot or DB cluster snapshot to restore from.
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         * <p>
         * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
         * <p>
         * <ul>
         * <li><code>GlobalClusterIdentifier</code></li>
         * <li><code>MasterUsername</code></li>
         * <li><code>MasterUserPassword</code></li>
         * <li><code>ReplicationSourceIdentifier</code></li>
         * <li><code>RestoreType</code></li>
         * <li><code>SourceDBClusterIdentifier</code></li>
         * <li><code>SourceRegion</code></li>
         * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
         * <li><code>UseLatestRestorableTime</code></li>
         * </ul>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing Snapshot.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The identifier for the DB snapshot or DB cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must match the identifier of an existing DBCluster.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param sourceDbClusterIdentifier When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(final java.lang.String sourceDbClusterIdentifier) {
            this.props.sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        /**
         * The AWS Region which contains the source DB cluster when replicating a DB cluster.
         * <p>
         * For example, <code>us-east-1</code> .
         * <p>
         * @return {@code this}
         * @param sourceRegion The AWS Region which contains the source DB cluster when replicating a DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(final java.lang.String sourceRegion) {
            this.props.sourceRegion(sourceRegion);
            return this;
        }

        /**
         * Indicates whether the DB cluster is encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * @return {@code this}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * Indicates whether the DB cluster is encrypted.
         * <p>
         * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         * <p>
         * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         * <p>
         * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         * <p>
         * @return {@code this}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * Tags to assign to the DB cluster.
         * <p>
         * @return {@code this}
         * @param tags Tags to assign to the DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         * <p>
         * By default, the DB cluster is not restored to the latest restorable backup time.
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final java.lang.Boolean useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }
        /**
         * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         * <p>
         * By default, the DB cluster is not restored to the latest restorable backup time.
         * <p>
         * @return {@code this}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(final software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.props.useLatestRestorableTime(useLatestRestorableTime);
            return this;
        }

        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * <p>
         * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBCluster build() {
            return new software.amazon.awscdk.services.rds.CfnDBCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
