package software.amazon.awscdk.services.rds;

/**
 * The versions for the Aurora PostgreSQL cluster engine (those returned by {@link DatabaseClusterEngine.auroraPostgres}).
 * <p>
 * https://docs.aws.amazon.com/AmazonRDS/latest/AuroraPostgreSQLReleaseNotes/AuroraPostgreSQL.Updates.html
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * AuroraPostgresEngineVersion auroraPostgresEngineVersion = AuroraPostgresEngineVersion.VER_10_11;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.352Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.AuroraPostgresEngineVersion")
public class AuroraPostgresEngineVersion extends software.amazon.jsii.JsiiObject {

    protected AuroraPostgresEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AuroraPostgresEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_10_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_10_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_10_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_11_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_11_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_10 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_10", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_12_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_12_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_6 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_13_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_13_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_14_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_14_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_18 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_18", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_8 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_8", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
        VER_9_6_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "VER_9_6_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class));
    }

    /**
     * Create a new AuroraPostgresEngineVersion with an arbitrary version.
     * <p>
     * @param auroraPostgresFullVersion the full version string, for example "9.6.25.1". This parameter is required.
     * @param auroraPostgresMajorVersion the major version of the engine, for example "9.6". This parameter is required.
     * @param auroraPostgresFeatures
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresMajorVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.AuroraPostgresEngineFeatures auroraPostgresFeatures) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraPostgresFullVersion, "auroraPostgresFullVersion is required"), java.util.Objects.requireNonNull(auroraPostgresMajorVersion, "auroraPostgresMajorVersion is required"), auroraPostgresFeatures });
    }

    /**
     * Create a new AuroraPostgresEngineVersion with an arbitrary version.
     * <p>
     * @param auroraPostgresFullVersion the full version string, for example "9.6.25.1". This parameter is required.
     * @param auroraPostgresMajorVersion the major version of the engine, for example "9.6". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String auroraPostgresMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(auroraPostgresFullVersion, "auroraPostgresFullVersion is required"), java.util.Objects.requireNonNull(auroraPostgresMajorVersion, "auroraPostgresMajorVersion is required") });
    }

    /**
     * (deprecated) Version "10.11".
     * <p>
     * @deprecated Version 10.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_11;

    /**
     * (deprecated) Version "10.12".
     * <p>
     * @deprecated Version 10.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_12;

    /**
     * (deprecated) Version "10.13".
     * <p>
     * @deprecated Version 10.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_13;

    /**
     * (deprecated) Version "10.14".
     * <p>
     * @deprecated Version 10.14 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_14;

    /**
     * Version "10.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_16;

    /**
     * Version "10.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_17;

    /**
     * Version "10.18".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_18;

    /**
     * Version "10.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_19;

    /**
     * Version "10.20".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_20;

    /**
     * Version "10.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_21;

    /**
     * (deprecated) Version "10.4".
     * <p>
     * @deprecated Version 10.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_4;

    /**
     * (deprecated) Version "10.5".
     * <p>
     * @deprecated Version 10.5 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_5;

    /**
     * (deprecated) Version "10.6".
     * <p>
     * @deprecated Version 10.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_6;

    /**
     * (deprecated) Version "10.7".
     * <p>
     * @deprecated Version 10.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_10_7;

    /**
     * Version "11.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_11;

    /**
     * Version "11.12".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_12;

    /**
     * Version "11.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_13;

    /**
     * Version "11.14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_14;

    /**
     * Version "11.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_15;

    /**
     * Version "11.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_16;

    /**
     * (deprecated) Version "11.4".
     * <p>
     * @deprecated Version 11.4 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_4;

    /**
     * (deprecated) Version "11.6".
     * <p>
     * @deprecated Version 11.6 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_6;

    /**
     * (deprecated) Version "11.7".
     * <p>
     * @deprecated Version 11.7 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_7;

    /**
     * (deprecated) Version "11.8".
     * <p>
     * @deprecated Version 11.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_8;

    /**
     * Version "11.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_11_9;

    /**
     * Version "12.10".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_10;

    /**
     * Version "12.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_11;

    /**
     * Version "12.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_4;

    /**
     * Version "12.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_6;

    /**
     * Version "12.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_7;

    /**
     * Version "12.8".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_8;

    /**
     * Version "12.9".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_12_9;

    /**
     * Version "13.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_3;

    /**
     * Version "13.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_4;

    /**
     * Version "13.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_5;

    /**
     * Version "13.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_6;

    /**
     * Version "13.7".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_13_7;

    /**
     * Version "14.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_14_3;

    /**
     * (deprecated) Version "9.6.11".
     * <p>
     * @deprecated Version 9.6.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_11;

    /**
     * (deprecated) Version "9.6.12".
     * <p>
     * @deprecated Version 9.6.12 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_12;

    /**
     * (deprecated) Version "9.6.16".
     * <p>
     * @deprecated Version 9.6.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_16;

    /**
     * (deprecated) Version "9.6.17".
     * <p>
     * @deprecated Version 9.6.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_17;

    /**
     * (deprecated) Version "9.6.18".
     * <p>
     * @deprecated Version 9.6.18 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_18;

    /**
     * (deprecated) Version "9.6.19".
     * <p>
     * @deprecated Version 9.6.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_19;

    /**
     * (deprecated) Version "9.6.8".
     * <p>
     * @deprecated Version 9.6.8 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_8;

    /**
     * (deprecated) Version "9.6.9".
     * <p>
     * @deprecated Version 9.6.9 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.AuroraPostgresEngineVersion VER_9_6_9;

    /**
     * The full version string, for example, "9.6.25.1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraPostgresFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraPostgresFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "9.6".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuroraPostgresMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "auroraPostgresMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
