package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a `CfnVolume`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * CfnVolumeProps cfnVolumeProps = CfnVolumeProps.builder()
 *         .ec2VolumeId("ec2VolumeId")
 *         .stackId("stackId")
 *         // the properties below are optional
 *         .mountPoint("mountPoint")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:41.162Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnVolumeProps")
@software.amazon.jsii.Jsii.Proxy(CfnVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon EC2 volume ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEc2VolumeId();

    /**
     * The stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackId();

    /**
     * The volume mount point.
     * <p>
     * For example, "/mnt/disk1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMountPoint() {
        return null;
    }

    /**
     * The volume name.
     * <p>
     * Volume names are a maximum of 128 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVolumeProps> {
        java.lang.String ec2VolumeId;
        java.lang.String stackId;
        java.lang.String mountPoint;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnVolumeProps#getEc2VolumeId}
         * @param ec2VolumeId The Amazon EC2 volume ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2VolumeId(java.lang.String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getStackId}
         * @param stackId The stack ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackId(java.lang.String stackId) {
            this.stackId = stackId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getMountPoint}
         * @param mountPoint The volume mount point.
         *                   For example, "/mnt/disk1".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPoint(java.lang.String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getName}
         * @param name The volume name.
         *             Volume names are a maximum of 128 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeProps {
        private final java.lang.String ec2VolumeId;
        private final java.lang.String stackId;
        private final java.lang.String mountPoint;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ec2VolumeId = software.amazon.jsii.Kernel.get(this, "ec2VolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stackId = software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mountPoint = software.amazon.jsii.Kernel.get(this, "mountPoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ec2VolumeId = java.util.Objects.requireNonNull(builder.ec2VolumeId, "ec2VolumeId is required");
            this.stackId = java.util.Objects.requireNonNull(builder.stackId, "stackId is required");
            this.mountPoint = builder.mountPoint;
            this.name = builder.name;
        }

        @Override
        public final java.lang.String getEc2VolumeId() {
            return this.ec2VolumeId;
        }

        @Override
        public final java.lang.String getStackId() {
            return this.stackId;
        }

        @Override
        public final java.lang.String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ec2VolumeId", om.valueToTree(this.getEc2VolumeId()));
            data.set("stackId", om.valueToTree(this.getStackId()));
            if (this.getMountPoint() != null) {
                data.set("mountPoint", om.valueToTree(this.getMountPoint()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeProps.Jsii$Proxy that = (CfnVolumeProps.Jsii$Proxy) o;

            if (!ec2VolumeId.equals(that.ec2VolumeId)) return false;
            if (!stackId.equals(that.stackId)) return false;
            if (this.mountPoint != null ? !this.mountPoint.equals(that.mountPoint) : that.mountPoint != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ec2VolumeId.hashCode();
            result = 31 * result + (this.stackId.hashCode());
            result = 31 * result + (this.mountPoint != null ? this.mountPoint.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
