package software.amazon.awscdk.services.kms;

/**
 * A CloudFormation `AWS::KMS::Key`.
 * <p>
 * The <code>AWS::KMS::Key</code> resource specifies an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys">KMS key</a> in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use <code>AWS::KMS::Key</code> to create <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key">multi-Region primary keys</a> of all supported types. To replicate a multi-Region key, use the <code>AWS::KMS::ReplicaKey</code> resource.
 * <p>
 * You cannot use the <code>AWS::KMS::Key</code> resource to specify a KMS key with <a href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html">imported key material</a> or a KMS key in a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html">custom key store</a> .
 * <p>
 * <blockquote>
 * <p>
 * AWS KMS replaced the term <em>customer master key (CMK)</em> with <em>AWS KMS key</em> and <em>KMS key</em> . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 * <p>
 * </blockquote>
 * <p>
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are <a href="https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration">integrated with AWS KMS</a> . For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks">Symmetric encryption KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric <code>KeySpec</code> value and a <code>KeyUsage</code> value. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC <code>KeySpec</code> value and a <code>KeyUsage</code> value of <code>GENERATE_VERIFY_MAC</code> . For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the <code>MultiRegion</code> property to <code>true</code> . For information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys in AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * If you change the value of the <code>KeyUsage</code> , <code>KeySpec</code> , or <code>MultiRegion</code> property on an existing KMS key, the existing KMS key is <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">scheduled for deletion</a> and a new KMS key is created with the specified value.
 * <p>
 * While scheduled for deletion, the existing KMS key becomes unusable. If you don't <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the existing KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
 * <p>
 * </blockquote>
 * <p>
 * <em>Regions</em>
 * <p>
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage asymmetric KMS keys or multi-Region KMS keys (primary or replica).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude cfnTemplate;
 * CfnKey cfnKey = (CfnKey)cfnTemplate.getResource("Key");
 * IKey key = Key.fromCfnKey(cfnKey);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:40.318Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.CfnKey")
public class CfnKey extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kms.CfnKey.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::KMS::Key`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.CfnKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the KMS key, such as `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab` .
     * <p>
     * For information about the key ARN of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">Key ARN</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The key ID of the KMS key, such as `1234abcd-12ab-34cd-56ef-1234567890ab` .
     * <p>
     * For information about the key ID of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id">Key ID</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyId() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Assigns one or more tags to the replica key.
     * <p>
     * <blockquote>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * For information about tags in AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> in the <em>AWS Key Management Service Developer Guide</em> . For information about tags in CloudFormation, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The key policy that authorizes use of the KMS key. The key policy must conform to the following rules.
     * <p>
     * <ul>
     * <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
     * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
     * </ul>
     * <p>
     * If you are unsure of which policy to use, consider the <em>default key policy</em> . This is the key policy that AWS KMS applies to KMS keys that are created by using the CreateKey API with no specified key policy. It gives the AWS account that owns the key permission to perform all operations on the key. It also allows you write IAM policies to authorize access to the key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * A key policy document can include only the following characters:
     * <p>
     * <ul>
     * <li>Printable ASCII characters</li>
     * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
     * <li>The tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> ) special characters</li>
     * </ul>
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>32768</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKeyPolicy() {
        return software.amazon.jsii.Kernel.get(this, "keyPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key policy that authorizes use of the KMS key. The key policy must conform to the following rules.
     * <p>
     * <ul>
     * <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
     * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
     * </ul>
     * <p>
     * If you are unsure of which policy to use, consider the <em>default key policy</em> . This is the key policy that AWS KMS applies to KMS keys that are created by using the CreateKey API with no specified key policy. It gives the AWS account that owns the key permission to perform all operations on the key. It also allows you write IAM policies to authorize access to the key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * A key policy document can include only the following characters:
     * <p>
     * <ul>
     * <li>Printable ASCII characters</li>
     * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
     * <li>The tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> ) special characters</li>
     * </ul>
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>32768</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "keyPolicy", java.util.Objects.requireNonNull(value, "keyPolicy is required"));
    }

    /**
     * A description of the KMS key.
     * <p>
     * Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the KMS key.
     * <p>
     * Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
     * <p>
     * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
     * <p>
     * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
     * <p>
     * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
     * <p>
     * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
     * <p>
     * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
     * <p>
     * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
     * <p>
     * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
     * <p>
     * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
     * <p>
     * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     * <p>
     * By default, automatic key rotation is not enabled.
     * <p>
     * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
     * <p>
     * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableKeyRotation() {
        return software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     * <p>
     * By default, automatic key rotation is not enabled.
     * <p>
     * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
     * <p>
     * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableKeyRotation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableKeyRotation", value);
    }

    /**
     * Enables automatic rotation of the key material for the specified KMS key.
     * <p>
     * By default, automatic key rotation is not enabled.
     * <p>
     * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
     * <p>
     * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableKeyRotation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableKeyRotation", value);
    }

    /**
     * Specifies the type of KMS key to create.
     * <p>
     * The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>KeySpec</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeySpec</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * AWS KMS supports the following key specs for KMS keys:
     * <p>
     * <ul>
     * <li>Symmetric encryption key (default)</li>
     * <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
     * <li>HMAC keys (symmetric)</li>
     * <li><code>HMAC_224</code></li>
     * <li><code>HMAC_256</code></li>
     * <li><code>HMAC_384</code></li>
     * <li><code>HMAC_512</code></li>
     * <li>Asymmetric RSA key pairs</li>
     * <li><code>RSA_2048</code></li>
     * <li><code>RSA_3072</code></li>
     * <li><code>RSA_4096</code></li>
     * <li>Asymmetric NIST-recommended elliptic curve key pairs</li>
     * <li><code>ECC_NIST_P256</code> (secp256r1)</li>
     * <li><code>ECC_NIST_P384</code> (secp384r1)</li>
     * <li><code>ECC_NIST_P521</code> (secp521r1)</li>
     * <li>Other asymmetric elliptic curve key pairs</li>
     * <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeySpec() {
        return software.amazon.jsii.Kernel.get(this, "keySpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the type of KMS key to create.
     * <p>
     * The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>KeySpec</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeySpec</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * AWS KMS supports the following key specs for KMS keys:
     * <p>
     * <ul>
     * <li>Symmetric encryption key (default)</li>
     * <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
     * <li>HMAC keys (symmetric)</li>
     * <li><code>HMAC_224</code></li>
     * <li><code>HMAC_256</code></li>
     * <li><code>HMAC_384</code></li>
     * <li><code>HMAC_512</code></li>
     * <li>Asymmetric RSA key pairs</li>
     * <li><code>RSA_2048</code></li>
     * <li><code>RSA_3072</code></li>
     * <li><code>RSA_4096</code></li>
     * <li>Asymmetric NIST-recommended elliptic curve key pairs</li>
     * <li><code>ECC_NIST_P256</code> (secp256r1)</li>
     * <li><code>ECC_NIST_P384</code> (secp384r1)</li>
     * <li><code>ECC_NIST_P521</code> (secp521r1)</li>
     * <li>Other asymmetric elliptic curve key pairs</li>
     * <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeySpec(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keySpec", value);
    }

    /**
     * Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT` . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the `KeyUsage` value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>KeyUsage</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeyUsage</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
     * <p>
     * </blockquote>
     * <p>
     * Select only one valid value.
     * <p>
     * <ul>
     * <li>For symmetric encryption KMS keys, omit the property or specify <code>ENCRYPT_DECRYPT</code> .</li>
     * <li>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
     * <li>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code> .</li>
     * <li>For HMAC KMS keys, specify <code>GENERATE_VERIFY_MAC</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyUsage() {
        return software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT` . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the `KeyUsage` value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>KeyUsage</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeyUsage</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
     * <p>
     * </blockquote>
     * <p>
     * Select only one valid value.
     * <p>
     * <ul>
     * <li>For symmetric encryption KMS keys, omit the property or specify <code>ENCRYPT_DECRYPT</code> .</li>
     * <li>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
     * <li>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code> .</li>
     * <li>For HMAC KMS keys, specify <code>GENERATE_VERIFY_MAC</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyUsage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyUsage", value);
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     * <p>
     * You can't change the <code>MultiRegion</code> value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>MultiRegion</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>Multi-Region</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
     * <p>
     * </blockquote>
     * <p>
     * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
     * <p>
     * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
     * <p>
     * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegion() {
        return software.amazon.jsii.Kernel.get(this, "multiRegion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     * <p>
     * You can't change the <code>MultiRegion</code> value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>MultiRegion</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>Multi-Region</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
     * <p>
     * </blockquote>
     * <p>
     * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
     * <p>
     * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
     * <p>
     * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegion(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiRegion", value);
    }

    /**
     * Creates a multi-Region primary key that you can replicate in other AWS Regions .
     * <p>
     * You can't change the <code>MultiRegion</code> value after the KMS key is created.
     * <p>
     * <blockquote>
     * <p>
     * If you change the <code>MultiRegion</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>Multi-Region</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
     * <p>
     * </blockquote>
     * <p>
     * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
     * <p>
     * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
     * <p>
     * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiRegion", value);
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
     * <p>
     * Enter a value between 7 and 30 days. The default value is 30 days.
     * <p>
     * When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
     * <p>
     * AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
     * <p>
     * For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <em>Minimum</em> : 7
     * <p>
     * <em>Maximum</em> : 30
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPendingWindowInDays() {
        return software.amazon.jsii.Kernel.get(this, "pendingWindowInDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
     * <p>
     * Enter a value between 7 and 30 days. The default value is 30 days.
     * <p>
     * When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
     * <p>
     * AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
     * <p>
     * For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * <em>Minimum</em> : 7
     * <p>
     * <em>Maximum</em> : 30
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPendingWindowInDays(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "pendingWindowInDays", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kms.CfnKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kms.CfnKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kms.CfnKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kms.CfnKeyProps.Builder();
        }

        /**
         * The key policy that authorizes use of the KMS key. The key policy must conform to the following rules.
         * <p>
         * <ul>
         * <li>The key policy must allow the caller to make a subsequent <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_PutKeyPolicy.html">PutKeyPolicy</a> request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam">Default key policy</a> section of the <strong>AWS Key Management Service Developer Guide</strong> .</li>
         * <li>Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to AWS KMS . When you create a new AWS principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to AWS KMS . For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency">Changes that I make are not always immediately visible</a> in the <em>AWS Identity and Access Management User Guide</em> .</li>
         * </ul>
         * <p>
         * If you are unsure of which policy to use, consider the <em>default key policy</em> . This is the key policy that AWS KMS applies to KMS keys that are created by using the CreateKey API with no specified key policy. It gives the AWS account that owns the key permission to perform all operations on the key. It also allows you write IAM policies to authorize access to the key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">Default key policy</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * A key policy document can include only the following characters:
         * <p>
         * <ul>
         * <li>Printable ASCII characters</li>
         * <li>Printable characters in the Basic Latin and Latin-1 Supplement character set</li>
         * <li>The tab ( <code>\ u0009</code> ), line feed ( <code>\ u000A</code> ), and carriage return ( <code>\ u000D</code> ) special characters</li>
         * </ul>
         * <p>
         * <em>Minimum</em> : <code>1</code>
         * <p>
         * <em>Maximum</em> : <code>32768</code>
         * <p>
         * @return {@code this}
         * @param keyPolicy The key policy that authorizes use of the KMS key. The key policy must conform to the following rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPolicy(final java.lang.Object keyPolicy) {
            this.props.keyPolicy(keyPolicy);
            return this;
        }

        /**
         * A description of the KMS key.
         * <p>
         * Use a description that helps you to distinguish this KMS key from others in the account, such as its intended use.
         * <p>
         * @return {@code this}
         * @param description A description of the KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         * <p>
         * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         * <p>
         * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         * <p>
         * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations.
         * <p>
         * When <code>Enabled</code> is <code>true</code> , the <em>key state</em> of the KMS key is <code>Enabled</code> . When <code>Enabled</code> is <code>false</code> , the key state of the KMS key is <code>Disabled</code> . The default value is <code>true</code> .
         * <p>
         * The actual key state of the KMS key might be affected by actions taken outside of CloudFormation, such as running the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_EnableKey.html">EnableKey</a> , <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DisableKey.html">DisableKey</a> , or <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operations.
         * <p>
         * For information about the key states of a KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether the KMS key is enabled. Disabled KMS keys cannot be used in cryptographic operations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * Enables automatic rotation of the key material for the specified KMS key.
         * <p>
         * By default, automatic key rotation is not enabled.
         * <p>
         * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         * <p>
         * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final java.lang.Boolean enableKeyRotation) {
            this.props.enableKeyRotation(enableKeyRotation);
            return this;
        }
        /**
         * Enables automatic rotation of the key material for the specified KMS key.
         * <p>
         * By default, automatic key rotation is not enabled.
         * <p>
         * AWS KMS supports automatic rotation only for symmetric encryption KMS keys ( <code>KeySpec</code> = <code>SYMMETRIC_DEFAULT</code> ). For asymmetric KMS keys and HMAC KMS keys, omit the <code>EnableKeyRotation</code> property or set it to <code>false</code> .
         * <p>
         * To enable automatic key rotation of the key material for a multi-Region KMS key, set <code>EnableKeyRotation</code> to <code>true</code> on the primary key (created by using <code>AWS::KMS::Key</code> ). AWS KMS copies the rotation status to all replica keys. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate">Rotating multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * When you enable automatic rotation, AWS KMS automatically creates new key material for the KMS key one year after the enable date and every year thereafter. AWS KMS retains all key material until you delete the KMS key. For detailed information about automatic key rotation, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html">Rotating KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param enableKeyRotation Enables automatic rotation of the key material for the specified KMS key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(final software.amazon.awscdk.IResolvable enableKeyRotation) {
            this.props.enableKeyRotation(enableKeyRotation);
            return this;
        }

        /**
         * Specifies the type of KMS key to create.
         * <p>
         * The default value, <code>SYMMETRIC_DEFAULT</code> , creates a KMS key with a 256-bit symmetric key for encryption and decryption. You can't change the <code>KeySpec</code> value after the KMS key is created. For help choosing a key spec for your KMS key, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html">Choosing a KMS key type</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * The <code>KeySpec</code> property determines the type of key material in the KMS key and the algorithms that the KMS key supports. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms">AWS KMS condition keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>KeySpec</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeySpec</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted. &gt; <a href="https://docs.aws.amazon.com/kms/features/#AWS_Service_Integration">AWS services that are integrated with AWS KMS</a> use symmetric encryption KMS keys to protect your data. These services do not support encryption with asymmetric KMS keys. For help determining whether a KMS key is asymmetric, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html">Identifying asymmetric KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * AWS KMS supports the following key specs for KMS keys:
         * <p>
         * <ul>
         * <li>Symmetric encryption key (default)</li>
         * <li><code>SYMMETRIC_DEFAULT</code> (AES-256-GCM)</li>
         * <li>HMAC keys (symmetric)</li>
         * <li><code>HMAC_224</code></li>
         * <li><code>HMAC_256</code></li>
         * <li><code>HMAC_384</code></li>
         * <li><code>HMAC_512</code></li>
         * <li>Asymmetric RSA key pairs</li>
         * <li><code>RSA_2048</code></li>
         * <li><code>RSA_3072</code></li>
         * <li><code>RSA_4096</code></li>
         * <li>Asymmetric NIST-recommended elliptic curve key pairs</li>
         * <li><code>ECC_NIST_P256</code> (secp256r1)</li>
         * <li><code>ECC_NIST_P384</code> (secp384r1)</li>
         * <li><code>ECC_NIST_P521</code> (secp521r1)</li>
         * <li>Other asymmetric elliptic curve key pairs</li>
         * <li><code>ECC_SECG_P256K1</code> (secp256k1), commonly used for cryptocurrencies.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param keySpec Specifies the type of KMS key to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySpec(final java.lang.String keySpec) {
            this.props.keySpec(keySpec);
            return this;
        }

        /**
         * Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT` . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the `KeyUsage` value after the KMS key is created.
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>KeyUsage</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>KeyUsage</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
         * <p>
         * </blockquote>
         * <p>
         * Select only one valid value.
         * <p>
         * <ul>
         * <li>For symmetric encryption KMS keys, omit the property or specify <code>ENCRYPT_DECRYPT</code> .</li>
         * <li>For asymmetric KMS keys with RSA key material, specify <code>ENCRYPT_DECRYPT</code> or <code>SIGN_VERIFY</code> .</li>
         * <li>For asymmetric KMS keys with ECC key material, specify <code>SIGN_VERIFY</code> .</li>
         * <li>For HMAC KMS keys, specify <code>GENERATE_VERIFY_MAC</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param keyUsage Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT` . This property is required for asymmetric KMS keys and HMAC KMS keys. You can't change the `KeyUsage` value after the KMS key is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyUsage(final java.lang.String keyUsage) {
            this.props.keyUsage(keyUsage);
            return this;
        }

        /**
         * Creates a multi-Region primary key that you can replicate in other AWS Regions .
         * <p>
         * You can't change the <code>MultiRegion</code> value after the KMS key is created.
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>MultiRegion</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>Multi-Region</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
         * <p>
         * </blockquote>
         * <p>
         * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         * <p>
         * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         * <p>
         * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * <p>
         * @return {@code this}
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(final java.lang.Boolean multiRegion) {
            this.props.multiRegion(multiRegion);
            return this;
        }
        /**
         * Creates a multi-Region primary key that you can replicate in other AWS Regions .
         * <p>
         * You can't change the <code>MultiRegion</code> value after the KMS key is created.
         * <p>
         * <blockquote>
         * <p>
         * If you change the <code>MultiRegion</code> value of an existing KMS key, the existing KMS key is scheduled for deletion and a new KMS key is created with the specified <code>Multi-Region</code> value. While the scheduled deletion is pending, you can't use the existing KMS key. Unless you <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion">cancel the scheduled deletion</a> of the KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
         * <p>
         * </blockquote>
         * <p>
         * For a multi-Region key, set to this property to <code>true</code> . For a single-Region key, omit this property or set it to <code>false</code> . The default value is <code>false</code> .
         * <p>
         * <em>Multi-Region keys</em> are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You can create a symmetric encryption, HMAC, or asymmetric multi-Region KMS key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         * <p>
         * To create a replica of this primary key in a different AWS Region , create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html">AWS::KMS::ReplicaKey</a> resource in a CloudFormation stack in the replica Region. Specify the key ARN of this primary key.
         * <p>
         * @return {@code this}
         * @param multiRegion Creates a multi-Region primary key that you can replicate in other AWS Regions . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegion(final software.amazon.awscdk.IResolvable multiRegion) {
            this.props.multiRegion(multiRegion);
            return this;
        }

        /**
         * Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack.
         * <p>
         * Enter a value between 7 and 30 days. The default value is 30 days.
         * <p>
         * When you remove a KMS key from a CloudFormation stack, AWS KMS schedules the KMS key for deletion and starts the mandatory waiting period. The <code>PendingWindowInDays</code> property determines the length of waiting period. During the waiting period, the key state of KMS key is <code>Pending Deletion</code> or <code>Pending Replica Deletion</code> , which prevents the KMS key from being used in cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the KMS key.
         * <p>
         * AWS KMS will not delete a <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">multi-Region primary key</a> that has replica keys. If you remove a multi-Region primary key from a CloudFormation stack, its key state changes to <code>PendingReplicaDeletion</code> so it cannot be replicated or used in cryptographic operations. This state can persist indefinitely. When the last of its replica keys is deleted, the key state of the primary key changes to <code>PendingDeletion</code> and the waiting period specified by <code>PendingWindowInDays</code> begins. When this waiting period expires, AWS KMS deletes the primary key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-delete.html">Deleting multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * You cannot use a CloudFormation template to cancel deletion of the KMS key after you remove it from the stack, regardless of the waiting period. If you specify a KMS key in your template, even one with the same name, CloudFormation creates a new KMS key. To cancel deletion of a KMS key, use the AWS KMS console or the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CancelKeyDeletion.html">CancelKeyDeletion</a> operation.
         * <p>
         * For information about the <code>Pending Deletion</code> and <code>Pending Replica Deletion</code> key states, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key state: Effect on your KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> . For more information about deleting KMS keys, see the <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_ScheduleKeyDeletion.html">ScheduleKeyDeletion</a> operation in the <em>AWS Key Management Service API Reference</em> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html">Deleting KMS keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * <em>Minimum</em> : 7
         * <p>
         * <em>Maximum</em> : 30
         * <p>
         * @return {@code this}
         * @param pendingWindowInDays Specifies the number of days in the waiting period before AWS KMS deletes a KMS key that has been removed from a CloudFormation stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pendingWindowInDays(final java.lang.Number pendingWindowInDays) {
            this.props.pendingWindowInDays(pendingWindowInDays);
            return this;
        }

        /**
         * Assigns one or more tags to the replica key.
         * <p>
         * <blockquote>
         * <p>
         * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC for AWS KMS</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * For information about tags in AWS KMS , see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging keys</a> in the <em>AWS Key Management Service Developer Guide</em> . For information about tags in CloudFormation, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags Assigns one or more tags to the replica key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kms.CfnKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kms.CfnKey build() {
            return new software.amazon.awscdk.services.kms.CfnKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
