package software.amazon.awscdk.services.inspector;

/**
 * Properties for defining a `CfnResourceGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspector.*;
 * CfnResourceGroupProps cfnResourceGroupProps = CfnResourceGroupProps.builder()
 *         .resourceGroupTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:39.830Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspector.CfnResourceGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The tags (key and value pairs) that will be associated with the resource group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getResourceGroupTags();

    /**
     * @return a {@link Builder} of {@link CfnResourceGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceGroupProps> {
        java.lang.Object resourceGroupTags;

        /**
         * Sets the value of {@link CfnResourceGroupProps#getResourceGroupTags}
         * @param resourceGroupTags The tags (key and value pairs) that will be associated with the resource group. This parameter is required.
         *                          For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGroupTags(software.amazon.awscdk.IResolvable resourceGroupTags) {
            this.resourceGroupTags = resourceGroupTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceGroupProps#getResourceGroupTags}
         * @param resourceGroupTags The tags (key and value pairs) that will be associated with the resource group. This parameter is required.
         *                          For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGroupTags(java.util.List<? extends java.lang.Object> resourceGroupTags) {
            this.resourceGroupTags = resourceGroupTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceGroupProps {
        private final java.lang.Object resourceGroupTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceGroupTags = software.amazon.jsii.Kernel.get(this, "resourceGroupTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceGroupTags = java.util.Objects.requireNonNull(builder.resourceGroupTags, "resourceGroupTags is required");
        }

        @Override
        public final java.lang.Object getResourceGroupTags() {
            return this.resourceGroupTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceGroupTags", om.valueToTree(this.getResourceGroupTags()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspector.CfnResourceGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceGroupProps.Jsii$Proxy that = (CfnResourceGroupProps.Jsii$Proxy) o;

            return this.resourceGroupTags.equals(that.resourceGroupTags);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceGroupTags.hashCode();
            return result;
        }
    }
}
