package software.amazon.awscdk.services.efs;

/**
 * A CloudFormation `AWS::EFS::FileSystem`.
 * <p>
 * The <code>AWS::EFS::FileSystem</code> resource creates a new, empty file system in Amazon Elastic File System ( Amazon EFS ). You must create a mount target ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html">AWS::EFS::MountTarget</a> ) to mount your EFS file system on an Amazon EC2 or other AWS cloud compute resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * Object fileSystemPolicy;
 * CfnFileSystem cfnFileSystem = CfnFileSystem.Builder.create(this, "MyCfnFileSystem")
 *         .availabilityZoneName("availabilityZoneName")
 *         .backupPolicy(BackupPolicyProperty.builder()
 *                 .status("status")
 *                 .build())
 *         .bypassPolicyLockoutSafetyCheck(false)
 *         .encrypted(false)
 *         .fileSystemPolicy(fileSystemPolicy)
 *         .fileSystemTags(List.of(ElasticFileSystemTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .kmsKeyId("kmsKeyId")
 *         .lifecyclePolicies(List.of(LifecyclePolicyProperty.builder()
 *                 .transitionToIa("transitionToIa")
 *                 .transitionToPrimaryStorageClass("transitionToPrimaryStorageClass")
 *                 .build()))
 *         .performanceMode("performanceMode")
 *         .provisionedThroughputInMibps(123)
 *         .throughputMode("throughputMode")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.852Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem")
public class CfnFileSystem extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.efs.CfnFileSystem.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::EFS::FileSystem`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::EFS::FileSystem`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the EFS file system.
     * <p>
     * Example: <code>arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-0123456789abcdef8</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the EFS file system.
     * <p>
     * For example: <code>fs-abcdef0123456789a</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "attrFileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Use to create one or more tags associated with the file system.
     * <p>
     * Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The `FileSystemPolicy` for the EFS file system.
     * <p>
     * A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFileSystemPolicy() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The `FileSystemPolicy` for the EFS file system.
     * <p>
     * A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemPolicy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemPolicy", java.util.Objects.requireNonNull(value, "fileSystemPolicy is required"));
    }

    /**
     * Used to create a file system that uses One Zone storage classes.
     * <p>
     * It specifies the AWS Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneName() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Used to create a file system that uses One Zone storage classes.
     * <p>
     * It specifies the AWS Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZoneName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZoneName", value);
    }

    /**
     * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBackupPolicy() {
        return software.amazon.jsii.Kernel.get(this, "backupPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "backupPolicy", value);
    }

    /**
     * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "backupPolicy", value);
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
     * <p>
     * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBypassPolicyLockoutSafetyCheck() {
        return software.amazon.jsii.Kernel.get(this, "bypassPolicyLockoutSafetyCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
     * <p>
     * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
     * <p>
     * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBypassPolicyLockoutSafetyCheck(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bypassPolicyLockoutSafetyCheck", value);
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     * <p>
     * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     * <p>
     * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * A Boolean value that, if true, creates an encrypted file system.
     * <p>
     * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encrypted", value);
    }

    /**
     * The ID of the AWS KMS key to be used to protect the encrypted file system.
     * <p>
     * This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
     * <p>
     * <ul>
     * <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
     * <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
     * </ul>
     * <p>
     * If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS KMS key to be used to protect the encrypted file system.
     * <p>
     * This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
     * <p>
     * <ul>
     * <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
     * <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
     * <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
     * </ul>
     * <p>
     * If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
     * <p>
     * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
     * <p>
     * <ul>
     * <li>When to move files in the file system from primary storage to the IA storage class.</li>
     * <li>When to move files that are in IA storage to primary storage.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLifecyclePolicies() {
        return software.amazon.jsii.Kernel.get(this, "lifecyclePolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
     * <p>
     * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
     * <p>
     * <ul>
     * <li>When to move files in the file system from primary storage to the IA storage class.</li>
     * <li>When to move files that are in IA storage to primary storage.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecyclePolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lifecyclePolicies", value);
    }

    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
     * <p>
     * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
     * <p>
     * <ul>
     * <li>When to move files in the file system from primary storage to the IA storage class.</li>
     * <li>When to move files that are in IA storage to primary storage.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLifecyclePolicies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.efs.CfnFileSystem.LifecyclePolicyProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.efs.CfnFileSystem.LifecyclePolicyProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "lifecyclePolicies", value);
    }

    /**
     * The performance mode of the file system.
     * <p>
     * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
     * <p>
     * <blockquote>
     * <p>
     * The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPerformanceMode() {
        return software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The performance mode of the file system.
     * <p>
     * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
     * <p>
     * <blockquote>
     * <p>
     * The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "performanceMode", value);
    }

    /**
     * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
     * <p>
     * Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedThroughputInMibps() {
        return software.amazon.jsii.Kernel.get(this, "provisionedThroughputInMibps", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
     * <p>
     * Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisionedThroughputInMibps(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "provisionedThroughputInMibps", value);
    }

    /**
     * Specifies the throughput mode for the file system, either `bursting` or `provisioned` .
     * <p>
     * If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * Default is <code>bursting</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThroughputMode() {
        return software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the throughput mode for the file system, either `bursting` or `provisioned` .
     * <p>
     * If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
     * <p>
     * Default is <code>bursting</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThroughputMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "throughputMode", value);
    }
    /**
     * The backup policy turns automatic backups for the file system on or off.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * BackupPolicyProperty backupPolicyProperty = BackupPolicyProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.BackupPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(BackupPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BackupPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set the backup policy status for the file system.
         * <p>
         * <ul>
         * <li><em><code>ENABLED</code></em> - Turns automatic backups on for the file system.</li>
         * <li><em><code>DISABLED</code></em> - Turns automatic backups off for the file system.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BackupPolicyProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link BackupPolicyProperty#getStatus}
             * @param status Set the backup policy status for the file system. This parameter is required.
             *               <ul>
             *               <li><em><code>ENABLED</code></em> - Turns automatic backups on for the file system.</li>
             *               <li><em><code>DISABLED</code></em> - Turns automatic backups off for the file system.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BackupPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BackupPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BackupPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPolicyProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.BackupPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BackupPolicyProperty.Jsii$Proxy that = (BackupPolicyProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }
    /**
     * A tag is a key-value pair attached to a file system.
     * <p>
     * Allowed characters in the <code>Key</code> and <code>Value</code> properties are letters, white space, and numbers that can be represented in UTF-8, and the following characters: <code>+ - = . _ : /</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * ElasticFileSystemTagProperty elasticFileSystemTagProperty = ElasticFileSystemTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticFileSystemTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticFileSystemTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key (String).
         * <p>
         * The key can't start with <code>aws:</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the tag key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticFileSystemTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ElasticFileSystemTagProperty#getKey}
             * @param key The tag key (String). This parameter is required.
             *            The key can't start with <code>aws:</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ElasticFileSystemTagProperty#getValue}
             * @param value The value of the tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticFileSystemTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticFileSystemTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticFileSystemTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticFileSystemTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.ElasticFileSystemTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticFileSystemTagProperty.Jsii$Proxy that = (ElasticFileSystemTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes a policy used by EFS lifecycle management and EFS Intelligent-Tiering that specifies when to transition files into and out of the file system's Infrequent Access (IA) storage class.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html">EFS Intelligent‐Tiering and EFS Lifecycle Management</a> .
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>Each <code>LifecyclePolicy</code> object can have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> must be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> .</li>
     * <li>See the AWS::EFS::FileSystem examples for the correct <code>LifecyclePolicy</code> structure. Do not use the syntax shown on this page.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.efs.*;
     * LifecyclePolicyProperty lifecyclePolicyProperty = LifecyclePolicyProperty.builder()
     *         .transitionToIa("transitionToIa")
     *         .transitionToPrimaryStorageClass("transitionToPrimaryStorageClass")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.CfnFileSystem.LifecyclePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(LifecyclePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LifecyclePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the period of time that a file is not accessed, after which it transitions to IA storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitionToIa() {
            return null;
        }

        /**
         * Describes when to transition a file from IA storage to primary storage.
         * <p>
         * Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitionToPrimaryStorageClass() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LifecyclePolicyProperty> {
            java.lang.String transitionToIa;
            java.lang.String transitionToPrimaryStorageClass;

            /**
             * Sets the value of {@link LifecyclePolicyProperty#getTransitionToIa}
             * @param transitionToIa Describes the period of time that a file is not accessed, after which it transitions to IA storage.
             *                       Metadata operations such as listing the contents of a directory don't count as file access events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionToIa(java.lang.String transitionToIa) {
                this.transitionToIa = transitionToIa;
                return this;
            }

            /**
             * Sets the value of {@link LifecyclePolicyProperty#getTransitionToPrimaryStorageClass}
             * @param transitionToPrimaryStorageClass Describes when to transition a file from IA storage to primary storage.
             *                                        Metadata operations such as listing the contents of a directory don't count as file access events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitionToPrimaryStorageClass(java.lang.String transitionToPrimaryStorageClass) {
                this.transitionToPrimaryStorageClass = transitionToPrimaryStorageClass;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LifecyclePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LifecyclePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LifecyclePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecyclePolicyProperty {
            private final java.lang.String transitionToIa;
            private final java.lang.String transitionToPrimaryStorageClass;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transitionToIa = software.amazon.jsii.Kernel.get(this, "transitionToIa", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitionToPrimaryStorageClass = software.amazon.jsii.Kernel.get(this, "transitionToPrimaryStorageClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transitionToIa = builder.transitionToIa;
                this.transitionToPrimaryStorageClass = builder.transitionToPrimaryStorageClass;
            }

            @Override
            public final java.lang.String getTransitionToIa() {
                return this.transitionToIa;
            }

            @Override
            public final java.lang.String getTransitionToPrimaryStorageClass() {
                return this.transitionToPrimaryStorageClass;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTransitionToIa() != null) {
                    data.set("transitionToIa", om.valueToTree(this.getTransitionToIa()));
                }
                if (this.getTransitionToPrimaryStorageClass() != null) {
                    data.set("transitionToPrimaryStorageClass", om.valueToTree(this.getTransitionToPrimaryStorageClass()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.CfnFileSystem.LifecyclePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LifecyclePolicyProperty.Jsii$Proxy that = (LifecyclePolicyProperty.Jsii$Proxy) o;

                if (this.transitionToIa != null ? !this.transitionToIa.equals(that.transitionToIa) : that.transitionToIa != null) return false;
                return this.transitionToPrimaryStorageClass != null ? this.transitionToPrimaryStorageClass.equals(that.transitionToPrimaryStorageClass) : that.transitionToPrimaryStorageClass == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transitionToIa != null ? this.transitionToIa.hashCode() : 0;
                result = 31 * result + (this.transitionToPrimaryStorageClass != null ? this.transitionToPrimaryStorageClass.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.efs.CfnFileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.CfnFileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Used to create a file system that uses One Zone storage classes.
         * <p>
         * It specifies the AWS Availability Zone in which to create the file system. Use the format <code>us-east-1a</code> to specify the Availability Zone. For more information about One Zone storage classes, see <a href="https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html">Using EFS storage classes</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * One Zone storage classes are not available in all Availability Zones in AWS Regions where Amazon EFS is available.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param availabilityZoneName Used to create a file system that uses One Zone storage classes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneName(final java.lang.String availabilityZoneName) {
            this.props().availabilityZoneName(availabilityZoneName);
            return this;
        }

        /**
         * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
         * <p>
         * @return {@code this}
         * @param backupPolicy Use the `BackupPolicy` to turn automatic backups on or off for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(final software.amazon.awscdk.services.efs.CfnFileSystem.BackupPolicyProperty backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }
        /**
         * Use the `BackupPolicy` to turn automatic backups on or off for the file system.
         * <p>
         * @return {@code this}
         * @param backupPolicy Use the `BackupPolicy` to turn automatic backups on or off for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPolicy(final software.amazon.awscdk.IResolvable backupPolicy) {
            this.props().backupPolicy(backupPolicy);
            return this;
        }

        /**
         * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
         * <p>
         * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * <p>
         * @return {@code this}
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final java.lang.Boolean bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }
        /**
         * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check.
         * <p>
         * The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future <code>PutFileSystemPolicy</code> requests on this file system. Set <code>BypassPolicyLockoutSafetyCheck</code> to <code>True</code> only when you intend to prevent the IAM principal that is making the request from making subsequent <code>PutFileSystemPolicy</code> requests on this file system. The default value is <code>False</code> .
         * <p>
         * @return {@code this}
         * @param bypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bypassPolicyLockoutSafetyCheck(final software.amazon.awscdk.IResolvable bypassPolicyLockoutSafetyCheck) {
            this.props().bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
            return this;
        }

        /**
         * A Boolean value that, if true, creates an encrypted file system.
         * <p>
         * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * <p>
         * @return {@code this}
         * @param encrypted A Boolean value that, if true, creates an encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }
        /**
         * A Boolean value that, if true, creates an encrypted file system.
         * <p>
         * When creating an encrypted file system, you have the option of specifying a KmsKeyId for an existing AWS KMS key . If you don't specify a KMS key , then the default KMS key for Amazon EFS , <code>/aws/elasticfilesystem</code> , is used to protect the encrypted file system.
         * <p>
         * @return {@code this}
         * @param encrypted A Boolean value that, if true, creates an encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(final software.amazon.awscdk.IResolvable encrypted) {
            this.props().encrypted(encrypted);
            return this;
        }

        /**
         * The `FileSystemPolicy` for the EFS file system.
         * <p>
         * A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html">Using IAM to control NFS access to Amazon EFS</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @return {@code this}
         * @param fileSystemPolicy The `FileSystemPolicy` for the EFS file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPolicy(final java.lang.Object fileSystemPolicy) {
            this.props().fileSystemPolicy(fileSystemPolicy);
            return this;
        }

        /**
         * Use to create one or more tags associated with the file system.
         * <p>
         * Each tag is a user-defined key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code> key-value pair. Each key must be unique. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> in the <em>AWS General Reference Guide</em> .
         * <p>
         * @return {@code this}
         * @param fileSystemTags Use to create one or more tags associated with the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemTags(final java.util.List<? extends software.amazon.awscdk.services.efs.CfnFileSystem.ElasticFileSystemTagProperty> fileSystemTags) {
            this.props().fileSystemTags(fileSystemTags);
            return this;
        }

        /**
         * The ID of the AWS KMS key to be used to protect the encrypted file system.
         * <p>
         * This parameter is only required if you want to use a nondefault KMS key . If this parameter is not specified, the default KMS key for Amazon EFS is used. This ID can be in one of the following formats:
         * <p>
         * <ul>
         * <li>Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         * <li>ARN - An Amazon Resource Name (ARN) for the key, for example <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> .</li>
         * <li>Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code> .</li>
         * <li>Key alias ARN - An ARN for a key alias, for example <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code> .</li>
         * </ul>
         * <p>
         * If <code>KmsKeyId</code> is specified, the <code>Encrypted</code> parameter must be set to true.
         * <p>
         * @return {@code this}
         * @param kmsKeyId The ID of the AWS KMS key to be used to protect the encrypted file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props().kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
         * <p>
         * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
         * <p>
         * <ul>
         * <li>When to move files in the file system from primary storage to the IA storage class.</li>
         * <li>When to move files that are in IA storage to primary storage.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param lifecyclePolicies An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(final software.amazon.awscdk.IResolvable lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }
        /**
         * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object.
         * <p>
         * A <code>LifecycleConfiguration</code> object informs EFS lifecycle management and intelligent tiering of the following:
         * <p>
         * <ul>
         * <li>When to move files in the file system from primary storage to the IA storage class.</li>
         * <li>When to move files that are in IA storage to primary storage.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Amazon EFS requires that each <code>LifecyclePolicy</code> object have only a single transition. This means that in a request body, <code>LifecyclePolicies</code> needs to be structured as an array of <code>LifecyclePolicy</code> objects, one object for each transition, <code>TransitionToIA</code> , <code>TransitionToPrimaryStorageClass</code> . See the example requests in the following section for more information.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param lifecyclePolicies An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicies(final java.util.List<? extends java.lang.Object> lifecyclePolicies) {
            this.props().lifecyclePolicies(lifecyclePolicies);
            return this;
        }

        /**
         * The performance mode of the file system.
         * <p>
         * We recommend <code>generalPurpose</code> performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
         * <p>
         * <blockquote>
         * <p>
         * The <code>maxIO</code> mode is not supported on file systems using One Zone storage classes.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param performanceMode The performance mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(final java.lang.String performanceMode) {
            this.props().performanceMode(performanceMode);
            return this;
        }

        /**
         * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
         * <p>
         * Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code> . The upper limit for throughput is 1024 MiB/s. To increase this limit, contact AWS Support . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS quotas that you can increase</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * @return {@code this}
         * @param provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputInMibps(final java.lang.Number provisionedThroughputInMibps) {
            this.props().provisionedThroughputInMibps(provisionedThroughputInMibps);
            return this;
        }

        /**
         * Specifies the throughput mode for the file system, either `bursting` or `provisioned` .
         * <p>
         * If you set <code>ThroughputMode</code> to <code>provisioned</code> , you must also set a value for <code>ProvisionedThroughputInMibps</code> . After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying throughput with provisioned mode</a> in the <em>Amazon EFS User Guide</em> .
         * <p>
         * Default is <code>bursting</code> .
         * <p>
         * @return {@code this}
         * @param throughputMode Specifies the throughput mode for the file system, either `bursting` or `provisioned` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(final java.lang.String throughputMode) {
            this.props().throughputMode(throughputMode);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.efs.CfnFileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.efs.CfnFileSystem build() {
            return new software.amazon.awscdk.services.efs.CfnFileSystem(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.efs.CfnFileSystemProps.Builder();
            }
            return this.props;
        }
    }
}
