package software.amazon.awscdk.services.efs;

/**
 * Properties for the AccessPoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * FileSystem fileSystem;
 * AccessPointProps accessPointProps = AccessPointProps.builder()
 *         .fileSystem(fileSystem)
 *         // the properties below are optional
 *         .createAcl(Acl.builder()
 *                 .ownerGid("ownerGid")
 *                 .ownerUid("ownerUid")
 *                 .permissions("permissions")
 *                 .build())
 *         .path("path")
 *         .posixUser(PosixUser.builder()
 *                 .gid("gid")
 *                 .uid("uid")
 *                 // the properties below are optional
 *                 .secondaryGids(List.of("secondaryGids"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.849Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.AccessPointProps")
@software.amazon.jsii.Jsii.Proxy(AccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.efs.AccessPointOptions {

    /**
     * The efs filesystem.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem getFileSystem();

    /**
     * @return a {@link Builder} of {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPointProps> {
        software.amazon.awscdk.services.efs.IFileSystem fileSystem;
        software.amazon.awscdk.services.efs.Acl createAcl;
        java.lang.String path;
        software.amazon.awscdk.services.efs.PosixUser posixUser;

        /**
         * Sets the value of {@link AccessPointProps#getFileSystem}
         * @param fileSystem The efs filesystem. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystem(software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getCreateAcl}
         * @param createAcl Specifies the POSIX IDs and permissions to apply when creating the access point's root directory.
         *                  If the
         *                  root directory specified by <code>path</code> does not exist, EFS creates the root directory and applies the
         *                  permissions specified here. If the specified <code>path</code> does not exist, you must specify <code>createAcl</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createAcl(software.amazon.awscdk.services.efs.Acl createAcl) {
            this.createAcl = createAcl;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getPath}
         * @param path Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AccessPointProps#getPosixUser}
         * @param posixUser The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
         *                  Specify this to enforce a user identity using an access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder posixUser(software.amazon.awscdk.services.efs.PosixUser posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPointProps {
        private final software.amazon.awscdk.services.efs.IFileSystem fileSystem;
        private final software.amazon.awscdk.services.efs.Acl createAcl;
        private final java.lang.String path;
        private final software.amazon.awscdk.services.efs.PosixUser posixUser;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystem = software.amazon.jsii.Kernel.get(this, "fileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
            this.createAcl = software.amazon.jsii.Kernel.get(this, "createAcl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.Acl.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.posixUser = software.amazon.jsii.Kernel.get(this, "posixUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.PosixUser.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystem = java.util.Objects.requireNonNull(builder.fileSystem, "fileSystem is required");
            this.createAcl = builder.createAcl;
            this.path = builder.path;
            this.posixUser = builder.posixUser;
        }

        @Override
        public final software.amazon.awscdk.services.efs.IFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public final software.amazon.awscdk.services.efs.Acl getCreateAcl() {
            return this.createAcl;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final software.amazon.awscdk.services.efs.PosixUser getPosixUser() {
            return this.posixUser;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystem", om.valueToTree(this.getFileSystem()));
            if (this.getCreateAcl() != null) {
                data.set("createAcl", om.valueToTree(this.getCreateAcl()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPosixUser() != null) {
                data.set("posixUser", om.valueToTree(this.getPosixUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.AccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPointProps.Jsii$Proxy that = (AccessPointProps.Jsii$Proxy) o;

            if (!fileSystem.equals(that.fileSystem)) return false;
            if (this.createAcl != null ? !this.createAcl.equals(that.createAcl) : that.createAcl != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            return this.posixUser != null ? this.posixUser.equals(that.posixUser) : that.posixUser == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystem.hashCode();
            result = 31 * result + (this.createAcl != null ? this.createAcl.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.posixUser != null ? this.posixUser.hashCode() : 0);
            return result;
        }
    }
}
