package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux Kernel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc;
 * InstanceType instanceType;
 * // AWS Linux
 * // AWS Linux
 * Instance.Builder.create(this, "Instance1")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(new AmazonLinuxImage())
 *         .build();
 * // AWS Linux 2
 * // AWS Linux 2
 * Instance.Builder.create(this, "Instance2")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .build();
 * // AWS Linux 2 with kernel 5.x
 * // AWS Linux 2 with kernel 5.x
 * Instance.Builder.create(this, "Instance3")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .kernel(AmazonLinuxKernel.KERNEL5_X)
 *                 .build())
 *         .build();
 * // AWS Linux 2022
 * // AWS Linux 2022
 * Instance.Builder.create(this, "Instance4")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2022)
 *                 .build())
 *         .build();
 * // Graviton 3 Processor
 * // Graviton 3 Processor
 * Instance.Builder.create(this, "Instance5")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.C7G, InstanceSize.LARGE))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .cpuType(AmazonLinuxCpuType.ARM_64)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:38.104Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinuxKernel")
public enum AmazonLinuxKernel {
    /**
     * Standard edition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KERNEL5_X,
}
