package software.amazon.awscdk.services.connect;

/**
 * Properties for defining a `CfnInstance`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnInstanceProps cfnInstanceProps = CfnInstanceProps.builder()
 *         .attributes(AttributesProperty.builder()
 *                 .inboundCalls(false)
 *                 .outboundCalls(false)
 *                 // the properties below are optional
 *                 .autoResolveBestVoices(false)
 *                 .contactflowLogs(false)
 *                 .contactLens(false)
 *                 .earlyMedia(false)
 *                 .useCustomTtsVoices(false)
 *                 .build())
 *         .identityManagementType("identityManagementType")
 *         // the properties below are optional
 *         .directoryId("directoryId")
 *         .instanceAlias("instanceAlias")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.768Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::Connect::Instance.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAttributes();

    /**
     * `AWS::Connect::Instance.IdentityManagementType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIdentityManagementType();

    /**
     * `AWS::Connect::Instance.DirectoryId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDirectoryId() {
        return null;
    }

    /**
     * `AWS::Connect::Instance.InstanceAlias`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceAlias() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        java.lang.Object attributes;
        java.lang.String identityManagementType;
        java.lang.String directoryId;
        java.lang.String instanceAlias;

        /**
         * Sets the value of {@link CfnInstanceProps#getAttributes}
         * @param attributes `AWS::Connect::Instance.Attributes`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.services.connect.CfnInstance.AttributesProperty attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAttributes}
         * @param attributes `AWS::Connect::Instance.Attributes`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getIdentityManagementType}
         * @param identityManagementType `AWS::Connect::Instance.IdentityManagementType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityManagementType(java.lang.String identityManagementType) {
            this.identityManagementType = identityManagementType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getDirectoryId}
         * @param directoryId `AWS::Connect::Instance.DirectoryId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryId(java.lang.String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceAlias}
         * @param instanceAlias `AWS::Connect::Instance.InstanceAlias`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAlias(java.lang.String instanceAlias) {
            this.instanceAlias = instanceAlias;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.Object attributes;
        private final java.lang.String identityManagementType;
        private final java.lang.String directoryId;
        private final java.lang.String instanceAlias;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.identityManagementType = software.amazon.jsii.Kernel.get(this, "identityManagementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directoryId = software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceAlias = software.amazon.jsii.Kernel.get(this, "instanceAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributes = java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
            this.identityManagementType = java.util.Objects.requireNonNull(builder.identityManagementType, "identityManagementType is required");
            this.directoryId = builder.directoryId;
            this.instanceAlias = builder.instanceAlias;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.String getIdentityManagementType() {
            return this.identityManagementType;
        }

        @Override
        public final java.lang.String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final java.lang.String getInstanceAlias() {
            return this.instanceAlias;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attributes", om.valueToTree(this.getAttributes()));
            data.set("identityManagementType", om.valueToTree(this.getIdentityManagementType()));
            if (this.getDirectoryId() != null) {
                data.set("directoryId", om.valueToTree(this.getDirectoryId()));
            }
            if (this.getInstanceAlias() != null) {
                data.set("instanceAlias", om.valueToTree(this.getInstanceAlias()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (!attributes.equals(that.attributes)) return false;
            if (!identityManagementType.equals(that.identityManagementType)) return false;
            if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) return false;
            return this.instanceAlias != null ? this.instanceAlias.equals(that.instanceAlias) : that.instanceAlias == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attributes.hashCode();
            result = 31 * result + (this.identityManagementType.hashCode());
            result = 31 * result + (this.directoryId != null ? this.directoryId.hashCode() : 0);
            result = 31 * result + (this.instanceAlias != null ? this.instanceAlias.hashCode() : 0);
            return result;
        }
    }
}
