package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of the CodeBuild action that determines its CodePipeline Category - Build, or Test.
 * <p>
 * The default is Build.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * PipelineProject project;
 * Artifact sourceOutput = new Artifact();
 * CodeBuildAction testAction = CodeBuildAction.Builder.create()
 *         .actionName("IntegrationTest")
 *         .project(project)
 *         .input(sourceOutput)
 *         .type(CodeBuildActionType.TEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.525Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CodeBuildActionType")
public enum CodeBuildActionType {
    /**
     * The action will have the Build Category.
     * <p>
     * This is the default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD,
    /**
     * The action will have the Test Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
}
