package software.amazon.awscdk.services.codebuild;

/**
 * Artifacts definition for a CodeBuild Project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Project project = Project.Builder.create(this, "MyProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         .artifacts(Artifacts.s3(S3ArtifactsProps.builder()
 *                 .bucket(bucket)
 *                 .includeBuildId(false)
 *                 .packageZip(true)
 *                 .path("another/path")
 *                 .identifier("AddArtifact1")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.291Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Artifacts")
public abstract class Artifacts extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IArtifacts {

    protected Artifacts(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Artifacts(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Artifacts(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ArtifactsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IArtifacts s3(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.S3ArtifactsProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Artifacts.class, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IArtifacts.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Callback when an Artifacts class is used in a CodeBuild Project.
     * <p>
     * @param _scope This parameter is required.
     * @param _project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ArtifactsConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject _project) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ArtifactsConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_project, "_project is required") });
    }

    /**
     * The CodeBuild type of this artifact.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The artifact identifier.
     * <p>
     * This property is required on secondary artifacts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.Artifacts implements software.amazon.awscdk.services.codebuild.IArtifacts.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The CodeBuild type of this artifact.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
