package software.amazon.awscdk.services.cloudtrail;

/**
 * Properties for defining a `CfnTrail`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnTrailProps cfnTrailProps = CfnTrailProps.builder()
 *         .isLogging(false)
 *         .s3BucketName("s3BucketName")
 *         // the properties below are optional
 *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *         .enableLogFileValidation(false)
 *         .eventSelectors(List.of(EventSelectorProperty.builder()
 *                 .dataResources(List.of(DataResourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .excludeManagementEventSources(List.of("excludeManagementEventSources"))
 *                 .includeManagementEvents(false)
 *                 .readWriteType("readWriteType")
 *                 .build()))
 *         .includeGlobalServiceEvents(false)
 *         .insightSelectors(List.of(InsightSelectorProperty.builder()
 *                 .insightType("insightType")
 *                 .build()))
 *         .isMultiRegionTrail(false)
 *         .isOrganizationTrail(false)
 *         .kmsKeyId("kmsKeyId")
 *         .s3KeyPrefix("s3KeyPrefix")
 *         .snsTopicName("snsTopicName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trailName("trailName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:37.188Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrailProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrailProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrailProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIsLogging();

    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     * <p>
     * See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
     * <p>
     * Not required unless you specify <code>CloudWatchLogsRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
        return null;
    }

    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
        return null;
    }

    /**
     * Specifies whether log file validation is enabled. The default is false.
     * <p>
     * <blockquote>
     * <p>
     * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableLogFileValidation() {
        return null;
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventSelectors() {
        return null;
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeGlobalServiceEvents() {
        return null;
    }

    /**
     * `AWS::CloudTrail::Trail.InsightSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInsightSelectors() {
        return null;
    }

    /**
     * Specifies whether the trail applies only to the current region or to all regions.
     * <p>
     * The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsMultiRegionTrail() {
        return null;
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     * <p>
     * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsOrganizationTrail() {
        return null;
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
     * <p>
     * The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
     * <p>
     * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * Examples:
     * <p>
     * <ul>
     * <li>alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
     * <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
     * <li>12345678-1234-1234-1234-123456789012</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return null;
    }

    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
     * <p>
     * The maximum length is 256 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicName() {
        return null;
    }

    /**
     * A custom set of tags (key-value pairs) for this trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the name of the trail. The name must meet the following requirements:.
     * <p>
     * <ul>
     * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
     * <li>Start with a letter or number, and end with a letter or number</li>
     * <li>Be between 3 and 128 characters</li>
     * <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
     * <li>Not be in IP address format (for example, 192.168.5.4)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTrailName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrailProps> {
        java.lang.Object isLogging;
        java.lang.String s3BucketName;
        java.lang.String cloudWatchLogsLogGroupArn;
        java.lang.String cloudWatchLogsRoleArn;
        java.lang.Object enableLogFileValidation;
        java.lang.Object eventSelectors;
        java.lang.Object includeGlobalServiceEvents;
        java.lang.Object insightSelectors;
        java.lang.Object isMultiRegionTrail;
        java.lang.Object isOrganizationTrail;
        java.lang.String kmsKeyId;
        java.lang.String s3KeyPrefix;
        java.lang.String snsTopicName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String trailName;

        /**
         * Sets the value of {@link CfnTrailProps#getIsLogging}
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(java.lang.Boolean isLogging) {
            this.isLogging = isLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIsLogging}
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(software.amazon.awscdk.IResolvable isLogging) {
            this.isLogging = isLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getS3BucketName}
         * @param s3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log files. This parameter is required.
         *                     See <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html">Amazon S3 Bucket Naming Requirements</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketName(java.lang.String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getCloudWatchLogsLogGroupArn}
         * @param cloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
         *                                  Not required unless you specify <code>CloudWatchLogsRoleArn</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsLogGroupArn(java.lang.String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getCloudWatchLogsRoleArn}
         * @param cloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRoleArn(java.lang.String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getEnableLogFileValidation}
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false.
         *                                <blockquote>
         *                                <p>
         *                                When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(java.lang.Boolean enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getEnableLogFileValidation}
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false.
         *                                <blockquote>
         *                                <p>
         *                                When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         *                                <p>
         *                                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(software.amazon.awscdk.IResolvable enableLogFileValidation) {
            this.enableLogFileValidation = enableLogFileValidation;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getEventSelectors}
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail.
         *                       By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         *                       <p>
         *                       You can configure up to five event selectors for a trail.
         *                       <p>
         *                       You cannot apply both event selectors and advanced event selectors to a trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(software.amazon.awscdk.IResolvable eventSelectors) {
            this.eventSelectors = eventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getEventSelectors}
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail.
         *                       By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         *                       <p>
         *                       You can configure up to five event selectors for a trail.
         *                       <p>
         *                       You cannot apply both event selectors and advanced event selectors to a trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(java.util.List<? extends java.lang.Object> eventSelectors) {
            this.eventSelectors = eventSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIncludeGlobalServiceEvents}
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(java.lang.Boolean includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIncludeGlobalServiceEvents}
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(software.amazon.awscdk.IResolvable includeGlobalServiceEvents) {
            this.includeGlobalServiceEvents = includeGlobalServiceEvents;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getInsightSelectors}
         * @param insightSelectors `AWS::CloudTrail::Trail.InsightSelectors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(software.amazon.awscdk.IResolvable insightSelectors) {
            this.insightSelectors = insightSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getInsightSelectors}
         * @param insightSelectors `AWS::CloudTrail::Trail.InsightSelectors`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(java.util.List<? extends java.lang.Object> insightSelectors) {
            this.insightSelectors = insightSelectors;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIsMultiRegionTrail}
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current region or to all regions.
         *                           The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(java.lang.Boolean isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIsMultiRegionTrail}
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current region or to all regions.
         *                           The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(software.amazon.awscdk.IResolvable isMultiRegionTrail) {
            this.isMultiRegionTrail = isMultiRegionTrail;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIsOrganizationTrail}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         *                            The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(java.lang.Boolean isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getIsOrganizationTrail}
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         *                            The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(software.amazon.awscdk.IResolvable isOrganizationTrail) {
            this.isOrganizationTrail = isOrganizationTrail;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getKmsKeyId}
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
         *                 The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         *                 <p>
         *                 CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                 <p>
         *                 Examples:
         *                 <p>
         *                 <ul>
         *                 <li>alias/MyAliasName</li>
         *                 <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
         *                 <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
         *                 <li>12345678-1234-1234-1234-123456789012</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getS3KeyPrefix}
         * @param s3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
         *                    For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(java.lang.String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getSnsTopicName}
         * @param snsTopicName Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
         *                     The maximum length is 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicName(java.lang.String snsTopicName) {
            this.snsTopicName = snsTopicName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getTags}
         * @param tags A custom set of tags (key-value pairs) for this trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrailProps#getTrailName}
         * @param trailName Specifies the name of the trail. The name must meet the following requirements:.
         *                  <ul>
         *                  <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
         *                  <li>Start with a letter or number, and end with a letter or number</li>
         *                  <li>Be between 3 and 128 characters</li>
         *                  <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
         *                  <li>Not be in IP address format (for example, 192.168.5.4)</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trailName(java.lang.String trailName) {
            this.trailName = trailName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrailProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrailProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrailProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrailProps {
        private final java.lang.Object isLogging;
        private final java.lang.String s3BucketName;
        private final java.lang.String cloudWatchLogsLogGroupArn;
        private final java.lang.String cloudWatchLogsRoleArn;
        private final java.lang.Object enableLogFileValidation;
        private final java.lang.Object eventSelectors;
        private final java.lang.Object includeGlobalServiceEvents;
        private final java.lang.Object insightSelectors;
        private final java.lang.Object isMultiRegionTrail;
        private final java.lang.Object isOrganizationTrail;
        private final java.lang.String kmsKeyId;
        private final java.lang.String s3KeyPrefix;
        private final java.lang.String snsTopicName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String trailName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.isLogging = software.amazon.jsii.Kernel.get(this, "isLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchLogsRoleArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableLogFileValidation = software.amazon.jsii.Kernel.get(this, "enableLogFileValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventSelectors = software.amazon.jsii.Kernel.get(this, "eventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includeGlobalServiceEvents = software.amazon.jsii.Kernel.get(this, "includeGlobalServiceEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.insightSelectors = software.amazon.jsii.Kernel.get(this, "insightSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isMultiRegionTrail = software.amazon.jsii.Kernel.get(this, "isMultiRegionTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isOrganizationTrail = software.amazon.jsii.Kernel.get(this, "isOrganizationTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3KeyPrefix = software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snsTopicName = software.amazon.jsii.Kernel.get(this, "snsTopicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.trailName = software.amazon.jsii.Kernel.get(this, "trailName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.isLogging = java.util.Objects.requireNonNull(builder.isLogging, "isLogging is required");
            this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
            this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
            this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
            this.enableLogFileValidation = builder.enableLogFileValidation;
            this.eventSelectors = builder.eventSelectors;
            this.includeGlobalServiceEvents = builder.includeGlobalServiceEvents;
            this.insightSelectors = builder.insightSelectors;
            this.isMultiRegionTrail = builder.isMultiRegionTrail;
            this.isOrganizationTrail = builder.isOrganizationTrail;
            this.kmsKeyId = builder.kmsKeyId;
            this.s3KeyPrefix = builder.s3KeyPrefix;
            this.snsTopicName = builder.snsTopicName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.trailName = builder.trailName;
        }

        @Override
        public final java.lang.Object getIsLogging() {
            return this.isLogging;
        }

        @Override
        public final java.lang.String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final java.lang.String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        @Override
        public final java.lang.String getCloudWatchLogsRoleArn() {
            return this.cloudWatchLogsRoleArn;
        }

        @Override
        public final java.lang.Object getEnableLogFileValidation() {
            return this.enableLogFileValidation;
        }

        @Override
        public final java.lang.Object getEventSelectors() {
            return this.eventSelectors;
        }

        @Override
        public final java.lang.Object getIncludeGlobalServiceEvents() {
            return this.includeGlobalServiceEvents;
        }

        @Override
        public final java.lang.Object getInsightSelectors() {
            return this.insightSelectors;
        }

        @Override
        public final java.lang.Object getIsMultiRegionTrail() {
            return this.isMultiRegionTrail;
        }

        @Override
        public final java.lang.Object getIsOrganizationTrail() {
            return this.isOrganizationTrail;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final java.lang.String getSnsTopicName() {
            return this.snsTopicName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTrailName() {
            return this.trailName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("isLogging", om.valueToTree(this.getIsLogging()));
            data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
            if (this.getCloudWatchLogsLogGroupArn() != null) {
                data.set("cloudWatchLogsLogGroupArn", om.valueToTree(this.getCloudWatchLogsLogGroupArn()));
            }
            if (this.getCloudWatchLogsRoleArn() != null) {
                data.set("cloudWatchLogsRoleArn", om.valueToTree(this.getCloudWatchLogsRoleArn()));
            }
            if (this.getEnableLogFileValidation() != null) {
                data.set("enableLogFileValidation", om.valueToTree(this.getEnableLogFileValidation()));
            }
            if (this.getEventSelectors() != null) {
                data.set("eventSelectors", om.valueToTree(this.getEventSelectors()));
            }
            if (this.getIncludeGlobalServiceEvents() != null) {
                data.set("includeGlobalServiceEvents", om.valueToTree(this.getIncludeGlobalServiceEvents()));
            }
            if (this.getInsightSelectors() != null) {
                data.set("insightSelectors", om.valueToTree(this.getInsightSelectors()));
            }
            if (this.getIsMultiRegionTrail() != null) {
                data.set("isMultiRegionTrail", om.valueToTree(this.getIsMultiRegionTrail()));
            }
            if (this.getIsOrganizationTrail() != null) {
                data.set("isOrganizationTrail", om.valueToTree(this.getIsOrganizationTrail()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getS3KeyPrefix() != null) {
                data.set("s3KeyPrefix", om.valueToTree(this.getS3KeyPrefix()));
            }
            if (this.getSnsTopicName() != null) {
                data.set("snsTopicName", om.valueToTree(this.getSnsTopicName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTrailName() != null) {
                data.set("trailName", om.valueToTree(this.getTrailName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrailProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrailProps.Jsii$Proxy that = (CfnTrailProps.Jsii$Proxy) o;

            if (!isLogging.equals(that.isLogging)) return false;
            if (!s3BucketName.equals(that.s3BucketName)) return false;
            if (this.cloudWatchLogsLogGroupArn != null ? !this.cloudWatchLogsLogGroupArn.equals(that.cloudWatchLogsLogGroupArn) : that.cloudWatchLogsLogGroupArn != null) return false;
            if (this.cloudWatchLogsRoleArn != null ? !this.cloudWatchLogsRoleArn.equals(that.cloudWatchLogsRoleArn) : that.cloudWatchLogsRoleArn != null) return false;
            if (this.enableLogFileValidation != null ? !this.enableLogFileValidation.equals(that.enableLogFileValidation) : that.enableLogFileValidation != null) return false;
            if (this.eventSelectors != null ? !this.eventSelectors.equals(that.eventSelectors) : that.eventSelectors != null) return false;
            if (this.includeGlobalServiceEvents != null ? !this.includeGlobalServiceEvents.equals(that.includeGlobalServiceEvents) : that.includeGlobalServiceEvents != null) return false;
            if (this.insightSelectors != null ? !this.insightSelectors.equals(that.insightSelectors) : that.insightSelectors != null) return false;
            if (this.isMultiRegionTrail != null ? !this.isMultiRegionTrail.equals(that.isMultiRegionTrail) : that.isMultiRegionTrail != null) return false;
            if (this.isOrganizationTrail != null ? !this.isOrganizationTrail.equals(that.isOrganizationTrail) : that.isOrganizationTrail != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.s3KeyPrefix != null ? !this.s3KeyPrefix.equals(that.s3KeyPrefix) : that.s3KeyPrefix != null) return false;
            if (this.snsTopicName != null ? !this.snsTopicName.equals(that.snsTopicName) : that.snsTopicName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.trailName != null ? this.trailName.equals(that.trailName) : that.trailName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.isLogging.hashCode();
            result = 31 * result + (this.s3BucketName.hashCode());
            result = 31 * result + (this.cloudWatchLogsLogGroupArn != null ? this.cloudWatchLogsLogGroupArn.hashCode() : 0);
            result = 31 * result + (this.cloudWatchLogsRoleArn != null ? this.cloudWatchLogsRoleArn.hashCode() : 0);
            result = 31 * result + (this.enableLogFileValidation != null ? this.enableLogFileValidation.hashCode() : 0);
            result = 31 * result + (this.eventSelectors != null ? this.eventSelectors.hashCode() : 0);
            result = 31 * result + (this.includeGlobalServiceEvents != null ? this.includeGlobalServiceEvents.hashCode() : 0);
            result = 31 * result + (this.insightSelectors != null ? this.insightSelectors.hashCode() : 0);
            result = 31 * result + (this.isMultiRegionTrail != null ? this.isMultiRegionTrail.hashCode() : 0);
            result = 31 * result + (this.isOrganizationTrail != null ? this.isOrganizationTrail.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.s3KeyPrefix != null ? this.s3KeyPrefix.hashCode() : 0);
            result = 31 * result + (this.snsTopicName != null ? this.snsTopicName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.trailName != null ? this.trailName.hashCode() : 0);
            return result;
        }
    }
}
