package software.amazon.awscdk.services.cloud9;

/**
 * Properties for defining a `CfnEnvironmentEC2`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloud9.*;
 * CfnEnvironmentEC2Props cfnEnvironmentEC2Props = CfnEnvironmentEC2Props.builder()
 *         .instanceType("instanceType")
 *         // the properties below are optional
 *         .automaticStopTimeMinutes(123)
 *         .connectionType("connectionType")
 *         .description("description")
 *         .imageId("imageId")
 *         .name("name")
 *         .ownerArn("ownerArn")
 *         .repositories(List.of(RepositoryProperty.builder()
 *                 .pathComponent("pathComponent")
 *                 .repositoryUrl("repositoryUrl")
 *                 .build()))
 *         .subnetId("subnetId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.991Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloud9.CfnEnvironmentEC2Props")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentEC2Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentEC2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of instance to connect to the environment (for example, `t2.micro` ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * The number of minutes until the running instance is shut down after the environment was last used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAutomaticStopTimeMinutes() {
        return null;
    }

    /**
     * The connection type used for connecting to an Amazon EC2 environment.
     * <p>
     * Valid values are <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
        return null;
    }

    /**
     * The description of the environment to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
     * <p>
     * To choose an AMI for the instance, you must specify a valid AMI alias or a valid AWS Systems Manager path.
     * <p>
     * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
     * <p>
     * <em>AMI aliases</em>
     * <p>
     * <ul>
     * <li><em>Amazon Linux (default): <code>amazonlinux-1-x86_64</code></em></li>
     * <li>Amazon Linux 2: <code>amazonlinux-2-x86_64</code></li>
     * <li>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code></li>
     * </ul>
     * <p>
     * <em>SSM paths</em>
     * <p>
     * <ul>
     * <li><em>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code></em></li>
     * <li>Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code></li>
     * <li>Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
        return null;
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the environment owner.
     * <p>
     * This ARN can be the ARN of any AWS Identity and Access Management principal. If this value is not specified, the ARN defaults to this environment's creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwnerArn() {
        return null;
    }

    /**
     * Any AWS CodeCommit source code repositories to be cloned into the development environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRepositories() {
        return null;
    }

    /**
     * The ID of the subnet in Amazon Virtual Private Cloud (Amazon VPC) that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentEC2Props> {
        java.lang.String instanceType;
        java.lang.Number automaticStopTimeMinutes;
        java.lang.String connectionType;
        java.lang.String description;
        java.lang.String imageId;
        java.lang.String name;
        java.lang.String ownerArn;
        java.lang.Object repositories;
        java.lang.String subnetId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getInstanceType}
         * @param instanceType The type of instance to connect to the environment (for example, `t2.micro` ). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getAutomaticStopTimeMinutes}
         * @param automaticStopTimeMinutes The number of minutes until the running instance is shut down after the environment was last used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticStopTimeMinutes(java.lang.Number automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getConnectionType}
         * @param connectionType The connection type used for connecting to an Amazon EC2 environment.
         *                       Valid values are <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(java.lang.String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getDescription}
         * @param description The description of the environment to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getImageId}
         * @param imageId The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance.
         *                To choose an AMI for the instance, you must specify a valid AMI alias or a valid AWS Systems Manager path.
         *                <p>
         *                The default AMI is used if the parameter isn't explicitly assigned a value in the request.
         *                <p>
         *                <em>AMI aliases</em>
         *                <p>
         *                <ul>
         *                <li><em>Amazon Linux (default): <code>amazonlinux-1-x86_64</code></em></li>
         *                <li>Amazon Linux 2: <code>amazonlinux-2-x86_64</code></li>
         *                <li>Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code></li>
         *                </ul>
         *                <p>
         *                <em>SSM paths</em>
         *                <p>
         *                <ul>
         *                <li><em>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code></em></li>
         *                <li>Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code></li>
         *                <li>Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code></li>
         *                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getName}
         * @param name The name of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getOwnerArn}
         * @param ownerArn The Amazon Resource Name (ARN) of the environment owner.
         *                 This ARN can be the ARN of any AWS Identity and Access Management principal. If this value is not specified, the ARN defaults to this environment's creator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerArn(java.lang.String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getRepositories}
         * @param repositories Any AWS CodeCommit source code repositories to be cloned into the development environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositories(software.amazon.awscdk.IResolvable repositories) {
            this.repositories = repositories;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getRepositories}
         * @param repositories Any AWS CodeCommit source code repositories to be cloned into the development environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositories(java.util.List<? extends java.lang.Object> repositories) {
            this.repositories = repositories;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getSubnetId}
         * @param subnetId The ID of the subnet in Amazon Virtual Private Cloud (Amazon VPC) that AWS Cloud9 will use to communicate with the Amazon Elastic Compute Cloud (Amazon EC2) instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentEC2Props#getTags}
         * @param tags An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentEC2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentEC2Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentEC2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentEC2Props {
        private final java.lang.String instanceType;
        private final java.lang.Number automaticStopTimeMinutes;
        private final java.lang.String connectionType;
        private final java.lang.String description;
        private final java.lang.String imageId;
        private final java.lang.String name;
        private final java.lang.String ownerArn;
        private final java.lang.Object repositories;
        private final java.lang.String subnetId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automaticStopTimeMinutes = software.amazon.jsii.Kernel.get(this, "automaticStopTimeMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ownerArn = software.amazon.jsii.Kernel.get(this, "ownerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositories = software.amazon.jsii.Kernel.get(this, "repositories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
            this.connectionType = builder.connectionType;
            this.description = builder.description;
            this.imageId = builder.imageId;
            this.name = builder.name;
            this.ownerArn = builder.ownerArn;
            this.repositories = builder.repositories;
            this.subnetId = builder.subnetId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Number getAutomaticStopTimeMinutes() {
            return this.automaticStopTimeMinutes;
        }

        @Override
        public final java.lang.String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOwnerArn() {
            return this.ownerArn;
        }

        @Override
        public final java.lang.Object getRepositories() {
            return this.repositories;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAutomaticStopTimeMinutes() != null) {
                data.set("automaticStopTimeMinutes", om.valueToTree(this.getAutomaticStopTimeMinutes()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getImageId() != null) {
                data.set("imageId", om.valueToTree(this.getImageId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOwnerArn() != null) {
                data.set("ownerArn", om.valueToTree(this.getOwnerArn()));
            }
            if (this.getRepositories() != null) {
                data.set("repositories", om.valueToTree(this.getRepositories()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloud9.CfnEnvironmentEC2Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentEC2Props.Jsii$Proxy that = (CfnEnvironmentEC2Props.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.automaticStopTimeMinutes != null ? !this.automaticStopTimeMinutes.equals(that.automaticStopTimeMinutes) : that.automaticStopTimeMinutes != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.ownerArn != null ? !this.ownerArn.equals(that.ownerArn) : that.ownerArn != null) return false;
            if (this.repositories != null ? !this.repositories.equals(that.repositories) : that.repositories != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.automaticStopTimeMinutes != null ? this.automaticStopTimeMinutes.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.ownerArn != null ? this.ownerArn.hashCode() : 0);
            result = 31 * result + (this.repositories != null ? this.repositories.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
