package software.amazon.awscdk.services.chatbot;

/**
 * Properties for defining a `CfnSlackChannelConfiguration`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.chatbot.*;
 * CfnSlackChannelConfigurationProps cfnSlackChannelConfigurationProps = CfnSlackChannelConfigurationProps.builder()
 *         .configurationName("configurationName")
 *         .iamRoleArn("iamRoleArn")
 *         .slackChannelId("slackChannelId")
 *         .slackWorkspaceId("slackWorkspaceId")
 *         // the properties below are optional
 *         .guardrailPolicies(List.of("guardrailPolicies"))
 *         .loggingLevel("loggingLevel")
 *         .snsTopicArns(List.of("snsTopicArns"))
 *         .userRoleRequired(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.984Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_chatbot.CfnSlackChannelConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSlackChannelConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSlackChannelConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConfigurationName();

    /**
     * The ARN of the IAM role that defines the permissions for AWS Chatbot .
     * <p>
     * This is a user-definworked role that AWS Chatbot will assume. This is not the service-linked role. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM Policies for AWS Chatbot</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

    /**
     * The ID of the Slack channel.
     * <p>
     * To get the ID, open Slack, right click on the channel name in the left pane, then choose Copy Link. The channel ID is the 9-character string at the end of the URL. For example, <code>ABCBBLZZZ</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSlackChannelId();

    /**
     * The ID of the Slack workspace authorized with AWS Chatbot .
     * <p>
     * To get the workspace ID, you must perform the initial authorization flow with Slack in the AWS Chatbot console. Then you can copy and paste the workspace ID from the console. For more details, see steps 1-4 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro">Setting Up AWS Chatbot with Slack</a> in the <em>AWS Chatbot User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSlackWorkspaceId();

    /**
     * The list of IAM policy ARNs that are applied as channel guardrails.
     * <p>
     * The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGuardrailPolicies() {
        return null;
    }

    /**
     * Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon CloudWatch Logs.
     * <p>
     * Logging levels include <code>ERROR</code> , <code>INFO</code> , or <code>NONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
        return null;
    }

    /**
     * The ARNs of the SNS topics that deliver notifications to AWS Chatbot .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnsTopicArns() {
        return null;
    }

    /**
     * Enables use of a user role requirement in your chat configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserRoleRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSlackChannelConfigurationProps> {
        java.lang.String configurationName;
        java.lang.String iamRoleArn;
        java.lang.String slackChannelId;
        java.lang.String slackWorkspaceId;
        java.util.List<java.lang.String> guardrailPolicies;
        java.lang.String loggingLevel;
        java.util.List<java.lang.String> snsTopicArns;
        java.lang.Object userRoleRequired;

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getConfigurationName}
         * @param configurationName The name of the configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationName(java.lang.String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getIamRoleArn}
         * @param iamRoleArn The ARN of the IAM role that defines the permissions for AWS Chatbot . This parameter is required.
         *                   This is a user-definworked role that AWS Chatbot will assume. This is not the service-linked role. For more information, see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html">IAM Policies for AWS Chatbot</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoleArn(java.lang.String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getSlackChannelId}
         * @param slackChannelId The ID of the Slack channel. This parameter is required.
         *                       To get the ID, open Slack, right click on the channel name in the left pane, then choose Copy Link. The channel ID is the 9-character string at the end of the URL. For example, <code>ABCBBLZZZ</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackChannelId(java.lang.String slackChannelId) {
            this.slackChannelId = slackChannelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getSlackWorkspaceId}
         * @param slackWorkspaceId The ID of the Slack workspace authorized with AWS Chatbot . This parameter is required.
         *                         To get the workspace ID, you must perform the initial authorization flow with Slack in the AWS Chatbot console. Then you can copy and paste the workspace ID from the console. For more details, see steps 1-4 in <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro">Setting Up AWS Chatbot with Slack</a> in the <em>AWS Chatbot User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackWorkspaceId(java.lang.String slackWorkspaceId) {
            this.slackWorkspaceId = slackWorkspaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getGuardrailPolicies}
         * @param guardrailPolicies The list of IAM policy ARNs that are applied as channel guardrails.
         *                          The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailPolicies(java.util.List<java.lang.String> guardrailPolicies) {
            this.guardrailPolicies = guardrailPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this configuration. This property affects the log entries pushed to Amazon CloudWatch Logs.
         *                     Logging levels include <code>ERROR</code> , <code>INFO</code> , or <code>NONE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(java.lang.String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getSnsTopicArns}
         * @param snsTopicArns The ARNs of the SNS topics that deliver notifications to AWS Chatbot .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArns(java.util.List<java.lang.String> snsTopicArns) {
            this.snsTopicArns = snsTopicArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getUserRoleRequired}
         * @param userRoleRequired Enables use of a user role requirement in your chat configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleRequired(java.lang.Boolean userRoleRequired) {
            this.userRoleRequired = userRoleRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getUserRoleRequired}
         * @param userRoleRequired Enables use of a user role requirement in your chat configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleRequired(software.amazon.awscdk.IResolvable userRoleRequired) {
            this.userRoleRequired = userRoleRequired;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSlackChannelConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSlackChannelConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSlackChannelConfigurationProps {
        private final java.lang.String configurationName;
        private final java.lang.String iamRoleArn;
        private final java.lang.String slackChannelId;
        private final java.lang.String slackWorkspaceId;
        private final java.util.List<java.lang.String> guardrailPolicies;
        private final java.lang.String loggingLevel;
        private final java.util.List<java.lang.String> snsTopicArns;
        private final java.lang.Object userRoleRequired;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationName = software.amazon.jsii.Kernel.get(this, "configurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slackChannelId = software.amazon.jsii.Kernel.get(this, "slackChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slackWorkspaceId = software.amazon.jsii.Kernel.get(this, "slackWorkspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.guardrailPolicies = software.amazon.jsii.Kernel.get(this, "guardrailPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.snsTopicArns = software.amazon.jsii.Kernel.get(this, "snsTopicArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userRoleRequired = software.amazon.jsii.Kernel.get(this, "userRoleRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationName = java.util.Objects.requireNonNull(builder.configurationName, "configurationName is required");
            this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            this.slackChannelId = java.util.Objects.requireNonNull(builder.slackChannelId, "slackChannelId is required");
            this.slackWorkspaceId = java.util.Objects.requireNonNull(builder.slackWorkspaceId, "slackWorkspaceId is required");
            this.guardrailPolicies = builder.guardrailPolicies;
            this.loggingLevel = builder.loggingLevel;
            this.snsTopicArns = builder.snsTopicArns;
            this.userRoleRequired = builder.userRoleRequired;
        }

        @Override
        public final java.lang.String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final java.lang.String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final java.lang.String getSlackChannelId() {
            return this.slackChannelId;
        }

        @Override
        public final java.lang.String getSlackWorkspaceId() {
            return this.slackWorkspaceId;
        }

        @Override
        public final java.util.List<java.lang.String> getGuardrailPolicies() {
            return this.guardrailPolicies;
        }

        @Override
        public final java.lang.String getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final java.util.List<java.lang.String> getSnsTopicArns() {
            return this.snsTopicArns;
        }

        @Override
        public final java.lang.Object getUserRoleRequired() {
            return this.userRoleRequired;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configurationName", om.valueToTree(this.getConfigurationName()));
            data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
            data.set("slackChannelId", om.valueToTree(this.getSlackChannelId()));
            data.set("slackWorkspaceId", om.valueToTree(this.getSlackWorkspaceId()));
            if (this.getGuardrailPolicies() != null) {
                data.set("guardrailPolicies", om.valueToTree(this.getGuardrailPolicies()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getSnsTopicArns() != null) {
                data.set("snsTopicArns", om.valueToTree(this.getSnsTopicArns()));
            }
            if (this.getUserRoleRequired() != null) {
                data.set("userRoleRequired", om.valueToTree(this.getUserRoleRequired()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_chatbot.CfnSlackChannelConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSlackChannelConfigurationProps.Jsii$Proxy that = (CfnSlackChannelConfigurationProps.Jsii$Proxy) o;

            if (!configurationName.equals(that.configurationName)) return false;
            if (!iamRoleArn.equals(that.iamRoleArn)) return false;
            if (!slackChannelId.equals(that.slackChannelId)) return false;
            if (!slackWorkspaceId.equals(that.slackWorkspaceId)) return false;
            if (this.guardrailPolicies != null ? !this.guardrailPolicies.equals(that.guardrailPolicies) : that.guardrailPolicies != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.snsTopicArns != null ? !this.snsTopicArns.equals(that.snsTopicArns) : that.snsTopicArns != null) return false;
            return this.userRoleRequired != null ? this.userRoleRequired.equals(that.userRoleRequired) : that.userRoleRequired == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationName.hashCode();
            result = 31 * result + (this.iamRoleArn.hashCode());
            result = 31 * result + (this.slackChannelId.hashCode());
            result = 31 * result + (this.slackWorkspaceId.hashCode());
            result = 31 * result + (this.guardrailPolicies != null ? this.guardrailPolicies.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.snsTopicArns != null ? this.snsTopicArns.hashCode() : 0);
            result = 31 * result + (this.userRoleRequired != null ? this.userRoleRequired.hashCode() : 0);
            return result;
        }
    }
}
