package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for defining a `CfnScheduledAction`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnScheduledActionProps cfnScheduledActionProps = CfnScheduledActionProps.builder()
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .desiredCapacity(123)
 *         .endTime("endTime")
 *         .maxSize(123)
 *         .minSize(123)
 *         .recurrence("recurrence")
 *         .startTime("startTime")
 *         .timeZone("timeZone")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.794Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScheduledActionProps")
@software.amazon.jsii.Jsii.Proxy(CfnScheduledActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScheduledActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName();

    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
     * <p>
     * It can scale beyond this capacity if you add more scaling conditions.
     * <p>
     * <blockquote>
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return null;
    }

    /**
     * The date and time for the recurring schedule to end, in UTC.
     * <p>
     * For example, <code>"2021-06-01T00:00:00Z"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndTime() {
        return null;
    }

    /**
     * The maximum size of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSize() {
        return null;
    }

    /**
     * The minimum size of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return null;
    }

    /**
     * The recurring schedule for this action.
     * <p>
     * This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code> ). For more information about this format, see <a href="https://docs.aws.amazon.com/http://crontab.org">Crontab</a> .
     * <p>
     * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code> , they form the boundaries of when the recurring action starts and stops.
     * <p>
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecurrence() {
        return null;
    }

    /**
     * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2021-06-01T00:00:00Z"` ).
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code> , Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return null;
    }

    /**
     * Specifies the time zone for a cron expression.
     * <p>
     * If a time zone is not provided, UTC is used by default.
     * <p>
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code> ). For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScheduledActionProps> {
        java.lang.String autoScalingGroupName;
        java.lang.Number desiredCapacity;
        java.lang.String endTime;
        java.lang.Number maxSize;
        java.lang.Number minSize;
        java.lang.String recurrence;
        java.lang.String startTime;
        java.lang.String timeZone;

        /**
         * Sets the value of {@link CfnScheduledActionProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getDesiredCapacity}
         * @param desiredCapacity The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
         *                        It can scale beyond this capacity if you add more scaling conditions.
         *                        <p>
         *                        <blockquote>
         *                        <p>
         *                        You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getEndTime}
         * @param endTime The date and time for the recurring schedule to end, in UTC.
         *                For example, <code>"2021-06-01T00:00:00Z"</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(java.lang.String endTime) {
            this.endTime = endTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getMaxSize}
         * @param maxSize The maximum size of the Auto Scaling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getMinSize}
         * @param minSize The minimum size of the Auto Scaling group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getRecurrence}
         * @param recurrence The recurring schedule for this action.
         *                   This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code> ). For more information about this format, see <a href="https://docs.aws.amazon.com/http://crontab.org">Crontab</a> .
         *                   <p>
         *                   When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code> , they form the boundaries of when the recurring action starts and stops.
         *                   <p>
         *                   Cron expressions use Universal Coordinated Time (UTC) by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(java.lang.String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getStartTime}
         * @param startTime The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, `"2021-06-01T00:00:00Z"` ).
         *                  If you specify <code>Recurrence</code> and <code>StartTime</code> , Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(java.lang.String startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledActionProps#getTimeZone}
         * @param timeZone Specifies the time zone for a cron expression.
         *                 If a time zone is not provided, UTC is used by default.
         *                 <p>
         *                 Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code> ). For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(java.lang.String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScheduledActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScheduledActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScheduledActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScheduledActionProps {
        private final java.lang.String autoScalingGroupName;
        private final java.lang.Number desiredCapacity;
        private final java.lang.String endTime;
        private final java.lang.Number maxSize;
        private final java.lang.Number minSize;
        private final java.lang.String recurrence;
        private final java.lang.String startTime;
        private final java.lang.String timeZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.recurrence = software.amazon.jsii.Kernel.get(this, "recurrence", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroupName = java.util.Objects.requireNonNull(builder.autoScalingGroupName, "autoScalingGroupName is required");
            this.desiredCapacity = builder.desiredCapacity;
            this.endTime = builder.endTime;
            this.maxSize = builder.maxSize;
            this.minSize = builder.minSize;
            this.recurrence = builder.recurrence;
            this.startTime = builder.startTime;
            this.timeZone = builder.timeZone;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.lang.String getEndTime() {
            return this.endTime;
        }

        @Override
        public final java.lang.Number getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.lang.String getRecurrence() {
            return this.recurrence;
        }

        @Override
        public final java.lang.String getStartTime() {
            return this.startTime;
        }

        @Override
        public final java.lang.String getTimeZone() {
            return this.timeZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getEndTime() != null) {
                data.set("endTime", om.valueToTree(this.getEndTime()));
            }
            if (this.getMaxSize() != null) {
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getRecurrence() != null) {
                data.set("recurrence", om.valueToTree(this.getRecurrence()));
            }
            if (this.getStartTime() != null) {
                data.set("startTime", om.valueToTree(this.getStartTime()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScheduledActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScheduledActionProps.Jsii$Proxy that = (CfnScheduledActionProps.Jsii$Proxy) o;

            if (!autoScalingGroupName.equals(that.autoScalingGroupName)) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
            if (this.maxSize != null ? !this.maxSize.equals(that.maxSize) : that.maxSize != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            if (this.recurrence != null ? !this.recurrence.equals(that.recurrence) : that.recurrence != null) return false;
            if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) return false;
            return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroupName.hashCode();
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
            result = 31 * result + (this.maxSize != null ? this.maxSize.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.recurrence != null ? this.recurrence.hashCode() : 0);
            result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            return result;
        }
    }
}
