package software.amazon.awscdk.services.apprunner;

/**
 * A CloudFormation `AWS::AppRunner::VpcConnector`.
 * <p>
 * Specify an AWS App Runner VPC connector by using the <code>AWS::AppRunner::VpcConnector</code> resource in an AWS CloudFormation template.
 * <p>
 * The <code>AWS::AppRunner::VpcConnector</code> resource is an AWS App Runner resource type that specifies an App Runner VPC connector.
 * <p>
 * App Runner requires this resource when you want to associate your App Runner service to a custom Amazon Virtual Private Cloud ( Amazon VPC ).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apprunner.*;
 * CfnVpcConnector cfnVpcConnector = CfnVpcConnector.Builder.create(this, "MyCfnVpcConnector")
 *         .subnets(List.of("subnets"))
 *         // the properties below are optional
 *         .securityGroups(List.of("securityGroups"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConnectorName("vpcConnectorName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.615Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apprunner.CfnVpcConnector")
public class CfnVpcConnector extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnVpcConnector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVpcConnector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apprunner.CfnVpcConnector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppRunner::VpcConnector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVpcConnector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apprunner.CfnVpcConnectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of this VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcConnectorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcConnectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The revision of this VPC connector.
     * <p>
     * It's unique among all the active connectors ( <code>"Status": "ACTIVE"</code> ) that share the same <code>Name</code> .
     * <p>
     * <blockquote>
     * <p>
     * At this time, App Runner supports only one revision per name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrVpcConnectorRevision() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcConnectorRevision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of metadata items that you can associate with your VPC connector resource.
     * <p>
     * A tag is a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
     * <p>
     * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     * <p>
     * <blockquote>
     * <p>
     * App Runner currently only provides support for IPv4.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
     * <p>
     * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     * <p>
     * <blockquote>
     * <p>
     * App Runner currently only provides support for IPv4.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnets(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnets", java.util.Objects.requireNonNull(value, "subnets is required"));
    }

    /**
     * A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets.
     * <p>
     * If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets.
     * <p>
     * If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroups", value);
    }

    /**
     * A name for the VPC connector.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a name for your VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcConnectorName() {
        return software.amazon.jsii.Kernel.get(this, "vpcConnectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the VPC connector.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a name for your VPC connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConnectorName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcConnectorName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apprunner.CfnVpcConnector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apprunner.CfnVpcConnector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apprunner.CfnVpcConnectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apprunner.CfnVpcConnectorProps.Builder();
        }

        /**
         * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
         * <p>
         * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
         * <p>
         * <blockquote>
         * <p>
         * App Runner currently only provides support for IPv4.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param subnets A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final java.util.List<java.lang.String> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets.
         * <p>
         * If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
         * <p>
         * @return {@code this}
         * @param securityGroups A list of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * A list of metadata items that you can associate with your VPC connector resource.
         * <p>
         * A tag is a key-value pair.
         * <p>
         * @return {@code this}
         * @param tags A list of metadata items that you can associate with your VPC connector resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A name for the VPC connector.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a name for your VPC connector.
         * <p>
         * @return {@code this}
         * @param vpcConnectorName A name for the VPC connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConnectorName(final java.lang.String vpcConnectorName) {
            this.props.vpcConnectorName(vpcConnectorName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apprunner.CfnVpcConnector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apprunner.CfnVpcConnector build() {
            return new software.amazon.awscdk.services.apprunner.CfnVpcConnector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
