package software.amazon.awscdk.services.appmesh;

/**
 * Defines listener for a VirtualNode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.585Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualNodeListener")
public abstract class VirtualNodeListener extends software.amazon.jsii.JsiiObject {

    protected VirtualNodeListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualNodeListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected VirtualNodeListener() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns an GRPC Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener grpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.GrpcVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * Returns an GRPC Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener grpc() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "grpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * Returns an HTTP Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HttpVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * Returns an HTTP Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * Returns an HTTP2 Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Http2VirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * Returns an HTTP2 Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener http2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "http2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * Returns an TCP Listener for a VirtualNode.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener tcp(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.TcpVirtualNodeListenerOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class), new Object[] { props });
    }

    /**
     * Returns an TCP Listener for a VirtualNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListener tcp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class));
    }

    /**
     * Binds the current object when adding Listener to a VirtualNode.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.VirtualNodeListener {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Binds the current object when adding Listener to a VirtualNode.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListenerConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
