package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define HTTP2 Listeners for a VirtualGateway.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * // A Virtual Node with listener TLS from an ACM provided certificate
 * Certificate cert;
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .listeners(List.of(VirtualNodeListener.grpc(GrpcVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.acm(cert))
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with listener TLS from a customer provided file certificate
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.file("path/to/certChain", "path/to/privateKey"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * // A Virtual Gateway with listener TLS from a SDS provided certificate
 * VirtualGateway gateway2 = VirtualGateway.Builder.create(this, "gateway2")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.http2(Http2GatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.sds("secrete_certificate"))
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway2")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:36.540Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.Http2GatewayListenerOptions")
@software.amazon.jsii.Jsii.Proxy(Http2GatewayListenerOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Http2GatewayListenerOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Connection pool for http listeners.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Http2ConnectionPool getConnectionPool() {
        return null;
    }

    /**
     * The health check information for the listener.
     * <p>
     * Default: - no healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * Port to listen for connections on.
     * <p>
     * Default: - 8080
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Represents the configuration for enabling TLS on a listener.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.ListenerTlsOptions getTls() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Http2GatewayListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Http2GatewayListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Http2GatewayListenerOptions> {
        software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool;
        software.amazon.awscdk.services.appmesh.HealthCheck healthCheck;
        java.lang.Number port;
        software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls;

        /**
         * Sets the value of {@link Http2GatewayListenerOptions#getConnectionPool}
         * @param connectionPool Connection pool for http listeners.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionPool(software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        /**
         * Sets the value of {@link Http2GatewayListenerOptions#getHealthCheck}
         * @param healthCheck The health check information for the listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.appmesh.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link Http2GatewayListenerOptions#getPort}
         * @param port Port to listen for connections on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link Http2GatewayListenerOptions#getTls}
         * @param tls Represents the configuration for enabling TLS on a listener.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tls(software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls) {
            this.tls = tls;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Http2GatewayListenerOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Http2GatewayListenerOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Http2GatewayListenerOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Http2GatewayListenerOptions {
        private final software.amazon.awscdk.services.appmesh.Http2ConnectionPool connectionPool;
        private final software.amazon.awscdk.services.appmesh.HealthCheck healthCheck;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.appmesh.ListenerTlsOptions tls;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionPool = software.amazon.jsii.Kernel.get(this, "connectionPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.Http2ConnectionPool.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HealthCheck.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ListenerTlsOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionPool = builder.connectionPool;
            this.healthCheck = builder.healthCheck;
            this.port = builder.port;
            this.tls = builder.tls;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.Http2ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.ListenerTlsOptions getTls() {
            return this.tls;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConnectionPool() != null) {
                data.set("connectionPool", om.valueToTree(this.getConnectionPool()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getTls() != null) {
                data.set("tls", om.valueToTree(this.getTls()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.Http2GatewayListenerOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Http2GatewayListenerOptions.Jsii$Proxy that = (Http2GatewayListenerOptions.Jsii$Proxy) o;

            if (this.connectionPool != null ? !this.connectionPool.equals(that.connectionPool) : that.connectionPool != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionPool != null ? this.connectionPool.hashCode() : 0;
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
            return result;
        }
    }
}
