package software.amazon.awscdk.assertions;

/**
 * Suite of assertions that can be run on a CDK Stack.
 * <p>
 * Focused on asserting annotations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.assertions.*;
 * Stack stack;
 * Annotations annotations = Annotations.fromStack(stack);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T20:26:35.961Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.assertions.Annotations")
public class Annotations extends software.amazon.jsii.JsiiObject {

    protected Annotations(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Annotations(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Base your assertions on the messages returned by a synthesized CDK `Stack`.
     * <p>
     * @param stack the CDK Stack to run assertions on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.assertions.Annotations fromStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.assertions.Annotations.class, "fromStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assertions.Annotations.class), new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Get the set of matching errors of a given construct path and message.
     * <p>
     * @param constructPath the construct path to the error. This parameter is required.
     * @param message the error message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.SynthesisMessage> findError(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findError", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.SynthesisMessage.class)), new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message }));
    }

    /**
     * Get the set of matching infos of a given construct path and message.
     * <p>
     * @param constructPath the construct path to the info. This parameter is required.
     * @param message the info message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.SynthesisMessage> findInfo(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findInfo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.SynthesisMessage.class)), new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message }));
    }

    /**
     * Get the set of matching warning of a given construct path and message.
     * <p>
     * @param constructPath the construct path to the warning. This parameter is required.
     * @param message the warning message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.cxapi.SynthesisMessage> findWarning(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "findWarning", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cxapi.SynthesisMessage.class)), new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message }));
    }

    /**
     * Assert that an error with the given message exists in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the error. This parameter is required.
     * @param message the error message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasError(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasError", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }

    /**
     * Assert that an info with the given message exists in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the info. This parameter is required.
     * @param message the info message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasInfo(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasInfo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }

    /**
     * Assert that an error with the given message does not exist in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the error. This parameter is required.
     * @param message the error message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasNoError(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasNoError", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }

    /**
     * Assert that an info with the given message does not exist in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the info. This parameter is required.
     * @param message the info message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasNoInfo(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasNoInfo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }

    /**
     * Assert that an warning with the given message does not exist in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the warning. This parameter is required.
     * @param message the warning message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasNoWarning(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasNoWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }

    /**
     * Assert that an warning with the given message exists in the synthesized CDK `Stack`.
     * <p>
     * @param constructPath the construct path to the warning. This parameter is required.
     * @param message the warning message as should be expected. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void hasWarning(final @org.jetbrains.annotations.NotNull java.lang.String constructPath, final @org.jetbrains.annotations.NotNull java.lang.Object message) {
        software.amazon.jsii.Kernel.call(this, "hasWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(constructPath, "constructPath is required"), message });
    }
}
