package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a `CfnRateBasedRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnRateBasedRuleProps cfnRateBasedRuleProps = CfnRateBasedRuleProps.builder()
 *         .metricName("metricName")
 *         .name("name")
 *         .rateKey("rateKey")
 *         .rateLimit(123)
 *         // the properties below are optional
 *         .matchPredicates(List.of(PredicateProperty.builder()
 *                 .dataId("dataId")
 *                 .negated(false)
 *                 .type("type")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnRateBasedRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRateBasedRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRateBasedRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the metrics for a `RateBasedRule` .
     * <p>
     * The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF , including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * A friendly name or description for a `RateBasedRule` .
     * <p>
     * You can't change the name of a <code>RateBasedRule</code> after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring.
     * <p>
     * The only valid value for <code>RateKey</code> is <code>IP</code> . <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRateKey();

    /**
     * The maximum number of requests, which have an identical value in the field specified by the `RateKey` , allowed in a five-minute period.
     * <p>
     * If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRateLimit();

    /**
     * The `Predicates` object contains one `Predicate` element for each `ByteMatchSet` , `IPSet` , or `SqlInjectionMatchSet>` object that you want to include in a `RateBasedRule` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMatchPredicates() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRateBasedRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRateBasedRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRateBasedRuleProps> {
        java.lang.String metricName;
        java.lang.String name;
        java.lang.String rateKey;
        java.lang.Number rateLimit;
        java.lang.Object matchPredicates;

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getMetricName}
         * @param metricName A name for the metrics for a `RateBasedRule` . This parameter is required.
         *                   The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF , including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getName}
         * @param name A friendly name or description for a `RateBasedRule` . This parameter is required.
         *             You can't change the name of a <code>RateBasedRule</code> after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getRateKey}
         * @param rateKey The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. This parameter is required.
         *                The only valid value for <code>RateKey</code> is <code>IP</code> . <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateKey(java.lang.String rateKey) {
            this.rateKey = rateKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getRateLimit}
         * @param rateLimit The maximum number of requests, which have an identical value in the field specified by the `RateKey` , allowed in a five-minute period. This parameter is required.
         *                  If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimit(java.lang.Number rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getMatchPredicates}
         * @param matchPredicates The `Predicates` object contains one `Predicate` element for each `ByteMatchSet` , `IPSet` , or `SqlInjectionMatchSet>` object that you want to include in a `RateBasedRule` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPredicates(software.amazon.awscdk.IResolvable matchPredicates) {
            this.matchPredicates = matchPredicates;
            return this;
        }

        /**
         * Sets the value of {@link CfnRateBasedRuleProps#getMatchPredicates}
         * @param matchPredicates The `Predicates` object contains one `Predicate` element for each `ByteMatchSet` , `IPSet` , or `SqlInjectionMatchSet>` object that you want to include in a `RateBasedRule` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPredicates(java.util.List<? extends java.lang.Object> matchPredicates) {
            this.matchPredicates = matchPredicates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRateBasedRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRateBasedRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRateBasedRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRateBasedRuleProps {
        private final java.lang.String metricName;
        private final java.lang.String name;
        private final java.lang.String rateKey;
        private final java.lang.Number rateLimit;
        private final java.lang.Object matchPredicates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rateKey = software.amazon.jsii.Kernel.get(this, "rateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rateLimit = software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.matchPredicates = software.amazon.jsii.Kernel.get(this, "matchPredicates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.rateKey = java.util.Objects.requireNonNull(builder.rateKey, "rateKey is required");
            this.rateLimit = java.util.Objects.requireNonNull(builder.rateLimit, "rateLimit is required");
            this.matchPredicates = builder.matchPredicates;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRateKey() {
            return this.rateKey;
        }

        @Override
        public final java.lang.Number getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public final java.lang.Object getMatchPredicates() {
            return this.matchPredicates;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("rateKey", om.valueToTree(this.getRateKey()));
            data.set("rateLimit", om.valueToTree(this.getRateLimit()));
            if (this.getMatchPredicates() != null) {
                data.set("matchPredicates", om.valueToTree(this.getMatchPredicates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnRateBasedRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRateBasedRuleProps.Jsii$Proxy that = (CfnRateBasedRuleProps.Jsii$Proxy) o;

            if (!metricName.equals(that.metricName)) return false;
            if (!name.equals(that.name)) return false;
            if (!rateKey.equals(that.rateKey)) return false;
            if (!rateLimit.equals(that.rateLimit)) return false;
            return this.matchPredicates != null ? this.matchPredicates.equals(that.matchPredicates) : that.matchPredicates == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricName.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.rateKey.hashCode());
            result = 31 * result + (this.rateLimit.hashCode());
            result = 31 * result + (this.matchPredicates != null ? this.matchPredicates.hashCode() : 0);
            return result;
        }
    }
}
