package software.amazon.awscdk.services.timestream;

/**
 * Properties for defining a `CfnTable`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * Object magneticStoreWriteProperties;
 * Object retentionProperties;
 * CfnTableProps cfnTableProps = CfnTableProps.builder()
 *         .databaseName("databaseName")
 *         // the properties below are optional
 *         .magneticStoreWriteProperties(magneticStoreWriteProperties)
 *         .retentionProperties(retentionProperties)
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.653Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Timestream database that contains this table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" BucketName: "1234abcd-12ab-34cd-56ef-1234567890ab" EncryptionOption: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMagneticStoreWriteProperties() {
        return null;
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionProperties() {
        return null;
    }

    /**
     * The name of the Timestream table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * The tags to add to the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableProps> {
        java.lang.String databaseName;
        java.lang.Object magneticStoreWriteProperties;
        java.lang.Object retentionProperties;
        java.lang.String tableName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTableProps#getDatabaseName}
         * @param databaseName The name of the Timestream database that contains this table. This parameter is required.
         *                     <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getMagneticStoreWriteProperties}
         * @param magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes.
         *                                     This object has the following attributes:
         *                                     <p>
         *                                     <ul>
         *                                     <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
         *                                     <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
         *                                     <li><em>BucketName</em> : The name of the S3 bucket.</li>
         *                                     <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
         *                                     <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
         *                                     <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
         *                                     </ul>
         *                                     <p>
         *                                     Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
         *                                     <p>
         *                                     <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
         *                                     <p>
         *                                     See the following examples:
         *                                     <p>
         *                                     <em>JSON</em>
         *                                     <p>
         *                                     <blockquote><pre>
         *                                     { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
         *                                     }
         *                                     </pre></blockquote>
         *                                     <p>
         *                                     <em>YAML</em>
         *                                     <p>
         *                                     <blockquote><pre>
         *                                     Type: AWS::Timestream::Table
         *                                     DependsOn: TestDatabase
         *                                     Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" BucketName: "1234abcd-12ab-34cd-56ef-1234567890ab" EncryptionOption: "prefix"
         *                                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder magneticStoreWriteProperties(java.lang.Object magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getRetentionProperties}
         * @param retentionProperties The retention duration for the memory store and magnetic store. This object has the following attributes:.
         *                            <ul>
         *                            <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
         *                            <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
         *                            </ul>
         *                            <p>
         *                            Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
         *                            <p>
         *                            See the following examples:
         *                            <p>
         *                            <em>JSON</em>
         *                            <p>
         *                            <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
         *                            <p>
         *                            <em>YAML</em>
         *                            <p>
         *                            <blockquote><pre>
         *                            Type: AWS::Timestream::Table
         *                            DependsOn: TestDatabase
         *                            Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
         *                            </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionProperties(java.lang.Object retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableName}
         * @param tableName The name of the Timestream table.
         *                  <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTags}
         * @param tags The tags to add to the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.String databaseName;
        private final java.lang.Object magneticStoreWriteProperties;
        private final java.lang.Object retentionProperties;
        private final java.lang.String tableName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.magneticStoreWriteProperties = software.amazon.jsii.Kernel.get(this, "magneticStoreWriteProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionProperties = software.amazon.jsii.Kernel.get(this, "retentionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
            this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
            this.retentionProperties = builder.retentionProperties;
            this.tableName = builder.tableName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.Object getMagneticStoreWriteProperties() {
            return this.magneticStoreWriteProperties;
        }

        @Override
        public final java.lang.Object getRetentionProperties() {
            return this.retentionProperties;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            if (this.getMagneticStoreWriteProperties() != null) {
                data.set("magneticStoreWriteProperties", om.valueToTree(this.getMagneticStoreWriteProperties()));
            }
            if (this.getRetentionProperties() != null) {
                data.set("retentionProperties", om.valueToTree(this.getRetentionProperties()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!databaseName.equals(that.databaseName)) return false;
            if (this.magneticStoreWriteProperties != null ? !this.magneticStoreWriteProperties.equals(that.magneticStoreWriteProperties) : that.magneticStoreWriteProperties != null) return false;
            if (this.retentionProperties != null ? !this.retentionProperties.equals(that.retentionProperties) : that.retentionProperties != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.databaseName.hashCode();
            result = 31 * result + (this.magneticStoreWriteProperties != null ? this.magneticStoreWriteProperties.hashCode() : 0);
            result = 31 * result + (this.retentionProperties != null ? this.retentionProperties.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
