package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The overrides that should be sent to a container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * InstanceType instanceType;
 * ContainerOverrides containerOverrides = ContainerOverrides.builder()
 *         .command(List.of("command"))
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .gpuCount(123)
 *         .instanceType(instanceType)
 *         .memory(123)
 *         .vcpus(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ContainerOverrides")
@software.amazon.jsii.Jsii.Proxy(ContainerOverrides.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerOverrides extends software.amazon.jsii.JsiiSerializable {

    /**
     * The command to send to the container that overrides the default command from the Docker image or the job definition.
     * <p>
     * Default: - No command overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to send to the container.
     * <p>
     * You can add new environment variables, which are added to the container
     * at launch, or you can override the existing environment variables from
     * the Docker image or the job definition.
     * <p>
     * Default: - No environment overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * The number of GPUs reserved for all containers in a job
     * should not exceed the number of available GPUs on the compute
     * resource that the job is launched on.
     * <p>
     * Default: - No GPU reservation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuCount() {
        return null;
    }

    /**
     * The instance type to use for a multi-node parallel job.
     * <p>
     * This parameter is not valid for single-node container jobs.
     * <p>
     * Default: - No instance type overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * The number of MiB of memory reserved for the job.
     * <p>
     * This value overrides the value set in the job definition.
     * <p>
     * Default: - No memory overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
        return null;
    }

    /**
     * The number of vCPUs to reserve for the container.
     * <p>
     * This value overrides the value set in the job definition.
     * <p>
     * Default: - No vCPUs overrides
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerOverrides> {
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.Number gpuCount;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.Number memory;
        java.lang.Number vcpus;

        /**
         * Sets the value of {@link ContainerOverrides#getCommand}
         * @param command The command to send to the container that overrides the default command from the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getEnvironment}
         * @param environment The environment variables to send to the container.
         *                    You can add new environment variables, which are added to the container
         *                    at launch, or you can override the existing environment variables from
         *                    the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getGpuCount}
         * @param gpuCount The number of physical GPUs to reserve for the container.
         *                 The number of GPUs reserved for all containers in a job
         *                 should not exceed the number of available GPUs on the compute
         *                 resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getInstanceType}
         * @param instanceType The instance type to use for a multi-node parallel job.
         *                     This parameter is not valid for single-node container jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getMemory}
         * @param memory The number of MiB of memory reserved for the job.
         *               This value overrides the value set in the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(java.lang.Number memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getVcpus}
         * @param vcpus The number of vCPUs to reserve for the container.
         *              This value overrides the value set in the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vcpus(java.lang.Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerOverrides}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerOverrides build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerOverrides {
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Number memory;
        private final java.lang.Number vcpus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = software.amazon.jsii.Kernel.get(this, "gpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vcpus = software.amazon.jsii.Kernel.get(this, "vcpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = builder.command;
            this.environment = builder.environment;
            this.gpuCount = builder.gpuCount;
            this.instanceType = builder.instanceType;
            this.memory = builder.memory;
            this.vcpus = builder.vcpus;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Number getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.Number getVcpus() {
            return this.vcpus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getVcpus() != null) {
                data.set("vcpus", om.valueToTree(this.getVcpus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ContainerOverrides"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerOverrides.Jsii$Proxy that = (ContainerOverrides.Jsii$Proxy) o;

            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            return this.vcpus != null ? this.vcpus.equals(that.vcpus) : that.vcpus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.command != null ? this.command.hashCode() : 0;
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
            return result;
        }
    }
}
