package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Map state in the state machine.
 * <p>
 * A <code>Map</code> state can be used to run a set of steps for each element of an input array.
 * A Map state will execute the same steps for multiple entries of an array in the state input.
 * <p>
 * While the Parallel state executes multiple branches of steps using the same input, a Map state
 * will execute the same steps for multiple entries of an array in the state input.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .build();
 * map.iterator(new Pass(this, "Pass State"));
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-map-state.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.382Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Map")
public class Map extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected Map(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Map(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Map(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.MapProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Map(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addRetry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map addRetry() {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class));
    }

    /**
     * Define iterator state machine in Map.
     * <p>
     * @param iterator This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Map iterator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable iterator) {
        return software.amazon.jsii.Kernel.call(this, "iterator", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Map.class), new Object[] { java.util.Objects.requireNonNull(iterator, "iterator is required") });
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Validate this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateState() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateState", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Map}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Map> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.MapProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props().inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select the array to iterate over.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param itemsPath JSONPath expression to select the array to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemsPath(final java.lang.String itemsPath) {
            this.props().itemsPath(itemsPath);
            return this;
        }

        /**
         * MaxConcurrency.
         * <p>
         * An upper bound on the number of iterations you want running at once.
         * <p>
         * Default: - full concurrency
         * <p>
         * @return {@code this}
         * @param maxConcurrency MaxConcurrency. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(final java.lang.Number maxConcurrency) {
            this.props().maxConcurrency(maxConcurrency);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props().outputPath(outputPath);
            return this;
        }

        /**
         * The JSON that you want to override your default iteration input.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param parameters The JSON that you want to override your default iteration input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props().resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props().resultSelector(resultSelector);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Map}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Map build() {
            return new software.amazon.awscdk.services.stepfunctions.Map(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.MapProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.MapProps.Builder();
            }
            return this.props;
        }
    }
}
