package software.amazon.awscdk.services.ssm;

/**
 * SSM parameter type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * StringParameter ssmParameter = StringParameter.Builder.create(this, "mySsmParameter")
 *         .parameterName("mySsmParameter")
 *         .stringValue("mySsmParameterValue")
 *         .type(ParameterType.STRING)
 *         .build();
 * StringParameter secureParameter = StringParameter.Builder.create(this, "mySecretParameter")
 *         .parameterName("mySecretParameter")
 *         .stringValue("mySecretParameterValue")
 *         .type(ParameterType.SECURE_STRING)
 *         .build();
 * StringParameter listParameter = StringParameter.Builder.create(this, "myListParameter")
 *         .parameterName("myListParameter")
 *         .stringValue(List.of("myListParameterValue1", "myListParameterValue2"))
 *         .type(ParameterType.STRING_LIST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:02.245Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.ParameterType")
public enum ParameterType {
    /**
     * String.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING,
    /**
     * Secure String.
     * <p>
     * Parameter Store uses an AWS Key Management Service (KMS) customer master key (CMK) to encrypt the parameter value.
     * Parameters of type SecureString cannot be created directly from a CDK application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SECURE_STRING,
    /**
     * String List.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STRING_LIST,
    /**
     * An Amazon EC2 image ID, such as ami-0ff8a91507f77f867.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_EC2_IMAGE_ID,
}
