package software.amazon.awscdk.services.servicecatalog;

/**
 * Properties for a Cloudformation Product.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.*;
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProduct");
 *     }
 * }
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "Product")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(CloudFormationProductVersion.builder()
 *                 .productVersionName("v1")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromProductStack(new S3BucketProduct(this, "S3BucketProduct")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.807Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.CloudFormationProductProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationProductProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationProductProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The owner of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOwner();

    /**
     * The name of the product.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductName();

    /**
     * The configuration of the product version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> getProductVersions();

    /**
     * The description of the product.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The distributor of the product.
     * <p>
     * Default: - No distributor provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributor() {
        return null;
    }

    /**
     * The language code.
     * <p>
     * Controls language for logging and errors.
     * <p>
     * Default: - English
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
        return null;
    }

    /**
     * Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceProductVersionIds() {
        return null;
    }

    /**
     * The support information about the product.
     * <p>
     * Default: - No support description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportDescription() {
        return null;
    }

    /**
     * The contact email for product support.
     * <p>
     * Default: - No support email provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportEmail() {
        return null;
    }

    /**
     * The contact URL for product support.
     * <p>
     * Default: - No support URL provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSupportUrl() {
        return null;
    }

    /**
     * TagOptions associated directly to a product.
     * <p>
     * Default: - No tagOptions provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicecatalog.TagOptions getTagOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationProductProps> {
        java.lang.String owner;
        java.lang.String productName;
        java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions;
        java.lang.String description;
        java.lang.String distributor;
        software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        java.lang.Boolean replaceProductVersionIds;
        java.lang.String supportDescription;
        java.lang.String supportEmail;
        java.lang.String supportUrl;
        software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions;

        /**
         * Sets the value of {@link CloudFormationProductProps#getOwner}
         * @param owner The owner of the product. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getProductName}
         * @param productName The name of the product. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productName(java.lang.String productName) {
            this.productName = productName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getProductVersions}
         * @param productVersions The configuration of the product version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder productVersions(java.util.List<? extends software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions) {
            this.productVersions = (java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion>)productVersions;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getDescription}
         * @param description The description of the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getDistributor}
         * @param distributor The distributor of the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributor(java.lang.String distributor) {
            this.distributor = distributor;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getMessageLanguage}
         * @param messageLanguage The language code.
         *                        Controls language for logging and errors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageLanguage(software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage) {
            this.messageLanguage = messageLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getReplaceProductVersionIds}
         * @param replaceProductVersionIds Whether to give provisioning artifacts a new unique identifier when the product attributes or provisioning artifacts is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceProductVersionIds(java.lang.Boolean replaceProductVersionIds) {
            this.replaceProductVersionIds = replaceProductVersionIds;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportDescription}
         * @param supportDescription The support information about the product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportDescription(java.lang.String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportEmail}
         * @param supportEmail The contact email for product support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportEmail(java.lang.String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getSupportUrl}
         * @param supportUrl The contact URL for product support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportUrl(java.lang.String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationProductProps#getTagOptions}
         * @param tagOptions TagOptions associated directly to a product.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagOptions(software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions) {
            this.tagOptions = tagOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationProductProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationProductProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationProductProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationProductProps {
        private final java.lang.String owner;
        private final java.lang.String productName;
        private final java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> productVersions;
        private final java.lang.String description;
        private final java.lang.String distributor;
        private final software.amazon.awscdk.services.servicecatalog.MessageLanguage messageLanguage;
        private final java.lang.Boolean replaceProductVersionIds;
        private final java.lang.String supportDescription;
        private final java.lang.String supportEmail;
        private final java.lang.String supportUrl;
        private final software.amazon.awscdk.services.servicecatalog.TagOptions tagOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productVersions = software.amazon.jsii.Kernel.get(this, "productVersions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributor = software.amazon.jsii.Kernel.get(this, "distributor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.messageLanguage = software.amazon.jsii.Kernel.get(this, "messageLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.MessageLanguage.class));
            this.replaceProductVersionIds = software.amazon.jsii.Kernel.get(this, "replaceProductVersionIds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportDescription = software.amazon.jsii.Kernel.get(this, "supportDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supportEmail = software.amazon.jsii.Kernel.get(this, "supportEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supportUrl = software.amazon.jsii.Kernel.get(this, "supportUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tagOptions = software.amazon.jsii.Kernel.get(this, "tagOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.TagOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
            this.productName = java.util.Objects.requireNonNull(builder.productName, "productName is required");
            this.productVersions = (java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion>)java.util.Objects.requireNonNull(builder.productVersions, "productVersions is required");
            this.description = builder.description;
            this.distributor = builder.distributor;
            this.messageLanguage = builder.messageLanguage;
            this.replaceProductVersionIds = builder.replaceProductVersionIds;
            this.supportDescription = builder.supportDescription;
            this.supportEmail = builder.supportEmail;
            this.supportUrl = builder.supportUrl;
            this.tagOptions = builder.tagOptions;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getProductName() {
            return this.productName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion> getProductVersions() {
            return this.productVersions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDistributor() {
            return this.distributor;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.MessageLanguage getMessageLanguage() {
            return this.messageLanguage;
        }

        @Override
        public final java.lang.Boolean getReplaceProductVersionIds() {
            return this.replaceProductVersionIds;
        }

        @Override
        public final java.lang.String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final java.lang.String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final java.lang.String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        public final software.amazon.awscdk.services.servicecatalog.TagOptions getTagOptions() {
            return this.tagOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("owner", om.valueToTree(this.getOwner()));
            data.set("productName", om.valueToTree(this.getProductName()));
            data.set("productVersions", om.valueToTree(this.getProductVersions()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDistributor() != null) {
                data.set("distributor", om.valueToTree(this.getDistributor()));
            }
            if (this.getMessageLanguage() != null) {
                data.set("messageLanguage", om.valueToTree(this.getMessageLanguage()));
            }
            if (this.getReplaceProductVersionIds() != null) {
                data.set("replaceProductVersionIds", om.valueToTree(this.getReplaceProductVersionIds()));
            }
            if (this.getSupportDescription() != null) {
                data.set("supportDescription", om.valueToTree(this.getSupportDescription()));
            }
            if (this.getSupportEmail() != null) {
                data.set("supportEmail", om.valueToTree(this.getSupportEmail()));
            }
            if (this.getSupportUrl() != null) {
                data.set("supportUrl", om.valueToTree(this.getSupportUrl()));
            }
            if (this.getTagOptions() != null) {
                data.set("tagOptions", om.valueToTree(this.getTagOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.CloudFormationProductProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationProductProps.Jsii$Proxy that = (CloudFormationProductProps.Jsii$Proxy) o;

            if (!owner.equals(that.owner)) return false;
            if (!productName.equals(that.productName)) return false;
            if (!productVersions.equals(that.productVersions)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.distributor != null ? !this.distributor.equals(that.distributor) : that.distributor != null) return false;
            if (this.messageLanguage != null ? !this.messageLanguage.equals(that.messageLanguage) : that.messageLanguage != null) return false;
            if (this.replaceProductVersionIds != null ? !this.replaceProductVersionIds.equals(that.replaceProductVersionIds) : that.replaceProductVersionIds != null) return false;
            if (this.supportDescription != null ? !this.supportDescription.equals(that.supportDescription) : that.supportDescription != null) return false;
            if (this.supportEmail != null ? !this.supportEmail.equals(that.supportEmail) : that.supportEmail != null) return false;
            if (this.supportUrl != null ? !this.supportUrl.equals(that.supportUrl) : that.supportUrl != null) return false;
            return this.tagOptions != null ? this.tagOptions.equals(that.tagOptions) : that.tagOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + (this.productName.hashCode());
            result = 31 * result + (this.productVersions.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.distributor != null ? this.distributor.hashCode() : 0);
            result = 31 * result + (this.messageLanguage != null ? this.messageLanguage.hashCode() : 0);
            result = 31 * result + (this.replaceProductVersionIds != null ? this.replaceProductVersionIds.hashCode() : 0);
            result = 31 * result + (this.supportDescription != null ? this.supportDescription.hashCode() : 0);
            result = 31 * result + (this.supportEmail != null ? this.supportEmail.hashCode() : 0);
            result = 31 * result + (this.supportUrl != null ? this.supportUrl.hashCode() : 0);
            result = 31 * result + (this.tagOptions != null ? this.tagOptions.hashCode() : 0);
            return result;
        }
    }
}
