/**
 * <h1>Route53 Alias Record Targets for the CDK Route53 Library</h1>
 * <p>
 * This library contains Route53 Alias Record targets for:
 * <p>
 * <ul>
 * <li>API Gateway custom domains
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigateway.*;
 * 
 * HostedZone zone;
 * LambdaRestApi restApi;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ApiGateway(restApi)))
 *         .build();
 * </pre></blockquote></li>
 * <li>API Gateway V2 custom domains
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * 
 * HostedZone zone;
 * apigwv2.DomainName domainName;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ApiGatewayv2DomainProperties(domainName.getRegionalDomainName(), domainName.getRegionalHostedZoneId())))
 *         .build();
 * </pre></blockquote></li>
 * <li>CloudFront distributions
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudfront.*;
 * 
 * HostedZone zone;
 * CloudFrontWebDistribution distribution;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new CloudFrontTarget(distribution)))
 *         .build();
 * </pre></blockquote></li>
 * <li>ELBv2 load balancers
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * 
 * HostedZone zone;
 * ApplicationLoadBalancer lb;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new LoadBalancerTarget(lb)))
 *         .build();
 * </pre></blockquote></li>
 * <li>Classic load balancers
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * 
 * HostedZone zone;
 * LoadBalancer lb;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ClassicLoadBalancerTarget(lb)))
 *         .build();
 * </pre></blockquote></li>
 * </ul>
 * <p>
 * <strong>Important:</strong> Based on <a href="https://aws.amazon.com/de/premiumsupport/knowledge-center/alias-resource-record-set-route53-cli/">AWS documentation</a>, all alias record in Route 53 that points to a Elastic Load Balancer will always include <em>dualstack</em> for the DNSName to resolve IPv4/IPv6 addresses (without <em>dualstack</em> IPv6 will not resolve).
 * <p>
 * For example, if the Amazon-provided DNS for the load balancer is <code>ALB-xxxxxxx.us-west-2.elb.amazonaws.com</code>, CDK will create alias target in Route 53 will be <code>dualstack.ALB-xxxxxxx.us-west-2.elb.amazonaws.com</code>.
 * <p>
 * <ul>
 * <li>GlobalAccelerator
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * 
 * HostedZone zone;
 * Accelerator accelerator;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new GlobalAcceleratorTarget(accelerator)))
 *         .build();
 * </pre></blockquote></li>
 * </ul>
 * <p>
 * <strong>Important:</strong> If you use GlobalAcceleratorDomainTarget, passing a string rather than an instance of IAccelerator, ensure that the string is a valid domain name of an existing Global Accelerator instance.
 * See <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html">the documentation on DNS addressing</a> with Global Accelerator for more info.
 * <p>
 * <ul>
 * <li>InterfaceVpcEndpoints</li>
 * </ul>
 * <p>
 * <strong>Important:</strong> Based on the CFN docs for VPCEndpoints - <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#aws-resource-ec2-vpcendpoint-return-values">see here</a> - the attributes returned for DnsEntries in CloudFormation is a combination of the hosted zone ID and the DNS name. The entries are ordered as follows: regional public DNS, zonal public DNS, private DNS, and wildcard DNS. This order is not enforced for AWS Marketplace services, and therefore this CDK construct is ONLY guaranteed to work with non-marketplace services.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * 
 * HostedZone zone;
 * InterfaceVpcEndpoint interfaceVpcEndpoint;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new InterfaceVpcEndpointTarget(interfaceVpcEndpoint)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>S3 Bucket Website:</li>
 * </ul>
 * <p>
 * <strong>Important:</strong> The Bucket name must strictly match the full DNS name.
 * See <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html">the Developer Guide</a> for more info.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * 
 * 
 * String recordName = "www";
 * String domainName = "example.com";
 * 
 * Bucket bucketWebsite = Bucket.Builder.create(this, "BucketWebsite")
 *         .bucketName(List.of(recordName, domainName).join(".")) // www.example.com
 *         .publicReadAccess(true)
 *         .websiteIndexDocument("index.html")
 *         .build();
 * 
 * IHostedZone zone = HostedZone.fromLookup(this, "Zone", HostedZoneProviderProps.builder().domainName(domainName).build()); // example.com
 * 
 *  // example.com
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .recordName(recordName) // www
 *         .target(RecordTarget.fromAlias(new BucketWebsiteTarget(bucketWebsite)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li>User pool domain
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * 
 * HostedZone zone;
 * UserPoolDomain domain;
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new UserPoolDomainTarget(domain)))
 *         .build();
 * </pre></blockquote></li>
 * <li>Route 53 record
 * <p>
 * <blockquote><pre>
 * HostedZone zone;
 * ARecord record;
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new Route53RecordTarget(record)))
 *         .build();
 * </pre></blockquote></li>
 * <li>Elastic Beanstalk environment:</li>
 * </ul>
 * <p>
 * <strong>Important:</strong> Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 * <p>
 * <blockquote><pre>
 * HostedZone zone;
 * String ebsEnvironmentUrl;
 * 
 * 
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ElasticBeanstalkEnvironmentEndpointTarget(ebsEnvironmentUrl)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * See the documentation of <code>&#64;aws-cdk/aws-route53</code> for more information.
 */
package software.amazon.awscdk.services.route53.targets;
