package software.amazon.awscdk.services.rds;

/**
 * Properties for Oracle Enterprise Edition instance engines.
 * <p>
 * Used in {&#64;link DatabaseInstanceEngine.oracleEe}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * OracleEngineVersion oracleEngineVersion;
 * OracleEeInstanceEngineProps oracleEeInstanceEngineProps = OracleEeInstanceEngineProps.builder()
 *         .version(oracleEngineVersion)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:01.207Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.OracleEeInstanceEngineProps")
@software.amazon.jsii.Jsii.Proxy(OracleEeInstanceEngineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OracleEeInstanceEngineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The exact version of the engine to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEngineVersion getVersion();

    /**
     * @return a {@link Builder} of {@link OracleEeInstanceEngineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OracleEeInstanceEngineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OracleEeInstanceEngineProps> {
        software.amazon.awscdk.services.rds.OracleEngineVersion version;

        /**
         * Sets the value of {@link OracleEeInstanceEngineProps#getVersion}
         * @param version The exact version of the engine to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.rds.OracleEngineVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OracleEeInstanceEngineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OracleEeInstanceEngineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OracleEeInstanceEngineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OracleEeInstanceEngineProps {
        private final software.amazon.awscdk.services.rds.OracleEngineVersion version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.OracleEngineVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
        }

        @Override
        public final software.amazon.awscdk.services.rds.OracleEngineVersion getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.OracleEeInstanceEngineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OracleEeInstanceEngineProps.Jsii$Proxy that = (OracleEeInstanceEngineProps.Jsii$Proxy) o;

            return this.version.equals(that.version);
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            return result;
        }
    }
}
