package software.amazon.awscdk.services.pinpoint;

/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 * <p>
 * Specifies the settings for a campaign. A <em>campaign</em> is a messaging initiative that engages a specific segment of users for an Amazon Pinpoint application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object attributes;
 * Object customConfig;
 * Object metrics;
 * Object tags;
 * CfnCampaign cfnCampaign = CfnCampaign.Builder.create(this, "MyCfnCampaign")
 *         .applicationId("applicationId")
 *         .name("name")
 *         .schedule(ScheduleProperty.builder()
 *                 .endTime("endTime")
 *                 .eventFilter(CampaignEventFilterProperty.builder()
 *                         .dimensions(EventDimensionsProperty.builder()
 *                                 .attributes(attributes)
 *                                 .eventType(SetDimensionProperty.builder()
 *                                         .dimensionType("dimensionType")
 *                                         .values(List.of("values"))
 *                                         .build())
 *                                 .metrics(metrics)
 *                                 .build())
 *                         .filterType("filterType")
 *                         .build())
 *                 .frequency("frequency")
 *                 .isLocalTime(false)
 *                 .quietTime(QuietTimeProperty.builder()
 *                         .end("end")
 *                         .start("start")
 *                         .build())
 *                 .startTime("startTime")
 *                 .timeZone("timeZone")
 *                 .build())
 *         .segmentId("segmentId")
 *         // the properties below are optional
 *         .additionalTreatments(List.of(WriteTreatmentResourceProperty.builder()
 *                 .customDeliveryConfiguration(CustomDeliveryConfigurationProperty.builder()
 *                         .deliveryUri("deliveryUri")
 *                         .endpointTypes(List.of("endpointTypes"))
 *                         .build())
 *                 .messageConfiguration(MessageConfigurationProperty.builder()
 *                         .admMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .apnsMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .baiduMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .customMessage(CampaignCustomMessageProperty.builder()
 *                                 .data("data")
 *                                 .build())
 *                         .defaultMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .emailMessage(CampaignEmailMessageProperty.builder()
 *                                 .body("body")
 *                                 .fromAddress("fromAddress")
 *                                 .htmlBody("htmlBody")
 *                                 .title("title")
 *                                 .build())
 *                         .gcmMessage(MessageProperty.builder()
 *                                 .action("action")
 *                                 .body("body")
 *                                 .imageIconUrl("imageIconUrl")
 *                                 .imageSmallIconUrl("imageSmallIconUrl")
 *                                 .imageUrl("imageUrl")
 *                                 .jsonBody("jsonBody")
 *                                 .mediaUrl("mediaUrl")
 *                                 .rawContent("rawContent")
 *                                 .silentPush(false)
 *                                 .timeToLive(123)
 *                                 .title("title")
 *                                 .url("url")
 *                                 .build())
 *                         .inAppMessage(CampaignInAppMessageProperty.builder()
 *                                 .content(List.of(InAppMessageContentProperty.builder()
 *                                         .backgroundColor("backgroundColor")
 *                                         .bodyConfig(InAppMessageBodyConfigProperty.builder()
 *                                                 .alignment("alignment")
 *                                                 .body("body")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .headerConfig(InAppMessageHeaderConfigProperty.builder()
 *                                                 .alignment("alignment")
 *                                                 .header("header")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .imageUrl("imageUrl")
 *                                         .primaryBtn(InAppMessageButtonProperty.builder()
 *                                                 .android(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                         .backgroundColor("backgroundColor")
 *                                                         .borderRadius(123)
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .text("text")
 *                                                         .textColor("textColor")
 *                                                         .build())
 *                                                 .ios(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .web(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .build())
 *                                         .secondaryBtn(InAppMessageButtonProperty.builder()
 *                                                 .android(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                         .backgroundColor("backgroundColor")
 *                                                         .borderRadius(123)
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .text("text")
 *                                                         .textColor("textColor")
 *                                                         .build())
 *                                                 .ios(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .web(OverrideButtonConfigurationProperty.builder()
 *                                                         .buttonAction("buttonAction")
 *                                                         .link("link")
 *                                                         .build())
 *                                                 .build())
 *                                         .build()))
 *                                 .customConfig(customConfig)
 *                                 .layout("layout")
 *                                 .build())
 *                         .smsMessage(CampaignSmsMessageProperty.builder()
 *                                 .body("body")
 *                                 .entityId("entityId")
 *                                 .messageType("messageType")
 *                                 .originationNumber("originationNumber")
 *                                 .senderId("senderId")
 *                                 .templateId("templateId")
 *                                 .build())
 *                         .build())
 *                 .schedule(ScheduleProperty.builder()
 *                         .endTime("endTime")
 *                         .eventFilter(CampaignEventFilterProperty.builder()
 *                                 .dimensions(EventDimensionsProperty.builder()
 *                                         .attributes(attributes)
 *                                         .eventType(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .metrics(metrics)
 *                                         .build())
 *                                 .filterType("filterType")
 *                                 .build())
 *                         .frequency("frequency")
 *                         .isLocalTime(false)
 *                         .quietTime(QuietTimeProperty.builder()
 *                                 .end("end")
 *                                 .start("start")
 *                                 .build())
 *                         .startTime("startTime")
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .sizePercent(123)
 *                 .templateConfiguration(TemplateConfigurationProperty.builder()
 *                         .emailTemplate(TemplateProperty.builder()
 *                                 .name("name")
 *                                 .version("version")
 *                                 .build())
 *                         .pushTemplate(TemplateProperty.builder()
 *                                 .name("name")
 *                                 .version("version")
 *                                 .build())
 *                         .smsTemplate(TemplateProperty.builder()
 *                                 .name("name")
 *                                 .version("version")
 *                                 .build())
 *                         .voiceTemplate(TemplateProperty.builder()
 *                                 .name("name")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .treatmentDescription("treatmentDescription")
 *                 .treatmentName("treatmentName")
 *                 .build()))
 *         .campaignHook(CampaignHookProperty.builder()
 *                 .lambdaFunctionName("lambdaFunctionName")
 *                 .mode("mode")
 *                 .webUrl("webUrl")
 *                 .build())
 *         .customDeliveryConfiguration(CustomDeliveryConfigurationProperty.builder()
 *                 .deliveryUri("deliveryUri")
 *                 .endpointTypes(List.of("endpointTypes"))
 *                 .build())
 *         .description("description")
 *         .holdoutPercent(123)
 *         .isPaused(false)
 *         .limits(LimitsProperty.builder()
 *                 .daily(123)
 *                 .maximumDuration(123)
 *                 .messagesPerSecond(123)
 *                 .session(123)
 *                 .total(123)
 *                 .build())
 *         .messageConfiguration(MessageConfigurationProperty.builder()
 *                 .admMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .apnsMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .baiduMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .customMessage(CampaignCustomMessageProperty.builder()
 *                         .data("data")
 *                         .build())
 *                 .defaultMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .emailMessage(CampaignEmailMessageProperty.builder()
 *                         .body("body")
 *                         .fromAddress("fromAddress")
 *                         .htmlBody("htmlBody")
 *                         .title("title")
 *                         .build())
 *                 .gcmMessage(MessageProperty.builder()
 *                         .action("action")
 *                         .body("body")
 *                         .imageIconUrl("imageIconUrl")
 *                         .imageSmallIconUrl("imageSmallIconUrl")
 *                         .imageUrl("imageUrl")
 *                         .jsonBody("jsonBody")
 *                         .mediaUrl("mediaUrl")
 *                         .rawContent("rawContent")
 *                         .silentPush(false)
 *                         .timeToLive(123)
 *                         .title("title")
 *                         .url("url")
 *                         .build())
 *                 .inAppMessage(CampaignInAppMessageProperty.builder()
 *                         .content(List.of(InAppMessageContentProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .bodyConfig(InAppMessageBodyConfigProperty.builder()
 *                                         .alignment("alignment")
 *                                         .body("body")
 *                                         .textColor("textColor")
 *                                         .build())
 *                                 .headerConfig(InAppMessageHeaderConfigProperty.builder()
 *                                         .alignment("alignment")
 *                                         .header("header")
 *                                         .textColor("textColor")
 *                                         .build())
 *                                 .imageUrl("imageUrl")
 *                                 .primaryBtn(InAppMessageButtonProperty.builder()
 *                                         .android(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                 .backgroundColor("backgroundColor")
 *                                                 .borderRadius(123)
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .text("text")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .web(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .build())
 *                                 .secondaryBtn(InAppMessageButtonProperty.builder()
 *                                         .android(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                                 .backgroundColor("backgroundColor")
 *                                                 .borderRadius(123)
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .text("text")
 *                                                 .textColor("textColor")
 *                                                 .build())
 *                                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .web(OverrideButtonConfigurationProperty.builder()
 *                                                 .buttonAction("buttonAction")
 *                                                 .link("link")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .customConfig(customConfig)
 *                         .layout("layout")
 *                         .build())
 *                 .smsMessage(CampaignSmsMessageProperty.builder()
 *                         .body("body")
 *                         .entityId("entityId")
 *                         .messageType("messageType")
 *                         .originationNumber("originationNumber")
 *                         .senderId("senderId")
 *                         .templateId("templateId")
 *                         .build())
 *                 .build())
 *         .priority(123)
 *         .segmentVersion(123)
 *         .tags(tags)
 *         .templateConfiguration(TemplateConfigurationProperty.builder()
 *                 .emailTemplate(TemplateProperty.builder()
 *                         .name("name")
 *                         .version("version")
 *                         .build())
 *                 .pushTemplate(TemplateProperty.builder()
 *                         .name("name")
 *                         .version("version")
 *                         .build())
 *                 .smsTemplate(TemplateProperty.builder()
 *                         .name("name")
 *                         .version("version")
 *                         .build())
 *                 .voiceTemplate(TemplateProperty.builder()
 *                         .name("name")
 *                         .version("version")
 *                         .build())
 *                 .build())
 *         .treatmentDescription("treatmentDescription")
 *         .treatmentName("treatmentName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign")
public class CfnCampaign extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCampaign(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCampaign(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnCampaign.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pinpoint::Campaign`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCampaign(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnCampaignProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCampaignId() {
        return software.amazon.jsii.Kernel.get(this, "attrCampaignId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the campaign is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application that the campaign is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * The name of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The schedule settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schedule settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnCampaign.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * The schedule settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", java.util.Objects.requireNonNull(value, "schedule is required"));
    }

    /**
     * The unique identifier for the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSegmentId() {
        return software.amazon.jsii.Kernel.get(this, "segmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "segmentId", java.util.Objects.requireNonNull(value, "segmentId is required"));
    }

    /**
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalTreatments() {
        return software.amazon.jsii.Kernel.get(this, "additionalTreatments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalTreatments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalTreatments", value);
    }

    /**
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalTreatments(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "additionalTreatments", value);
    }

    /**
     * Specifies the Lambda function to use as a code hook for a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCampaignHook() {
        return software.amazon.jsii.Kernel.get(this, "campaignHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the Lambda function to use as a code hook for a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCampaignHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignHookProperty value) {
        software.amazon.jsii.Kernel.set(this, "campaignHook", value);
    }

    /**
     * Specifies the Lambda function to use as a code hook for a campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCampaignHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "campaignHook", value);
    }

    /**
     * The delivery configuration settings for sending the treatment through a custom channel.
     * <p>
     * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomDeliveryConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "customDeliveryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The delivery configuration settings for sending the treatment through a custom channel.
     * <p>
     * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDeliveryConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "customDeliveryConfiguration", value);
    }

    /**
     * The delivery configuration settings for sending the treatment through a custom channel.
     * <p>
     * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDeliveryConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customDeliveryConfiguration", value);
    }

    /**
     * A custom description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom description of the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHoldoutPercent() {
        return software.amazon.jsii.Kernel.get(this, "holdoutPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHoldoutPercent(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "holdoutPercent", value);
    }

    /**
     * Specifies whether to pause the campaign.
     * <p>
     * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsPaused() {
        return software.amazon.jsii.Kernel.get(this, "isPaused", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to pause the campaign.
     * <p>
     * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsPaused(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isPaused", value);
    }

    /**
     * Specifies whether to pause the campaign.
     * <p>
     * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsPaused(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isPaused", value);
    }

    /**
     * The messaging limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
        return software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The messaging limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnCampaign.LimitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "limits", value);
    }

    /**
     * The messaging limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "limits", value);
    }

    /**
     * The message configuration settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMessageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "messageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message configuration settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "messageConfiguration", value);
    }

    /**
     * The message configuration settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "messageConfiguration", value);
    }

    /**
     * An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest.
     * <p>
     * If there are multiple messages scheduled to be displayed at the same time, the priority determines the order in which those messages are displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest.
     * <p>
     * If there are multiple messages scheduled to be displayed at the same time, the priority determines the order in which those messages are displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", value);
    }

    /**
     * The version of the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSegmentVersion() {
        return software.amazon.jsii.Kernel.get(this, "segmentVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The version of the segment to associate with the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentVersion(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "segmentVersion", value);
    }

    /**
     * The message template to use for the treatment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTemplateConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The message template to use for the treatment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "templateConfiguration", value);
    }

    /**
     * The message template to use for the treatment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "templateConfiguration", value);
    }

    /**
     * A custom description of the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTreatmentDescription() {
        return software.amazon.jsii.Kernel.get(this, "treatmentDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom description of the default treatment for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatmentDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "treatmentDescription", value);
    }

    /**
     * A custom name of the default treatment for the campaign, if the campaign has multiple treatments.
     * <p>
     * A <em>treatment</em> is a variation of a campaign that's used for A/B testing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTreatmentName() {
        return software.amazon.jsii.Kernel.get(this, "treatmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A custom name of the default treatment for the campaign, if the campaign has multiple treatments.
     * <p>
     * A <em>treatment</em> is a variation of a campaign that's used for A/B testing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "treatmentName", value);
    }
    /**
     * Specifies attribute-based criteria for including or excluding endpoints from a segment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * AttributeDimensionProperty attributeDimensionProperty = AttributeDimensionProperty.builder()
     *         .attributeType("attributeType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of segment dimension to use. Valid values are:.
         * <p>
         * <ul>
         * <li><code>INCLUSIVE</code> – endpoints that have attributes matching the values are included in the segment.</li>
         * <li><code>EXCLUSIVE</code> – endpoints that have attributes matching the values are excluded from the segment.</li>
         * <li><code>CONTAINS</code> – endpoints that have attributes' substrings match the values are included in the segment.</li>
         * <li><code>BEFORE</code> – endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li>
         * <li><code>AFTER</code> – endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
         * <li><code>BETWEEN</code> – endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li>
         * <li><code>ON</code> – endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttributeType() {
            return null;
        }

        /**
         * The criteria values to use for the segment dimension.
         * <p>
         * Depending on the value of the <code>AttributeType</code> property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            java.lang.String attributeType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link AttributeDimensionProperty#getAttributeType}
             * @param attributeType The type of segment dimension to use. Valid values are:.
             *                      <ul>
             *                      <li><code>INCLUSIVE</code> – endpoints that have attributes matching the values are included in the segment.</li>
             *                      <li><code>EXCLUSIVE</code> – endpoints that have attributes matching the values are excluded from the segment.</li>
             *                      <li><code>CONTAINS</code> – endpoints that have attributes' substrings match the values are included in the segment.</li>
             *                      <li><code>BEFORE</code> – endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li>
             *                      <li><code>AFTER</code> – endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
             *                      <li><code>BETWEEN</code> – endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li>
             *                      <li><code>ON</code> – endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeType(java.lang.String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            /**
             * Sets the value of {@link AttributeDimensionProperty#getValues}
             * @param values The criteria values to use for the segment dimension.
             *               Depending on the value of the <code>AttributeType</code> property, endpoints are included or excluded from the segment if their attribute values match the criteria values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDimensionProperty {
            private final java.lang.String attributeType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeType = software.amazon.jsii.Kernel.get(this, "attributeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeType = builder.attributeType;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getAttributeType() {
                return this.attributeType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributeType() != null) {
                    data.set("attributeType", om.valueToTree(this.getAttributeType()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.AttributeDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDimensionProperty.Jsii$Proxy that = (AttributeDimensionProperty.Jsii$Proxy) o;

                if (this.attributeType != null ? !this.attributeType.equals(that.attributeType) : that.attributeType != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributeType != null ? this.attributeType.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the contents of a message that's sent through a custom channel to recipients of a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CampaignCustomMessageProperty campaignCustomMessageProperty = CampaignCustomMessageProperty.builder()
     *         .data("data")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignCustomMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignCustomMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignCustomMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The raw, JSON-formatted string to use as the payload for the message.
         * <p>
         * The maximum size is 5 KB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignCustomMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignCustomMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignCustomMessageProperty> {
            java.lang.String data;

            /**
             * Sets the value of {@link CampaignCustomMessageProperty#getData}
             * @param data The raw, JSON-formatted string to use as the payload for the message.
             *             The maximum size is 5 KB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(java.lang.String data) {
                this.data = data;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignCustomMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignCustomMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignCustomMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignCustomMessageProperty {
            private final java.lang.String data;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.data = software.amazon.jsii.Kernel.get(this, "data", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.data = builder.data;
            }

            @Override
            public final java.lang.String getData() {
                return this.data;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getData() != null) {
                    data.set("data", om.valueToTree(this.getData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignCustomMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignCustomMessageProperty.Jsii$Proxy that = (CampaignCustomMessageProperty.Jsii$Proxy) o;

                return this.data != null ? this.data.equals(that.data) : that.data == null;
            }

            @Override
            public final int hashCode() {
                int result = this.data != null ? this.data.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the content and "From" address for an email message that's sent to recipients of a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CampaignEmailMessageProperty campaignEmailMessageProperty = CampaignEmailMessageProperty.builder()
     *         .body("body")
     *         .fromAddress("fromAddress")
     *         .htmlBody("htmlBody")
     *         .title("title")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEmailMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignEmailMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignEmailMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The body of the email for recipients whose email clients don't render HTML content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The verified email address to send the email from.
         * <p>
         * The default address is the <code>FromAddress</code> specified for the email channel for the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFromAddress() {
            return null;
        }

        /**
         * The body of the email, in HTML format, for recipients whose email clients render HTML content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHtmlBody() {
            return null;
        }

        /**
         * The subject line, or title, of the email.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignEmailMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignEmailMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignEmailMessageProperty> {
            java.lang.String body;
            java.lang.String fromAddress;
            java.lang.String htmlBody;
            java.lang.String title;

            /**
             * Sets the value of {@link CampaignEmailMessageProperty#getBody}
             * @param body The body of the email for recipients whose email clients don't render HTML content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link CampaignEmailMessageProperty#getFromAddress}
             * @param fromAddress The verified email address to send the email from.
             *                    The default address is the <code>FromAddress</code> specified for the email channel for the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromAddress(java.lang.String fromAddress) {
                this.fromAddress = fromAddress;
                return this;
            }

            /**
             * Sets the value of {@link CampaignEmailMessageProperty#getHtmlBody}
             * @param htmlBody The body of the email, in HTML format, for recipients whose email clients render HTML content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder htmlBody(java.lang.String htmlBody) {
                this.htmlBody = htmlBody;
                return this;
            }

            /**
             * Sets the value of {@link CampaignEmailMessageProperty#getTitle}
             * @param title The subject line, or title, of the email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignEmailMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignEmailMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignEmailMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignEmailMessageProperty {
            private final java.lang.String body;
            private final java.lang.String fromAddress;
            private final java.lang.String htmlBody;
            private final java.lang.String title;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fromAddress = software.amazon.jsii.Kernel.get(this, "fromAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.htmlBody = software.amazon.jsii.Kernel.get(this, "htmlBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.body = builder.body;
                this.fromAddress = builder.fromAddress;
                this.htmlBody = builder.htmlBody;
                this.title = builder.title;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getFromAddress() {
                return this.fromAddress;
            }

            @Override
            public final java.lang.String getHtmlBody() {
                return this.htmlBody;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getFromAddress() != null) {
                    data.set("fromAddress", om.valueToTree(this.getFromAddress()));
                }
                if (this.getHtmlBody() != null) {
                    data.set("htmlBody", om.valueToTree(this.getHtmlBody()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEmailMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignEmailMessageProperty.Jsii$Proxy that = (CampaignEmailMessageProperty.Jsii$Proxy) o;

                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.fromAddress != null ? !this.fromAddress.equals(that.fromAddress) : that.fromAddress != null) return false;
                if (this.htmlBody != null ? !this.htmlBody.equals(that.htmlBody) : that.htmlBody != null) return false;
                return this.title != null ? this.title.equals(that.title) : that.title == null;
            }

            @Override
            public final int hashCode() {
                int result = this.body != null ? this.body.hashCode() : 0;
                result = 31 * result + (this.fromAddress != null ? this.fromAddress.hashCode() : 0);
                result = 31 * result + (this.htmlBody != null ? this.htmlBody.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the settings for events that cause a campaign to be sent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * CampaignEventFilterProperty campaignEventFilterProperty = CampaignEventFilterProperty.builder()
     *         .dimensions(EventDimensionsProperty.builder()
     *                 .attributes(attributes)
     *                 .eventType(SetDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .metrics(metrics)
     *                 .build())
     *         .filterType("filterType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEventFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignEventFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignEventFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimension settings of the event filter for the campaign.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The type of event that causes the campaign to be sent.
         * <p>
         * Valid values are: <code>SYSTEM</code> , sends the campaign when a system event occurs; and, <code>ENDPOINT</code> , sends the campaign when an endpoint event (Events resource) occurs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignEventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignEventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignEventFilterProperty> {
            java.lang.Object dimensions;
            java.lang.String filterType;

            /**
             * Sets the value of {@link CampaignEventFilterProperty#getDimensions}
             * @param dimensions The dimension settings of the event filter for the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.services.pinpoint.CfnCampaign.EventDimensionsProperty dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CampaignEventFilterProperty#getDimensions}
             * @param dimensions The dimension settings of the event filter for the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CampaignEventFilterProperty#getFilterType}
             * @param filterType The type of event that causes the campaign to be sent.
             *                   Valid values are: <code>SYSTEM</code> , sends the campaign when a system event occurs; and, <code>ENDPOINT</code> , sends the campaign when an endpoint event (Events resource) occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterType(java.lang.String filterType) {
                this.filterType = filterType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignEventFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignEventFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignEventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignEventFilterProperty {
            private final java.lang.Object dimensions;
            private final java.lang.String filterType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterType = software.amazon.jsii.Kernel.get(this, "filterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.filterType = builder.filterType;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getFilterType() {
                return this.filterType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getFilterType() != null) {
                    data.set("filterType", om.valueToTree(this.getFilterType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignEventFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignEventFilterProperty.Jsii$Proxy that = (CampaignEventFilterProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.filterType != null ? this.filterType.equals(that.filterType) : that.filterType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.filterType != null ? this.filterType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies settings for invoking an Lambda function that customizes a segment for a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CampaignHookProperty campaignHookProperty = CampaignHookProperty.builder()
     *         .lambdaFunctionName("lambdaFunctionName")
     *         .mode("mode")
     *         .webUrl("webUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignHookProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name or Amazon Resource Name (ARN) of the Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionName() {
            return null;
        }

        /**
         * The mode that Amazon Pinpoint uses to invoke the Lambda function. Possible values are:.
         * <p>
         * <ul>
         * <li><code>FILTER</code> - Invoke the function to customize the segment that's used by a campaign.</li>
         * <li><code>DELIVERY</code> - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the <code>CustomDeliveryConfiguration</code> and <code>CampaignCustomMessage</code> objects of the campaign.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The web URL that Amazon Pinpoint calls to invoke the Lambda function over HTTPS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignHookProperty> {
            java.lang.String lambdaFunctionName;
            java.lang.String mode;
            java.lang.String webUrl;

            /**
             * Sets the value of {@link CampaignHookProperty#getLambdaFunctionName}
             * @param lambdaFunctionName The name or Amazon Resource Name (ARN) of the Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionName(java.lang.String lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            /**
             * Sets the value of {@link CampaignHookProperty#getMode}
             * @param mode The mode that Amazon Pinpoint uses to invoke the Lambda function. Possible values are:.
             *             <ul>
             *             <li><code>FILTER</code> - Invoke the function to customize the segment that's used by a campaign.</li>
             *             <li><code>DELIVERY</code> - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the <code>CustomDeliveryConfiguration</code> and <code>CampaignCustomMessage</code> objects of the campaign.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link CampaignHookProperty#getWebUrl}
             * @param webUrl The web URL that Amazon Pinpoint calls to invoke the Lambda function over HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webUrl(java.lang.String webUrl) {
                this.webUrl = webUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignHookProperty {
            private final java.lang.String lambdaFunctionName;
            private final java.lang.String mode;
            private final java.lang.String webUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaFunctionName = software.amazon.jsii.Kernel.get(this, "lambdaFunctionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.webUrl = software.amazon.jsii.Kernel.get(this, "webUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaFunctionName = builder.lambdaFunctionName;
                this.mode = builder.mode;
                this.webUrl = builder.webUrl;
            }

            @Override
            public final java.lang.String getLambdaFunctionName() {
                return this.lambdaFunctionName;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getWebUrl() {
                return this.webUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaFunctionName() != null) {
                    data.set("lambdaFunctionName", om.valueToTree(this.getLambdaFunctionName()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getWebUrl() != null) {
                    data.set("webUrl", om.valueToTree(this.getWebUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignHookProperty.Jsii$Proxy that = (CampaignHookProperty.Jsii$Proxy) o;

                if (this.lambdaFunctionName != null ? !this.lambdaFunctionName.equals(that.lambdaFunctionName) : that.lambdaFunctionName != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.webUrl != null ? this.webUrl.equals(that.webUrl) : that.webUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaFunctionName != null ? this.lambdaFunctionName.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.webUrl != null ? this.webUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the appearance of an in-app message, including the message type, the title and body text, text and background colors, and the configurations of buttons that appear in the message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object customConfig;
     * CampaignInAppMessageProperty campaignInAppMessageProperty = CampaignInAppMessageProperty.builder()
     *         .content(List.of(InAppMessageContentProperty.builder()
     *                 .backgroundColor("backgroundColor")
     *                 .bodyConfig(InAppMessageBodyConfigProperty.builder()
     *                         .alignment("alignment")
     *                         .body("body")
     *                         .textColor("textColor")
     *                         .build())
     *                 .headerConfig(InAppMessageHeaderConfigProperty.builder()
     *                         .alignment("alignment")
     *                         .header("header")
     *                         .textColor("textColor")
     *                         .build())
     *                 .imageUrl("imageUrl")
     *                 .primaryBtn(InAppMessageButtonProperty.builder()
     *                         .android(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                 .backgroundColor("backgroundColor")
     *                                 .borderRadius(123)
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .text("text")
     *                                 .textColor("textColor")
     *                                 .build())
     *                         .ios(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .web(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .build())
     *                 .secondaryBtn(InAppMessageButtonProperty.builder()
     *                         .android(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                 .backgroundColor("backgroundColor")
     *                                 .borderRadius(123)
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .text("text")
     *                                 .textColor("textColor")
     *                                 .build())
     *                         .ios(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .web(OverrideButtonConfigurationProperty.builder()
     *                                 .buttonAction("buttonAction")
     *                                 .link("link")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .customConfig(customConfig)
     *         .layout("layout")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignInAppMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignInAppMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignInAppMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array that contains configurtion information about the in-app message for the campaign, including title and body text, text colors, background colors, image URLs, and button configurations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContent() {
            return null;
        }

        /**
         * Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConfig() {
            return null;
        }

        /**
         * A string that describes how the in-app message will appear. You can specify one of the following:.
         * <p>
         * <ul>
         * <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
         * <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
         * <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
         * <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
         * <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
         * <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLayout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignInAppMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignInAppMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignInAppMessageProperty> {
            java.lang.Object content;
            java.lang.Object customConfig;
            java.lang.String layout;

            /**
             * Sets the value of {@link CampaignInAppMessageProperty#getContent}
             * @param content An array that contains configurtion information about the in-app message for the campaign, including title and body text, text colors, background colors, image URLs, and button configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(software.amazon.awscdk.IResolvable content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link CampaignInAppMessageProperty#getContent}
             * @param content An array that contains configurtion information about the in-app message for the campaign, including title and body text, text colors, background colors, image URLs, and button configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.util.List<? extends java.lang.Object> content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link CampaignInAppMessageProperty#getCustomConfig}
             * @param customConfig Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConfig(java.lang.Object customConfig) {
                this.customConfig = customConfig;
                return this;
            }

            /**
             * Sets the value of {@link CampaignInAppMessageProperty#getLayout}
             * @param layout A string that describes how the in-app message will appear. You can specify one of the following:.
             *               <ul>
             *               <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
             *               <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
             *               <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
             *               <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
             *               <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
             *               <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder layout(java.lang.String layout) {
                this.layout = layout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignInAppMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignInAppMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignInAppMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignInAppMessageProperty {
            private final java.lang.Object content;
            private final java.lang.Object customConfig;
            private final java.lang.String layout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customConfig = software.amazon.jsii.Kernel.get(this, "customConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.layout = software.amazon.jsii.Kernel.get(this, "layout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = builder.content;
                this.customConfig = builder.customConfig;
                this.layout = builder.layout;
            }

            @Override
            public final java.lang.Object getContent() {
                return this.content;
            }

            @Override
            public final java.lang.Object getCustomConfig() {
                return this.customConfig;
            }

            @Override
            public final java.lang.String getLayout() {
                return this.layout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContent() != null) {
                    data.set("content", om.valueToTree(this.getContent()));
                }
                if (this.getCustomConfig() != null) {
                    data.set("customConfig", om.valueToTree(this.getCustomConfig()));
                }
                if (this.getLayout() != null) {
                    data.set("layout", om.valueToTree(this.getLayout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignInAppMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignInAppMessageProperty.Jsii$Proxy that = (CampaignInAppMessageProperty.Jsii$Proxy) o;

                if (this.content != null ? !this.content.equals(that.content) : that.content != null) return false;
                if (this.customConfig != null ? !this.customConfig.equals(that.customConfig) : that.customConfig != null) return false;
                return this.layout != null ? this.layout.equals(that.layout) : that.layout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.content != null ? this.content.hashCode() : 0;
                result = 31 * result + (this.customConfig != null ? this.customConfig.hashCode() : 0);
                result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the content and settings for an SMS message that's sent to recipients of a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CampaignSmsMessageProperty campaignSmsMessageProperty = CampaignSmsMessageProperty.builder()
     *         .body("body")
     *         .entityId("entityId")
     *         .messageType("messageType")
     *         .originationNumber("originationNumber")
     *         .senderId("senderId")
     *         .templateId("templateId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignSmsMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignSmsMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignSmsMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The body of the SMS message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityId() {
            return null;
        }

        /**
         * The SMS message type.
         * <p>
         * Valid values are <code>TRANSACTIONAL</code> (for messages that are critical or time-sensitive, such as a one-time passwords) and <code>PROMOTIONAL</code> (for messsages that aren't critical or time-sensitive, such as marketing messages).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageType() {
            return null;
        }

        /**
         * The long code to send the SMS message from.
         * <p>
         * This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginationNumber() {
            return null;
        }

        /**
         * The alphabetic Sender ID to display as the sender of the message on a recipient's device.
         * <p>
         * Support for sender IDs varies by country or region. To specify a phone number as the sender, omit this parameter and use <code>OriginationNumber</code> instead. For more information about support for Sender ID by country, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Amazon Pinpoint User Guide</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSenderId() {
            return null;
        }

        /**
         * The template ID received from the regulatory body for sending SMS in your country.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplateId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignSmsMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignSmsMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignSmsMessageProperty> {
            java.lang.String body;
            java.lang.String entityId;
            java.lang.String messageType;
            java.lang.String originationNumber;
            java.lang.String senderId;
            java.lang.String templateId;

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getBody}
             * @param body The body of the SMS message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getEntityId}
             * @param entityId The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityId(java.lang.String entityId) {
                this.entityId = entityId;
                return this;
            }

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getMessageType}
             * @param messageType The SMS message type.
             *                    Valid values are <code>TRANSACTIONAL</code> (for messages that are critical or time-sensitive, such as a one-time passwords) and <code>PROMOTIONAL</code> (for messsages that aren't critical or time-sensitive, such as marketing messages).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageType(java.lang.String messageType) {
                this.messageType = messageType;
                return this;
            }

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getOriginationNumber}
             * @param originationNumber The long code to send the SMS message from.
             *                          This value should be one of the dedicated long codes that's assigned to your AWS account. Although it isn't required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originationNumber(java.lang.String originationNumber) {
                this.originationNumber = originationNumber;
                return this;
            }

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getSenderId}
             * @param senderId The alphabetic Sender ID to display as the sender of the message on a recipient's device.
             *                 Support for sender IDs varies by country or region. To specify a phone number as the sender, omit this parameter and use <code>OriginationNumber</code> instead. For more information about support for Sender ID by country, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Amazon Pinpoint User Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder senderId(java.lang.String senderId) {
                this.senderId = senderId;
                return this;
            }

            /**
             * Sets the value of {@link CampaignSmsMessageProperty#getTemplateId}
             * @param templateId The template ID received from the regulatory body for sending SMS in your country.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateId(java.lang.String templateId) {
                this.templateId = templateId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignSmsMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignSmsMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignSmsMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignSmsMessageProperty {
            private final java.lang.String body;
            private final java.lang.String entityId;
            private final java.lang.String messageType;
            private final java.lang.String originationNumber;
            private final java.lang.String senderId;
            private final java.lang.String templateId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entityId = software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageType = software.amazon.jsii.Kernel.get(this, "messageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originationNumber = software.amazon.jsii.Kernel.get(this, "originationNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.senderId = software.amazon.jsii.Kernel.get(this, "senderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateId = software.amazon.jsii.Kernel.get(this, "templateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.body = builder.body;
                this.entityId = builder.entityId;
                this.messageType = builder.messageType;
                this.originationNumber = builder.originationNumber;
                this.senderId = builder.senderId;
                this.templateId = builder.templateId;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getEntityId() {
                return this.entityId;
            }

            @Override
            public final java.lang.String getMessageType() {
                return this.messageType;
            }

            @Override
            public final java.lang.String getOriginationNumber() {
                return this.originationNumber;
            }

            @Override
            public final java.lang.String getSenderId() {
                return this.senderId;
            }

            @Override
            public final java.lang.String getTemplateId() {
                return this.templateId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getEntityId() != null) {
                    data.set("entityId", om.valueToTree(this.getEntityId()));
                }
                if (this.getMessageType() != null) {
                    data.set("messageType", om.valueToTree(this.getMessageType()));
                }
                if (this.getOriginationNumber() != null) {
                    data.set("originationNumber", om.valueToTree(this.getOriginationNumber()));
                }
                if (this.getSenderId() != null) {
                    data.set("senderId", om.valueToTree(this.getSenderId()));
                }
                if (this.getTemplateId() != null) {
                    data.set("templateId", om.valueToTree(this.getTemplateId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CampaignSmsMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignSmsMessageProperty.Jsii$Proxy that = (CampaignSmsMessageProperty.Jsii$Proxy) o;

                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) return false;
                if (this.messageType != null ? !this.messageType.equals(that.messageType) : that.messageType != null) return false;
                if (this.originationNumber != null ? !this.originationNumber.equals(that.originationNumber) : that.originationNumber != null) return false;
                if (this.senderId != null ? !this.senderId.equals(that.senderId) : that.senderId != null) return false;
                return this.templateId != null ? this.templateId.equals(that.templateId) : that.templateId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.body != null ? this.body.hashCode() : 0;
                result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
                result = 31 * result + (this.messageType != null ? this.messageType.hashCode() : 0);
                result = 31 * result + (this.originationNumber != null ? this.originationNumber.hashCode() : 0);
                result = 31 * result + (this.senderId != null ? this.senderId.hashCode() : 0);
                result = 31 * result + (this.templateId != null ? this.templateId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the delivery configuration settings for sending a campaign or campaign treatment through a custom channel.
     * <p>
     * This object is required if you use the <code>CampaignCustomMessage</code> object to define the message to send for the campaign or campaign treatment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CustomDeliveryConfigurationProperty customDeliveryConfigurationProperty = CustomDeliveryConfigurationProperty.builder()
     *         .deliveryUri("deliveryUri")
     *         .endpointTypes(List.of("endpointTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomDeliveryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomDeliveryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination to send the campaign or treatment to. This value can be one of the following:.
         * <p>
         * <ul>
         * <li>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</li>
         * <li>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryUri() {
            return null;
        }

        /**
         * The types of endpoints to send the campaign or treatment to.
         * <p>
         * Each valid value maps to a type of channel that you can associate with an endpoint by using the <code>ChannelType</code> property of an endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndpointTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomDeliveryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomDeliveryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomDeliveryConfigurationProperty> {
            java.lang.String deliveryUri;
            java.util.List<java.lang.String> endpointTypes;

            /**
             * Sets the value of {@link CustomDeliveryConfigurationProperty#getDeliveryUri}
             * @param deliveryUri The destination to send the campaign or treatment to. This value can be one of the following:.
             *                    <ul>
             *                    <li>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</li>
             *                    <li>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryUri(java.lang.String deliveryUri) {
                this.deliveryUri = deliveryUri;
                return this;
            }

            /**
             * Sets the value of {@link CustomDeliveryConfigurationProperty#getEndpointTypes}
             * @param endpointTypes The types of endpoints to send the campaign or treatment to.
             *                      Each valid value maps to a type of channel that you can associate with an endpoint by using the <code>ChannelType</code> property of an endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointTypes(java.util.List<java.lang.String> endpointTypes) {
                this.endpointTypes = endpointTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomDeliveryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomDeliveryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomDeliveryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomDeliveryConfigurationProperty {
            private final java.lang.String deliveryUri;
            private final java.util.List<java.lang.String> endpointTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryUri = software.amazon.jsii.Kernel.get(this, "deliveryUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointTypes = software.amazon.jsii.Kernel.get(this, "endpointTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryUri = builder.deliveryUri;
                this.endpointTypes = builder.endpointTypes;
            }

            @Override
            public final java.lang.String getDeliveryUri() {
                return this.deliveryUri;
            }

            @Override
            public final java.util.List<java.lang.String> getEndpointTypes() {
                return this.endpointTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeliveryUri() != null) {
                    data.set("deliveryUri", om.valueToTree(this.getDeliveryUri()));
                }
                if (this.getEndpointTypes() != null) {
                    data.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomDeliveryConfigurationProperty.Jsii$Proxy that = (CustomDeliveryConfigurationProperty.Jsii$Proxy) o;

                if (this.deliveryUri != null ? !this.deliveryUri.equals(that.deliveryUri) : that.deliveryUri != null) return false;
                return this.endpointTypes != null ? this.endpointTypes.equals(that.endpointTypes) : that.endpointTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryUri != null ? this.deliveryUri.hashCode() : 0;
                result = 31 * result + (this.endpointTypes != null ? this.endpointTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default behavior for a button that appears in an in-app message.
     * <p>
     * You can optionally add button configurations that specifically apply to iOS, Android, or web browser users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * DefaultButtonConfigurationProperty defaultButtonConfigurationProperty = DefaultButtonConfigurationProperty.builder()
     *         .backgroundColor("backgroundColor")
     *         .borderRadius(123)
     *         .buttonAction("buttonAction")
     *         .link("link")
     *         .text("text")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.DefaultButtonConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultButtonConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultButtonConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The background color of a button, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * The border radius of a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBorderRadius() {
            return null;
        }

        /**
         * The action that occurs when a recipient chooses a button in an in-app message.
         * <p>
         * You can specify one of the following:
         * <p>
         * <ul>
         * <li><code>LINK</code> – A link to a web destination.</li>
         * <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
         * <li><code>CLOSE</code> – Dismisses the message.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getButtonAction() {
            return null;
        }

        /**
         * The destination (such as a URL) for a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLink() {
            return null;
        }

        /**
         * The text that appears on a button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * The color of the body text in a button, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultButtonConfigurationProperty> {
            java.lang.String backgroundColor;
            java.lang.Number borderRadius;
            java.lang.String buttonAction;
            java.lang.String link;
            java.lang.String text;
            java.lang.String textColor;

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getBackgroundColor}
             * @param backgroundColor The background color of a button, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getBorderRadius}
             * @param borderRadius The border radius of a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder borderRadius(java.lang.Number borderRadius) {
                this.borderRadius = borderRadius;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getButtonAction}
             * @param buttonAction The action that occurs when a recipient chooses a button in an in-app message.
             *                     You can specify one of the following:
             *                     <p>
             *                     <ul>
             *                     <li><code>LINK</code> – A link to a web destination.</li>
             *                     <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
             *                     <li><code>CLOSE</code> – Dismisses the message.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttonAction(java.lang.String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getLink}
             * @param link The destination (such as a URL) for a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder link(java.lang.String link) {
                this.link = link;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getText}
             * @param text The text that appears on a button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link DefaultButtonConfigurationProperty#getTextColor}
             * @param textColor The color of the body text in a button, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultButtonConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultButtonConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultButtonConfigurationProperty {
            private final java.lang.String backgroundColor;
            private final java.lang.Number borderRadius;
            private final java.lang.String buttonAction;
            private final java.lang.String link;
            private final java.lang.String text;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.borderRadius = software.amazon.jsii.Kernel.get(this, "borderRadius", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.buttonAction = software.amazon.jsii.Kernel.get(this, "buttonAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.link = software.amazon.jsii.Kernel.get(this, "link", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backgroundColor = builder.backgroundColor;
                this.borderRadius = builder.borderRadius;
                this.buttonAction = builder.buttonAction;
                this.link = builder.link;
                this.text = builder.text;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBorderRadius() {
                return this.borderRadius;
            }

            @Override
            public final java.lang.String getButtonAction() {
                return this.buttonAction;
            }

            @Override
            public final java.lang.String getLink() {
                return this.link;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBorderRadius() != null) {
                    data.set("borderRadius", om.valueToTree(this.getBorderRadius()));
                }
                if (this.getButtonAction() != null) {
                    data.set("buttonAction", om.valueToTree(this.getButtonAction()));
                }
                if (this.getLink() != null) {
                    data.set("link", om.valueToTree(this.getLink()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.DefaultButtonConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultButtonConfigurationProperty.Jsii$Proxy that = (DefaultButtonConfigurationProperty.Jsii$Proxy) o;

                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.borderRadius != null ? !this.borderRadius.equals(that.borderRadius) : that.borderRadius != null) return false;
                if (this.buttonAction != null ? !this.buttonAction.equals(that.buttonAction) : that.buttonAction != null) return false;
                if (this.link != null ? !this.link.equals(that.link) : that.link != null) return false;
                if (this.text != null ? !this.text.equals(that.text) : that.text != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backgroundColor != null ? this.backgroundColor.hashCode() : 0;
                result = 31 * result + (this.borderRadius != null ? this.borderRadius.hashCode() : 0);
                result = 31 * result + (this.buttonAction != null ? this.buttonAction.hashCode() : 0);
                result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the dimensions for an event filter that determines when a campaign is sent or a journey activity is performed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * EventDimensionsProperty eventDimensionsProperty = EventDimensionsProperty.builder()
     *         .attributes(attributes)
     *         .eventType(SetDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .metrics(metrics)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.EventDimensionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EventDimensionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventDimensionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more custom attributes that your application reports to Amazon Pinpoint.
         * <p>
         * You can use these attributes as selection criteria when you create an event filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * The name of the event that causes the campaign to be sent or the journey activity to be performed.
         * <p>
         * This can be a standard event that Amazon Pinpoint generates, such as <code>_email.delivered</code> . For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <em>Amazon Pinpoint Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventType() {
            return null;
        }

        /**
         * One or more custom metrics that your application reports to Amazon Pinpoint .
         * <p>
         * You can use these metrics as selection criteria when you create an event filter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventDimensionsProperty> {
            java.lang.Object attributes;
            java.lang.Object eventType;
            java.lang.Object metrics;

            /**
             * Sets the value of {@link EventDimensionsProperty#getAttributes}
             * @param attributes One or more custom attributes that your application reports to Amazon Pinpoint.
             *                   You can use these attributes as selection criteria when you create an event filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.lang.Object attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link EventDimensionsProperty#getEventType}
             * @param eventType The name of the event that causes the campaign to be sent or the journey activity to be performed.
             *                  This can be a standard event that Amazon Pinpoint generates, such as <code>_email.delivered</code> . For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <em>Amazon Pinpoint Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(software.amazon.awscdk.services.pinpoint.CfnCampaign.SetDimensionProperty eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link EventDimensionsProperty#getEventType}
             * @param eventType The name of the event that causes the campaign to be sent or the journey activity to be performed.
             *                  This can be a standard event that Amazon Pinpoint generates, such as <code>_email.delivered</code> . For campaigns, this can also be a custom event that's specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <em>Amazon Pinpoint Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(software.amazon.awscdk.IResolvable eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link EventDimensionsProperty#getMetrics}
             * @param metrics One or more custom metrics that your application reports to Amazon Pinpoint .
             *                You can use these metrics as selection criteria when you create an event filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metrics(java.lang.Object metrics) {
                this.metrics = metrics;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventDimensionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventDimensionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventDimensionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventDimensionsProperty {
            private final java.lang.Object attributes;
            private final java.lang.Object eventType;
            private final java.lang.Object metrics;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
                this.eventType = builder.eventType;
                this.metrics = builder.metrics;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Object getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.Object getMetrics() {
                return this.metrics;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getMetrics() != null) {
                    data.set("metrics", om.valueToTree(this.getMetrics()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.EventDimensionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventDimensionsProperty.Jsii$Proxy that = (EventDimensionsProperty.Jsii$Proxy) o;

                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                return this.metrics != null ? this.metrics.equals(that.metrics) : that.metrics == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
                result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of main body text of the in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * InAppMessageBodyConfigProperty inAppMessageBodyConfigProperty = InAppMessageBodyConfigProperty.builder()
     *         .alignment("alignment")
     *         .body("body")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageBodyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InAppMessageBodyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InAppMessageBodyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text alignment of the main body text of the message.
         * <p>
         * Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * The main body text of the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The color of the body text, expressed as a string consisting of a hex color code (such as "#000000" for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InAppMessageBodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InAppMessageBodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InAppMessageBodyConfigProperty> {
            java.lang.String alignment;
            java.lang.String body;
            java.lang.String textColor;

            /**
             * Sets the value of {@link InAppMessageBodyConfigProperty#getAlignment}
             * @param alignment The text alignment of the main body text of the message.
             *                  Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageBodyConfigProperty#getBody}
             * @param body The main body text of the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageBodyConfigProperty#getTextColor}
             * @param textColor The color of the body text, expressed as a string consisting of a hex color code (such as "#000000" for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InAppMessageBodyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InAppMessageBodyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InAppMessageBodyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InAppMessageBodyConfigProperty {
            private final java.lang.String alignment;
            private final java.lang.String body;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.body = builder.body;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageBodyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InAppMessageBodyConfigProperty.Jsii$Proxy that = (InAppMessageBodyConfigProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a button that appears in an in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * InAppMessageButtonProperty inAppMessageButtonProperty = InAppMessageButtonProperty.builder()
     *         .android(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                 .backgroundColor("backgroundColor")
     *                 .borderRadius(123)
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .text("text")
     *                 .textColor("textColor")
     *                 .build())
     *         .ios(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .web(OverrideButtonConfigurationProperty.builder()
     *                 .buttonAction("buttonAction")
     *                 .link("link")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageButtonProperty")
    @software.amazon.jsii.Jsii.Proxy(InAppMessageButtonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InAppMessageButtonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that defines the default behavior for a button in in-app messages sent to Android.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndroid() {
            return null;
        }

        /**
         * An object that defines the default behavior for a button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultConfig() {
            return null;
        }

        /**
         * An object that defines the default behavior for a button in in-app messages sent to iOS devices.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIos() {
            return null;
        }

        /**
         * An object that defines the default behavior for a button in in-app messages for web applications.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InAppMessageButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InAppMessageButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InAppMessageButtonProperty> {
            java.lang.Object android;
            java.lang.Object defaultConfig;
            java.lang.Object ios;
            java.lang.Object web;

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getAndroid}
             * @param android An object that defines the default behavior for a button in in-app messages sent to Android.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder android(software.amazon.awscdk.services.pinpoint.CfnCampaign.OverrideButtonConfigurationProperty android) {
                this.android = android;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getAndroid}
             * @param android An object that defines the default behavior for a button in in-app messages sent to Android.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder android(software.amazon.awscdk.IResolvable android) {
                this.android = android;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getDefaultConfig}
             * @param defaultConfig An object that defines the default behavior for a button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.services.pinpoint.CfnCampaign.DefaultButtonConfigurationProperty defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getDefaultConfig}
             * @param defaultConfig An object that defines the default behavior for a button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.IResolvable defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getIos}
             * @param ios An object that defines the default behavior for a button in in-app messages sent to iOS devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ios(software.amazon.awscdk.services.pinpoint.CfnCampaign.OverrideButtonConfigurationProperty ios) {
                this.ios = ios;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getIos}
             * @param ios An object that defines the default behavior for a button in in-app messages sent to iOS devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ios(software.amazon.awscdk.IResolvable ios) {
                this.ios = ios;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getWeb}
             * @param web An object that defines the default behavior for a button in in-app messages for web applications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder web(software.amazon.awscdk.services.pinpoint.CfnCampaign.OverrideButtonConfigurationProperty web) {
                this.web = web;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageButtonProperty#getWeb}
             * @param web An object that defines the default behavior for a button in in-app messages for web applications.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder web(software.amazon.awscdk.IResolvable web) {
                this.web = web;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InAppMessageButtonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InAppMessageButtonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InAppMessageButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InAppMessageButtonProperty {
            private final java.lang.Object android;
            private final java.lang.Object defaultConfig;
            private final java.lang.Object ios;
            private final java.lang.Object web;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.android = software.amazon.jsii.Kernel.get(this, "android", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultConfig = software.amazon.jsii.Kernel.get(this, "defaultConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ios = software.amazon.jsii.Kernel.get(this, "ios", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.web = software.amazon.jsii.Kernel.get(this, "web", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.android = builder.android;
                this.defaultConfig = builder.defaultConfig;
                this.ios = builder.ios;
                this.web = builder.web;
            }

            @Override
            public final java.lang.Object getAndroid() {
                return this.android;
            }

            @Override
            public final java.lang.Object getDefaultConfig() {
                return this.defaultConfig;
            }

            @Override
            public final java.lang.Object getIos() {
                return this.ios;
            }

            @Override
            public final java.lang.Object getWeb() {
                return this.web;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndroid() != null) {
                    data.set("android", om.valueToTree(this.getAndroid()));
                }
                if (this.getDefaultConfig() != null) {
                    data.set("defaultConfig", om.valueToTree(this.getDefaultConfig()));
                }
                if (this.getIos() != null) {
                    data.set("ios", om.valueToTree(this.getIos()));
                }
                if (this.getWeb() != null) {
                    data.set("web", om.valueToTree(this.getWeb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageButtonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InAppMessageButtonProperty.Jsii$Proxy that = (InAppMessageButtonProperty.Jsii$Proxy) o;

                if (this.android != null ? !this.android.equals(that.android) : that.android != null) return false;
                if (this.defaultConfig != null ? !this.defaultConfig.equals(that.defaultConfig) : that.defaultConfig != null) return false;
                if (this.ios != null ? !this.ios.equals(that.ios) : that.ios != null) return false;
                return this.web != null ? this.web.equals(that.web) : that.web == null;
            }

            @Override
            public final int hashCode() {
                int result = this.android != null ? this.android.hashCode() : 0;
                result = 31 * result + (this.defaultConfig != null ? this.defaultConfig.hashCode() : 0);
                result = 31 * result + (this.ios != null ? this.ios.hashCode() : 0);
                result = 31 * result + (this.web != null ? this.web.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration and contents of an in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * InAppMessageContentProperty inAppMessageContentProperty = InAppMessageContentProperty.builder()
     *         .backgroundColor("backgroundColor")
     *         .bodyConfig(InAppMessageBodyConfigProperty.builder()
     *                 .alignment("alignment")
     *                 .body("body")
     *                 .textColor("textColor")
     *                 .build())
     *         .headerConfig(InAppMessageHeaderConfigProperty.builder()
     *                 .alignment("alignment")
     *                 .header("header")
     *                 .textColor("textColor")
     *                 .build())
     *         .imageUrl("imageUrl")
     *         .primaryBtn(InAppMessageButtonProperty.builder()
     *                 .android(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                         .backgroundColor("backgroundColor")
     *                         .borderRadius(123)
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .text("text")
     *                         .textColor("textColor")
     *                         .build())
     *                 .ios(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .web(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .build())
     *         .secondaryBtn(InAppMessageButtonProperty.builder()
     *                 .android(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                         .backgroundColor("backgroundColor")
     *                         .borderRadius(123)
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .text("text")
     *                         .textColor("textColor")
     *                         .build())
     *                 .ios(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .web(OverrideButtonConfigurationProperty.builder()
     *                         .buttonAction("buttonAction")
     *                         .link("link")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageContentProperty")
    @software.amazon.jsii.Jsii.Proxy(InAppMessageContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InAppMessageContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The background color for an in-app message banner, expressed as a hex color code (such as #000000 for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * Specifies the configuration of main body text in an in-app message template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBodyConfig() {
            return null;
        }

        /**
         * Specifies the configuration and content of the header or title text of the in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaderConfig() {
            return null;
        }

        /**
         * The URL of the image that appears on an in-app message banner.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * An object that contains configuration information about the primary button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryBtn() {
            return null;
        }

        /**
         * An object that contains configuration information about the secondary button in an in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecondaryBtn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InAppMessageContentProperty> {
            java.lang.String backgroundColor;
            java.lang.Object bodyConfig;
            java.lang.Object headerConfig;
            java.lang.String imageUrl;
            java.lang.Object primaryBtn;
            java.lang.Object secondaryBtn;

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBackgroundColor}
             * @param backgroundColor The background color for an in-app message banner, expressed as a hex color code (such as #000000 for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBodyConfig}
             * @param bodyConfig Specifies the configuration of main body text in an in-app message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyConfig(software.amazon.awscdk.services.pinpoint.CfnCampaign.InAppMessageBodyConfigProperty bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getBodyConfig}
             * @param bodyConfig Specifies the configuration of main body text in an in-app message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bodyConfig(software.amazon.awscdk.IResolvable bodyConfig) {
                this.bodyConfig = bodyConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getHeaderConfig}
             * @param headerConfig Specifies the configuration and content of the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerConfig(software.amazon.awscdk.services.pinpoint.CfnCampaign.InAppMessageHeaderConfigProperty headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getHeaderConfig}
             * @param headerConfig Specifies the configuration and content of the header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerConfig(software.amazon.awscdk.IResolvable headerConfig) {
                this.headerConfig = headerConfig;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getImageUrl}
             * @param imageUrl The URL of the image that appears on an in-app message banner.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getPrimaryBtn}
             * @param primaryBtn An object that contains configuration information about the primary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryBtn(software.amazon.awscdk.services.pinpoint.CfnCampaign.InAppMessageButtonProperty primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getPrimaryBtn}
             * @param primaryBtn An object that contains configuration information about the primary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryBtn(software.amazon.awscdk.IResolvable primaryBtn) {
                this.primaryBtn = primaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getSecondaryBtn}
             * @param secondaryBtn An object that contains configuration information about the secondary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryBtn(software.amazon.awscdk.services.pinpoint.CfnCampaign.InAppMessageButtonProperty secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageContentProperty#getSecondaryBtn}
             * @param secondaryBtn An object that contains configuration information about the secondary button in an in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryBtn(software.amazon.awscdk.IResolvable secondaryBtn) {
                this.secondaryBtn = secondaryBtn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InAppMessageContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InAppMessageContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InAppMessageContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InAppMessageContentProperty {
            private final java.lang.String backgroundColor;
            private final java.lang.Object bodyConfig;
            private final java.lang.Object headerConfig;
            private final java.lang.String imageUrl;
            private final java.lang.Object primaryBtn;
            private final java.lang.Object secondaryBtn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bodyConfig = software.amazon.jsii.Kernel.get(this, "bodyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headerConfig = software.amazon.jsii.Kernel.get(this, "headerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryBtn = software.amazon.jsii.Kernel.get(this, "primaryBtn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secondaryBtn = software.amazon.jsii.Kernel.get(this, "secondaryBtn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backgroundColor = builder.backgroundColor;
                this.bodyConfig = builder.bodyConfig;
                this.headerConfig = builder.headerConfig;
                this.imageUrl = builder.imageUrl;
                this.primaryBtn = builder.primaryBtn;
                this.secondaryBtn = builder.secondaryBtn;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Object getBodyConfig() {
                return this.bodyConfig;
            }

            @Override
            public final java.lang.Object getHeaderConfig() {
                return this.headerConfig;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.Object getPrimaryBtn() {
                return this.primaryBtn;
            }

            @Override
            public final java.lang.Object getSecondaryBtn() {
                return this.secondaryBtn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBodyConfig() != null) {
                    data.set("bodyConfig", om.valueToTree(this.getBodyConfig()));
                }
                if (this.getHeaderConfig() != null) {
                    data.set("headerConfig", om.valueToTree(this.getHeaderConfig()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getPrimaryBtn() != null) {
                    data.set("primaryBtn", om.valueToTree(this.getPrimaryBtn()));
                }
                if (this.getSecondaryBtn() != null) {
                    data.set("secondaryBtn", om.valueToTree(this.getSecondaryBtn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InAppMessageContentProperty.Jsii$Proxy that = (InAppMessageContentProperty.Jsii$Proxy) o;

                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.bodyConfig != null ? !this.bodyConfig.equals(that.bodyConfig) : that.bodyConfig != null) return false;
                if (this.headerConfig != null ? !this.headerConfig.equals(that.headerConfig) : that.headerConfig != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                if (this.primaryBtn != null ? !this.primaryBtn.equals(that.primaryBtn) : that.primaryBtn != null) return false;
                return this.secondaryBtn != null ? this.secondaryBtn.equals(that.secondaryBtn) : that.secondaryBtn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.backgroundColor != null ? this.backgroundColor.hashCode() : 0;
                result = 31 * result + (this.bodyConfig != null ? this.bodyConfig.hashCode() : 0);
                result = 31 * result + (this.headerConfig != null ? this.headerConfig.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.primaryBtn != null ? this.primaryBtn.hashCode() : 0);
                result = 31 * result + (this.secondaryBtn != null ? this.secondaryBtn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration and content of the header or title text of the in-app message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * InAppMessageHeaderConfigProperty inAppMessageHeaderConfigProperty = InAppMessageHeaderConfigProperty.builder()
     *         .alignment("alignment")
     *         .header("header")
     *         .textColor("textColor")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageHeaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InAppMessageHeaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InAppMessageHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text alignment of the title of the message.
         * <p>
         * Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * The header or title text of the in-app message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHeader() {
            return null;
        }

        /**
         * The color of the body text, expressed as a string consisting of a hex color code (such as "#000000" for black).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextColor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InAppMessageHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InAppMessageHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InAppMessageHeaderConfigProperty> {
            java.lang.String alignment;
            java.lang.String header;
            java.lang.String textColor;

            /**
             * Sets the value of {@link InAppMessageHeaderConfigProperty#getAlignment}
             * @param alignment The text alignment of the title of the message.
             *                  Acceptable values: <code>LEFT</code> , <code>CENTER</code> , <code>RIGHT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageHeaderConfigProperty#getHeader}
             * @param header The header or title text of the in-app message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.String header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link InAppMessageHeaderConfigProperty#getTextColor}
             * @param textColor The color of the body text, expressed as a string consisting of a hex color code (such as "#000000" for black).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textColor(java.lang.String textColor) {
                this.textColor = textColor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InAppMessageHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InAppMessageHeaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InAppMessageHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InAppMessageHeaderConfigProperty {
            private final java.lang.String alignment;
            private final java.lang.String header;
            private final java.lang.String textColor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textColor = software.amazon.jsii.Kernel.get(this, "textColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.header = builder.header;
                this.textColor = builder.textColor;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.String getTextColor() {
                return this.textColor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }
                if (this.getTextColor() != null) {
                    data.set("textColor", om.valueToTree(this.getTextColor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.InAppMessageHeaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InAppMessageHeaderConfigProperty.Jsii$Proxy that = (InAppMessageHeaderConfigProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.header != null ? !this.header.equals(that.header) : that.header != null) return false;
                return this.textColor != null ? this.textColor.equals(that.textColor) : that.textColor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.header != null ? this.header.hashCode() : 0);
                result = 31 * result + (this.textColor != null ? this.textColor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the limits on the messages that a campaign can send.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * LimitsProperty limitsProperty = LimitsProperty.builder()
     *         .daily(123)
     *         .maximumDuration(123)
     *         .messagesPerSecond(123)
     *         .session(123)
     *         .total(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.LimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(LimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period.
         * <p>
         * The maximum value is 100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDaily() {
            return null;
        }

        /**
         * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign.
         * <p>
         * The minimum value is 60 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumDuration() {
            return null;
        }

        /**
         * The maximum number of messages that a campaign can send each second.
         * <p>
         * The minimum value is 50. The maximum value is 20,000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMessagesPerSecond() {
            return null;
        }

        /**
         * `CfnCampaign.LimitsProperty.Session`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSession() {
            return null;
        }

        /**
         * The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign.
         * <p>
         * The maximum value is 100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LimitsProperty> {
            java.lang.Number daily;
            java.lang.Number maximumDuration;
            java.lang.Number messagesPerSecond;
            java.lang.Number session;
            java.lang.Number total;

            /**
             * Sets the value of {@link LimitsProperty#getDaily}
             * @param daily The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period.
             *              The maximum value is 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daily(java.lang.Number daily) {
                this.daily = daily;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getMaximumDuration}
             * @param maximumDuration The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign.
             *                        The minimum value is 60 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumDuration(java.lang.Number maximumDuration) {
                this.maximumDuration = maximumDuration;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getMessagesPerSecond}
             * @param messagesPerSecond The maximum number of messages that a campaign can send each second.
             *                          The minimum value is 50. The maximum value is 20,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messagesPerSecond(java.lang.Number messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getSession}
             * @param session `CfnCampaign.LimitsProperty.Session`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder session(java.lang.Number session) {
                this.session = session;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getTotal}
             * @param total The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign.
             *              The maximum value is 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder total(java.lang.Number total) {
                this.total = total;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LimitsProperty {
            private final java.lang.Number daily;
            private final java.lang.Number maximumDuration;
            private final java.lang.Number messagesPerSecond;
            private final java.lang.Number session;
            private final java.lang.Number total;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daily = software.amazon.jsii.Kernel.get(this, "daily", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumDuration = software.amazon.jsii.Kernel.get(this, "maximumDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messagesPerSecond = software.amazon.jsii.Kernel.get(this, "messagesPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.session = software.amazon.jsii.Kernel.get(this, "session", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.total = software.amazon.jsii.Kernel.get(this, "total", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daily = builder.daily;
                this.maximumDuration = builder.maximumDuration;
                this.messagesPerSecond = builder.messagesPerSecond;
                this.session = builder.session;
                this.total = builder.total;
            }

            @Override
            public final java.lang.Number getDaily() {
                return this.daily;
            }

            @Override
            public final java.lang.Number getMaximumDuration() {
                return this.maximumDuration;
            }

            @Override
            public final java.lang.Number getMessagesPerSecond() {
                return this.messagesPerSecond;
            }

            @Override
            public final java.lang.Number getSession() {
                return this.session;
            }

            @Override
            public final java.lang.Number getTotal() {
                return this.total;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDaily() != null) {
                    data.set("daily", om.valueToTree(this.getDaily()));
                }
                if (this.getMaximumDuration() != null) {
                    data.set("maximumDuration", om.valueToTree(this.getMaximumDuration()));
                }
                if (this.getMessagesPerSecond() != null) {
                    data.set("messagesPerSecond", om.valueToTree(this.getMessagesPerSecond()));
                }
                if (this.getSession() != null) {
                    data.set("session", om.valueToTree(this.getSession()));
                }
                if (this.getTotal() != null) {
                    data.set("total", om.valueToTree(this.getTotal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.LimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LimitsProperty.Jsii$Proxy that = (LimitsProperty.Jsii$Proxy) o;

                if (this.daily != null ? !this.daily.equals(that.daily) : that.daily != null) return false;
                if (this.maximumDuration != null ? !this.maximumDuration.equals(that.maximumDuration) : that.maximumDuration != null) return false;
                if (this.messagesPerSecond != null ? !this.messagesPerSecond.equals(that.messagesPerSecond) : that.messagesPerSecond != null) return false;
                if (this.session != null ? !this.session.equals(that.session) : that.session != null) return false;
                return this.total != null ? this.total.equals(that.total) : that.total == null;
            }

            @Override
            public final int hashCode() {
                int result = this.daily != null ? this.daily.hashCode() : 0;
                result = 31 * result + (this.maximumDuration != null ? this.maximumDuration.hashCode() : 0);
                result = 31 * result + (this.messagesPerSecond != null ? this.messagesPerSecond.hashCode() : 0);
                result = 31 * result + (this.session != null ? this.session.hashCode() : 0);
                result = 31 * result + (this.total != null ? this.total.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the message configuration settings for a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object customConfig;
     * MessageConfigurationProperty messageConfigurationProperty = MessageConfigurationProperty.builder()
     *         .admMessage(MessageProperty.builder()
     *                 .action("action")
     *                 .body("body")
     *                 .imageIconUrl("imageIconUrl")
     *                 .imageSmallIconUrl("imageSmallIconUrl")
     *                 .imageUrl("imageUrl")
     *                 .jsonBody("jsonBody")
     *                 .mediaUrl("mediaUrl")
     *                 .rawContent("rawContent")
     *                 .silentPush(false)
     *                 .timeToLive(123)
     *                 .title("title")
     *                 .url("url")
     *                 .build())
     *         .apnsMessage(MessageProperty.builder()
     *                 .action("action")
     *                 .body("body")
     *                 .imageIconUrl("imageIconUrl")
     *                 .imageSmallIconUrl("imageSmallIconUrl")
     *                 .imageUrl("imageUrl")
     *                 .jsonBody("jsonBody")
     *                 .mediaUrl("mediaUrl")
     *                 .rawContent("rawContent")
     *                 .silentPush(false)
     *                 .timeToLive(123)
     *                 .title("title")
     *                 .url("url")
     *                 .build())
     *         .baiduMessage(MessageProperty.builder()
     *                 .action("action")
     *                 .body("body")
     *                 .imageIconUrl("imageIconUrl")
     *                 .imageSmallIconUrl("imageSmallIconUrl")
     *                 .imageUrl("imageUrl")
     *                 .jsonBody("jsonBody")
     *                 .mediaUrl("mediaUrl")
     *                 .rawContent("rawContent")
     *                 .silentPush(false)
     *                 .timeToLive(123)
     *                 .title("title")
     *                 .url("url")
     *                 .build())
     *         .customMessage(CampaignCustomMessageProperty.builder()
     *                 .data("data")
     *                 .build())
     *         .defaultMessage(MessageProperty.builder()
     *                 .action("action")
     *                 .body("body")
     *                 .imageIconUrl("imageIconUrl")
     *                 .imageSmallIconUrl("imageSmallIconUrl")
     *                 .imageUrl("imageUrl")
     *                 .jsonBody("jsonBody")
     *                 .mediaUrl("mediaUrl")
     *                 .rawContent("rawContent")
     *                 .silentPush(false)
     *                 .timeToLive(123)
     *                 .title("title")
     *                 .url("url")
     *                 .build())
     *         .emailMessage(CampaignEmailMessageProperty.builder()
     *                 .body("body")
     *                 .fromAddress("fromAddress")
     *                 .htmlBody("htmlBody")
     *                 .title("title")
     *                 .build())
     *         .gcmMessage(MessageProperty.builder()
     *                 .action("action")
     *                 .body("body")
     *                 .imageIconUrl("imageIconUrl")
     *                 .imageSmallIconUrl("imageSmallIconUrl")
     *                 .imageUrl("imageUrl")
     *                 .jsonBody("jsonBody")
     *                 .mediaUrl("mediaUrl")
     *                 .rawContent("rawContent")
     *                 .silentPush(false)
     *                 .timeToLive(123)
     *                 .title("title")
     *                 .url("url")
     *                 .build())
     *         .inAppMessage(CampaignInAppMessageProperty.builder()
     *                 .content(List.of(InAppMessageContentProperty.builder()
     *                         .backgroundColor("backgroundColor")
     *                         .bodyConfig(InAppMessageBodyConfigProperty.builder()
     *                                 .alignment("alignment")
     *                                 .body("body")
     *                                 .textColor("textColor")
     *                                 .build())
     *                         .headerConfig(InAppMessageHeaderConfigProperty.builder()
     *                                 .alignment("alignment")
     *                                 .header("header")
     *                                 .textColor("textColor")
     *                                 .build())
     *                         .imageUrl("imageUrl")
     *                         .primaryBtn(InAppMessageButtonProperty.builder()
     *                                 .android(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                         .backgroundColor("backgroundColor")
     *                                         .borderRadius(123)
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .text("text")
     *                                         .textColor("textColor")
     *                                         .build())
     *                                 .ios(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .web(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .build())
     *                         .secondaryBtn(InAppMessageButtonProperty.builder()
     *                                 .android(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                         .backgroundColor("backgroundColor")
     *                                         .borderRadius(123)
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .text("text")
     *                                         .textColor("textColor")
     *                                         .build())
     *                                 .ios(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .web(OverrideButtonConfigurationProperty.builder()
     *                                         .buttonAction("buttonAction")
     *                                         .link("link")
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .customConfig(customConfig)
     *                 .layout("layout")
     *                 .build())
     *         .smsMessage(CampaignSmsMessageProperty.builder()
     *                 .body("body")
     *                 .entityId("entityId")
     *                 .messageType("messageType")
     *                 .originationNumber("originationNumber")
     *                 .senderId("senderId")
     *                 .templateId("templateId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message that the campaign sends through the ADM (Amazon Device Messaging) channel.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdmMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through the APNs (Apple Push Notification service) channel.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getApnsMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through the Baidu (Baidu Cloud Push) channel.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaiduMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through a custom channel, as specified by the delivery configuration ( `CustomDeliveryConfiguration` ) settings for the campaign.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomMessage() {
            return null;
        }

        /**
         * The default message that the campaign sends through all the channels that are configured for the campaign.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through the email channel.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGcmMessage() {
            return null;
        }

        /**
         * The default message for the in-app messaging channel.
         * <p>
         * This message overrides the default message ( <code>DefaultMessage</code> ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInAppMessage() {
            return null;
        }

        /**
         * The message that the campaign sends through the SMS channel.
         * <p>
         * If specified, this message overrides the default message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmsMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageConfigurationProperty> {
            java.lang.Object admMessage;
            java.lang.Object apnsMessage;
            java.lang.Object baiduMessage;
            java.lang.Object customMessage;
            java.lang.Object defaultMessage;
            java.lang.Object emailMessage;
            java.lang.Object gcmMessage;
            java.lang.Object inAppMessage;
            java.lang.Object smsMessage;

            /**
             * Sets the value of {@link MessageConfigurationProperty#getAdmMessage}
             * @param admMessage The message that the campaign sends through the ADM (Amazon Device Messaging) channel.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder admMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageProperty admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getAdmMessage}
             * @param admMessage The message that the campaign sends through the ADM (Amazon Device Messaging) channel.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder admMessage(software.amazon.awscdk.IResolvable admMessage) {
                this.admMessage = admMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getApnsMessage}
             * @param apnsMessage The message that the campaign sends through the APNs (Apple Push Notification service) channel.
             *                    If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apnsMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageProperty apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getApnsMessage}
             * @param apnsMessage The message that the campaign sends through the APNs (Apple Push Notification service) channel.
             *                    If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apnsMessage(software.amazon.awscdk.IResolvable apnsMessage) {
                this.apnsMessage = apnsMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getBaiduMessage}
             * @param baiduMessage The message that the campaign sends through the Baidu (Baidu Cloud Push) channel.
             *                     If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baiduMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageProperty baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getBaiduMessage}
             * @param baiduMessage The message that the campaign sends through the Baidu (Baidu Cloud Push) channel.
             *                     If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baiduMessage(software.amazon.awscdk.IResolvable baiduMessage) {
                this.baiduMessage = baiduMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getCustomMessage}
             * @param customMessage The message that the campaign sends through a custom channel, as specified by the delivery configuration ( `CustomDeliveryConfiguration` ) settings for the campaign.
             *                      If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignCustomMessageProperty customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getCustomMessage}
             * @param customMessage The message that the campaign sends through a custom channel, as specified by the delivery configuration ( `CustomDeliveryConfiguration` ) settings for the campaign.
             *                      If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMessage(software.amazon.awscdk.IResolvable customMessage) {
                this.customMessage = customMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getDefaultMessage}
             * @param defaultMessage The default message that the campaign sends through all the channels that are configured for the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageProperty defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getDefaultMessage}
             * @param defaultMessage The default message that the campaign sends through all the channels that are configured for the campaign.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultMessage(software.amazon.awscdk.IResolvable defaultMessage) {
                this.defaultMessage = defaultMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getEmailMessage}
             * @param emailMessage The message that the campaign sends through the email channel.
             *                     If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignEmailMessageProperty emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getEmailMessage}
             * @param emailMessage The message that the campaign sends through the email channel.
             *                     If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessage(software.amazon.awscdk.IResolvable emailMessage) {
                this.emailMessage = emailMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getGcmMessage}
             * @param gcmMessage The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gcmMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageProperty gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getGcmMessage}
             * @param gcmMessage The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gcmMessage(software.amazon.awscdk.IResolvable gcmMessage) {
                this.gcmMessage = gcmMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getInAppMessage}
             * @param inAppMessage The default message for the in-app messaging channel.
             *                     This message overrides the default message ( <code>DefaultMessage</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inAppMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignInAppMessageProperty inAppMessage) {
                this.inAppMessage = inAppMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getInAppMessage}
             * @param inAppMessage The default message for the in-app messaging channel.
             *                     This message overrides the default message ( <code>DefaultMessage</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inAppMessage(software.amazon.awscdk.IResolvable inAppMessage) {
                this.inAppMessage = inAppMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getSmsMessage}
             * @param smsMessage The message that the campaign sends through the SMS channel.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessage(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignSmsMessageProperty smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageConfigurationProperty#getSmsMessage}
             * @param smsMessage The message that the campaign sends through the SMS channel.
             *                   If specified, this message overrides the default message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessage(software.amazon.awscdk.IResolvable smsMessage) {
                this.smsMessage = smsMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageConfigurationProperty {
            private final java.lang.Object admMessage;
            private final java.lang.Object apnsMessage;
            private final java.lang.Object baiduMessage;
            private final java.lang.Object customMessage;
            private final java.lang.Object defaultMessage;
            private final java.lang.Object emailMessage;
            private final java.lang.Object gcmMessage;
            private final java.lang.Object inAppMessage;
            private final java.lang.Object smsMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.admMessage = software.amazon.jsii.Kernel.get(this, "admMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apnsMessage = software.amazon.jsii.Kernel.get(this, "apnsMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.baiduMessage = software.amazon.jsii.Kernel.get(this, "baiduMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customMessage = software.amazon.jsii.Kernel.get(this, "customMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultMessage = software.amazon.jsii.Kernel.get(this, "defaultMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.emailMessage = software.amazon.jsii.Kernel.get(this, "emailMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.gcmMessage = software.amazon.jsii.Kernel.get(this, "gcmMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inAppMessage = software.amazon.jsii.Kernel.get(this, "inAppMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smsMessage = software.amazon.jsii.Kernel.get(this, "smsMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.admMessage = builder.admMessage;
                this.apnsMessage = builder.apnsMessage;
                this.baiduMessage = builder.baiduMessage;
                this.customMessage = builder.customMessage;
                this.defaultMessage = builder.defaultMessage;
                this.emailMessage = builder.emailMessage;
                this.gcmMessage = builder.gcmMessage;
                this.inAppMessage = builder.inAppMessage;
                this.smsMessage = builder.smsMessage;
            }

            @Override
            public final java.lang.Object getAdmMessage() {
                return this.admMessage;
            }

            @Override
            public final java.lang.Object getApnsMessage() {
                return this.apnsMessage;
            }

            @Override
            public final java.lang.Object getBaiduMessage() {
                return this.baiduMessage;
            }

            @Override
            public final java.lang.Object getCustomMessage() {
                return this.customMessage;
            }

            @Override
            public final java.lang.Object getDefaultMessage() {
                return this.defaultMessage;
            }

            @Override
            public final java.lang.Object getEmailMessage() {
                return this.emailMessage;
            }

            @Override
            public final java.lang.Object getGcmMessage() {
                return this.gcmMessage;
            }

            @Override
            public final java.lang.Object getInAppMessage() {
                return this.inAppMessage;
            }

            @Override
            public final java.lang.Object getSmsMessage() {
                return this.smsMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdmMessage() != null) {
                    data.set("admMessage", om.valueToTree(this.getAdmMessage()));
                }
                if (this.getApnsMessage() != null) {
                    data.set("apnsMessage", om.valueToTree(this.getApnsMessage()));
                }
                if (this.getBaiduMessage() != null) {
                    data.set("baiduMessage", om.valueToTree(this.getBaiduMessage()));
                }
                if (this.getCustomMessage() != null) {
                    data.set("customMessage", om.valueToTree(this.getCustomMessage()));
                }
                if (this.getDefaultMessage() != null) {
                    data.set("defaultMessage", om.valueToTree(this.getDefaultMessage()));
                }
                if (this.getEmailMessage() != null) {
                    data.set("emailMessage", om.valueToTree(this.getEmailMessage()));
                }
                if (this.getGcmMessage() != null) {
                    data.set("gcmMessage", om.valueToTree(this.getGcmMessage()));
                }
                if (this.getInAppMessage() != null) {
                    data.set("inAppMessage", om.valueToTree(this.getInAppMessage()));
                }
                if (this.getSmsMessage() != null) {
                    data.set("smsMessage", om.valueToTree(this.getSmsMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageConfigurationProperty.Jsii$Proxy that = (MessageConfigurationProperty.Jsii$Proxy) o;

                if (this.admMessage != null ? !this.admMessage.equals(that.admMessage) : that.admMessage != null) return false;
                if (this.apnsMessage != null ? !this.apnsMessage.equals(that.apnsMessage) : that.apnsMessage != null) return false;
                if (this.baiduMessage != null ? !this.baiduMessage.equals(that.baiduMessage) : that.baiduMessage != null) return false;
                if (this.customMessage != null ? !this.customMessage.equals(that.customMessage) : that.customMessage != null) return false;
                if (this.defaultMessage != null ? !this.defaultMessage.equals(that.defaultMessage) : that.defaultMessage != null) return false;
                if (this.emailMessage != null ? !this.emailMessage.equals(that.emailMessage) : that.emailMessage != null) return false;
                if (this.gcmMessage != null ? !this.gcmMessage.equals(that.gcmMessage) : that.gcmMessage != null) return false;
                if (this.inAppMessage != null ? !this.inAppMessage.equals(that.inAppMessage) : that.inAppMessage != null) return false;
                return this.smsMessage != null ? this.smsMessage.equals(that.smsMessage) : that.smsMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.admMessage != null ? this.admMessage.hashCode() : 0;
                result = 31 * result + (this.apnsMessage != null ? this.apnsMessage.hashCode() : 0);
                result = 31 * result + (this.baiduMessage != null ? this.baiduMessage.hashCode() : 0);
                result = 31 * result + (this.customMessage != null ? this.customMessage.hashCode() : 0);
                result = 31 * result + (this.defaultMessage != null ? this.defaultMessage.hashCode() : 0);
                result = 31 * result + (this.emailMessage != null ? this.emailMessage.hashCode() : 0);
                result = 31 * result + (this.gcmMessage != null ? this.gcmMessage.hashCode() : 0);
                result = 31 * result + (this.inAppMessage != null ? this.inAppMessage.hashCode() : 0);
                result = 31 * result + (this.smsMessage != null ? this.smsMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the content and settings for a push notification that's sent to recipients of a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * MessageProperty messageProperty = MessageProperty.builder()
     *         .action("action")
     *         .body("body")
     *         .imageIconUrl("imageIconUrl")
     *         .imageSmallIconUrl("imageSmallIconUrl")
     *         .imageUrl("imageUrl")
     *         .jsonBody("jsonBody")
     *         .mediaUrl("mediaUrl")
     *         .rawContent("rawContent")
     *         .silentPush(false)
     *         .timeToLive(123)
     *         .title("title")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to occur if a recipient taps the push notification. Valid values are:.
         * <p>
         * <ul>
         * <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
         * <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</li>
         * <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The body of the notification message.
         * <p>
         * The maximum number of characters is 200.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBody() {
            return null;
        }

        /**
         * The URL of the image to display as the push notification icon, such as the icon for the app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageIconUrl() {
            return null;
        }

        /**
         * The URL of the image to display as the small, push notification icon, such as a small version of the icon for the app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageSmallIconUrl() {
            return null;
        }

        /**
         * The URL of an image to display in the push notification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * The JSON payload to use for a silent push notification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJsonBody() {
            return null;
        }

        /**
         * The URL of the image or video to display in the push notification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMediaUrl() {
            return null;
        }

        /**
         * The raw, JSON-formatted string to use as the payload for the notification message.
         * <p>
         * If specified, this value overrides all other content for the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRawContent() {
            return null;
        }

        /**
         * Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device.
         * <p>
         * Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSilentPush() {
            return null;
        }

        /**
         * The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time.
         * <p>
         * This value is converted to an expiration value when it's sent to a push notification service. If this value is <code>0</code> , the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
         * <p>
         * This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeToLive() {
            return null;
        }

        /**
         * The title to display above the notification message on a recipient's device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTitle() {
            return null;
        }

        /**
         * The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the `Action` property is `URL` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageProperty> {
            java.lang.String action;
            java.lang.String body;
            java.lang.String imageIconUrl;
            java.lang.String imageSmallIconUrl;
            java.lang.String imageUrl;
            java.lang.String jsonBody;
            java.lang.String mediaUrl;
            java.lang.String rawContent;
            java.lang.Object silentPush;
            java.lang.Number timeToLive;
            java.lang.String title;
            java.lang.String url;

            /**
             * Sets the value of {@link MessageProperty#getAction}
             * @param action The action to occur if a recipient taps the push notification. Valid values are:.
             *               <ul>
             *               <li><code>OPEN_APP</code> – Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</li>
             *               <li><code>DEEP_LINK</code> – Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</li>
             *               <li><code>URL</code> – The default mobile browser on the recipient's device opens and loads the web page at a URL that you specify.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getBody}
             * @param body The body of the notification message.
             *             The maximum number of characters is 200.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(java.lang.String body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageIconUrl}
             * @param imageIconUrl The URL of the image to display as the push notification icon, such as the icon for the app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageIconUrl(java.lang.String imageIconUrl) {
                this.imageIconUrl = imageIconUrl;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageSmallIconUrl}
             * @param imageSmallIconUrl The URL of the image to display as the small, push notification icon, such as a small version of the icon for the app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageSmallIconUrl(java.lang.String imageSmallIconUrl) {
                this.imageSmallIconUrl = imageSmallIconUrl;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageUrl}
             * @param imageUrl The URL of an image to display in the push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getJsonBody}
             * @param jsonBody The JSON payload to use for a silent push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(java.lang.String jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getMediaUrl}
             * @param mediaUrl The URL of the image or video to display in the push notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mediaUrl(java.lang.String mediaUrl) {
                this.mediaUrl = mediaUrl;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getRawContent}
             * @param rawContent The raw, JSON-formatted string to use as the payload for the notification message.
             *                   If specified, this value overrides all other content for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawContent(java.lang.String rawContent) {
                this.rawContent = rawContent;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSilentPush}
             * @param silentPush Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device.
             *                   Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder silentPush(java.lang.Boolean silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSilentPush}
             * @param silentPush Specifies whether the notification is a silent push notification, which is a push notification that doesn't display on a recipient's device.
             *                   Silent push notifications can be used for cases such as updating an app's configuration, displaying messages in an in-app message center, or supporting phone home functionality.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder silentPush(software.amazon.awscdk.IResolvable silentPush) {
                this.silentPush = silentPush;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getTimeToLive}
             * @param timeToLive The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time.
             *                   This value is converted to an expiration value when it's sent to a push notification service. If this value is <code>0</code> , the service treats the notification as if it expires immediately and the service doesn't store or try to deliver the notification again.
             *                   <p>
             *                   This value doesn't apply to messages that are sent through the Amazon Device Messaging (ADM) service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeToLive(java.lang.Number timeToLive) {
                this.timeToLive = timeToLive;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getTitle}
             * @param title The title to display above the notification message on a recipient's device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getUrl}
             * @param url The URL to open in a recipient's default mobile browser, if a recipient taps the push notification and the value of the `Action` property is `URL` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageProperty {
            private final java.lang.String action;
            private final java.lang.String body;
            private final java.lang.String imageIconUrl;
            private final java.lang.String imageSmallIconUrl;
            private final java.lang.String imageUrl;
            private final java.lang.String jsonBody;
            private final java.lang.String mediaUrl;
            private final java.lang.String rawContent;
            private final java.lang.Object silentPush;
            private final java.lang.Number timeToLive;
            private final java.lang.String title;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageIconUrl = software.amazon.jsii.Kernel.get(this, "imageIconUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageSmallIconUrl = software.amazon.jsii.Kernel.get(this, "imageSmallIconUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jsonBody = software.amazon.jsii.Kernel.get(this, "jsonBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mediaUrl = software.amazon.jsii.Kernel.get(this, "mediaUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rawContent = software.amazon.jsii.Kernel.get(this, "rawContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.silentPush = software.amazon.jsii.Kernel.get(this, "silentPush", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeToLive = software.amazon.jsii.Kernel.get(this, "timeToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.body = builder.body;
                this.imageIconUrl = builder.imageIconUrl;
                this.imageSmallIconUrl = builder.imageSmallIconUrl;
                this.imageUrl = builder.imageUrl;
                this.jsonBody = builder.jsonBody;
                this.mediaUrl = builder.mediaUrl;
                this.rawContent = builder.rawContent;
                this.silentPush = builder.silentPush;
                this.timeToLive = builder.timeToLive;
                this.title = builder.title;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getBody() {
                return this.body;
            }

            @Override
            public final java.lang.String getImageIconUrl() {
                return this.imageIconUrl;
            }

            @Override
            public final java.lang.String getImageSmallIconUrl() {
                return this.imageSmallIconUrl;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.String getJsonBody() {
                return this.jsonBody;
            }

            @Override
            public final java.lang.String getMediaUrl() {
                return this.mediaUrl;
            }

            @Override
            public final java.lang.String getRawContent() {
                return this.rawContent;
            }

            @Override
            public final java.lang.Object getSilentPush() {
                return this.silentPush;
            }

            @Override
            public final java.lang.Number getTimeToLive() {
                return this.timeToLive;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getImageIconUrl() != null) {
                    data.set("imageIconUrl", om.valueToTree(this.getImageIconUrl()));
                }
                if (this.getImageSmallIconUrl() != null) {
                    data.set("imageSmallIconUrl", om.valueToTree(this.getImageSmallIconUrl()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getJsonBody() != null) {
                    data.set("jsonBody", om.valueToTree(this.getJsonBody()));
                }
                if (this.getMediaUrl() != null) {
                    data.set("mediaUrl", om.valueToTree(this.getMediaUrl()));
                }
                if (this.getRawContent() != null) {
                    data.set("rawContent", om.valueToTree(this.getRawContent()));
                }
                if (this.getSilentPush() != null) {
                    data.set("silentPush", om.valueToTree(this.getSilentPush()));
                }
                if (this.getTimeToLive() != null) {
                    data.set("timeToLive", om.valueToTree(this.getTimeToLive()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.MessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageProperty.Jsii$Proxy that = (MessageProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.imageIconUrl != null ? !this.imageIconUrl.equals(that.imageIconUrl) : that.imageIconUrl != null) return false;
                if (this.imageSmallIconUrl != null ? !this.imageSmallIconUrl.equals(that.imageSmallIconUrl) : that.imageSmallIconUrl != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                if (this.jsonBody != null ? !this.jsonBody.equals(that.jsonBody) : that.jsonBody != null) return false;
                if (this.mediaUrl != null ? !this.mediaUrl.equals(that.mediaUrl) : that.mediaUrl != null) return false;
                if (this.rawContent != null ? !this.rawContent.equals(that.rawContent) : that.rawContent != null) return false;
                if (this.silentPush != null ? !this.silentPush.equals(that.silentPush) : that.silentPush != null) return false;
                if (this.timeToLive != null ? !this.timeToLive.equals(that.timeToLive) : that.timeToLive != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.imageIconUrl != null ? this.imageIconUrl.hashCode() : 0);
                result = 31 * result + (this.imageSmallIconUrl != null ? this.imageSmallIconUrl.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.jsonBody != null ? this.jsonBody.hashCode() : 0);
                result = 31 * result + (this.mediaUrl != null ? this.mediaUrl.hashCode() : 0);
                result = 31 * result + (this.rawContent != null ? this.rawContent.hashCode() : 0);
                result = 31 * result + (this.silentPush != null ? this.silentPush.hashCode() : 0);
                result = 31 * result + (this.timeToLive != null ? this.timeToLive.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies metric-based criteria for including or excluding endpoints from a segment.
     * <p>
     * These criteria derive from custom metrics that you define for endpoints.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator to use when comparing metric values.
         * <p>
         * Valid values are: <code>GREATER_THAN</code> , <code>LESS_THAN</code> , <code>GREATER_THAN_OR_EQUAL</code> , <code>LESS_THAN_OR_EQUAL</code> , and <code>EQUAL</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComparisonOperator() {
            return null;
        }

        /**
         * The value to compare.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String comparisonOperator;
            java.lang.Number value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getComparisonOperator}
             * @param comparisonOperator The operator to use when comparing metric values.
             *                           Valid values are: <code>GREATER_THAN</code> , <code>LESS_THAN</code> , <code>GREATER_THAN_OR_EQUAL</code> , <code>LESS_THAN_OR_EQUAL</code> , and <code>EQUAL</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The value to compare.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = builder.comparisonOperator;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComparisonOperator() != null) {
                    data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (this.comparisonOperator != null ? !this.comparisonOperator.equals(that.comparisonOperator) : that.comparisonOperator != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator != null ? this.comparisonOperator.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a button with settings that are specific to a certain device type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * OverrideButtonConfigurationProperty overrideButtonConfigurationProperty = OverrideButtonConfigurationProperty.builder()
     *         .buttonAction("buttonAction")
     *         .link("link")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.OverrideButtonConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideButtonConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideButtonConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that occurs when a recipient chooses a button in an in-app message.
         * <p>
         * You can specify one of the following:
         * <p>
         * <ul>
         * <li><code>LINK</code> – A link to a web destination.</li>
         * <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
         * <li><code>CLOSE</code> – Dismisses the message.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getButtonAction() {
            return null;
        }

        /**
         * The destination (such as a URL) for a button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLink() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideButtonConfigurationProperty> {
            java.lang.String buttonAction;
            java.lang.String link;

            /**
             * Sets the value of {@link OverrideButtonConfigurationProperty#getButtonAction}
             * @param buttonAction The action that occurs when a recipient chooses a button in an in-app message.
             *                     You can specify one of the following:
             *                     <p>
             *                     <ul>
             *                     <li><code>LINK</code> – A link to a web destination.</li>
             *                     <li><code>DEEP_LINK</code> – A link to a specific page in an application.</li>
             *                     <li><code>CLOSE</code> – Dismisses the message.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttonAction(java.lang.String buttonAction) {
                this.buttonAction = buttonAction;
                return this;
            }

            /**
             * Sets the value of {@link OverrideButtonConfigurationProperty#getLink}
             * @param link The destination (such as a URL) for a button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder link(java.lang.String link) {
                this.link = link;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideButtonConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideButtonConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideButtonConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideButtonConfigurationProperty {
            private final java.lang.String buttonAction;
            private final java.lang.String link;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.buttonAction = software.amazon.jsii.Kernel.get(this, "buttonAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.link = software.amazon.jsii.Kernel.get(this, "link", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.buttonAction = builder.buttonAction;
                this.link = builder.link;
            }

            @Override
            public final java.lang.String getButtonAction() {
                return this.buttonAction;
            }

            @Override
            public final java.lang.String getLink() {
                return this.link;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getButtonAction() != null) {
                    data.set("buttonAction", om.valueToTree(this.getButtonAction()));
                }
                if (this.getLink() != null) {
                    data.set("link", om.valueToTree(this.getLink()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.OverrideButtonConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideButtonConfigurationProperty.Jsii$Proxy that = (OverrideButtonConfigurationProperty.Jsii$Proxy) o;

                if (this.buttonAction != null ? !this.buttonAction.equals(that.buttonAction) : that.buttonAction != null) return false;
                return this.link != null ? this.link.equals(that.link) : that.link == null;
            }

            @Override
            public final int hashCode() {
                int result = this.buttonAction != null ? this.buttonAction.hashCode() : 0;
                result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the start and end times that define a time range when messages aren't sent to endpoints.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * QuietTimeProperty quietTimeProperty = QuietTimeProperty.builder()
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.QuietTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(QuietTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QuietTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specific time when quiet time ends.
         * <p>
         * This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEnd();

        /**
         * The specific time when quiet time begins.
         * <p>
         * This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStart();

        /**
         * @return a {@link Builder} of {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QuietTimeProperty> {
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link QuietTimeProperty#getEnd}
             * @param end The specific time when quiet time ends. This parameter is required.
             *            This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link QuietTimeProperty#getStart}
             * @param start The specific time when quiet time begins. This parameter is required.
             *              This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QuietTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QuietTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuietTimeProperty {
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.end = java.util.Objects.requireNonNull(builder.end, "end is required");
                this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("end", om.valueToTree(this.getEnd()));
                data.set("start", om.valueToTree(this.getStart()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.QuietTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QuietTimeProperty.Jsii$Proxy that = (QuietTimeProperty.Jsii$Proxy) o;

                if (!end.equals(that.end)) return false;
                return this.start.equals(that.start);
            }

            @Override
            public final int hashCode() {
                int result = this.end.hashCode();
                result = 31 * result + (this.start.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the schedule settings for a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object metrics;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .endTime("endTime")
     *         .eventFilter(CampaignEventFilterProperty.builder()
     *                 .dimensions(EventDimensionsProperty.builder()
     *                         .attributes(attributes)
     *                         .eventType(SetDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .metrics(metrics)
     *                         .build())
     *                 .filterType("filterType")
     *                 .build())
     *         .frequency("frequency")
     *         .isLocalTime(false)
     *         .quietTime(QuietTimeProperty.builder()
     *                 .end("end")
     *                 .start("start")
     *                 .build())
     *         .startTime("startTime")
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scheduled time, in ISO 8601 format, when the campaign ended or will end.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndTime() {
            return null;
        }

        /**
         * The type of event that causes the campaign to be sent, if the value of the `Frequency` property is `EVENT` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventFilter() {
            return null;
        }

        /**
         * Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFrequency() {
            return null;
        }

        /**
         * Specifies whether the start and end times for the campaign schedule use each recipient's local time.
         * <p>
         * To base the schedule on each recipient's local time, set this value to <code>true</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsLocalTime() {
            return null;
        }

        /**
         * The default quiet time for the campaign.
         * <p>
         * Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:
         * <p>
         * <ul>
         * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
         * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the campaign.</li>
         * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the campaign.</li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuietTime() {
            return null;
        }

        /**
         * The scheduled time when the campaign began or will begin.
         * <p>
         * Valid values are: <code>IMMEDIATE</code> , to start the campaign immediately; or, a specific time in ISO 8601 format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
            return null;
        }

        /**
         * The starting UTC offset for the campaign schedule, if the value of the `IsLocalTime` property is `true` .
         * <p>
         * Valid values are: <code>UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10,</code> and <code>UTC-11</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String endTime;
            java.lang.Object eventFilter;
            java.lang.String frequency;
            java.lang.Object isLocalTime;
            java.lang.Object quietTime;
            java.lang.String startTime;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link ScheduleProperty#getEndTime}
             * @param endTime The scheduled time, in ISO 8601 format, when the campaign ended or will end.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endTime(java.lang.String endTime) {
                this.endTime = endTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getEventFilter}
             * @param eventFilter The type of event that causes the campaign to be sent, if the value of the `Frequency` property is `EVENT` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventFilter(software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignEventFilterProperty eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getEventFilter}
             * @param eventFilter The type of event that causes the campaign to be sent, if the value of the `Frequency` property is `EVENT` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventFilter(software.amazon.awscdk.IResolvable eventFilter) {
                this.eventFilter = eventFilter;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getFrequency}
             * @param frequency Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequency(java.lang.String frequency) {
                this.frequency = frequency;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getIsLocalTime}
             * @param isLocalTime Specifies whether the start and end times for the campaign schedule use each recipient's local time.
             *                    To base the schedule on each recipient's local time, set this value to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isLocalTime(java.lang.Boolean isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getIsLocalTime}
             * @param isLocalTime Specifies whether the start and end times for the campaign schedule use each recipient's local time.
             *                    To base the schedule on each recipient's local time, set this value to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isLocalTime(software.amazon.awscdk.IResolvable isLocalTime) {
                this.isLocalTime = isLocalTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getQuietTime}
             * @param quietTime The default quiet time for the campaign.
             *                  Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:
             *                  <p>
             *                  <ul>
             *                  <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
             *                  <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the campaign.</li>
             *                  <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the campaign.</li>
             *                  </ul>
             *                  <p>
             *                  If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quietTime(software.amazon.awscdk.services.pinpoint.CfnCampaign.QuietTimeProperty quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getQuietTime}
             * @param quietTime The default quiet time for the campaign.
             *                  Quiet time is a specific time range when a campaign doesn't send messages to endpoints, if all the following conditions are met:
             *                  <p>
             *                  <ul>
             *                  <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
             *                  <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the campaign.</li>
             *                  <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the campaign.</li>
             *                  </ul>
             *                  <p>
             *                  If any of the preceding conditions isn't met, the endpoint will receive messages from the campaign, even if quiet time is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quietTime(software.amazon.awscdk.IResolvable quietTime) {
                this.quietTime = quietTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getStartTime}
             * @param startTime The scheduled time when the campaign began or will begin.
             *                  Valid values are: <code>IMMEDIATE</code> , to start the campaign immediately; or, a specific time in ISO 8601 format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getTimeZone}
             * @param timeZone The starting UTC offset for the campaign schedule, if the value of the `IsLocalTime` property is `true` .
             *                 Valid values are: <code>UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10,</code> and <code>UTC-11</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String endTime;
            private final java.lang.Object eventFilter;
            private final java.lang.String frequency;
            private final java.lang.Object isLocalTime;
            private final java.lang.Object quietTime;
            private final java.lang.String startTime;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endTime = software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventFilter = software.amazon.jsii.Kernel.get(this, "eventFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isLocalTime = software.amazon.jsii.Kernel.get(this, "isLocalTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quietTime = software.amazon.jsii.Kernel.get(this, "quietTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endTime = builder.endTime;
                this.eventFilter = builder.eventFilter;
                this.frequency = builder.frequency;
                this.isLocalTime = builder.isLocalTime;
                this.quietTime = builder.quietTime;
                this.startTime = builder.startTime;
                this.timeZone = builder.timeZone;
            }

            @Override
            public final java.lang.String getEndTime() {
                return this.endTime;
            }

            @Override
            public final java.lang.Object getEventFilter() {
                return this.eventFilter;
            }

            @Override
            public final java.lang.String getFrequency() {
                return this.frequency;
            }

            @Override
            public final java.lang.Object getIsLocalTime() {
                return this.isLocalTime;
            }

            @Override
            public final java.lang.Object getQuietTime() {
                return this.quietTime;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEndTime() != null) {
                    data.set("endTime", om.valueToTree(this.getEndTime()));
                }
                if (this.getEventFilter() != null) {
                    data.set("eventFilter", om.valueToTree(this.getEventFilter()));
                }
                if (this.getFrequency() != null) {
                    data.set("frequency", om.valueToTree(this.getFrequency()));
                }
                if (this.getIsLocalTime() != null) {
                    data.set("isLocalTime", om.valueToTree(this.getIsLocalTime()));
                }
                if (this.getQuietTime() != null) {
                    data.set("quietTime", om.valueToTree(this.getQuietTime()));
                }
                if (this.getStartTime() != null) {
                    data.set("startTime", om.valueToTree(this.getStartTime()));
                }
                if (this.getTimeZone() != null) {
                    data.set("timeZone", om.valueToTree(this.getTimeZone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) return false;
                if (this.eventFilter != null ? !this.eventFilter.equals(that.eventFilter) : that.eventFilter != null) return false;
                if (this.frequency != null ? !this.frequency.equals(that.frequency) : that.frequency != null) return false;
                if (this.isLocalTime != null ? !this.isLocalTime.equals(that.isLocalTime) : that.isLocalTime != null) return false;
                if (this.quietTime != null ? !this.quietTime.equals(that.quietTime) : that.quietTime != null) return false;
                if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) return false;
                return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endTime != null ? this.endTime.hashCode() : 0;
                result = 31 * result + (this.eventFilter != null ? this.eventFilter.hashCode() : 0);
                result = 31 * result + (this.frequency != null ? this.frequency.hashCode() : 0);
                result = 31 * result + (this.isLocalTime != null ? this.isLocalTime.hashCode() : 0);
                result = 31 * result + (this.quietTime != null ? this.quietTime.hashCode() : 0);
                result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the dimension type and values for a segment dimension.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * SetDimensionProperty setDimensionProperty = SetDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.SetDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(SetDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SetDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of segment dimension to use.
         * <p>
         * Valid values are: <code>INCLUSIVE</code> , endpoints that match the criteria are included in the segment; and, <code>EXCLUSIVE</code> , endpoints that match the criteria are excluded from the segment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDimensionType() {
            return null;
        }

        /**
         * The criteria values to use for the segment dimension.
         * <p>
         * Depending on the value of the <code>DimensionType</code> property, endpoints are included or excluded from the segment if their values match the criteria values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SetDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link SetDimensionProperty#getDimensionType}
             * @param dimensionType The type of segment dimension to use.
             *                      Valid values are: <code>INCLUSIVE</code> , endpoints that match the criteria are included in the segment; and, <code>EXCLUSIVE</code> , endpoints that match the criteria are excluded from the segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link SetDimensionProperty#getValues}
             * @param values The criteria values to use for the segment dimension.
             *               Depending on the value of the <code>DimensionType</code> property, endpoints are included or excluded from the segment if their values match the criteria values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SetDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SetDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SetDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SetDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = builder.dimensionType;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensionType() != null) {
                    data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.SetDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SetDimensionProperty.Jsii$Proxy that = (SetDimensionProperty.Jsii$Proxy) o;

                if (this.dimensionType != null ? !this.dimensionType.equals(that.dimensionType) : that.dimensionType != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType != null ? this.dimensionType.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the message template to use for the message, for each type of channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * TemplateConfigurationProperty templateConfigurationProperty = TemplateConfigurationProperty.builder()
     *         .emailTemplate(TemplateProperty.builder()
     *                 .name("name")
     *                 .version("version")
     *                 .build())
     *         .pushTemplate(TemplateProperty.builder()
     *                 .name("name")
     *                 .version("version")
     *                 .build())
     *         .smsTemplate(TemplateProperty.builder()
     *                 .name("name")
     *                 .version("version")
     *                 .build())
     *         .voiceTemplate(TemplateProperty.builder()
     *                 .name("name")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.TemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email template to use for the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailTemplate() {
            return null;
        }

        /**
         * The push notification template to use for the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPushTemplate() {
            return null;
        }

        /**
         * The SMS template to use for the message.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmsTemplate() {
            return null;
        }

        /**
         * The voice template to use for the message.
         * <p>
         * This object isn't supported for campaigns.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVoiceTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateConfigurationProperty> {
            java.lang.Object emailTemplate;
            java.lang.Object pushTemplate;
            java.lang.Object smsTemplate;
            java.lang.Object voiceTemplate;

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getEmailTemplate}
             * @param emailTemplate The email template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailTemplate(software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateProperty emailTemplate) {
                this.emailTemplate = emailTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getEmailTemplate}
             * @param emailTemplate The email template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailTemplate(software.amazon.awscdk.IResolvable emailTemplate) {
                this.emailTemplate = emailTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getPushTemplate}
             * @param pushTemplate The push notification template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pushTemplate(software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateProperty pushTemplate) {
                this.pushTemplate = pushTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getPushTemplate}
             * @param pushTemplate The push notification template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pushTemplate(software.amazon.awscdk.IResolvable pushTemplate) {
                this.pushTemplate = pushTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getSmsTemplate}
             * @param smsTemplate The SMS template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsTemplate(software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateProperty smsTemplate) {
                this.smsTemplate = smsTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getSmsTemplate}
             * @param smsTemplate The SMS template to use for the message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsTemplate(software.amazon.awscdk.IResolvable smsTemplate) {
                this.smsTemplate = smsTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getVoiceTemplate}
             * @param voiceTemplate The voice template to use for the message.
             *                      This object isn't supported for campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceTemplate(software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateProperty voiceTemplate) {
                this.voiceTemplate = voiceTemplate;
                return this;
            }

            /**
             * Sets the value of {@link TemplateConfigurationProperty#getVoiceTemplate}
             * @param voiceTemplate The voice template to use for the message.
             *                      This object isn't supported for campaigns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceTemplate(software.amazon.awscdk.IResolvable voiceTemplate) {
                this.voiceTemplate = voiceTemplate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateConfigurationProperty {
            private final java.lang.Object emailTemplate;
            private final java.lang.Object pushTemplate;
            private final java.lang.Object smsTemplate;
            private final java.lang.Object voiceTemplate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailTemplate = software.amazon.jsii.Kernel.get(this, "emailTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pushTemplate = software.amazon.jsii.Kernel.get(this, "pushTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smsTemplate = software.amazon.jsii.Kernel.get(this, "smsTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.voiceTemplate = software.amazon.jsii.Kernel.get(this, "voiceTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailTemplate = builder.emailTemplate;
                this.pushTemplate = builder.pushTemplate;
                this.smsTemplate = builder.smsTemplate;
                this.voiceTemplate = builder.voiceTemplate;
            }

            @Override
            public final java.lang.Object getEmailTemplate() {
                return this.emailTemplate;
            }

            @Override
            public final java.lang.Object getPushTemplate() {
                return this.pushTemplate;
            }

            @Override
            public final java.lang.Object getSmsTemplate() {
                return this.smsTemplate;
            }

            @Override
            public final java.lang.Object getVoiceTemplate() {
                return this.voiceTemplate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailTemplate() != null) {
                    data.set("emailTemplate", om.valueToTree(this.getEmailTemplate()));
                }
                if (this.getPushTemplate() != null) {
                    data.set("pushTemplate", om.valueToTree(this.getPushTemplate()));
                }
                if (this.getSmsTemplate() != null) {
                    data.set("smsTemplate", om.valueToTree(this.getSmsTemplate()));
                }
                if (this.getVoiceTemplate() != null) {
                    data.set("voiceTemplate", om.valueToTree(this.getVoiceTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.TemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateConfigurationProperty.Jsii$Proxy that = (TemplateConfigurationProperty.Jsii$Proxy) o;

                if (this.emailTemplate != null ? !this.emailTemplate.equals(that.emailTemplate) : that.emailTemplate != null) return false;
                if (this.pushTemplate != null ? !this.pushTemplate.equals(that.pushTemplate) : that.pushTemplate != null) return false;
                if (this.smsTemplate != null ? !this.smsTemplate.equals(that.smsTemplate) : that.smsTemplate != null) return false;
                return this.voiceTemplate != null ? this.voiceTemplate.equals(that.voiceTemplate) : that.voiceTemplate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailTemplate != null ? this.emailTemplate.hashCode() : 0;
                result = 31 * result + (this.pushTemplate != null ? this.pushTemplate.hashCode() : 0);
                result = 31 * result + (this.smsTemplate != null ? this.smsTemplate.hashCode() : 0);
                result = 31 * result + (this.voiceTemplate != null ? this.voiceTemplate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the name and version of the message template to use for the message.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * TemplateProperty templateProperty = TemplateProperty.builder()
     *         .name("name")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.TemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the message template to use for the message.
         * <p>
         * If specified, this value must match the name of an existing message template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The unique identifier for the version of the message template to use for the message.
         * <p>
         * If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the Template Versions resource.
         * <p>
         * If you don't specify a value for this property, Amazon Pinpoint uses the <em>active version</em> of the template. The <em>active version</em> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link TemplateProperty#getName}
             * @param name The name of the message template to use for the message.
             *             If specified, this value must match the name of an existing message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TemplateProperty#getVersion}
             * @param version The unique identifier for the version of the message template to use for the message.
             *                If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the Template Versions resource.
             *                <p>
             *                If you don't specify a value for this property, Amazon Pinpoint uses the <em>active version</em> of the template. The <em>active version</em> is typically the version of a template that's been most recently reviewed and approved for use, depending on your workflow. It isn't necessarily the latest version of a template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.TemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateProperty.Jsii$Proxy that = (TemplateProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the settings for a campaign treatment.
     * <p>
     * A <em>treatment</em> is a variation of a campaign that's used for A/B testing of a campaign.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * Object attributes;
     * Object customConfig;
     * Object metrics;
     * WriteTreatmentResourceProperty writeTreatmentResourceProperty = WriteTreatmentResourceProperty.builder()
     *         .customDeliveryConfiguration(CustomDeliveryConfigurationProperty.builder()
     *                 .deliveryUri("deliveryUri")
     *                 .endpointTypes(List.of("endpointTypes"))
     *                 .build())
     *         .messageConfiguration(MessageConfigurationProperty.builder()
     *                 .admMessage(MessageProperty.builder()
     *                         .action("action")
     *                         .body("body")
     *                         .imageIconUrl("imageIconUrl")
     *                         .imageSmallIconUrl("imageSmallIconUrl")
     *                         .imageUrl("imageUrl")
     *                         .jsonBody("jsonBody")
     *                         .mediaUrl("mediaUrl")
     *                         .rawContent("rawContent")
     *                         .silentPush(false)
     *                         .timeToLive(123)
     *                         .title("title")
     *                         .url("url")
     *                         .build())
     *                 .apnsMessage(MessageProperty.builder()
     *                         .action("action")
     *                         .body("body")
     *                         .imageIconUrl("imageIconUrl")
     *                         .imageSmallIconUrl("imageSmallIconUrl")
     *                         .imageUrl("imageUrl")
     *                         .jsonBody("jsonBody")
     *                         .mediaUrl("mediaUrl")
     *                         .rawContent("rawContent")
     *                         .silentPush(false)
     *                         .timeToLive(123)
     *                         .title("title")
     *                         .url("url")
     *                         .build())
     *                 .baiduMessage(MessageProperty.builder()
     *                         .action("action")
     *                         .body("body")
     *                         .imageIconUrl("imageIconUrl")
     *                         .imageSmallIconUrl("imageSmallIconUrl")
     *                         .imageUrl("imageUrl")
     *                         .jsonBody("jsonBody")
     *                         .mediaUrl("mediaUrl")
     *                         .rawContent("rawContent")
     *                         .silentPush(false)
     *                         .timeToLive(123)
     *                         .title("title")
     *                         .url("url")
     *                         .build())
     *                 .customMessage(CampaignCustomMessageProperty.builder()
     *                         .data("data")
     *                         .build())
     *                 .defaultMessage(MessageProperty.builder()
     *                         .action("action")
     *                         .body("body")
     *                         .imageIconUrl("imageIconUrl")
     *                         .imageSmallIconUrl("imageSmallIconUrl")
     *                         .imageUrl("imageUrl")
     *                         .jsonBody("jsonBody")
     *                         .mediaUrl("mediaUrl")
     *                         .rawContent("rawContent")
     *                         .silentPush(false)
     *                         .timeToLive(123)
     *                         .title("title")
     *                         .url("url")
     *                         .build())
     *                 .emailMessage(CampaignEmailMessageProperty.builder()
     *                         .body("body")
     *                         .fromAddress("fromAddress")
     *                         .htmlBody("htmlBody")
     *                         .title("title")
     *                         .build())
     *                 .gcmMessage(MessageProperty.builder()
     *                         .action("action")
     *                         .body("body")
     *                         .imageIconUrl("imageIconUrl")
     *                         .imageSmallIconUrl("imageSmallIconUrl")
     *                         .imageUrl("imageUrl")
     *                         .jsonBody("jsonBody")
     *                         .mediaUrl("mediaUrl")
     *                         .rawContent("rawContent")
     *                         .silentPush(false)
     *                         .timeToLive(123)
     *                         .title("title")
     *                         .url("url")
     *                         .build())
     *                 .inAppMessage(CampaignInAppMessageProperty.builder()
     *                         .content(List.of(InAppMessageContentProperty.builder()
     *                                 .backgroundColor("backgroundColor")
     *                                 .bodyConfig(InAppMessageBodyConfigProperty.builder()
     *                                         .alignment("alignment")
     *                                         .body("body")
     *                                         .textColor("textColor")
     *                                         .build())
     *                                 .headerConfig(InAppMessageHeaderConfigProperty.builder()
     *                                         .alignment("alignment")
     *                                         .header("header")
     *                                         .textColor("textColor")
     *                                         .build())
     *                                 .imageUrl("imageUrl")
     *                                 .primaryBtn(InAppMessageButtonProperty.builder()
     *                                         .android(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                                 .backgroundColor("backgroundColor")
     *                                                 .borderRadius(123)
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .text("text")
     *                                                 .textColor("textColor")
     *                                                 .build())
     *                                         .ios(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .web(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .build())
     *                                 .secondaryBtn(InAppMessageButtonProperty.builder()
     *                                         .android(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
     *                                                 .backgroundColor("backgroundColor")
     *                                                 .borderRadius(123)
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .text("text")
     *                                                 .textColor("textColor")
     *                                                 .build())
     *                                         .ios(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .web(OverrideButtonConfigurationProperty.builder()
     *                                                 .buttonAction("buttonAction")
     *                                                 .link("link")
     *                                                 .build())
     *                                         .build())
     *                                 .build()))
     *                         .customConfig(customConfig)
     *                         .layout("layout")
     *                         .build())
     *                 .smsMessage(CampaignSmsMessageProperty.builder()
     *                         .body("body")
     *                         .entityId("entityId")
     *                         .messageType("messageType")
     *                         .originationNumber("originationNumber")
     *                         .senderId("senderId")
     *                         .templateId("templateId")
     *                         .build())
     *                 .build())
     *         .schedule(ScheduleProperty.builder()
     *                 .endTime("endTime")
     *                 .eventFilter(CampaignEventFilterProperty.builder()
     *                         .dimensions(EventDimensionsProperty.builder()
     *                                 .attributes(attributes)
     *                                 .eventType(SetDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .metrics(metrics)
     *                                 .build())
     *                         .filterType("filterType")
     *                         .build())
     *                 .frequency("frequency")
     *                 .isLocalTime(false)
     *                 .quietTime(QuietTimeProperty.builder()
     *                         .end("end")
     *                         .start("start")
     *                         .build())
     *                 .startTime("startTime")
     *                 .timeZone("timeZone")
     *                 .build())
     *         .sizePercent(123)
     *         .templateConfiguration(TemplateConfigurationProperty.builder()
     *                 .emailTemplate(TemplateProperty.builder()
     *                         .name("name")
     *                         .version("version")
     *                         .build())
     *                 .pushTemplate(TemplateProperty.builder()
     *                         .name("name")
     *                         .version("version")
     *                         .build())
     *                 .smsTemplate(TemplateProperty.builder()
     *                         .name("name")
     *                         .version("version")
     *                         .build())
     *                 .voiceTemplate(TemplateProperty.builder()
     *                         .name("name")
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         .treatmentDescription("treatmentDescription")
     *         .treatmentName("treatmentName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnCampaign.WriteTreatmentResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(WriteTreatmentResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WriteTreatmentResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delivery configuration settings for sending the treatment through a custom channel.
         * <p>
         * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomDeliveryConfiguration() {
            return null;
        }

        /**
         * The message configuration settings for the treatment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMessageConfiguration() {
            return null;
        }

        /**
         * The schedule settings for the treatment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
            return null;
        }

        /**
         * The allocated percentage of users (segment members) to send the treatment to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizePercent() {
            return null;
        }

        /**
         * The message template to use for the treatment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateConfiguration() {
            return null;
        }

        /**
         * A custom description of the treatment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTreatmentDescription() {
            return null;
        }

        /**
         * A custom name for the treatment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTreatmentName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WriteTreatmentResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WriteTreatmentResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WriteTreatmentResourceProperty> {
            java.lang.Object customDeliveryConfiguration;
            java.lang.Object messageConfiguration;
            java.lang.Object schedule;
            java.lang.Number sizePercent;
            java.lang.Object templateConfiguration;
            java.lang.String treatmentDescription;
            java.lang.String treatmentName;

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getCustomDeliveryConfiguration}
             * @param customDeliveryConfiguration The delivery configuration settings for sending the treatment through a custom channel.
             *                                    This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customDeliveryConfiguration(software.amazon.awscdk.services.pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty customDeliveryConfiguration) {
                this.customDeliveryConfiguration = customDeliveryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getCustomDeliveryConfiguration}
             * @param customDeliveryConfiguration The delivery configuration settings for sending the treatment through a custom channel.
             *                                    This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customDeliveryConfiguration(software.amazon.awscdk.IResolvable customDeliveryConfiguration) {
                this.customDeliveryConfiguration = customDeliveryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getMessageConfiguration}
             * @param messageConfiguration The message configuration settings for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageConfiguration(software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageConfigurationProperty messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getMessageConfiguration}
             * @param messageConfiguration The message configuration settings for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageConfiguration(software.amazon.awscdk.IResolvable messageConfiguration) {
                this.messageConfiguration = messageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getSchedule}
             * @param schedule The schedule settings for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.services.pinpoint.CfnCampaign.ScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getSchedule}
             * @param schedule The schedule settings for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getSizePercent}
             * @param sizePercent The allocated percentage of users (segment members) to send the treatment to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizePercent(java.lang.Number sizePercent) {
                this.sizePercent = sizePercent;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getTemplateConfiguration}
             * @param templateConfiguration The message template to use for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getTemplateConfiguration}
             * @param templateConfiguration The message template to use for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getTreatmentDescription}
             * @param treatmentDescription A custom description of the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatmentDescription(java.lang.String treatmentDescription) {
                this.treatmentDescription = treatmentDescription;
                return this;
            }

            /**
             * Sets the value of {@link WriteTreatmentResourceProperty#getTreatmentName}
             * @param treatmentName A custom name for the treatment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatmentName(java.lang.String treatmentName) {
                this.treatmentName = treatmentName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WriteTreatmentResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WriteTreatmentResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WriteTreatmentResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WriteTreatmentResourceProperty {
            private final java.lang.Object customDeliveryConfiguration;
            private final java.lang.Object messageConfiguration;
            private final java.lang.Object schedule;
            private final java.lang.Number sizePercent;
            private final java.lang.Object templateConfiguration;
            private final java.lang.String treatmentDescription;
            private final java.lang.String treatmentName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customDeliveryConfiguration = software.amazon.jsii.Kernel.get(this, "customDeliveryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageConfiguration = software.amazon.jsii.Kernel.get(this, "messageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sizePercent = software.amazon.jsii.Kernel.get(this, "sizePercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.templateConfiguration = software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.treatmentDescription = software.amazon.jsii.Kernel.get(this, "treatmentDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.treatmentName = software.amazon.jsii.Kernel.get(this, "treatmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
                this.messageConfiguration = builder.messageConfiguration;
                this.schedule = builder.schedule;
                this.sizePercent = builder.sizePercent;
                this.templateConfiguration = builder.templateConfiguration;
                this.treatmentDescription = builder.treatmentDescription;
                this.treatmentName = builder.treatmentName;
            }

            @Override
            public final java.lang.Object getCustomDeliveryConfiguration() {
                return this.customDeliveryConfiguration;
            }

            @Override
            public final java.lang.Object getMessageConfiguration() {
                return this.messageConfiguration;
            }

            @Override
            public final java.lang.Object getSchedule() {
                return this.schedule;
            }

            @Override
            public final java.lang.Number getSizePercent() {
                return this.sizePercent;
            }

            @Override
            public final java.lang.Object getTemplateConfiguration() {
                return this.templateConfiguration;
            }

            @Override
            public final java.lang.String getTreatmentDescription() {
                return this.treatmentDescription;
            }

            @Override
            public final java.lang.String getTreatmentName() {
                return this.treatmentName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomDeliveryConfiguration() != null) {
                    data.set("customDeliveryConfiguration", om.valueToTree(this.getCustomDeliveryConfiguration()));
                }
                if (this.getMessageConfiguration() != null) {
                    data.set("messageConfiguration", om.valueToTree(this.getMessageConfiguration()));
                }
                if (this.getSchedule() != null) {
                    data.set("schedule", om.valueToTree(this.getSchedule()));
                }
                if (this.getSizePercent() != null) {
                    data.set("sizePercent", om.valueToTree(this.getSizePercent()));
                }
                if (this.getTemplateConfiguration() != null) {
                    data.set("templateConfiguration", om.valueToTree(this.getTemplateConfiguration()));
                }
                if (this.getTreatmentDescription() != null) {
                    data.set("treatmentDescription", om.valueToTree(this.getTreatmentDescription()));
                }
                if (this.getTreatmentName() != null) {
                    data.set("treatmentName", om.valueToTree(this.getTreatmentName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnCampaign.WriteTreatmentResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WriteTreatmentResourceProperty.Jsii$Proxy that = (WriteTreatmentResourceProperty.Jsii$Proxy) o;

                if (this.customDeliveryConfiguration != null ? !this.customDeliveryConfiguration.equals(that.customDeliveryConfiguration) : that.customDeliveryConfiguration != null) return false;
                if (this.messageConfiguration != null ? !this.messageConfiguration.equals(that.messageConfiguration) : that.messageConfiguration != null) return false;
                if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
                if (this.sizePercent != null ? !this.sizePercent.equals(that.sizePercent) : that.sizePercent != null) return false;
                if (this.templateConfiguration != null ? !this.templateConfiguration.equals(that.templateConfiguration) : that.templateConfiguration != null) return false;
                if (this.treatmentDescription != null ? !this.treatmentDescription.equals(that.treatmentDescription) : that.treatmentDescription != null) return false;
                return this.treatmentName != null ? this.treatmentName.equals(that.treatmentName) : that.treatmentName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customDeliveryConfiguration != null ? this.customDeliveryConfiguration.hashCode() : 0;
                result = 31 * result + (this.messageConfiguration != null ? this.messageConfiguration.hashCode() : 0);
                result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
                result = 31 * result + (this.sizePercent != null ? this.sizePercent.hashCode() : 0);
                result = 31 * result + (this.templateConfiguration != null ? this.templateConfiguration.hashCode() : 0);
                result = 31 * result + (this.treatmentDescription != null ? this.treatmentDescription.hashCode() : 0);
                result = 31 * result + (this.treatmentName != null ? this.treatmentName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnCampaign}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnCampaign> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnCampaignProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnCampaignProps.Builder();
        }

        /**
         * The unique identifier for the Amazon Pinpoint application that the campaign is associated with.
         * <p>
         * @return {@code this}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the campaign is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * The name of the campaign.
         * <p>
         * @return {@code this}
         * @param name The name of the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The schedule settings for the campaign.
         * <p>
         * @return {@code this}
         * @param schedule The schedule settings for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.pinpoint.CfnCampaign.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * The schedule settings for the campaign.
         * <p>
         * @return {@code this}
         * @param schedule The schedule settings for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The unique identifier for the segment to associate with the campaign.
         * <p>
         * @return {@code this}
         * @param segmentId The unique identifier for the segment to associate with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentId(final java.lang.String segmentId) {
            this.props.segmentId(segmentId);
            return this;
        }

        /**
         * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
         * <p>
         * @return {@code this}
         * @param additionalTreatments An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalTreatments(final software.amazon.awscdk.IResolvable additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }
        /**
         * An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.
         * <p>
         * @return {@code this}
         * @param additionalTreatments An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalTreatments(final java.util.List<? extends java.lang.Object> additionalTreatments) {
            this.props.additionalTreatments(additionalTreatments);
            return this;
        }

        /**
         * Specifies the Lambda function to use as a code hook for a campaign.
         * <p>
         * @return {@code this}
         * @param campaignHook Specifies the Lambda function to use as a code hook for a campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(final software.amazon.awscdk.services.pinpoint.CfnCampaign.CampaignHookProperty campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }
        /**
         * Specifies the Lambda function to use as a code hook for a campaign.
         * <p>
         * @return {@code this}
         * @param campaignHook Specifies the Lambda function to use as a code hook for a campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(final software.amazon.awscdk.IResolvable campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        /**
         * The delivery configuration settings for sending the treatment through a custom channel.
         * <p>
         * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
         * <p>
         * @return {@code this}
         * @param customDeliveryConfiguration The delivery configuration settings for sending the treatment through a custom channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDeliveryConfiguration(final software.amazon.awscdk.services.pinpoint.CfnCampaign.CustomDeliveryConfigurationProperty customDeliveryConfiguration) {
            this.props.customDeliveryConfiguration(customDeliveryConfiguration);
            return this;
        }
        /**
         * The delivery configuration settings for sending the treatment through a custom channel.
         * <p>
         * This object is required if the <code>MessageConfiguration</code> object for the treatment specifies a <code>CustomMessage</code> object.
         * <p>
         * @return {@code this}
         * @param customDeliveryConfiguration The delivery configuration settings for sending the treatment through a custom channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDeliveryConfiguration(final software.amazon.awscdk.IResolvable customDeliveryConfiguration) {
            this.props.customDeliveryConfiguration(customDeliveryConfiguration);
            return this;
        }

        /**
         * A custom description of the campaign.
         * <p>
         * @return {@code this}
         * @param description A custom description of the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * <p>
         * @return {@code this}
         * @param holdoutPercent The allocated percentage of users (segment members) who shouldn't receive messages from the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder holdoutPercent(final java.lang.Number holdoutPercent) {
            this.props.holdoutPercent(holdoutPercent);
            return this;
        }

        /**
         * Specifies whether to pause the campaign.
         * <p>
         * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
         * <p>
         * @return {@code this}
         * @param isPaused Specifies whether to pause the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPaused(final java.lang.Boolean isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }
        /**
         * Specifies whether to pause the campaign.
         * <p>
         * A paused campaign doesn't run unless you resume it by changing this value to <code>false</code> . If you restart a campaign, the campaign restarts from the beginning and not at the point you paused it.
         * <p>
         * @return {@code this}
         * @param isPaused Specifies whether to pause the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isPaused(final software.amazon.awscdk.IResolvable isPaused) {
            this.props.isPaused(isPaused);
            return this;
        }

        /**
         * The messaging limits for the campaign.
         * <p>
         * @return {@code this}
         * @param limits The messaging limits for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(final software.amazon.awscdk.services.pinpoint.CfnCampaign.LimitsProperty limits) {
            this.props.limits(limits);
            return this;
        }
        /**
         * The messaging limits for the campaign.
         * <p>
         * @return {@code this}
         * @param limits The messaging limits for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(final software.amazon.awscdk.IResolvable limits) {
            this.props.limits(limits);
            return this;
        }

        /**
         * The message configuration settings for the campaign.
         * <p>
         * @return {@code this}
         * @param messageConfiguration The message configuration settings for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageConfiguration(final software.amazon.awscdk.services.pinpoint.CfnCampaign.MessageConfigurationProperty messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }
        /**
         * The message configuration settings for the campaign.
         * <p>
         * @return {@code this}
         * @param messageConfiguration The message configuration settings for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageConfiguration(final software.amazon.awscdk.IResolvable messageConfiguration) {
            this.props.messageConfiguration(messageConfiguration);
            return this;
        }

        /**
         * An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest.
         * <p>
         * If there are multiple messages scheduled to be displayed at the same time, the priority determines the order in which those messages are displayed.
         * <p>
         * @return {@code this}
         * @param priority An integer between 1 and 5, inclusive, that represents the priority of the in-app message campaign, where 1 is the highest priority and 5 is the lowest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * The version of the segment to associate with the campaign.
         * <p>
         * @return {@code this}
         * @param segmentVersion The version of the segment to associate with the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentVersion(final java.lang.Number segmentVersion) {
            this.props.segmentVersion(segmentVersion);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The message template to use for the treatment.
         * <p>
         * @return {@code this}
         * @param templateConfiguration The message template to use for the treatment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateConfiguration(final software.amazon.awscdk.services.pinpoint.CfnCampaign.TemplateConfigurationProperty templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }
        /**
         * The message template to use for the treatment.
         * <p>
         * @return {@code this}
         * @param templateConfiguration The message template to use for the treatment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateConfiguration(final software.amazon.awscdk.IResolvable templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }

        /**
         * A custom description of the default treatment for the campaign.
         * <p>
         * @return {@code this}
         * @param treatmentDescription A custom description of the default treatment for the campaign. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatmentDescription(final java.lang.String treatmentDescription) {
            this.props.treatmentDescription(treatmentDescription);
            return this;
        }

        /**
         * A custom name of the default treatment for the campaign, if the campaign has multiple treatments.
         * <p>
         * A <em>treatment</em> is a variation of a campaign that's used for A/B testing.
         * <p>
         * @return {@code this}
         * @param treatmentName A custom name of the default treatment for the campaign, if the campaign has multiple treatments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatmentName(final java.lang.String treatmentName) {
            this.props.treatmentName(treatmentName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnCampaign}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnCampaign build() {
            return new software.amazon.awscdk.services.pinpoint.CfnCampaign(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
