package software.amazon.awscdk.services.logs;

/**
 * Properties for a MetricFilter created from a LogGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * IFilterPattern filterPattern;
 * MetricFilterOptions metricFilterOptions = MetricFilterOptions.builder()
 *         .filterPattern(filterPattern)
 *         .metricName("metricName")
 *         .metricNamespace("metricNamespace")
 *         // the properties below are optional
 *         .defaultValue(123)
 *         .metricValue("metricValue")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.427Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.MetricFilterOptions")
@software.amazon.jsii.Jsii.Proxy(MetricFilterOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MetricFilterOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Pattern to search for log events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern();

    /**
     * The name of the metric to emit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * The namespace of the metric to emit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricNamespace();

    /**
     * The value to emit if the pattern does not match a particular event.
     * <p>
     * Default: No metric emitted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultValue() {
        return null;
    }

    /**
     * The value to emit for the metric.
     * <p>
     * Can either be a literal number (typically "1"), or the name of a field in the structure
     * to take the value from the matched event. If you are using a field value, the field
     * value must have been matched using the pattern.
     * <p>
     * If you want to specify a field from a matched JSON structure, use '$.fieldName',
     * and make sure the field is in the pattern (if only as '$.fieldName = *').
     * <p>
     * If you want to specify a field from a matched space-delimited structure,
     * use '$fieldName'.
     * <p>
     * Default: "1"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MetricFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MetricFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MetricFilterOptions> {
        software.amazon.awscdk.services.logs.IFilterPattern filterPattern;
        java.lang.String metricName;
        java.lang.String metricNamespace;
        java.lang.Number defaultValue;
        java.lang.String metricValue;

        /**
         * Sets the value of {@link MetricFilterOptions#getFilterPattern}
         * @param filterPattern Pattern to search for log events. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(software.amazon.awscdk.services.logs.IFilterPattern filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        /**
         * Sets the value of {@link MetricFilterOptions#getMetricName}
         * @param metricName The name of the metric to emit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link MetricFilterOptions#getMetricNamespace}
         * @param metricNamespace The namespace of the metric to emit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricNamespace(java.lang.String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        /**
         * Sets the value of {@link MetricFilterOptions#getDefaultValue}
         * @param defaultValue The value to emit if the pattern does not match a particular event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultValue(java.lang.Number defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        /**
         * Sets the value of {@link MetricFilterOptions#getMetricValue}
         * @param metricValue The value to emit for the metric.
         *                    Can either be a literal number (typically "1"), or the name of a field in the structure
         *                    to take the value from the matched event. If you are using a field value, the field
         *                    value must have been matched using the pattern.
         *                    <p>
         *                    If you want to specify a field from a matched JSON structure, use '$.fieldName',
         *                    and make sure the field is in the pattern (if only as '$.fieldName = *').
         *                    <p>
         *                    If you want to specify a field from a matched space-delimited structure,
         *                    use '$fieldName'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricValue(java.lang.String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MetricFilterOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MetricFilterOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MetricFilterOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricFilterOptions {
        private final software.amazon.awscdk.services.logs.IFilterPattern filterPattern;
        private final java.lang.String metricName;
        private final java.lang.String metricNamespace;
        private final java.lang.Number defaultValue;
        private final java.lang.String metricValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filterPattern = software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IFilterPattern.class));
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metricNamespace = software.amazon.jsii.Kernel.get(this, "metricNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricValue = software.amazon.jsii.Kernel.get(this, "metricValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filterPattern = java.util.Objects.requireNonNull(builder.filterPattern, "filterPattern is required");
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.metricNamespace = java.util.Objects.requireNonNull(builder.metricNamespace, "metricNamespace is required");
            this.defaultValue = builder.defaultValue;
            this.metricValue = builder.metricValue;
        }

        @Override
        public final software.amazon.awscdk.services.logs.IFilterPattern getFilterPattern() {
            return this.filterPattern;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final java.lang.Number getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final java.lang.String getMetricValue() {
            return this.metricValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filterPattern", om.valueToTree(this.getFilterPattern()));
            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("metricNamespace", om.valueToTree(this.getMetricNamespace()));
            if (this.getDefaultValue() != null) {
                data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
            }
            if (this.getMetricValue() != null) {
                data.set("metricValue", om.valueToTree(this.getMetricValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.MetricFilterOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MetricFilterOptions.Jsii$Proxy that = (MetricFilterOptions.Jsii$Proxy) o;

            if (!filterPattern.equals(that.filterPattern)) return false;
            if (!metricName.equals(that.metricName)) return false;
            if (!metricNamespace.equals(that.metricNamespace)) return false;
            if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
            return this.metricValue != null ? this.metricValue.equals(that.metricValue) : that.metricValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.filterPattern.hashCode();
            result = 31 * result + (this.metricName.hashCode());
            result = 31 * result + (this.metricNamespace.hashCode());
            result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            result = 31 * result + (this.metricValue != null ? this.metricValue.hashCode() : 0);
            return result;
        }
    }
}
