package software.amazon.awscdk.services.lambda;

/**
 * Properties for a FunctionUrl.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Function function_;
 * FunctionUrlProps functionUrlProps = FunctionUrlProps.builder()
 *         .function(function_)
 *         // the properties below are optional
 *         .authType(FunctionUrlAuthType.AWS_IAM)
 *         .cors(FunctionUrlCorsOptions.builder()
 *                 .allowCredentials(false)
 *                 .allowedHeaders(List.of("allowedHeaders"))
 *                 .allowedMethods(List.of(HttpMethod.GET))
 *                 .allowedOrigins(List.of("allowedOrigins"))
 *                 .exposedHeaders(List.of("exposedHeaders"))
 *                 .maxAge(Duration.minutes(30))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.163Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionUrlProps")
@software.amazon.jsii.Jsii.Proxy(FunctionUrlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FunctionUrlProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.FunctionUrlOptions {

    /**
     * The function to which this url refers.
     * <p>
     * It can also be an <code>Alias</code> but not a <code>Version</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getFunction();

    /**
     * @return a {@link Builder} of {@link FunctionUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FunctionUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FunctionUrlProps> {
        software.amazon.awscdk.services.lambda.IFunction function;
        software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType;
        software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors;

        /**
         * Sets the value of {@link FunctionUrlProps#getFunction}
         * @param function The function to which this url refers. This parameter is required.
         *                 It can also be an <code>Alias</code> but not a <code>Version</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder function(software.amazon.awscdk.services.lambda.IFunction function) {
            this.function = function;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlProps#getAuthType}
         * @param authType The type of authentication that your function URL uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link FunctionUrlProps#getCors}
         * @param cors The cross-origin resource sharing (CORS) settings for your function URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors) {
            this.cors = cors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FunctionUrlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FunctionUrlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FunctionUrlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionUrlProps {
        private final software.amazon.awscdk.services.lambda.IFunction function;
        private final software.amazon.awscdk.services.lambda.FunctionUrlAuthType authType;
        private final software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions cors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.function = software.amazon.jsii.Kernel.get(this, "function", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlAuthType.class));
            this.cors = software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.function = java.util.Objects.requireNonNull(builder.function, "function is required");
            this.authType = builder.authType;
            this.cors = builder.cors;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getFunction() {
            return this.function;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionUrlAuthType getAuthType() {
            return this.authType;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions getCors() {
            return this.cors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("function", om.valueToTree(this.getFunction()));
            if (this.getAuthType() != null) {
                data.set("authType", om.valueToTree(this.getAuthType()));
            }
            if (this.getCors() != null) {
                data.set("cors", om.valueToTree(this.getCors()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.FunctionUrlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FunctionUrlProps.Jsii$Proxy that = (FunctionUrlProps.Jsii$Proxy) o;

            if (!function.equals(that.function)) return false;
            if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
            return this.cors != null ? this.cors.equals(that.cors) : that.cors == null;
        }

        @Override
        public final int hashCode() {
            int result = this.function.hashCode();
            result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
            result = 31 * result + (this.cors != null ? this.cors.hashCode() : 0);
            return result;
        }
    }
}
