package software.amazon.awscdk.services.lambda;

/**
 * Construction properties for {@link CfnParametersCode}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * CfnParameter cfnParameter;
 * CfnParametersCodeProps cfnParametersCodeProps = CfnParametersCodeProps.builder()
 *         .bucketNameParam(cfnParameter)
 *         .objectKeyParam(cfnParameter)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:52:00.121Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnParametersCodeProps")
@software.amazon.jsii.Jsii.Proxy(CfnParametersCodeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnParametersCodeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in.
     * <p>
     * Must be of type 'String'.
     * <p>
     * Default: a new parameter will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnParameter getBucketNameParam() {
        return null;
    }

    /**
     * The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at.
     * <p>
     * Must be of type 'String'.
     * <p>
     * Default: a new parameter will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnParameter getObjectKeyParam() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnParametersCodeProps> {
        software.amazon.awscdk.CfnParameter bucketNameParam;
        software.amazon.awscdk.CfnParameter objectKeyParam;

        /**
         * Sets the value of {@link CfnParametersCodeProps#getBucketNameParam}
         * @param bucketNameParam The CloudFormation parameter that represents the name of the S3 Bucket where the Lambda code will be located in.
         *                        Must be of type 'String'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNameParam(software.amazon.awscdk.CfnParameter bucketNameParam) {
            this.bucketNameParam = bucketNameParam;
            return this;
        }

        /**
         * Sets the value of {@link CfnParametersCodeProps#getObjectKeyParam}
         * @param objectKeyParam The CloudFormation parameter that represents the path inside the S3 Bucket where the Lambda code will be located at.
         *                       Must be of type 'String'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectKeyParam(software.amazon.awscdk.CfnParameter objectKeyParam) {
            this.objectKeyParam = objectKeyParam;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnParametersCodeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnParametersCodeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnParametersCodeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnParametersCodeProps {
        private final software.amazon.awscdk.CfnParameter bucketNameParam;
        private final software.amazon.awscdk.CfnParameter objectKeyParam;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucketNameParam = software.amazon.jsii.Kernel.get(this, "bucketNameParam", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnParameter.class));
            this.objectKeyParam = software.amazon.jsii.Kernel.get(this, "objectKeyParam", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnParameter.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucketNameParam = builder.bucketNameParam;
            this.objectKeyParam = builder.objectKeyParam;
        }

        @Override
        public final software.amazon.awscdk.CfnParameter getBucketNameParam() {
            return this.bucketNameParam;
        }

        @Override
        public final software.amazon.awscdk.CfnParameter getObjectKeyParam() {
            return this.objectKeyParam;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucketNameParam() != null) {
                data.set("bucketNameParam", om.valueToTree(this.getBucketNameParam()));
            }
            if (this.getObjectKeyParam() != null) {
                data.set("objectKeyParam", om.valueToTree(this.getObjectKeyParam()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnParametersCodeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnParametersCodeProps.Jsii$Proxy that = (CfnParametersCodeProps.Jsii$Proxy) o;

            if (this.bucketNameParam != null ? !this.bucketNameParam.equals(that.bucketNameParam) : that.bucketNameParam != null) return false;
            return this.objectKeyParam != null ? this.objectKeyParam.equals(that.objectKeyParam) : that.objectKeyParam == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucketNameParam != null ? this.bucketNameParam.hashCode() : 0;
            result = 31 * result + (this.objectKeyParam != null ? this.objectKeyParam.hashCode() : 0);
            return result;
        }
    }
}
