package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a `CfnGateway`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnGatewayProps cfnGatewayProps = CfnGatewayProps.builder()
 *         .gatewayName("gatewayName")
 *         .gatewayPlatform(GatewayPlatformProperty.builder()
 *                 .greengrass(GreengrassProperty.builder()
 *                         .groupArn("groupArn")
 *                         .build())
 *                 .greengrassV2(GreengrassV2Property.builder()
 *                         .coreDeviceThingName("coreDeviceThingName")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .gatewayCapabilitySummaries(List.of(GatewayCapabilitySummaryProperty.builder()
 *                 .capabilityNamespace("capabilityNamespace")
 *                 // the properties below are optional
 *                 .capabilityConfiguration("capabilityConfiguration")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.745Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique, friendly name for the gateway.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGatewayName();

    /**
     * The gateway's platform.
     * <p>
     * You can only specify one platform in a gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getGatewayPlatform();

    /**
     * A list of gateway capability summaries that each contain a namespace and status.
     * <p>
     * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGatewayCapabilitySummaries() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the gateway.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGatewayProps> {
        java.lang.String gatewayName;
        java.lang.Object gatewayPlatform;
        java.lang.Object gatewayCapabilitySummaries;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnGatewayProps#getGatewayName}
         * @param gatewayName A unique, friendly name for the gateway. This parameter is required.
         *                    The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayName(java.lang.String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getGatewayPlatform}
         * @param gatewayPlatform The gateway's platform. This parameter is required.
         *                        You can only specify one platform in a gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayPlatform(software.amazon.awscdk.services.iotsitewise.CfnGateway.GatewayPlatformProperty gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getGatewayPlatform}
         * @param gatewayPlatform The gateway's platform. This parameter is required.
         *                        You can only specify one platform in a gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayPlatform(software.amazon.awscdk.IResolvable gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getGatewayCapabilitySummaries}
         * @param gatewayCapabilitySummaries A list of gateway capability summaries that each contain a namespace and status.
         *                                   Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayCapabilitySummaries(software.amazon.awscdk.IResolvable gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = gatewayCapabilitySummaries;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getGatewayCapabilitySummaries}
         * @param gatewayCapabilitySummaries A list of gateway capability summaries that each contain a namespace and status.
         *                                   Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayCapabilitySummaries(java.util.List<? extends java.lang.Object> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = gatewayCapabilitySummaries;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the gateway.
         *             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayProps {
        private final java.lang.String gatewayName;
        private final java.lang.Object gatewayPlatform;
        private final java.lang.Object gatewayCapabilitySummaries;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gatewayName = software.amazon.jsii.Kernel.get(this, "gatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewayPlatform = software.amazon.jsii.Kernel.get(this, "gatewayPlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.gatewayCapabilitySummaries = software.amazon.jsii.Kernel.get(this, "gatewayCapabilitySummaries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gatewayName = java.util.Objects.requireNonNull(builder.gatewayName, "gatewayName is required");
            this.gatewayPlatform = java.util.Objects.requireNonNull(builder.gatewayPlatform, "gatewayPlatform is required");
            this.gatewayCapabilitySummaries = builder.gatewayCapabilitySummaries;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final java.lang.Object getGatewayPlatform() {
            return this.gatewayPlatform;
        }

        @Override
        public final java.lang.Object getGatewayCapabilitySummaries() {
            return this.gatewayCapabilitySummaries;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("gatewayName", om.valueToTree(this.getGatewayName()));
            data.set("gatewayPlatform", om.valueToTree(this.getGatewayPlatform()));
            if (this.getGatewayCapabilitySummaries() != null) {
                data.set("gatewayCapabilitySummaries", om.valueToTree(this.getGatewayCapabilitySummaries()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayProps.Jsii$Proxy that = (CfnGatewayProps.Jsii$Proxy) o;

            if (!gatewayName.equals(that.gatewayName)) return false;
            if (!gatewayPlatform.equals(that.gatewayPlatform)) return false;
            if (this.gatewayCapabilitySummaries != null ? !this.gatewayCapabilitySummaries.equals(that.gatewayCapabilitySummaries) : that.gatewayCapabilitySummaries != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gatewayName.hashCode();
            result = 31 * result + (this.gatewayPlatform.hashCode());
            result = 31 * result + (this.gatewayCapabilitySummaries != null ? this.gatewayCapabilitySummaries.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
