package software.amazon.awscdk.services.iotcoredeviceadvisor;

/**
 * A CloudFormation `AWS::IoTCoreDeviceAdvisor::SuiteDefinition`.
 * <p>
 * Creates a Device Advisor test suite.
 * <p>
 * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSuiteDefinition</a> action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotcoredeviceadvisor.*;
 * Object suiteDefinitionConfiguration;
 * CfnSuiteDefinition cfnSuiteDefinition = CfnSuiteDefinition.Builder.create(this, "MyCfnSuiteDefinition")
 *         .suiteDefinitionConfiguration(suiteDefinitionConfiguration)
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.644Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition")
public class CfnSuiteDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSuiteDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSuiteDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTCoreDeviceAdvisor::SuiteDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSuiteDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Arn of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionId() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata that can be used to manage the the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` .
     * <p>
     * <ul>
     * <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> List of devices under test
     * <p>
     * <ul>
     * <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> Boolean
     * <p>
     * <ul>
     * <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSuiteDefinitionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "suiteDefinitionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` .
     * <p>
     * <ul>
     * <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> List of devices under test
     * <p>
     * <ul>
     * <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
     * </ul>
     * <p>
     * Not a required element.
     * <p>
     * <em>Type:</em> Boolean
     * <p>
     * <ul>
     * <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     * <p>
     * <ul>
     * <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
     * </ul>
     * <p>
     * This is a required element.
     * <p>
     * <em>Type:</em> String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuiteDefinitionConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "suiteDefinitionConfiguration", java.util.Objects.requireNonNull(value, "suiteDefinitionConfiguration is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps.Builder();
        }

        /**
         * The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` .
         * <p>
         * <ul>
         * <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * <ul>
         * <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
         * </ul>
         * <p>
         * Not a required element.
         * <p>
         * <em>Type:</em> List of devices under test
         * <p>
         * <ul>
         * <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
         * </ul>
         * <p>
         * Not a required element.
         * <p>
         * <em>Type:</em> Boolean
         * <p>
         * <ul>
         * <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * <ul>
         * <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * @return {@code this}
         * @param suiteDefinitionConfiguration The configuration of the Suite Definition. Listed below are the required elements of the `SuiteDefinitionConfiguration` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suiteDefinitionConfiguration(final java.lang.Object suiteDefinitionConfiguration) {
            this.props.suiteDefinitionConfiguration(suiteDefinitionConfiguration);
            return this;
        }

        /**
         * Metadata that can be used to manage the the Suite Definition.
         * <p>
         * @return {@code this}
         * @param tags Metadata that can be used to manage the the Suite Definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition build() {
            return new software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
