package software.amazon.awscdk.services.evidently;

/**
 * A CloudFormation `AWS::Evidently::Launch`.
 * <p>
 * Creates or updates a <em>launch</em> of a given feature. Before you create a launch, you must create the feature to use for the launch.
 * <p>
 * You can use a launch to safely validate new features by serving them to a specified percentage of your users while you roll out the feature. You can monitor the performance of the new feature to help you decide when to ramp up traffic to more users. This helps you reduce risk and identify unintended consequences before you fully launch the feature.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnLaunch cfnLaunch = CfnLaunch.Builder.create(this, "MyCfnLaunch")
 *         .groups(List.of(LaunchGroupObjectProperty.builder()
 *                 .feature("feature")
 *                 .groupName("groupName")
 *                 .variation("variation")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         .name("name")
 *         .project("project")
 *         .scheduledSplitsConfig(List.of(StepConfigProperty.builder()
 *                 .groupWeights(List.of(GroupToWeightProperty.builder()
 *                         .groupName("groupName")
 *                         .splitWeight(123)
 *                         .build()))
 *                 .startTime("startTime")
 *                 // the properties below are optional
 *                 .segmentOverrides(List.of(SegmentOverrideProperty.builder()
 *                         .evaluationOrder(123)
 *                         .segment("segment")
 *                         .weights(List.of(GroupToWeightProperty.builder()
 *                                 .groupName("groupName")
 *                                 .splitWeight(123)
 *                                 .build()))
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .executionStatus(ExecutionStatusObjectProperty.builder()
 *                 .status("status")
 *                 // the properties below are optional
 *                 .desiredState("desiredState")
 *                 .reason("reason")
 *                 .build())
 *         .metricMonitors(List.of(MetricDefinitionObjectProperty.builder()
 *                 .entityIdKey("entityIdKey")
 *                 .eventPattern("eventPattern")
 *                 .metricName("metricName")
 *                 .valueKey("valueKey")
 *                 // the properties below are optional
 *                 .unitLabel("unitLabel")
 *                 .build()))
 *         .randomizationSalt("randomizationSalt")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:59.046Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch")
public class CfnLaunch extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLaunch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLaunch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.evidently.CfnLaunch.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Evidently::Launch`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLaunch(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.evidently.CfnLaunchProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the launch.
     * <p>
     * For example, <code>arn:aws:evidently:us-west-2:0123455678912:project/myProject/launch/myLaunch</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Assigns one or more tags (key-value pairs) to the launch.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with a launch.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An array of structures that contains the feature and variations that are to be used for the launch.
     * <p>
     * You can up to five launch groups in a launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getGroups() {
        return software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that contains the feature and variations that are to be used for the launch.
     * <p>
     * You can up to five launch groups in a launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "groups", java.util.Objects.requireNonNull(value, "groups is required"));
    }

    /**
     * An array of structures that contains the feature and variations that are to be used for the launch.
     * <p>
     * You can up to five launch groups in a launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroups(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "groups", java.util.Objects.requireNonNull(value, "groups is required"));
    }

    /**
     * The name for the launch.
     * <p>
     * It can include up to 127 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the launch.
     * <p>
     * It can include up to 127 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The name or ARN of the project that you want to create the launch in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProject() {
        return software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or ARN of the project that you want to create the launch in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProject(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "project", java.util.Objects.requireNonNull(value, "project is required"));
    }

    /**
     * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getScheduledSplitsConfig() {
        return software.amazon.jsii.Kernel.get(this, "scheduledSplitsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledSplitsConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scheduledSplitsConfig", java.util.Objects.requireNonNull(value, "scheduledSplitsConfig is required"));
    }

    /**
     * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledSplitsConfig(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "scheduledSplitsConfig", java.util.Objects.requireNonNull(value, "scheduledSplitsConfig is required"));
    }

    /**
     * An optional description for the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional description for the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * A structure that you can use to start and stop the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExecutionStatus() {
        return software.amazon.jsii.Kernel.get(this, "executionStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure that you can use to start and stop the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionStatus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.evidently.CfnLaunch.ExecutionStatusObjectProperty value) {
        software.amazon.jsii.Kernel.set(this, "executionStatus", value);
    }

    /**
     * A structure that you can use to start and stop the launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionStatus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "executionStatus", value);
    }

    /**
     * An array of structures that define the metrics that will be used to monitor the launch performance.
     * <p>
     * You can have up to three metric monitors in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetricMonitors() {
        return software.amazon.jsii.Kernel.get(this, "metricMonitors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of structures that define the metrics that will be used to monitor the launch performance.
     * <p>
     * You can have up to three metric monitors in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricMonitors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricMonitors", value);
    }

    /**
     * An array of structures that define the metrics that will be used to monitor the launch performance.
     * <p>
     * You can have up to three metric monitors in the array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricMonitors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "metricMonitors", value);
    }

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served.
     * <p>
     * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the launch name as the <code>randomizationsSalt</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRandomizationSalt() {
        return software.amazon.jsii.Kernel.get(this, "randomizationSalt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served.
     * <p>
     * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the launch name as the <code>randomizationsSalt</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRandomizationSalt(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "randomizationSalt", value);
    }
    /**
     * Use this structure to start and stop the launch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * ExecutionStatusObjectProperty executionStatusObjectProperty = ExecutionStatusObjectProperty.builder()
     *         .status("status")
     *         // the properties below are optional
     *         .desiredState("desiredState")
     *         .reason("reason")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.ExecutionStatusObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecutionStatusObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecutionStatusObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * To start the launch now, specify `START` for this parameter.
         * <p>
         * If this launch is currently running and you want to stop it now, specify <code>STOP</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * If you are using AWS CloudFormation to stop this launch, specify either `COMPLETED` or `CANCELLED` here to indicate how to classify this experiment.
         * <p>
         * If you omit this parameter, the default of <code>COMPLETED</code> is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDesiredState() {
            return null;
        }

        /**
         * If you are using AWS CloudFormation to stop this launch, this is an optional field that you can use to record why the launch is being stopped or cancelled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReason() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecutionStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecutionStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecutionStatusObjectProperty> {
            java.lang.String status;
            java.lang.String desiredState;
            java.lang.String reason;

            /**
             * Sets the value of {@link ExecutionStatusObjectProperty#getStatus}
             * @param status To start the launch now, specify `START` for this parameter. This parameter is required.
             *               If this launch is currently running and you want to stop it now, specify <code>STOP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionStatusObjectProperty#getDesiredState}
             * @param desiredState If you are using AWS CloudFormation to stop this launch, specify either `COMPLETED` or `CANCELLED` here to indicate how to classify this experiment.
             *                     If you omit this parameter, the default of <code>COMPLETED</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredState(java.lang.String desiredState) {
                this.desiredState = desiredState;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionStatusObjectProperty#getReason}
             * @param reason If you are using AWS CloudFormation to stop this launch, this is an optional field that you can use to record why the launch is being stopped or cancelled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reason(java.lang.String reason) {
                this.reason = reason;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecutionStatusObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecutionStatusObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecutionStatusObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionStatusObjectProperty {
            private final java.lang.String status;
            private final java.lang.String desiredState;
            private final java.lang.String reason;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.desiredState = software.amazon.jsii.Kernel.get(this, "desiredState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.desiredState = builder.desiredState;
                this.reason = builder.reason;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.String getDesiredState() {
                return this.desiredState;
            }

            @Override
            public final java.lang.String getReason() {
                return this.reason;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                if (this.getDesiredState() != null) {
                    data.set("desiredState", om.valueToTree(this.getDesiredState()));
                }
                if (this.getReason() != null) {
                    data.set("reason", om.valueToTree(this.getReason()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.ExecutionStatusObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecutionStatusObjectProperty.Jsii$Proxy that = (ExecutionStatusObjectProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                if (this.desiredState != null ? !this.desiredState.equals(that.desiredState) : that.desiredState != null) return false;
                return this.reason != null ? this.reason.equals(that.reason) : that.reason == null;
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.desiredState != null ? this.desiredState.hashCode() : 0);
                result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure containing the percentage of launch traffic to allocate to one launch group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * GroupToWeightProperty groupToWeightProperty = GroupToWeightProperty.builder()
     *         .groupName("groupName")
     *         .splitWeight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.GroupToWeightProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupToWeightProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupToWeightProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the launch group.
         * <p>
         * It can include up to 127 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupName();

        /**
         * The portion of launch traffic to allocate to this launch group.
         * <p>
         * This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSplitWeight();

        /**
         * @return a {@link Builder} of {@link GroupToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupToWeightProperty> {
            java.lang.String groupName;
            java.lang.Number splitWeight;

            /**
             * Sets the value of {@link GroupToWeightProperty#getGroupName}
             * @param groupName The name of the launch group. This parameter is required.
             *                  It can include up to 127 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link GroupToWeightProperty#getSplitWeight}
             * @param splitWeight The portion of launch traffic to allocate to this launch group. This parameter is required.
             *                    This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitWeight(java.lang.Number splitWeight) {
                this.splitWeight = splitWeight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupToWeightProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupToWeightProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupToWeightProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupToWeightProperty {
            private final java.lang.String groupName;
            private final java.lang.Number splitWeight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.splitWeight = software.amazon.jsii.Kernel.get(this, "splitWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupName = java.util.Objects.requireNonNull(builder.groupName, "groupName is required");
                this.splitWeight = java.util.Objects.requireNonNull(builder.splitWeight, "splitWeight is required");
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.Number getSplitWeight() {
                return this.splitWeight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupName", om.valueToTree(this.getGroupName()));
                data.set("splitWeight", om.valueToTree(this.getSplitWeight()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.GroupToWeightProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupToWeightProperty.Jsii$Proxy that = (GroupToWeightProperty.Jsii$Proxy) o;

                if (!groupName.equals(that.groupName)) return false;
                return this.splitWeight.equals(that.splitWeight);
            }

            @Override
            public final int hashCode() {
                int result = this.groupName.hashCode();
                result = 31 * result + (this.splitWeight.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that defines one launch group in a launch.
     * <p>
     * A launch group is a variation of the feature that you are including in the launch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * LaunchGroupObjectProperty launchGroupObjectProperty = LaunchGroupObjectProperty.builder()
     *         .feature("feature")
     *         .groupName("groupName")
     *         .variation("variation")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.LaunchGroupObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(LaunchGroupObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LaunchGroupObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The feature that this launch is using.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeature();

        /**
         * A name for this launch group.
         * <p>
         * It can include up to 127 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupName();

        /**
         * The feature variation to use for this launch group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariation();

        /**
         * A description of the launch group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LaunchGroupObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LaunchGroupObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LaunchGroupObjectProperty> {
            java.lang.String feature;
            java.lang.String groupName;
            java.lang.String variation;
            java.lang.String description;

            /**
             * Sets the value of {@link LaunchGroupObjectProperty#getFeature}
             * @param feature The feature that this launch is using. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder feature(java.lang.String feature) {
                this.feature = feature;
                return this;
            }

            /**
             * Sets the value of {@link LaunchGroupObjectProperty#getGroupName}
             * @param groupName A name for this launch group. This parameter is required.
             *                  It can include up to 127 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupName(java.lang.String groupName) {
                this.groupName = groupName;
                return this;
            }

            /**
             * Sets the value of {@link LaunchGroupObjectProperty#getVariation}
             * @param variation The feature variation to use for this launch group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variation(java.lang.String variation) {
                this.variation = variation;
                return this;
            }

            /**
             * Sets the value of {@link LaunchGroupObjectProperty#getDescription}
             * @param description A description of the launch group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchGroupObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LaunchGroupObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LaunchGroupObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchGroupObjectProperty {
            private final java.lang.String feature;
            private final java.lang.String groupName;
            private final java.lang.String variation;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.feature = software.amazon.jsii.Kernel.get(this, "feature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupName = software.amazon.jsii.Kernel.get(this, "groupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.variation = software.amazon.jsii.Kernel.get(this, "variation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.feature = java.util.Objects.requireNonNull(builder.feature, "feature is required");
                this.groupName = java.util.Objects.requireNonNull(builder.groupName, "groupName is required");
                this.variation = java.util.Objects.requireNonNull(builder.variation, "variation is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getFeature() {
                return this.feature;
            }

            @Override
            public final java.lang.String getGroupName() {
                return this.groupName;
            }

            @Override
            public final java.lang.String getVariation() {
                return this.variation;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("feature", om.valueToTree(this.getFeature()));
                data.set("groupName", om.valueToTree(this.getGroupName()));
                data.set("variation", om.valueToTree(this.getVariation()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.LaunchGroupObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LaunchGroupObjectProperty.Jsii$Proxy that = (LaunchGroupObjectProperty.Jsii$Proxy) o;

                if (!feature.equals(that.feature)) return false;
                if (!groupName.equals(that.groupName)) return false;
                if (!variation.equals(that.variation)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.feature.hashCode();
                result = 31 * result + (this.groupName.hashCode());
                result = 31 * result + (this.variation.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines a metric that you want to use to evaluate the variations during a launch or experiment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * MetricDefinitionObjectProperty metricDefinitionObjectProperty = MetricDefinitionObjectProperty.builder()
     *         .entityIdKey("entityIdKey")
     *         .eventPattern("eventPattern")
     *         .metricName("metricName")
     *         .valueKey("valueKey")
     *         // the properties below are optional
     *         .unitLabel("unitLabel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.MetricDefinitionObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDefinitionObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDefinitionObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity, such as a user or session, that does an action that causes a metric value to be recorded.
         * <p>
         * An example is <code>userDetails.userID</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityIdKey();

        /**
         * The EventBridge event pattern that defines how the metric is recorded.
         * <p>
         * For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventPattern();

        /**
         * A name for the metric.
         * <p>
         * It can include up to 255 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The value that is tracked to produce the metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueKey();

        /**
         * A label for the units that the metric is measuring.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricDefinitionObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDefinitionObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDefinitionObjectProperty> {
            java.lang.String entityIdKey;
            java.lang.String eventPattern;
            java.lang.String metricName;
            java.lang.String valueKey;
            java.lang.String unitLabel;

            /**
             * Sets the value of {@link MetricDefinitionObjectProperty#getEntityIdKey}
             * @param entityIdKey The entity, such as a user or session, that does an action that causes a metric value to be recorded. This parameter is required.
             *                    An example is <code>userDetails.userID</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityIdKey(java.lang.String entityIdKey) {
                this.entityIdKey = entityIdKey;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionObjectProperty#getEventPattern}
             * @param eventPattern The EventBridge event pattern that defines how the metric is recorded. This parameter is required.
             *                     For more information about EventBridge event patterns, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event patterns</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventPattern(java.lang.String eventPattern) {
                this.eventPattern = eventPattern;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionObjectProperty#getMetricName}
             * @param metricName A name for the metric. This parameter is required.
             *                   It can include up to 255 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionObjectProperty#getValueKey}
             * @param valueKey The value that is tracked to produce the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueKey(java.lang.String valueKey) {
                this.valueKey = valueKey;
                return this;
            }

            /**
             * Sets the value of {@link MetricDefinitionObjectProperty#getUnitLabel}
             * @param unitLabel A label for the units that the metric is measuring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitLabel(java.lang.String unitLabel) {
                this.unitLabel = unitLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDefinitionObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDefinitionObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDefinitionObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDefinitionObjectProperty {
            private final java.lang.String entityIdKey;
            private final java.lang.String eventPattern;
            private final java.lang.String metricName;
            private final java.lang.String valueKey;
            private final java.lang.String unitLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityIdKey = software.amazon.jsii.Kernel.get(this, "entityIdKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueKey = software.amazon.jsii.Kernel.get(this, "valueKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unitLabel = software.amazon.jsii.Kernel.get(this, "unitLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityIdKey = java.util.Objects.requireNonNull(builder.entityIdKey, "entityIdKey is required");
                this.eventPattern = java.util.Objects.requireNonNull(builder.eventPattern, "eventPattern is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.valueKey = java.util.Objects.requireNonNull(builder.valueKey, "valueKey is required");
                this.unitLabel = builder.unitLabel;
            }

            @Override
            public final java.lang.String getEntityIdKey() {
                return this.entityIdKey;
            }

            @Override
            public final java.lang.String getEventPattern() {
                return this.eventPattern;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getValueKey() {
                return this.valueKey;
            }

            @Override
            public final java.lang.String getUnitLabel() {
                return this.unitLabel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityIdKey", om.valueToTree(this.getEntityIdKey()));
                data.set("eventPattern", om.valueToTree(this.getEventPattern()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("valueKey", om.valueToTree(this.getValueKey()));
                if (this.getUnitLabel() != null) {
                    data.set("unitLabel", om.valueToTree(this.getUnitLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.MetricDefinitionObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDefinitionObjectProperty.Jsii$Proxy that = (MetricDefinitionObjectProperty.Jsii$Proxy) o;

                if (!entityIdKey.equals(that.entityIdKey)) return false;
                if (!eventPattern.equals(that.eventPattern)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!valueKey.equals(that.valueKey)) return false;
                return this.unitLabel != null ? this.unitLabel.equals(that.unitLabel) : that.unitLabel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityIdKey.hashCode();
                result = 31 * result + (this.eventPattern.hashCode());
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.valueKey.hashCode());
                result = 31 * result + (this.unitLabel != null ? this.unitLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * SegmentOverrideProperty segmentOverrideProperty = SegmentOverrideProperty.builder()
     *         .evaluationOrder(123)
     *         .segment("segment")
     *         .weights(List.of(GroupToWeightProperty.builder()
     *                 .groupName("groupName")
     *                 .splitWeight(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.SegmentOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(SegmentOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SegmentOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLaunch.SegmentOverrideProperty.EvaluationOrder`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationOrder();

        /**
         * `CfnLaunch.SegmentOverrideProperty.Segment`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSegment();

        /**
         * `CfnLaunch.SegmentOverrideProperty.Weights`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWeights();

        /**
         * @return a {@link Builder} of {@link SegmentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SegmentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SegmentOverrideProperty> {
            java.lang.Number evaluationOrder;
            java.lang.String segment;
            java.lang.Object weights;

            /**
             * Sets the value of {@link SegmentOverrideProperty#getEvaluationOrder}
             * @param evaluationOrder `CfnLaunch.SegmentOverrideProperty.EvaluationOrder`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationOrder(java.lang.Number evaluationOrder) {
                this.evaluationOrder = evaluationOrder;
                return this;
            }

            /**
             * Sets the value of {@link SegmentOverrideProperty#getSegment}
             * @param segment `CfnLaunch.SegmentOverrideProperty.Segment`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segment(java.lang.String segment) {
                this.segment = segment;
                return this;
            }

            /**
             * Sets the value of {@link SegmentOverrideProperty#getWeights}
             * @param weights `CfnLaunch.SegmentOverrideProperty.Weights`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weights(software.amazon.awscdk.IResolvable weights) {
                this.weights = weights;
                return this;
            }

            /**
             * Sets the value of {@link SegmentOverrideProperty#getWeights}
             * @param weights `CfnLaunch.SegmentOverrideProperty.Weights`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weights(java.util.List<? extends java.lang.Object> weights) {
                this.weights = weights;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SegmentOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SegmentOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SegmentOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentOverrideProperty {
            private final java.lang.Number evaluationOrder;
            private final java.lang.String segment;
            private final java.lang.Object weights;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.evaluationOrder = software.amazon.jsii.Kernel.get(this, "evaluationOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segment = software.amazon.jsii.Kernel.get(this, "segment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weights = software.amazon.jsii.Kernel.get(this, "weights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.evaluationOrder = java.util.Objects.requireNonNull(builder.evaluationOrder, "evaluationOrder is required");
                this.segment = java.util.Objects.requireNonNull(builder.segment, "segment is required");
                this.weights = java.util.Objects.requireNonNull(builder.weights, "weights is required");
            }

            @Override
            public final java.lang.Number getEvaluationOrder() {
                return this.evaluationOrder;
            }

            @Override
            public final java.lang.String getSegment() {
                return this.segment;
            }

            @Override
            public final java.lang.Object getWeights() {
                return this.weights;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("evaluationOrder", om.valueToTree(this.getEvaluationOrder()));
                data.set("segment", om.valueToTree(this.getSegment()));
                data.set("weights", om.valueToTree(this.getWeights()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.SegmentOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SegmentOverrideProperty.Jsii$Proxy that = (SegmentOverrideProperty.Jsii$Proxy) o;

                if (!evaluationOrder.equals(that.evaluationOrder)) return false;
                if (!segment.equals(that.segment)) return false;
                return this.weights.equals(that.weights);
            }

            @Override
            public final int hashCode() {
                int result = this.evaluationOrder.hashCode();
                result = 31 * result + (this.segment.hashCode());
                result = 31 * result + (this.weights.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that defines when each step of the launch is to start, and how much launch traffic is to be allocated to each variation during each step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.evidently.*;
     * StepConfigProperty stepConfigProperty = StepConfigProperty.builder()
     *         .groupWeights(List.of(GroupToWeightProperty.builder()
     *                 .groupName("groupName")
     *                 .splitWeight(123)
     *                 .build()))
     *         .startTime("startTime")
     *         // the properties below are optional
     *         .segmentOverrides(List.of(SegmentOverrideProperty.builder()
     *                 .evaluationOrder(123)
     *                 .segment("segment")
     *                 .weights(List.of(GroupToWeightProperty.builder()
     *                         .groupName("groupName")
     *                         .splitWeight(123)
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunch.StepConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(StepConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGroupWeights();

        /**
         * The date and time to start this step of the launch.
         * <p>
         * Use UTC format, <code>yyyy-MM-ddTHH:mm:ssZ</code> . For example, <code>2025-11-25T23:59:59Z</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStartTime();

        /**
         * `CfnLaunch.StepConfigProperty.SegmentOverrides`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSegmentOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepConfigProperty> {
            java.lang.Object groupWeights;
            java.lang.String startTime;
            java.lang.Object segmentOverrides;

            /**
             * Sets the value of {@link StepConfigProperty#getGroupWeights}
             * @param groupWeights An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupWeights(software.amazon.awscdk.IResolvable groupWeights) {
                this.groupWeights = groupWeights;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getGroupWeights}
             * @param groupWeights An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupWeights(java.util.List<? extends java.lang.Object> groupWeights) {
                this.groupWeights = groupWeights;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getStartTime}
             * @param startTime The date and time to start this step of the launch. This parameter is required.
             *                  Use UTC format, <code>yyyy-MM-ddTHH:mm:ssZ</code> . For example, <code>2025-11-25T23:59:59Z</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(java.lang.String startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getSegmentOverrides}
             * @param segmentOverrides `CfnLaunch.StepConfigProperty.SegmentOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentOverrides(software.amazon.awscdk.IResolvable segmentOverrides) {
                this.segmentOverrides = segmentOverrides;
                return this;
            }

            /**
             * Sets the value of {@link StepConfigProperty#getSegmentOverrides}
             * @param segmentOverrides `CfnLaunch.StepConfigProperty.SegmentOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentOverrides(java.util.List<? extends java.lang.Object> segmentOverrides) {
                this.segmentOverrides = segmentOverrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepConfigProperty {
            private final java.lang.Object groupWeights;
            private final java.lang.String startTime;
            private final java.lang.Object segmentOverrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupWeights = software.amazon.jsii.Kernel.get(this, "groupWeights", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentOverrides = software.amazon.jsii.Kernel.get(this, "segmentOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupWeights = java.util.Objects.requireNonNull(builder.groupWeights, "groupWeights is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
                this.segmentOverrides = builder.segmentOverrides;
            }

            @Override
            public final java.lang.Object getGroupWeights() {
                return this.groupWeights;
            }

            @Override
            public final java.lang.String getStartTime() {
                return this.startTime;
            }

            @Override
            public final java.lang.Object getSegmentOverrides() {
                return this.segmentOverrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupWeights", om.valueToTree(this.getGroupWeights()));
                data.set("startTime", om.valueToTree(this.getStartTime()));
                if (this.getSegmentOverrides() != null) {
                    data.set("segmentOverrides", om.valueToTree(this.getSegmentOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunch.StepConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepConfigProperty.Jsii$Proxy that = (StepConfigProperty.Jsii$Proxy) o;

                if (!groupWeights.equals(that.groupWeights)) return false;
                if (!startTime.equals(that.startTime)) return false;
                return this.segmentOverrides != null ? this.segmentOverrides.equals(that.segmentOverrides) : that.segmentOverrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupWeights.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                result = 31 * result + (this.segmentOverrides != null ? this.segmentOverrides.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.evidently.CfnLaunch}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.evidently.CfnLaunch> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.evidently.CfnLaunchProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.evidently.CfnLaunchProps.Builder();
        }

        /**
         * An array of structures that contains the feature and variations that are to be used for the launch.
         * <p>
         * You can up to five launch groups in a launch.
         * <p>
         * @return {@code this}
         * @param groups An array of structures that contains the feature and variations that are to be used for the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final software.amazon.awscdk.IResolvable groups) {
            this.props.groups(groups);
            return this;
        }
        /**
         * An array of structures that contains the feature and variations that are to be used for the launch.
         * <p>
         * You can up to five launch groups in a launch.
         * <p>
         * @return {@code this}
         * @param groups An array of structures that contains the feature and variations that are to be used for the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<? extends java.lang.Object> groups) {
            this.props.groups(groups);
            return this;
        }

        /**
         * The name for the launch.
         * <p>
         * It can include up to 127 characters.
         * <p>
         * @return {@code this}
         * @param name The name for the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The name or ARN of the project that you want to create the launch in.
         * <p>
         * @return {@code this}
         * @param project The name or ARN of the project that you want to create the launch in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(final java.lang.String project) {
            this.props.project(project);
            return this;
        }

        /**
         * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
         * <p>
         * @return {@code this}
         * @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledSplitsConfig(final software.amazon.awscdk.IResolvable scheduledSplitsConfig) {
            this.props.scheduledSplitsConfig(scheduledSplitsConfig);
            return this;
        }
        /**
         * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
         * <p>
         * @return {@code this}
         * @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledSplitsConfig(final java.util.List<? extends java.lang.Object> scheduledSplitsConfig) {
            this.props.scheduledSplitsConfig(scheduledSplitsConfig);
            return this;
        }

        /**
         * An optional description for the launch.
         * <p>
         * @return {@code this}
         * @param description An optional description for the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A structure that you can use to start and stop the launch.
         * <p>
         * @return {@code this}
         * @param executionStatus A structure that you can use to start and stop the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionStatus(final software.amazon.awscdk.services.evidently.CfnLaunch.ExecutionStatusObjectProperty executionStatus) {
            this.props.executionStatus(executionStatus);
            return this;
        }
        /**
         * A structure that you can use to start and stop the launch.
         * <p>
         * @return {@code this}
         * @param executionStatus A structure that you can use to start and stop the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionStatus(final software.amazon.awscdk.IResolvable executionStatus) {
            this.props.executionStatus(executionStatus);
            return this;
        }

        /**
         * An array of structures that define the metrics that will be used to monitor the launch performance.
         * <p>
         * You can have up to three metric monitors in the array.
         * <p>
         * @return {@code this}
         * @param metricMonitors An array of structures that define the metrics that will be used to monitor the launch performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMonitors(final software.amazon.awscdk.IResolvable metricMonitors) {
            this.props.metricMonitors(metricMonitors);
            return this;
        }
        /**
         * An array of structures that define the metrics that will be used to monitor the launch performance.
         * <p>
         * You can have up to three metric monitors in the array.
         * <p>
         * @return {@code this}
         * @param metricMonitors An array of structures that define the metrics that will be used to monitor the launch performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMonitors(final java.util.List<? extends java.lang.Object> metricMonitors) {
            this.props.metricMonitors(metricMonitors);
            return this;
        }

        /**
         * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served.
         * <p>
         * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the launch name as the <code>randomizationsSalt</code> .
         * <p>
         * @return {@code this}
         * @param randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder randomizationSalt(final java.lang.String randomizationSalt) {
            this.props.randomizationSalt(randomizationSalt);
            return this;
        }

        /**
         * Assigns one or more tags (key-value pairs) to the launch.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         * <p>
         * You can associate as many as 50 tags with a launch.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * <p>
         * @return {@code this}
         * @param tags Assigns one or more tags (key-value pairs) to the launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.evidently.CfnLaunch}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.evidently.CfnLaunch build() {
            return new software.amazon.awscdk.services.evidently.CfnLaunch(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
