package software.amazon.awscdk.services.emrserverless;

/**
 * Properties for defining a `CfnApplication`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emrserverless.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .releaseLabel("releaseLabel")
 *         .type("type")
 *         // the properties below are optional
 *         .autoStartConfiguration(AutoStartConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .autoStopConfiguration(AutoStopConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .idleTimeoutMinutes(123)
 *                 .build())
 *         .initialCapacity(List.of(InitialCapacityConfigKeyValuePairProperty.builder()
 *                 .key("key")
 *                 .value(InitialCapacityConfigProperty.builder()
 *                         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                                 .cpu("cpu")
 *                                 .memory("memory")
 *                                 // the properties below are optional
 *                                 .disk("disk")
 *                                 .build())
 *                         .workerCount(123)
 *                         .build())
 *                 .build()))
 *         .maximumCapacity(MaximumAllowedResourcesProperty.builder()
 *                 .cpu("cpu")
 *                 .memory("memory")
 *                 // the properties below are optional
 *                 .disk("disk")
 *                 .build())
 *         .name("name")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.932Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EMR release version associated with the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._/-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReleaseLabel();

    /**
     * The type of application, such as Spark or Hive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoStartConfiguration() {
        return null;
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoStopConfiguration() {
        return null;
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInitialCapacity() {
        return null;
    }

    /**
     * The maximum capacity of the application.
     * <p>
     * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMaximumCapacity() {
        return null;
    }

    /**
     * The name of the application.
     * <p>
     * <em>Minimum</em> : 1
     * <p>
     * <em>Maximum</em> : 64
     * <p>
     * <em>Pattern</em> : <code>^[A-Za-z0-9._\\/#-]+$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return null;
    }

    /**
     * The tags assigned to the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String releaseLabel;
        java.lang.String type;
        java.lang.Object autoStartConfiguration;
        java.lang.Object autoStopConfiguration;
        java.lang.Object initialCapacity;
        java.lang.Object maximumCapacity;
        java.lang.String name;
        java.lang.Object networkConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getReleaseLabel}
         * @param releaseLabel The EMR release version associated with the application. This parameter is required.
         *                     <em>Minimum</em> : 1
         *                     <p>
         *                     <em>Maximum</em> : 64
         *                     <p>
         *                     <em>Pattern</em> : <code>^[A-Za-z0-9._/-]+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getType}
         * @param type The type of application, such as Spark or Hive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStartConfiguration}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStartConfiguration}
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(software.amazon.awscdk.IResolvable autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStopConfiguration}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getAutoStopConfiguration}
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(software.amazon.awscdk.IResolvable autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInitialCapacity}
         * @param initialCapacity The initial capacity of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(software.amazon.awscdk.IResolvable initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getInitialCapacity}
         * @param initialCapacity The initial capacity of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(java.util.List<? extends java.lang.Object> initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMaximumCapacity}
         * @param maximumCapacity The maximum capacity of the application.
         *                        This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getMaximumCapacity}
         * @param maximumCapacity The maximum capacity of the application.
         *                        This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(software.amazon.awscdk.IResolvable maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getName}
         * @param name The name of the application.
         *             <em>Minimum</em> : 1
         *             <p>
         *             <em>Maximum</em> : 64
         *             <p>
         *             <em>Pattern</em> : <code>^[A-Za-z0-9._\\/#-]+$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getNetworkConfiguration}
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags The tags assigned to the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String releaseLabel;
        private final java.lang.String type;
        private final java.lang.Object autoStartConfiguration;
        private final java.lang.Object autoStopConfiguration;
        private final java.lang.Object initialCapacity;
        private final java.lang.Object maximumCapacity;
        private final java.lang.String name;
        private final java.lang.Object networkConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.releaseLabel = software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoStartConfiguration = software.amazon.jsii.Kernel.get(this, "autoStartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoStopConfiguration = software.amazon.jsii.Kernel.get(this, "autoStopConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.initialCapacity = software.amazon.jsii.Kernel.get(this, "initialCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumCapacity = software.amazon.jsii.Kernel.get(this, "maximumCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.releaseLabel = java.util.Objects.requireNonNull(builder.releaseLabel, "releaseLabel is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.autoStartConfiguration = builder.autoStartConfiguration;
            this.autoStopConfiguration = builder.autoStopConfiguration;
            this.initialCapacity = builder.initialCapacity;
            this.maximumCapacity = builder.maximumCapacity;
            this.name = builder.name;
            this.networkConfiguration = builder.networkConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAutoStartConfiguration() {
            return this.autoStartConfiguration;
        }

        @Override
        public final java.lang.Object getAutoStopConfiguration() {
            return this.autoStopConfiguration;
        }

        @Override
        public final java.lang.Object getInitialCapacity() {
            return this.initialCapacity;
        }

        @Override
        public final java.lang.Object getMaximumCapacity() {
            return this.maximumCapacity;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNetworkConfiguration() {
            return this.networkConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAutoStartConfiguration() != null) {
                data.set("autoStartConfiguration", om.valueToTree(this.getAutoStartConfiguration()));
            }
            if (this.getAutoStopConfiguration() != null) {
                data.set("autoStopConfiguration", om.valueToTree(this.getAutoStopConfiguration()));
            }
            if (this.getInitialCapacity() != null) {
                data.set("initialCapacity", om.valueToTree(this.getInitialCapacity()));
            }
            if (this.getMaximumCapacity() != null) {
                data.set("maximumCapacity", om.valueToTree(this.getMaximumCapacity()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNetworkConfiguration() != null) {
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!releaseLabel.equals(that.releaseLabel)) return false;
            if (!type.equals(that.type)) return false;
            if (this.autoStartConfiguration != null ? !this.autoStartConfiguration.equals(that.autoStartConfiguration) : that.autoStartConfiguration != null) return false;
            if (this.autoStopConfiguration != null ? !this.autoStopConfiguration.equals(that.autoStopConfiguration) : that.autoStopConfiguration != null) return false;
            if (this.initialCapacity != null ? !this.initialCapacity.equals(that.initialCapacity) : that.initialCapacity != null) return false;
            if (this.maximumCapacity != null ? !this.maximumCapacity.equals(that.maximumCapacity) : that.maximumCapacity != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.releaseLabel.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.autoStartConfiguration != null ? this.autoStartConfiguration.hashCode() : 0);
            result = 31 * result + (this.autoStopConfiguration != null ? this.autoStopConfiguration.hashCode() : 0);
            result = 31 * result + (this.initialCapacity != null ? this.initialCapacity.hashCode() : 0);
            result = 31 * result + (this.maximumCapacity != null ? this.maximumCapacity.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
