package software.amazon.awscdk.services.ecs;

/**
 * The details of a dependency on another container in the task definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * ContainerDefinition containerDefinition;
 * ContainerDependency containerDependency = ContainerDependency.builder()
 *         .container(containerDefinition)
 *         // the properties below are optional
 *         .condition(ContainerDependencyCondition.START)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDependency.html">https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDependency.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.374Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ContainerDependency")
@software.amazon.jsii.Jsii.Proxy(ContainerDependency.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerDependency extends software.amazon.jsii.JsiiSerializable {

    /**
     * The container to depend on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition getContainer();

    /**
     * The state the container needs to be in to satisfy the dependency and proceed with startup.
     * <p>
     * Valid values are ContainerDependencyCondition.START, ContainerDependencyCondition.COMPLETE,
     * ContainerDependencyCondition.SUCCESS and ContainerDependencyCondition.HEALTHY.
     * <p>
     * Default: ContainerDependencyCondition.HEALTHY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDependencyCondition getCondition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerDependency}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerDependency}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerDependency> {
        software.amazon.awscdk.services.ecs.ContainerDefinition container;
        software.amazon.awscdk.services.ecs.ContainerDependencyCondition condition;

        /**
         * Sets the value of {@link ContainerDependency#getContainer}
         * @param container The container to depend on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(software.amazon.awscdk.services.ecs.ContainerDefinition container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDependency#getCondition}
         * @param condition The state the container needs to be in to satisfy the dependency and proceed with startup.
         *                  Valid values are ContainerDependencyCondition.START, ContainerDependencyCondition.COMPLETE,
         *                  ContainerDependencyCondition.SUCCESS and ContainerDependencyCondition.HEALTHY.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder condition(software.amazon.awscdk.services.ecs.ContainerDependencyCondition condition) {
            this.condition = condition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerDependency}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerDependency build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerDependency}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDependency {
        private final software.amazon.awscdk.services.ecs.ContainerDefinition container;
        private final software.amazon.awscdk.services.ecs.ContainerDependencyCondition condition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class));
            this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDependencyCondition.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.container = java.util.Objects.requireNonNull(builder.container, "container is required");
            this.condition = builder.condition;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerDefinition getContainer() {
            return this.container;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerDependencyCondition getCondition() {
            return this.condition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("container", om.valueToTree(this.getContainer()));
            if (this.getCondition() != null) {
                data.set("condition", om.valueToTree(this.getCondition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ContainerDependency"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerDependency.Jsii$Proxy that = (ContainerDependency.Jsii$Proxy) o;

            if (!container.equals(that.container)) return false;
            return this.condition != null ? this.condition.equals(that.condition) : that.condition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
            return result;
        }
    }
}
