package software.amazon.awscdk.services.ecs;

/**
 * The ECS-optimized AMI variant to use.
 * <p>
 * For more information, see
 * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized AMIs</a>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addCapacity("graviton-cluster", AddCapacityOptions.builder()
 *         .minCapacity(2)
 *         .instanceType(new InstanceType("c6g.large"))
 *         .machineImage(EcsOptimizedImage.amazonLinux2(AmiHardwareType.ARM))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:58.260Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AmiHardwareType")
public enum AmiHardwareType {
    /**
     * Use the standard Amazon ECS-optimized AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Use the Amazon ECS GPU-optimized AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GPU,
    /**
     * Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM,
}
