package software.amazon.awscdk.services.datasync;

/**
 * A CloudFormation `AWS::DataSync::LocationFSxONTAP`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationFSxONTAP cfnLocationFSxONTAP = CfnLocationFSxONTAP.Builder.create(this, "MyCfnLocationFSxONTAP")
 *         .protocol(ProtocolProperty.builder()
 *                 .nfs(NFSProperty.builder()
 *                         .mountOptions(NfsMountOptionsProperty.builder()
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .smb(SMBProperty.builder()
 *                         .mountOptions(SmbMountOptionsProperty.builder()
 *                                 .version("version")
 *                                 .build())
 *                         .password("password")
 *                         .user("user")
 *                         // the properties below are optional
 *                         .domain("domain")
 *                         .build())
 *                 .build())
 *         .securityGroupArns(List.of("securityGroupArns"))
 *         .storageVirtualMachineArn("storageVirtualMachineArn")
 *         // the properties below are optional
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T19:51:57.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP")
public class CfnLocationFSxONTAP extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLocationFSxONTAP(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLocationFSxONTAP(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataSync::LocationFSxONTAP`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLocationFSxONTAP(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnLocationFSxONTAPProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFsxFilesystemArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFsxFilesystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationUri() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Protocol`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProtocol() {
        return software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Protocol`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.ProtocolProperty value) {
        software.amazon.jsii.Kernel.set(this, "protocol", java.util.Objects.requireNonNull(value, "protocol is required"));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Protocol`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocol(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "protocol", java.util.Objects.requireNonNull(value, "protocol is required"));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.SecurityGroupArns`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.SecurityGroupArns`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupArns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupArns", java.util.Objects.requireNonNull(value, "securityGroupArns is required"));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.StorageVirtualMachineArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStorageVirtualMachineArn() {
        return software.amazon.jsii.Kernel.get(this, "storageVirtualMachineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.StorageVirtualMachineArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageVirtualMachineArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageVirtualMachineArn", java.util.Objects.requireNonNull(value, "storageVirtualMachineArn is required"));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Subdirectory`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::DataSync::LocationFSxONTAP.Subdirectory`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubdirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subdirectory", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * NFSProperty nFSProperty = NFSProperty.builder()
     *         .mountOptions(NfsMountOptionsProperty.builder()
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.NFSProperty")
    @software.amazon.jsii.Jsii.Proxy(NFSProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NFSProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLocationFSxONTAP.NFSProperty.MountOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMountOptions();

        /**
         * @return a {@link Builder} of {@link NFSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NFSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NFSProperty> {
            java.lang.Object mountOptions;

            /**
             * Sets the value of {@link NFSProperty#getMountOptions}
             * @param mountOptions `CfnLocationFSxONTAP.NFSProperty.MountOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.NfsMountOptionsProperty mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Sets the value of {@link NFSProperty#getMountOptions}
             * @param mountOptions `CfnLocationFSxONTAP.NFSProperty.MountOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(software.amazon.awscdk.IResolvable mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NFSProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NFSProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NFSProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NFSProperty {
            private final java.lang.Object mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mountOptions = java.util.Objects.requireNonNull(builder.mountOptions, "mountOptions is required");
            }

            @Override
            public final java.lang.Object getMountOptions() {
                return this.mountOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mountOptions", om.valueToTree(this.getMountOptions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.NFSProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NFSProperty.Jsii$Proxy that = (NFSProperty.Jsii$Proxy) o;

                return this.mountOptions.equals(that.mountOptions);
            }

            @Override
            public final int hashCode() {
                int result = this.mountOptions.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * NfsMountOptionsProperty nfsMountOptionsProperty = NfsMountOptionsProperty.builder()
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.NfsMountOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(NfsMountOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NfsMountOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLocationFSxONTAP.NfsMountOptionsProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NfsMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NfsMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NfsMountOptionsProperty> {
            java.lang.String version;

            /**
             * Sets the value of {@link NfsMountOptionsProperty#getVersion}
             * @param version `CfnLocationFSxONTAP.NfsMountOptionsProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NfsMountOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NfsMountOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NfsMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NfsMountOptionsProperty {
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.NfsMountOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NfsMountOptionsProperty.Jsii$Proxy that = (NfsMountOptionsProperty.Jsii$Proxy) o;

                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version != null ? this.version.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * ProtocolProperty protocolProperty = ProtocolProperty.builder()
     *         .nfs(NFSProperty.builder()
     *                 .mountOptions(NfsMountOptionsProperty.builder()
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         .smb(SMBProperty.builder()
     *                 .mountOptions(SmbMountOptionsProperty.builder()
     *                         .version("version")
     *                         .build())
     *                 .password("password")
     *                 .user("user")
     *                 // the properties below are optional
     *                 .domain("domain")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.ProtocolProperty")
    @software.amazon.jsii.Jsii.Proxy(ProtocolProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProtocolProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLocationFSxONTAP.ProtocolProperty.NFS`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNfs() {
            return null;
        }

        /**
         * `CfnLocationFSxONTAP.ProtocolProperty.SMB`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProtocolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProtocolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProtocolProperty> {
            java.lang.Object nfs;
            java.lang.Object smb;

            /**
             * Sets the value of {@link ProtocolProperty#getNfs}
             * @param nfs `CfnLocationFSxONTAP.ProtocolProperty.NFS`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfs(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.NFSProperty nfs) {
                this.nfs = nfs;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolProperty#getNfs}
             * @param nfs `CfnLocationFSxONTAP.ProtocolProperty.NFS`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfs(software.amazon.awscdk.IResolvable nfs) {
                this.nfs = nfs;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolProperty#getSmb}
             * @param smb `CfnLocationFSxONTAP.ProtocolProperty.SMB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smb(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.SMBProperty smb) {
                this.smb = smb;
                return this;
            }

            /**
             * Sets the value of {@link ProtocolProperty#getSmb}
             * @param smb `CfnLocationFSxONTAP.ProtocolProperty.SMB`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smb(software.amazon.awscdk.IResolvable smb) {
                this.smb = smb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProtocolProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProtocolProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProtocolProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProtocolProperty {
            private final java.lang.Object nfs;
            private final java.lang.Object smb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nfs = software.amazon.jsii.Kernel.get(this, "nfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smb = software.amazon.jsii.Kernel.get(this, "smb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nfs = builder.nfs;
                this.smb = builder.smb;
            }

            @Override
            public final java.lang.Object getNfs() {
                return this.nfs;
            }

            @Override
            public final java.lang.Object getSmb() {
                return this.smb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNfs() != null) {
                    data.set("nfs", om.valueToTree(this.getNfs()));
                }
                if (this.getSmb() != null) {
                    data.set("smb", om.valueToTree(this.getSmb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.ProtocolProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProtocolProperty.Jsii$Proxy that = (ProtocolProperty.Jsii$Proxy) o;

                if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) return false;
                return this.smb != null ? this.smb.equals(that.smb) : that.smb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nfs != null ? this.nfs.hashCode() : 0;
                result = 31 * result + (this.smb != null ? this.smb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * SMBProperty sMBProperty = SMBProperty.builder()
     *         .mountOptions(SmbMountOptionsProperty.builder()
     *                 .version("version")
     *                 .build())
     *         .password("password")
     *         .user("user")
     *         // the properties below are optional
     *         .domain("domain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.SMBProperty")
    @software.amazon.jsii.Jsii.Proxy(SMBProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SMBProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLocationFSxONTAP.SMBProperty.MountOptions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMountOptions();

        /**
         * `CfnLocationFSxONTAP.SMBProperty.Password`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * `CfnLocationFSxONTAP.SMBProperty.User`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUser();

        /**
         * `CfnLocationFSxONTAP.SMBProperty.Domain`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SMBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SMBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SMBProperty> {
            java.lang.Object mountOptions;
            java.lang.String password;
            java.lang.String user;
            java.lang.String domain;

            /**
             * Sets the value of {@link SMBProperty#getMountOptions}
             * @param mountOptions `CfnLocationFSxONTAP.SMBProperty.MountOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.SmbMountOptionsProperty mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Sets the value of {@link SMBProperty#getMountOptions}
             * @param mountOptions `CfnLocationFSxONTAP.SMBProperty.MountOptions`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(software.amazon.awscdk.IResolvable mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Sets the value of {@link SMBProperty#getPassword}
             * @param password `CfnLocationFSxONTAP.SMBProperty.Password`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SMBProperty#getUser}
             * @param user `CfnLocationFSxONTAP.SMBProperty.User`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link SMBProperty#getDomain}
             * @param domain `CfnLocationFSxONTAP.SMBProperty.Domain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SMBProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SMBProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SMBProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SMBProperty {
            private final java.lang.Object mountOptions;
            private final java.lang.String password;
            private final java.lang.String user;
            private final java.lang.String domain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mountOptions = java.util.Objects.requireNonNull(builder.mountOptions, "mountOptions is required");
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
                this.domain = builder.domain;
            }

            @Override
            public final java.lang.Object getMountOptions() {
                return this.mountOptions;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                data.set("password", om.valueToTree(this.getPassword()));
                data.set("user", om.valueToTree(this.getUser()));
                if (this.getDomain() != null) {
                    data.set("domain", om.valueToTree(this.getDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.SMBProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SMBProperty.Jsii$Proxy that = (SMBProperty.Jsii$Proxy) o;

                if (!mountOptions.equals(that.mountOptions)) return false;
                if (!password.equals(that.password)) return false;
                if (!user.equals(that.user)) return false;
                return this.domain != null ? this.domain.equals(that.domain) : that.domain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mountOptions.hashCode();
                result = 31 * result + (this.password.hashCode());
                result = 31 * result + (this.user.hashCode());
                result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * SmbMountOptionsProperty smbMountOptionsProperty = SmbMountOptionsProperty.builder()
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.SmbMountOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SmbMountOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmbMountOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLocationFSxONTAP.SmbMountOptionsProperty.Version`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmbMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmbMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmbMountOptionsProperty> {
            java.lang.String version;

            /**
             * Sets the value of {@link SmbMountOptionsProperty#getVersion}
             * @param version `CfnLocationFSxONTAP.SmbMountOptionsProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmbMountOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmbMountOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmbMountOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmbMountOptionsProperty {
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationFSxONTAP.SmbMountOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmbMountOptionsProperty.Jsii$Proxy that = (SmbMountOptionsProperty.Jsii$Proxy) o;

                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.version != null ? this.version.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datasync.CfnLocationFSxONTAPProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datasync.CfnLocationFSxONTAPProps.Builder();
        }

        /**
         * `AWS::DataSync::LocationFSxONTAP.Protocol`.
         * <p>
         * @return {@code this}
         * @param protocol `AWS::DataSync::LocationFSxONTAP.Protocol`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.ProtocolProperty protocol) {
            this.props.protocol(protocol);
            return this;
        }
        /**
         * `AWS::DataSync::LocationFSxONTAP.Protocol`.
         * <p>
         * @return {@code this}
         * @param protocol `AWS::DataSync::LocationFSxONTAP.Protocol`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.IResolvable protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * `AWS::DataSync::LocationFSxONTAP.SecurityGroupArns`.
         * <p>
         * @return {@code this}
         * @param securityGroupArns `AWS::DataSync::LocationFSxONTAP.SecurityGroupArns`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupArns(final java.util.List<java.lang.String> securityGroupArns) {
            this.props.securityGroupArns(securityGroupArns);
            return this;
        }

        /**
         * `AWS::DataSync::LocationFSxONTAP.StorageVirtualMachineArn`.
         * <p>
         * @return {@code this}
         * @param storageVirtualMachineArn `AWS::DataSync::LocationFSxONTAP.StorageVirtualMachineArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageVirtualMachineArn(final java.lang.String storageVirtualMachineArn) {
            this.props.storageVirtualMachineArn(storageVirtualMachineArn);
            return this;
        }

        /**
         * `AWS::DataSync::LocationFSxONTAP.Subdirectory`.
         * <p>
         * @return {@code this}
         * @param subdirectory `AWS::DataSync::LocationFSxONTAP.Subdirectory`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(final java.lang.String subdirectory) {
            this.props.subdirectory(subdirectory);
            return this;
        }

        /**
         * `AWS::DataSync::LocationFSxONTAP.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::DataSync::LocationFSxONTAP.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP build() {
            return new software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
